/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.CatchTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Bundle;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.JavaFix;

public class ExtraCatch
implements ErrorRule<Void> {
    private static final Set<String> CODES = new HashSet<String>(Arrays.asList("compiler.err.except.already.caught", "compiler.err.except.never.thrown.in.try"));

    public Set<String> getCodes() {
        return CODES;
    }

    public List<Fix> run(CompilationInfo compilationInfo, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        boolean multiCatch;
        TreePath catchPath;
        for (catchPath = treePath; catchPath != null && catchPath.getLeaf().getKind() != Tree.Kind.CATCH; catchPath = catchPath.getParentPath()) {
        }
        if (catchPath == null) {
            return null;
        }
        String typeName = null;
        boolean bl = multiCatch = treePath.getParentPath().getLeaf().getKind() == Tree.Kind.UNION_TYPE;
        if (multiCatch) {
            typeName = compilationInfo.getTypeUtilities().getTypeName(compilationInfo.getTrees().getTypeMirror(treePath), new TypeUtilities.TypeNameOptions[0]).toString();
        }
        return Arrays.asList(new RemoveCatch(compilationInfo, multiCatch ? treePath : catchPath, typeName).toEditorFix());
    }

    public String getId() {
        return ExtraCatch.class.getName();
    }

    public String getDisplayName() {
        return Bundle.DN_ExtraCatch();
    }

    public void cancel() {
    }

    private static final class RemoveCatch
    extends JavaFix {
        final String typeName;

        public RemoveCatch(CompilationInfo info, TreePath tp, String typeName) {
            super(info, tp);
            this.typeName = typeName;
        }

        protected String getText() {
            return this.typeName == null ? Bundle.FIX_RemoveCatch() : Bundle.FIX_RemoveCatchException(this.typeName);
        }

        private void removeAlternativeFromMultiCatch(JavaFix.TransformationContext ctx) throws Exception {
            TreePath unionPath = ctx.getPath().getParentPath();
            UnionTypeTree union = (UnionTypeTree)unionPath.getLeaf();
            TreeMaker mk = ctx.getWorkingCopy().getTreeMaker();
            GeneratorUtilities gen = GeneratorUtilities.get((WorkingCopy)ctx.getWorkingCopy());
            union = (UnionTypeTree)gen.importComments((Tree)union, ctx.getWorkingCopy().getCompilationUnit());
            ArrayList<? extends Tree> alts = new ArrayList<Tree>(union.getTypeAlternatives());
            alts.remove(ctx.getPath().getLeaf());
            if (alts.size() > 1) {
                UnionTypeTree newUnion = mk.UnionType(alts);
                ctx.getWorkingCopy().rewrite((Tree)union, (Tree)newUnion);
            } else {
                ctx.getWorkingCopy().rewrite((Tree)union, (Tree)alts.get(0));
            }
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            Tree t = ctx.getPath().getLeaf();
            if (t.getKind() != Tree.Kind.CATCH) {
                this.removeAlternativeFromMultiCatch(ctx);
                return;
            }
            CatchTree toRemove = (CatchTree)t;
            TryTree parent = (TryTree)ctx.getPath().getParentPath().getLeaf();
            TreeMaker make = ctx.getWorkingCopy().getTreeMaker();
            if (parent.getResources().isEmpty() && parent.getCatches().size() == 1) {
                ArrayList<StatementTree> repl = new ArrayList<StatementTree>();
                repl.addAll(parent.getBlock().getStatements());
                if (parent.getFinallyBlock() != null) {
                    repl.addAll(parent.getFinallyBlock().getStatements());
                }
                Utilities.replaceStatement(ctx.getWorkingCopy(), ctx.getPath().getParentPath(), repl);
            } else {
                ctx.getWorkingCopy().rewrite((Tree)parent, (Tree)make.removeTryCatch(parent, toRemove));
            }
        }
    }
}

