/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.completion;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.Documentation;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.ElementQueryFactory;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.QuerySupportFactory;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.ConstantElement;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.FieldElement;
import org.netbeans.modules.php.editor.api.elements.InterfaceElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.TypeMemberElement;
import org.netbeans.modules.php.editor.api.elements.TypeResolver;
import org.netbeans.modules.php.editor.completion.Bundle;
import org.netbeans.modules.php.editor.completion.CCDocHtmlFormatter;
import org.netbeans.modules.php.editor.completion.PHPCodeCompletion;
import org.netbeans.modules.php.editor.index.PHPDOCTagElement;
import org.netbeans.modules.php.editor.index.PredefinedSymbolElement;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.impl.Type;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.parser.PHPDocCommentParser;
import org.netbeans.modules.php.editor.parser.annotation.LinkParsedLine;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocMethodTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.spi.annotation.AnnotationParsedLine;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

final class DocRenderer {
    private static final String TD_STYLE = "style=\"text-aling:left; border-width: 0px;padding: 1px;padding:3px;\" ";
    private static final String TD_STYLE_MAX_WIDTH = "style=\"text-aling:left; border-width: 0px;padding: 1px;padding:3px;width:80%;\" ";
    private static final String TABLE_STYLE = "style=\"border: 0px; width: 100%;\"";
    private static final Logger LOGGER = Logger.getLogger(PHPCodeCompletion.class.getName());

    private DocRenderer() {
    }

    static Documentation document(ParserResult info, ElementHandle element) {
        if (element instanceof PHPDOCTagElement) {
            PHPDOCTagElement pHPDOCTagElement = (PHPDOCTagElement)element;
            String doc = pHPDOCTagElement.getDoc();
            return Documentation.create((String)(doc == null ? Bundle.PHPDocNotFound() : doc));
        }
        if (element instanceof PredefinedSymbolElement) {
            PredefinedSymbolElement predefinedSymbolElement = (PredefinedSymbolElement)element;
            String doc = predefinedSymbolElement.getDoc();
            return Documentation.create((String)(doc == null ? Bundle.PHPDocNotFound() : doc));
        }
        if (element instanceof PhpElement) {
            return DocRenderer.documentIndexedElement((PhpElement)element);
        }
        if (element instanceof TypeMemberElement) {
            TypeMemberElement indexedClassMember = (TypeMemberElement)element;
            return DocRenderer.documentIndexedElement(indexedClassMember);
        }
        return null;
    }

    private static Documentation documentIndexedElement(PhpElement indexedElement) {
        PhpDocumentation phpDocumentation = PhpDocumentation.NONE;
        CCDocHtmlFormatter locationHeader = new CCDocHtmlFormatter();
        CCDocHtmlFormatter header = new CCDocHtmlFormatter();
        String location = DocRenderer.getLocation(indexedElement);
        ElementQuery elementQuery = indexedElement.getElementQuery();
        if (location != null) {
            locationHeader.appendHtml(String.format("<div align=\"right\"><font size=-1>%s</font></div>", location));
        }
        if (DocRenderer.canBeProcessed(indexedElement) && (phpDocumentation = DocRenderer.getPhpDocumentation(indexedElement, header)) == PhpDocumentation.NONE && indexedElement instanceof MethodElement) {
            ElementFilter forName = ElementFilter.forName(NameKind.exact(indexedElement.getName()));
            ElementQuery.Index index = elementQuery.getQueryScope().isIndexScope() ? (ElementQuery.Index)elementQuery : ElementQueryFactory.createIndexQuery(QuerySupportFactory.get(indexedElement.getFileObject()));
            Set<TypeElement> inheritedTypes = index.getInheritedTypes(((MethodElement)indexedElement).getType());
            Iterator<TypeElement> typeIt = inheritedTypes.iterator();
            while (phpDocumentation == PhpDocumentation.NONE && typeIt.hasNext()) {
                Set<MethodElement> inheritedMethods = forName.filter(index.getDeclaredMethods(typeIt.next()));
                Iterator<MethodElement> methodIt = inheritedMethods.iterator();
                while (phpDocumentation == PhpDocumentation.NONE && methodIt.hasNext()) {
                    header = new CCDocHtmlFormatter();
                    phpDocumentation = DocRenderer.getPhpDocumentation(methodIt.next(), header);
                }
            }
        }
        return phpDocumentation.createDocumentation(locationHeader);
    }

    private static boolean canBeProcessed(PhpElement indexedElement) {
        return indexedElement != null && indexedElement.getOffset() > -1 && indexedElement.getFileObject() != null;
    }

    private static PhpDocumentation getPhpDocumentation(PhpElement indexedElement, CCDocHtmlFormatter header) {
        PhpDocumentation result = PhpDocumentation.NONE;
        if (DocRenderer.canBeProcessed(indexedElement)) {
            FileObject nextFo = indexedElement.getFileObject();
            try {
                Source source = Source.create((FileObject)nextFo);
                if (source != null) {
                    ASTNodeFinder nodeFinder = new ASTNodeFinder(indexedElement);
                    ParserManager.parse(Collections.singleton(source), (UserTask)nodeFinder);
                    PHPDocExtractor phpDocExtractor = new PHPDocExtractor(header, indexedElement, nodeFinder.getNode(), nodeFinder.getPhpDocBlock());
                    result = phpDocExtractor.getPhpDocumentation();
                }
            }
            catch (ParseException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }
        return result;
    }

    private static String getLocation(PhpElement indexedElement) {
        String location = null;
        if (indexedElement.isPlatform()) {
            location = Bundle.PHPPlatform();
        } else {
            FileObject fobj = indexedElement.getFileObject();
            if (fobj != null) {
                Project project = FileOwnerQuery.getOwner((FileObject)fobj);
                if (project != null) {
                    Sources sources = ProjectUtils.getSources((Project)project);
                    for (SourceGroup group : sources.getSourceGroups("PHPSOURCE")) {
                        String relativePath = FileUtil.getRelativePath((FileObject)group.getRootFolder(), (FileObject)fobj);
                        if (relativePath == null) continue;
                        location = relativePath;
                        break;
                    }
                    if (location == null) {
                        location = fobj.getPath();
                    }
                } else {
                    location = indexedElement.getFilenameUrl();
                }
            }
        }
        return location;
    }

    private static interface PhpDocumentation {
        public static final PhpDocumentation NONE = new PhpDocumentation(){

            @Override
            public Documentation createDocumentation(CCDocHtmlFormatter locationHeader) {
                return Documentation.create((String)String.format("%s%s", locationHeader.getText(), Bundle.PHPDocNotFound()));
            }
        };

        public Documentation createDocumentation(CCDocHtmlFormatter var1);

        public static final class PhpDocumentationImpl
        implements PhpDocumentation {
            private final String description;
            private final URL url;

            private PhpDocumentationImpl(String description, URL url) {
                this.description = description;
                this.url = url;
            }

            @Override
            public Documentation createDocumentation(CCDocHtmlFormatter locationHeader) {
                assert (locationHeader != null);
                return Documentation.create((String)String.format("%s%s", locationHeader.getText(), this.description), (URL)this.url);
            }
        }

        public static final class Factory {
            static PhpDocumentation create(CCDocHtmlFormatter header, StringBuilder body, List<String> links) {
                URL url = null;
                if (links.size() > 0) {
                    try {
                        url = new URL(links.get(0));
                    }
                    catch (MalformedURLException ex) {
                        LOGGER.log(Level.INFO, null, ex);
                    }
                    if (links.size() > 1) {
                        Factory.attachLinks(body, links);
                    }
                }
                String description = String.format("%s%s", header.getText(), body.length() == 0 ? Bundle.PHPDocNotFound() : body);
                return new PhpDocumentationImpl(description, url);
            }

            private static void attachLinks(StringBuilder body, List<String> links) {
                assert (links.size() > 1) : links.size();
                body.append("<h3>");
                body.append(Bundle.OnlineDocs());
                body.append("</h3>\n");
                for (String link : links) {
                    String line = String.format("<a href=\"%s\">%s</a><br>%n", link, link);
                    body.append(line);
                }
            }
        }
    }

    private static final class ASTNodeFinder
    extends UserTask {
        private final PhpElement indexedElement;
        private ASTNode node;
        private PHPDocBlock phpDocBlock;

        public ASTNodeFinder(PhpElement indexedElement) {
            this.indexedElement = indexedElement;
        }

        public void run(ResultIterator resultIterator) throws Exception {
            Program program;
            ParserResult presult = (ParserResult)resultIterator.getParserResult();
            if (presult != null && (program = Utils.getRoot(presult)) != null) {
                Comment comment;
                this.node = Utils.getNodeAtOffset(program, this.indexedElement.getOffset());
                if (this.node == null) {
                    LOGGER.log(Level.WARNING, "Could not find AST node for element {0} defined in {1}", new Object[]{this.indexedElement.getName(), this.indexedElement.getFilenameUrl()});
                    return;
                }
                if (!(this.node instanceof PHPDocTag) && (comment = Utils.getCommentForNode(program, this.node)) instanceof PHPDocBlock) {
                    this.phpDocBlock = (PHPDocBlock)comment;
                }
            }
        }

        @CheckForNull
        public ASTNode getNode() {
            return this.node;
        }

        @CheckForNull
        public PHPDocBlock getPhpDocBlock() {
            return this.phpDocBlock;
        }
    }

    static final class PHPDocExtractor {
        private static final Pattern KEEP_TAGS_PATTERN = Pattern.compile("<(?!(/|b|code|br|i|kbd|li|ol|p|pre|samp|ul|var|table|tr|th|td)(\\b|\\s))", 2);
        private static final Pattern REPLACE_NEWLINE_PATTERN = Pattern.compile("(\r?\n){2,}");
        private static final Pattern LIST_PATTERN = Pattern.compile("(\r?\n)(?=([-+#o]\\s|\\d\\.?\\s))");
        private static final Pattern DESC_HEADER_PATTERN = Pattern.compile("(\r?\n)*(.*?((\r?\n){2,}|\\.\\s*\r?\n)|.*)", 32);
        private static final Pattern INLINE_INHERITDOC_PATTERN = Pattern.compile("\\{@inheritdoc *\\}", 2);
        private static final ArrayList<String> LINK_TAGS = new ArrayList();
        private final CCDocHtmlFormatter header;
        private final StringBuilder phpDoc = new StringBuilder();
        private final PhpElement indexedElement;
        private final List<String> links = new ArrayList<String>();
        private final ASTNode node;
        @NullAllowed
        private PHPDocBlock phpDocBlock;

        public PHPDocExtractor(CCDocHtmlFormatter header, PhpElement indexedElement, ASTNode node, @NullAllowed PHPDocBlock phpDocBlock) {
            this.header = header;
            this.indexedElement = indexedElement;
            this.node = node;
            this.phpDocBlock = phpDocBlock;
        }

        public PhpDocumentation getPhpDocumentation() {
            this.extract();
            return PhpDocumentation.Factory.create(this.header, this.phpDoc, this.links);
        }

        public void cancel() {
        }

        private void extract() {
            if (this.node == null) {
                return;
            }
            this.extractHeader();
            this.extractPHPDoc();
        }

        private void extractHeader() {
            if (this.node instanceof FunctionDeclaration) {
                this.doFunctionDeclaration((FunctionDeclaration)this.node);
            } else {
                this.header.name(this.indexedElement.getKind(), true);
                this.header.appendText(this.indexedElement.getName());
                this.header.name(this.indexedElement.getKind(), false);
                String value = null;
                if (this.indexedElement instanceof ConstantElement) {
                    ConstantElement constant = (ConstantElement)this.indexedElement;
                    value = constant.getValue();
                } else if (this.indexedElement instanceof TypeConstantElement) {
                    TypeConstantElement constant = (TypeConstantElement)this.indexedElement;
                    value = constant.getValue();
                }
                if (value != null) {
                    this.header.appendText(" = ");
                    this.header.appendText(value);
                }
            }
            this.header.appendHtml("<br/><br/>");
        }

        private void doFunctionDeclaration(FunctionDeclaration functionDeclaration) {
            String fname = CodeUtils.extractFunctionName(functionDeclaration);
            this.header.appendHtml("<font size=\"+1\">");
            this.header.name(ElementKind.METHOD, true);
            this.header.appendText(fname);
            this.header.name(ElementKind.METHOD, false);
            this.header.appendHtml("</font>");
            this.header.parameters(true);
            this.header.appendText("(");
            int paramCount = functionDeclaration.getFormalParameters().size();
            for (int i = 0; i < paramCount; ++i) {
                Identifier paramId;
                FormalParameter param = functionDeclaration.getFormalParameters().get(i);
                if (param.getParameterType() != null && (paramId = CodeUtils.extractUnqualifiedIdentifier(param.getParameterType())) != null) {
                    this.header.type(true);
                    if (param.isNullableType()) {
                        this.header.appendText("?");
                    }
                    this.header.appendText(paramId.getName() + " ");
                    this.header.type(false);
                }
                this.header.appendText(CodeUtils.getParamDisplayName(param));
                if (param.isOptional()) {
                    this.header.type(true);
                    this.header.appendText("=");
                    if (param.getDefaultValue() instanceof Scalar) {
                        Scalar scalar = (Scalar)param.getDefaultValue();
                        this.header.appendText(scalar.getStringValue());
                    }
                    this.header.type(false);
                }
                if (i + 1 >= paramCount) continue;
                this.header.appendText(", ");
            }
            this.header.appendText(")");
            this.header.parameters(false);
        }

        private void extractPHPDoc() {
            if (this.node instanceof PHPDocTag) {
                if (this.node instanceof PHPDocMethodTag) {
                    this.extractPHPDoc((PHPDocMethodTag)this.node);
                } else if (this.node instanceof PHPDocVarTypeTag) {
                    PHPDocVarTypeTag varTypeTag = (PHPDocVarTypeTag)this.node;
                    String type = this.composeType(varTypeTag.getTypes());
                    this.phpDoc.append(PHPDocExtractor.processPhpDoc(String.format("%s<br /><table><tr><th align=\"left\">Type:</th><td>%s</td></tr></table>", varTypeTag.getDocumentation(), type)));
                } else {
                    this.phpDoc.append(PHPDocExtractor.processPhpDoc(((PHPDocTag)this.node).getDocumentation()));
                }
            } else {
                this.extractPHPDocBlock();
            }
        }

        private void extractPHPDoc(PHPDocMethodTag methodTag) {
            StringBuilder params = new StringBuilder();
            StringBuilder returnValue = new StringBuilder();
            String description = methodTag.getDocumentation();
            if (description != null && description.length() > 0) {
                description = PHPDocExtractor.processPhpDoc(description);
            }
            if (methodTag.getParameters() != null && methodTag.getParameters().size() > 0) {
                for (PHPDocVarTypeTag tag : methodTag.getParameters()) {
                    params.append(this.composeParameterLine(tag));
                }
            }
            returnValue.append(this.composeTypesAndDescription(methodTag.getTypes(), null));
            this.phpDoc.append(this.composeFunctionDoc(description, params.toString(), returnValue.toString(), null));
        }

        private void extractPHPDocBlock() {
            ArrayList<PHPDocVarTypeTag> params = new ArrayList<PHPDocVarTypeTag>();
            ArrayList<PHPDocTypeTag> returns = new ArrayList<PHPDocTypeTag>();
            StringBuilder others = new StringBuilder();
            List<PhpElement> inheritedElements = this.getInheritedElements();
            List<PHPDocBlock> inheritedComments = this.getInheritedComments(inheritedElements);
            String description = this.phpDocBlock == null ? null : this.phpDocBlock.getDescription();
            description = this.composeDescription(description, inheritedComments);
            List<PHPDocTag> tags = this.phpDocBlock == null ? Collections.emptyList() : this.phpDocBlock.getTags();
            for (PHPDocTag tag : tags) {
                AnnotationParsedLine kind = tag.getKind();
                if (kind.equals((Object)PHPDocTag.Type.PARAM)) {
                    PHPDocVarTypeTag paramTag = (PHPDocVarTypeTag)tag;
                    params.add(paramTag);
                    continue;
                }
                if (kind.equals((Object)PHPDocTag.Type.RETURN)) {
                    PHPDocTypeTag returnTag = (PHPDocTypeTag)tag;
                    returns.add(returnTag);
                    continue;
                }
                if (kind.equals((Object)PHPDocTag.Type.VAR)) {
                    PHPDocTypeTag typeTag = (PHPDocTypeTag)tag;
                    others.append(this.composeTypesAndDescription(typeTag.getTypes(), typeTag.getDocumentation()));
                    continue;
                }
                if (kind.equals((Object)PHPDocTag.Type.DEPRECATED)) {
                    String oline = String.format("<tr><th align=\"left\">%s</th><td>%s</td></tr>%n", PHPDocExtractor.processPhpDoc(tag.getKind().getName()), PHPDocExtractor.processPhpDoc(tag.getDocumentation(), ""));
                    others.append(oline);
                    continue;
                }
                if (kind instanceof LinkParsedLine) {
                    this.links.add(kind.getDescription());
                    continue;
                }
                String tagDescription = kind instanceof PHPDocTag.Type ? tag.getValue() : kind.getDescription();
                String oline = String.format("<tr><th align=\"left\">%s</th><td>%s</td></tr>%n", PHPDocExtractor.processPhpDoc(tag.getKind().getName()), PHPDocExtractor.processPhpDoc(tagDescription, ""));
                others.append(oline);
            }
            if (this.phpDocBlock == null && this.indexedElement instanceof FieldElement) {
                FieldElement fieldElement = (FieldElement)this.indexedElement;
                Set<TypeResolver> types = fieldElement.getInstanceTypes();
                others.append(this.composeTypesAndDescription(this.composeType(types, this.getTypeKind(fieldElement)), ""));
            }
            this.phpDoc.append(this.composeFunctionDoc(this.processDescription(PHPDocExtractor.processPhpDoc(description, "")), this.composeParamTags(params, inheritedComments), this.composeReturnTags(returns, inheritedComments), others.toString()));
        }

        protected String processDescription(String text) {
            StringBuilder result = new StringBuilder();
            int lastIndex = 0;
            int index = text.indexOf(123, 0);
            while (index > -1 && text.length() > index + 1) {
                String tag;
                int endIndex;
                result.append(text.substring(lastIndex, index));
                lastIndex = index;
                char charAt = text.charAt(index + 2);
                if ((charAt == 'l' || charAt == 's' || charAt == 'u') && (endIndex = text.indexOf(32, index)) > -1 && LINK_TAGS.contains(tag = text.substring(index + 1, endIndex).trim()) && (endIndex = text.indexOf(125, index = endIndex + 1)) > -1) {
                    String link = text.substring(index, endIndex).trim();
                    result.append(String.format("<a href=\"%s\">%s</a>", link, link));
                    lastIndex = endIndex + 1;
                }
                index = text.indexOf(123, index + 1);
            }
            if (lastIndex > -1) {
                result.append(text.substring(lastIndex));
            }
            return result.toString();
        }

        private String composeFunctionDoc(String description, String parameters, String returnValue, String others) {
            StringBuilder value = new StringBuilder();
            value.append(description);
            value.append("<br />\n");
            if (parameters.length() > 0) {
                value.append("<h3>");
                value.append(Bundle.Parameters());
                value.append("</h3>\n<table cellspacing=0 style=\"border: 0px; width: 100%;\">\n").append(parameters).append("</table>\n");
            }
            if (returnValue.length() > 0) {
                value.append("<h3>");
                value.append(Bundle.ReturnValue());
                value.append("</h3>\n<table>\n");
                value.append(returnValue);
                value.append("</table>");
            }
            if (others != null && others.length() > 0) {
                value.append("<table>\n").append(others).append("</table>\n");
            }
            return value.toString();
        }

        private String composeParameterLine(PHPDocVarTypeTag param) {
            return this.composeParameterLine(param.getTypes(), param.getVariable().getValue(), param.getDocumentation());
        }

        private String composeParameterLine(List<PHPDocTypeNode> types, String variableValue, String documentation) {
            return this.composeParameterLine(this.composeType(types), variableValue, documentation);
        }

        private String composeParameterLine(String type, String variableValue, String documentation) {
            String pline = String.format("<tr><td>&nbsp;</td><td valign=\"top\" %s><nobr>%s</nobr></td><td valign=\"top\" %s><nobr><b>%s</b></nobr></td><td valign=\"top\" %s>%s</td></tr>%n", DocRenderer.TD_STYLE, type, DocRenderer.TD_STYLE, variableValue, DocRenderer.TD_STYLE_MAX_WIDTH, documentation == null ? "&nbsp" : PHPDocExtractor.processPhpDoc(documentation));
            return pline;
        }

        private String composeTypesAndDescription(List<PHPDocTypeNode> types, String description) {
            return this.composeTypesAndDescription(this.composeType(types), description);
        }

        private String composeTypesAndDescription(String type, String description) {
            StringBuilder returnValue = new StringBuilder();
            if (StringUtils.hasText((String)type)) {
                returnValue.append(String.format("<tr><th align=\"left\">%s:</th><td>%s</td></tr>", Bundle.Type(), type));
            }
            if (description != null && description.length() > 0) {
                returnValue.append(String.format("<tr><th align=\"left\" valign=\"top\">%s:</th><td>%s</td></tr>", Bundle.Description(), PHPDocExtractor.processPhpDoc(description)));
            }
            return returnValue.toString();
        }

        private String composeType(List<PHPDocTypeNode> types) {
            StringBuilder type = new StringBuilder();
            if (types != null) {
                for (PHPDocTypeNode typeNode : types) {
                    if (type.length() > 0) {
                        type.append(" | ");
                    }
                    type.append(typeNode.getValue());
                    if (!typeNode.isArray()) continue;
                    type.append("[]");
                }
            }
            return type.toString();
        }

        private String composeType(Collection<TypeResolver> types, Type.Kind typeKind) {
            StringBuilder sb = new StringBuilder();
            for (TypeResolver type : types) {
                String tName;
                QualifiedName typeName;
                if (!type.isResolved() || (typeName = type.getTypeName(true)) == null) continue;
                if (sb.length() > 0 && (typeKind == Type.Kind.UNION || typeKind == Type.Kind.INTERSECTION)) {
                    sb.append(" ").append(typeKind.getSign()).append(" ");
                }
                if (type.isNullableType()) {
                    sb.append("?");
                }
                if ((tName = typeName.toString()).startsWith("\\") && VariousUtils.isSpecialClassName(tName.substring(1))) {
                    tName = tName.substring(1);
                }
                sb.append(tName);
            }
            return sb.toString();
        }

        static String processPhpDoc(String phpDoc) {
            return PHPDocExtractor.processPhpDoc(phpDoc, Bundle.PHPDocNotFound());
        }

        static String processPhpDoc(String phpDoc, String defaultText) {
            String result = defaultText;
            if (StringUtils.hasText((String)phpDoc)) {
                String notags = KEEP_TAGS_PATTERN.matcher(phpDoc).replaceAll("&lt;");
                notags = REPLACE_NEWLINE_PATTERN.matcher(notags).replaceAll("<br><br>");
                result = LIST_PATTERN.matcher(notags).replaceAll("<br>&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            return result;
        }

        private String composeDescription(String description, List<PHPDocBlock> comments) {
            String ret;
            block1: {
                PHPDocBlock comment;
                ret = description;
                if (ret == null) break block1;
                Iterator<PHPDocBlock> iterator = comments.iterator();
                while (iterator.hasNext() && PHPDocExtractor.hasInlineInheritdoc(ret = this.replaceInheritdocForDescription(ret, (comment = iterator.next()).getDescription()))) {
                }
            }
            return ret;
        }

        @CheckForNull
        private String replaceInheritdocForDescription(@NullAllowed String description, @NullAllowed String parentDescription) {
            if (description == null) {
                return parentDescription;
            }
            if (description != null && PHPDocExtractor.hasInlineInheritdoc(description) && parentDescription != null && !parentDescription.trim().isEmpty()) {
                if (INLINE_INHERITDOC_PATTERN.matcher(description.trim()).matches()) {
                    return parentDescription;
                }
                String inheritdoc = PHPDocExtractor.removeDescriptionHeader(parentDescription);
                return PHPDocExtractor.replaceInlineInheritdoc(description, inheritdoc);
            }
            return description;
        }

        private String composeParamTags(List<PHPDocVarTypeTag> paramTags, List<PHPDocBlock> inheritedComments) {
            StringBuilder params = new StringBuilder();
            if (this.indexedElement instanceof BaseFunctionElement) {
                BaseFunctionElement functionElement = (BaseFunctionElement)this.indexedElement;
                List<ParameterElement> parameters = functionElement.getParameters();
                for (ParameterElement parameter : parameters) {
                    String paramLine;
                    PHPDocTypeTag param = null;
                    String name = parameter.getName();
                    for (PHPDocVarTypeTag paramTag : paramTags) {
                        String value = paramTag.getVariable().getValue();
                        if (!name.equals(value)) continue;
                        param = paramTag;
                    }
                    if (param == null && this.indexedElement instanceof MethodElement) {
                        for (PHPDocBlock inheritedComment : inheritedComments) {
                            List<PHPDocTag> tags = inheritedComment.getTags();
                            for (PHPDocTag tag : tags) {
                                PHPDocVarTypeTag t;
                                String value;
                                AnnotationParsedLine kind = tag.getKind();
                                if (!kind.equals((Object)PHPDocTag.Type.PARAM) || !name.equals(value = (t = (PHPDocVarTypeTag)tag).getVariable().getValue())) continue;
                                param = t;
                                break;
                            }
                            if (param == null) continue;
                            break;
                        }
                    }
                    if (param != null) {
                        String paramDescription = this.composeParamTagDescription((PHPDocVarTypeTag)param, inheritedComments);
                        paramLine = this.composeParameterLine(param.getTypes(), ((PHPDocVarTypeTag)param).getVariable().getValue(), paramDescription);
                        params.append(paramLine);
                        continue;
                    }
                    Set<TypeResolver> types = parameter.getTypes();
                    paramLine = this.composeParameterLine(this.composeType(types, this.getTypeKind(parameter)), name, "");
                    params.append(paramLine);
                }
            } else {
                for (PHPDocVarTypeTag paramTag : paramTags) {
                    String paramLine = this.composeParameterLine(paramTag);
                    params.append(paramLine);
                }
            }
            return params.toString();
        }

        private String composeParamTagDescription(PHPDocVarTypeTag tag, List<PHPDocBlock> phpDocBlocks) {
            String documentation = tag.getDocumentation();
            for (PHPDocBlock docBlock : phpDocBlocks) {
                documentation = this.composeParamTagDescription(documentation, tag, docBlock);
            }
            return documentation;
        }

        private String composeParamTagDescription(String documentation, PHPDocVarTypeTag varTypeTag, PHPDocBlock phpDocBlock) {
            String ret = documentation;
            if (ret != null && PHPDocExtractor.hasInlineInheritdoc(ret)) {
                List<PHPDocTag> tags = phpDocBlock.getTags();
                for (PHPDocTag tag : tags) {
                    String inheritedDocumentation;
                    AnnotationParsedLine kind = tag.getKind();
                    if (!kind.equals((Object)PHPDocTag.Type.PARAM)) continue;
                    PHPDocVarTypeTag inheritedTag = (PHPDocVarTypeTag)tag;
                    PHPDocNode variable = varTypeTag.getVariable();
                    PHPDocNode inheritedVariable = inheritedTag.getVariable();
                    if (variable == null || inheritedVariable == null || !variable.getValue().equals(inheritedVariable.getValue()) || (inheritedDocumentation = inheritedTag.getDocumentation()) == null || inheritedDocumentation.trim().isEmpty()) continue;
                    return PHPDocExtractor.replaceInlineInheritdoc(ret, inheritedTag.getDocumentation());
                }
            }
            return ret;
        }

        private String composeReturnTags(List<PHPDocTypeTag> returnTags, List<PHPDocBlock> inheritedComments) {
            StringBuilder returnValue = new StringBuilder();
            ArrayList<PHPDocTypeTag> fallbacks = new ArrayList<PHPDocTypeTag>(returnTags);
            if (fallbacks.isEmpty()) {
                for (PHPDocBlock inheritedComment : inheritedComments) {
                    List<PHPDocTag> tags = inheritedComment.getTags();
                    for (PHPDocTag tag : tags) {
                        if (!tag.getKind().equals((Object)PHPDocTag.Type.RETURN)) continue;
                        fallbacks.add((PHPDocTypeTag)tag);
                    }
                    if (fallbacks.isEmpty()) continue;
                    break;
                }
            }
            for (PHPDocTypeTag fallback : fallbacks) {
                returnValue.append(this.composeTypesAndDescription(fallback.getTypes(), fallback.getDocumentation()));
            }
            if (fallbacks.isEmpty() && this.indexedElement instanceof BaseFunctionElement) {
                BaseFunctionElement functionElement = (BaseFunctionElement)this.indexedElement;
                returnValue.append(this.composeTypesAndDescription(this.composeType(functionElement.getReturnTypes(), this.getTypeKind(functionElement)), ""));
            }
            return returnValue.toString();
        }

        private Type.Kind getTypeKind(BaseFunctionElement element) {
            Type.Kind kind = Type.Kind.NORMAL;
            if (element.isReturnIntersectionType()) {
                kind = Type.Kind.INTERSECTION;
            } else if (element.isReturnUnionType()) {
                kind = Type.Kind.UNION;
            }
            return kind;
        }

        private Type.Kind getTypeKind(ParameterElement element) {
            Type.Kind kind = Type.Kind.NORMAL;
            if (element.isIntersectionType()) {
                kind = Type.Kind.INTERSECTION;
            } else if (element.isUnionType()) {
                kind = Type.Kind.UNION;
            }
            return kind;
        }

        private Type.Kind getTypeKind(FieldElement element) {
            Type.Kind kind = Type.Kind.NORMAL;
            if (element.isIntersectionType()) {
                kind = Type.Kind.INTERSECTION;
            } else if (element.isUnionType()) {
                kind = Type.Kind.UNION;
            }
            return kind;
        }

        private List<PhpElement> getInheritedElements() {
            if (!this.needInheritedElements()) {
                return Collections.emptyList();
            }
            ArrayList<PhpElement> inheritedElements = new ArrayList<PhpElement>();
            if (this.indexedElement instanceof MethodElement) {
                MethodElement methodElement = (MethodElement)this.indexedElement;
                inheritedElements.addAll(PHPDocExtractor.getAllOverriddenMethods(methodElement));
            } else if (this.indexedElement instanceof ClassElement) {
                ClassElement classElement = (ClassElement)this.indexedElement;
                inheritedElements.addAll(PHPDocExtractor.getAllInheritedClasses(classElement));
            } else if (this.indexedElement instanceof InterfaceElement) {
                InterfaceElement interfaceElement = (InterfaceElement)this.indexedElement;
                inheritedElements.addAll(PHPDocExtractor.getAllInheritedInterfaces(interfaceElement));
            }
            return inheritedElements;
        }

        private boolean needInheritedElements() {
            if (this.phpDocBlock == null) {
                return true;
            }
            String description = this.phpDocBlock.getDescription();
            if (PHPDocExtractor.hasInlineInheritdoc(description)) {
                return true;
            }
            if (this.indexedElement instanceof MethodElement) {
                List<PHPDocTag> tags = this.phpDocBlock.getTags();
                HashSet<String> params = new HashSet<String>(tags.size());
                for (PHPDocTag tag : tags) {
                    AnnotationParsedLine kind = tag.getKind();
                    if (!kind.equals((Object)PHPDocTag.Type.PARAM)) continue;
                    PHPDocVarTypeTag t = (PHPDocVarTypeTag)tag;
                    params.add(t.getVariable().getValue());
                    if (!PHPDocExtractor.hasInlineInheritdoc(tag.getDocumentation())) continue;
                    return true;
                }
                MethodElement method = (MethodElement)this.indexedElement;
                for (ParameterElement parameter : method.getParameters()) {
                    if (params.contains(parameter.getName())) continue;
                    return true;
                }
            }
            return false;
        }

        private List<PHPDocBlock> getInheritedComments(List<PhpElement> elements) {
            ArrayList<PHPDocBlock> inheritedComments = new ArrayList<PHPDocBlock>();
            for (PhpElement element : elements) {
                PHPDocBlock docBlock = this.getPhpDocBlock(element);
                if (docBlock == null) continue;
                if (this.phpDocBlock == null || this.isOnlyInheritdoc(this.phpDocBlock)) {
                    this.phpDocBlock = docBlock;
                    continue;
                }
                inheritedComments.add(docBlock);
            }
            return inheritedComments;
        }

        private boolean isOnlyInheritdoc(PHPDocBlock phpDocBlock) {
            return INLINE_INHERITDOC_PATTERN.matcher(phpDocBlock.getDescription().trim()).matches() && phpDocBlock.getTags().isEmpty();
        }

        @CheckForNull
        static String replaceInlineInheritdoc(@NullAllowed String description, @NullAllowed String inheritdoc) {
            if (description == null && inheritdoc != null) {
                return inheritdoc;
            }
            if (description == null || inheritdoc == null) {
                return description;
            }
            if (inheritdoc.trim().isEmpty()) {
                return description;
            }
            return INLINE_INHERITDOC_PATTERN.matcher(description).replaceAll(Matcher.quoteReplacement(inheritdoc));
        }

        static boolean hasInlineInheritdoc(String description) {
            return description == null ? false : INLINE_INHERITDOC_PATTERN.matcher(description).find();
        }

        static String removeDescriptionHeader(String description) {
            return description == null ? null : DESC_HEADER_PATTERN.matcher(description).replaceFirst("");
        }

        private static ElementQuery.Index getIndex(PhpElement phpElement) {
            ElementQuery elementQuery = phpElement.getElementQuery();
            return elementQuery.getQueryScope().isIndexScope() ? (ElementQuery.Index)elementQuery : ElementQueryFactory.createIndexQuery(QuerySupportFactory.get(phpElement.getFileObject()));
        }

        private static List<TypeElement> getAllInheritedClasses(TypeElement typeElement) {
            ArrayList<TypeElement> types = new ArrayList<TypeElement>();
            PHPDocExtractor.getInheritedClasses(typeElement, types);
            return types;
        }

        private static void getInheritedClasses(TypeElement typeElement, List<TypeElement> types) {
            Set<ClassElement> inheritedClasses = PHPDocExtractor.getInheritedClasses(typeElement);
            types.addAll(inheritedClasses);
            for (ClassElement inheritedClasse : inheritedClasses) {
                PHPDocExtractor.getInheritedClasses(inheritedClasse, types);
            }
        }

        private static Set<ClassElement> getInheritedClasses(TypeElement typeElement) {
            ElementQuery.Index index = PHPDocExtractor.getIndex(typeElement);
            return index.getDirectInheritedClasses(typeElement);
        }

        private static List<TypeElement> getAllInheritedInterfaces(TypeElement typeElement) {
            ArrayList<TypeElement> types = new ArrayList<TypeElement>();
            PHPDocExtractor.getInheritedInterfaces(typeElement, types);
            return types;
        }

        private static void getInheritedInterfaces(TypeElement typeElement, List<TypeElement> types) {
            Set<InterfaceElement> inheritedInterfaces = PHPDocExtractor.getInheritedInterfaces(typeElement);
            types.addAll(inheritedInterfaces);
            for (InterfaceElement inheritedInterface : inheritedInterfaces) {
                PHPDocExtractor.getInheritedClasses(inheritedInterface, types);
            }
        }

        private static Set<InterfaceElement> getInheritedInterfaces(TypeElement typeElement) {
            ElementQuery.Index index = PHPDocExtractor.getIndex(typeElement);
            return index.getDirectInheritedInterfaces(typeElement);
        }

        private static List<MethodElement> getAllOverriddenMethods(MethodElement method) {
            ArrayList<MethodElement> methods = new ArrayList<MethodElement>();
            PHPDocExtractor.getOverriddenMethods(method, methods);
            return methods;
        }

        private static void getOverriddenMethods(MethodElement method, List<MethodElement> methods) {
            Set<MethodElement> overriddenMethods = PHPDocExtractor.getOverriddenMethods(method);
            methods.addAll(overriddenMethods);
            for (MethodElement overriddenMethod : overriddenMethods) {
                PHPDocExtractor.getOverriddenMethods(overriddenMethod, methods);
            }
        }

        private static Set<MethodElement> getOverriddenMethods(MethodElement method) {
            ElementFilter methodNameFilter = ElementFilter.forName(NameKind.exact(method.getName()));
            return methodNameFilter.filter(PHPDocExtractor.getInheritedMethods(method));
        }

        private static Set<MethodElement> getInheritedMethods(MethodElement method) {
            ElementQuery.Index index = PHPDocExtractor.getIndex(method);
            TypeElement type = method.getType();
            if (type == null) {
                return Collections.emptySet();
            }
            return index.getInheritedMethods(type);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        private PHPDocBlock getPhpDocBlock(PhpElement phpElement) {
            if (!DocRenderer.canBeProcessed(phpElement)) {
                return null;
            }
            FileObject fileObject = phpElement.getFileObject();
            BaseDocument document = GsfUtilities.getDocument((FileObject)fileObject, (boolean)true);
            if (document != null) {
                document.readLock();
                try {
                    int offset = phpElement.getOffset();
                    TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)document, offset);
                    if (ts != null) {
                        List<PHPTokenId> lookfor;
                        Token<? extends PHPTokenId> token;
                        ts.move(offset);
                        if (ts.movePrevious() && (token = LexUtilities.findPreviousToken(ts, lookfor = Arrays.asList(PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHP_CURLY_OPEN, PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.PHP_SEMICOLON))) != null && token.id() == PHPTokenId.PHPDOC_COMMENT) {
                            PHPDocCommentParser phpDocCommentParser = new PHPDocCommentParser();
                            PHPDocBlock pHPDocBlock = phpDocCommentParser.parse(ts.offset() - 3, ts.offset() + token.length(), token.text().toString());
                            return pHPDocBlock;
                        }
                    }
                }
                finally {
                    document.readUnlock();
                }
            }
            return null;
        }

        static {
            LINK_TAGS.add("@link");
            LINK_TAGS.add("@see");
            LINK_TAGS.add("@use");
        }
    }
}

