/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.disco;

import eu.hansolo.jdktools.Architecture;
import eu.hansolo.jdktools.ArchiveType;
import eu.hansolo.jdktools.Bitness;
import eu.hansolo.jdktools.Latest;
import eu.hansolo.jdktools.LibCType;
import eu.hansolo.jdktools.OperatingSystem;
import eu.hansolo.jdktools.PackageType;
import eu.hansolo.jdktools.ReleaseStatus;
import eu.hansolo.jdktools.TermOfSupport;
import eu.hansolo.jdktools.versioning.Semver;
import eu.hansolo.jdktools.versioning.VersionNumber;
import io.foojay.api.discoclient.DiscoClient;
import io.foojay.api.discoclient.event.Evt;
import io.foojay.api.discoclient.event.EvtObserver;
import io.foojay.api.discoclient.event.EvtType;
import io.foojay.api.discoclient.pkg.Distribution;
import io.foojay.api.discoclient.pkg.MajorVersion;
import io.foojay.api.discoclient.pkg.Pkg;
import io.foojay.api.discoclient.pkg.Scope;
import io.foojay.api.discoclient.util.PkgInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.netbeans.modules.java.disco.DiscoPlatformInstall;

public class Client {
    private static final Client INSTANCE = new Client();
    private DiscoClient client = null;
    private List<MajorVersion> majorVersions;
    private List<Distribution> distributions;

    public static Client getInstance() {
        return INSTANCE;
    }

    private synchronized DiscoClient getDisco() {
        if (this.client == null) {
            this.client = new DiscoClient(DiscoPlatformInstall.clientName());
        }
        return this.client;
    }

    private Client() {
    }

    public final synchronized List<MajorVersion> getAllMajorVersions() {
        if (this.majorVersions == null) {
            this.majorVersions = Collections.unmodifiableList(this.getDisco().getAllMajorVersions(false).stream().filter(majorVersion -> majorVersion.isMaintained()).filter(majorVersion -> majorVersion.isEarlyAccessOnly() != Boolean.TRUE).collect(Collectors.toList()));
        }
        return this.majorVersions;
    }

    public synchronized MajorVersion getLatestLts(boolean b) {
        return this.getDisco().getLatestLts(b);
    }

    public synchronized MajorVersion getLatestSts(boolean b) {
        return this.getDisco().getLatestSts(b);
    }

    public synchronized List<Pkg> getPkgs(Distribution distribution, VersionNumber versionNumber, Latest latest, OperatingSystem operatingSystem, Architecture architecture, ArchiveType archiveType, PackageType packageType, Boolean javafxBundled) {
        return this.getDisco().getPkgs(Arrays.asList(distribution), versionNumber, latest, operatingSystem, LibCType.NONE, architecture, Bitness.NONE, archiveType, packageType, javafxBundled, true, Arrays.asList(ReleaseStatus.NONE), TermOfSupport.NONE, Arrays.asList(Scope.PUBLIC), null);
    }

    public synchronized List<Distribution> getDistributions() {
        if (this.distributions == null) {
            this.distributions = Collections.unmodifiableList(this.getDisco().getDistributions().stream().filter(distribution -> distribution.getScopes().contains(Scope.BUILD_OF_OPEN_JDK)).filter(distribution -> distribution.getScopes().contains(Scope.PUBLIC)).collect(Collectors.toList()));
        }
        return this.distributions;
    }

    public synchronized Optional<Distribution> getDistribution(String text) {
        return this.getDistributions().stream().filter(d -> d.getSynonyms().contains(text)).findFirst();
    }

    public synchronized PkgInfo getPkgInfo(String ephemeralId, Semver javaVersion) {
        return this.getDisco().getPkgInfoByEphemeralId(ephemeralId, javaVersion);
    }

    public synchronized Future<?> downloadPkg(PkgInfo pkgInfo, String absolutePath) throws InterruptedException {
        return this.getDisco().downloadPkg(pkgInfo, absolutePath);
    }

    public synchronized void setOnEvt(EvtType<? extends Evt> type, EvtObserver observer) {
        this.getDisco().setOnEvt(type, observer);
    }

    public synchronized void removeAllObservers() {
        this.getDisco().removeAllObservers();
    }
}

