/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ddloaders.multiview.webservice;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.glassfish.eecommon.api.config.GlassfishConfiguration;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponent;
import org.netbeans.modules.j2ee.dd.api.webservices.ServiceImplBean;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.sun.ddloaders.Utils;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.common.CommonBeanReader;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public class WebServiceMetadataReader
extends CommonBeanReader {
    public WebServiceMetadataReader() {
        super("WebserviceDescription");
    }

    @Override
    public Map<String, Object> readAnnotations(DataObject dObj) {
        Map<String, Object> result = null;
        try {
            J2eeModule.Type moduleType;
            J2eeModule module;
            File key = FileUtil.toFile((FileObject)dObj.getPrimaryFile());
            GlassfishConfiguration dc = GlassfishConfiguration.getConfiguration((File)key);
            if (dc != null && (module = dc.getJ2eeModule()) != null && (J2eeModule.Type.WAR.equals(moduleType = module.getType()) || J2eeModule.Type.EJB.equals(moduleType)) && (result = this.readWebservicesMetadata((MetadataModel<WebservicesMetadata>)module.getMetadataModel(WebservicesMetadata.class))) != null && result.size() > 0) {
                this.filterInvalidServices(result, moduleType);
            }
        }
        catch (MetadataModelException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return result;
    }

    private void filterInvalidServices(Map<String, Object> annotationMap, Object moduleType) {
        String invalidBindingType = J2eeModule.Type.WAR.equals(moduleType) ? "EjbLink" : "ServletLink";
        ArrayList<String> servicesToRemove = new ArrayList<String>();
        block0: for (Map.Entry<String, Object> serviceEntry : annotationMap.entrySet()) {
            Map serviceDescMap;
            Object pm;
            Object serviceValue = serviceEntry.getValue();
            if (!(serviceValue instanceof Map) || !((pm = (serviceDescMap = (Map)serviceValue).get("PortComponent")) instanceof Map)) continue;
            Map portMap = (Map)pm;
            for (Map.Entry portEntry : portMap.entrySet()) {
                Map portDescMap;
                Object portValue = portEntry.getValue();
                if (!(portValue instanceof Map) || (portDescMap = (Map)portValue).get(invalidBindingType) == null) continue;
                servicesToRemove.add(serviceEntry.getKey());
                continue block0;
            }
        }
        for (String serviceKey : servicesToRemove) {
            annotationMap.remove(serviceKey);
        }
    }

    @Override
    public Map<String, Object> genProperties(CommonDDBean[] beans) {
        HashMap result = null;
        if (beans instanceof WebserviceDescription[]) {
            WebserviceDescription[] webServices;
            for (WebserviceDescription webServiceDesc : webServices = (WebserviceDescription[])beans) {
                String webServiceDescName = webServiceDesc.getWebserviceDescriptionName();
                if (!Utils.notEmpty(webServiceDescName)) continue;
                if (result == null) {
                    result = new HashMap();
                }
                HashMap<String, Object> webServiceDescMap = new HashMap<String, Object>();
                result.put(webServiceDescName, webServiceDescMap);
                webServiceDescMap.put("Name", webServiceDescName);
                PortComponent[] ports = webServiceDesc.getPortComponent();
                if (ports == null || ports.length <= 0) continue;
                HashMap<String, HashMap<String, Object>> portGroupMap = new HashMap<String, HashMap<String, Object>>();
                webServiceDescMap.put("PortComponent", portGroupMap);
                for (PortComponent port : ports) {
                    String portName = port.getPortComponentName();
                    if (!Utils.notEmpty(portName)) continue;
                    HashMap<String, Object> portMap = new HashMap<String, Object>(7);
                    portMap.put("Name", portName);
                    portGroupMap.put(portName, portMap);
                    this.addMapString(portMap, "EndpointInterface", port.getServiceEndpointInterface());
                    ServiceImplBean serviceBean = port.getServiceImplBean();
                    if (serviceBean == null) continue;
                    this.addMapString(portMap, "ServletLink", serviceBean.getServletLink());
                    this.addMapString(portMap, "EjbLink", serviceBean.getEjbLink());
                }
            }
        }
        return result;
    }
}

