/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.Bundle;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.api.execute.GradleDistributionManager;
import org.netbeans.modules.gradle.spi.execute.GradleDistributionProvider;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;

public final class GradleJavaCompatProblemsProvider
implements ProjectProblemsProvider {
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final Project project;
    private final PropertyChangeListener listener;

    public GradleJavaCompatProblemsProvider(Project project) {
        this.project = project;
        this.listener = evt -> {
            if ("ProjectInfo".equals(evt.getPropertyName())) {
                this.support.firePropertyChange("problems", null, null);
            }
        };
        NbGradleProject.addPropertyChangeListener(project, this.listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        GradleDistributionManager.GradleDistribution dist;
        GradleDistributionProvider pvd = (GradleDistributionProvider)this.project.getLookup().lookup(GradleDistributionProvider.class);
        if (pvd != null && (dist = pvd.getGradleDistribution()) != null && !dist.isCompatibleWithSystemJava()) {
            String javaVersion = System.getProperty("java.specification.version", System.getProperty("java.version"));
            GradleDistributionManager.GradleDistribution compatDist = GradleDistributionManager.get(dist.getGradleUserHome()).defaultDistribution();
            ProjectProblemsProvider.ProjectProblem problem = ProjectProblemsProvider.ProjectProblem.createWarning((String)Bundle.LBL_JavaVersionMismatch(), (String)Bundle.TXT_JavaVersionMismatch(javaVersion, dist.lastSupportedJava(), dist.getVersion(), compatDist.getVersion()));
            return Collections.singleton(problem);
        }
        return Collections.emptySet();
    }
}

