/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.admin;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import org.netbeans.modules.glassfish.tooling.admin.AdminFactoryHttp;
import org.netbeans.modules.glassfish.tooling.admin.AdminFactoryRest;
import org.netbeans.modules.glassfish.tooling.admin.Command;
import org.netbeans.modules.glassfish.tooling.admin.CommandException;
import org.netbeans.modules.glassfish.tooling.admin.Runner;
import org.netbeans.modules.glassfish.tooling.data.GlassFishAdminInterface;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;
import org.netbeans.modules.glassfish.tooling.data.GlassFishVersion;
import org.netbeans.modules.glassfish.tooling.logging.Logger;

public abstract class AdminFactory {
    private static final Logger LOGGER = new Logger(AdminFactory.class);

    static AdminFactory getInstance(GlassFishVersion version) throws CommandException {
        switch (version) {
            case GF_1: {
                throw new CommandException("Unsupported GlassFish version");
            }
            case GF_2: 
            case GF_2_1: 
            case GF_2_1_1: {
                return AdminFactoryHttp.getInstance();
            }
            case GF_3: 
            case GF_3_0_1: 
            case GF_3_1: 
            case GF_3_1_1: 
            case GF_3_1_2: 
            case GF_3_1_2_2: 
            case GF_3_1_2_3: 
            case GF_3_1_2_4: 
            case GF_3_1_2_5: 
            case GF_4: 
            case GF_4_0_1: 
            case GF_4_1: 
            case GF_4_1_1: 
            case GF_4_1_2: 
            case GF_5: 
            case GF_5_0_1: 
            case GF_5_1_0: 
            case GF_6: 
            case GF_6_1_0: 
            case GF_6_2_0: 
            case GF_6_2_1: 
            case GF_6_2_2: 
            case GF_6_2_3: 
            case GF_6_2_4: 
            case GF_6_2_5: {
                return AdminFactoryRest.getInstance();
            }
        }
        throw new CommandException("Unknown GlassFish version");
    }

    public static AdminFactory getInstance(GlassFishAdminInterface adminInterface) throws CommandException {
        switch (adminInterface) {
            case REST: {
                return AdminFactoryRest.getInstance();
            }
            case HTTP: {
                return AdminFactoryHttp.getInstance();
            }
        }
        throw new CommandException("Unknown GlassFish administration interface type");
    }

    public abstract Runner getRunner(GlassFishServer var1, Command var2);

    Runner newRunner(GlassFishServer srv, Command cmd, Class runnerClass) throws CommandException {
        String METHOD = "newRunner";
        Constructor con = null;
        Runner runner = null;
        try {
            con = runnerClass.getConstructor(GlassFishServer.class, Command.class);
        }
        catch (NoSuchMethodException | SecurityException nsme) {
            throw new CommandException("Cannot initialize Runner class", nsme);
        }
        if (con == null) {
            return runner;
        }
        try {
            runner = (Runner)con.newInstance(srv, cmd);
        }
        catch (IllegalAccessException | InstantiationException ie) {
            throw new CommandException("Cannot initialize Runner class", ie);
        }
        catch (InvocationTargetException ite) {
            LOGGER.log(Level.WARNING, "exceptionMsg", ite.getMessage());
            Throwable t = ite.getCause();
            if (t != null) {
                LOGGER.log(Level.WARNING, "cause", t.getMessage());
            }
            throw new CommandException("Cannot initialize Runner class", ite);
        }
        return runner;
    }
}

