/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.hints;

import com.oracle.js.parser.Source;
import com.oracle.js.parser.ir.AccessNode;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.IdentNode;
import com.oracle.js.parser.ir.LiteralNode;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.javascript2.editor.JsVersion;
import org.netbeans.modules.javascript2.editor.hints.Bundle;
import org.netbeans.modules.javascript2.editor.hints.EcmaLevelRule;
import org.netbeans.modules.javascript2.editor.hints.JsHintsProvider;
import org.netbeans.modules.javascript2.editor.hints.SwitchToEcmaXFix;
import org.netbeans.modules.javascript2.model.api.ModelUtils;
import org.netbeans.modules.javascript2.model.spi.PathNodeVisitor;
import org.netbeans.modules.javascript2.types.spi.ParserResult;

public class Ecma12Rule
extends EcmaLevelRule {
    @Override
    void computeHints(JsHintsProvider.JsRuleContext context, List<Hint> hints, int offset, HintsProvider.HintsManager manager) throws BadLocationException {
        if (Ecma12Rule.ecmaEditionProjectBelow(context, JsVersion.ECMA12)) {
            Ecma12Visitor visitor = new Ecma12Visitor();
            visitor.process(context, hints);
        }
    }

    private void addHint(JsHintsProvider.JsRuleContext context, List<Hint> hints, OffsetRange range) {
        this.addDocumenHint(context, hints, ModelUtils.documentOffsetRange((ParserResult)context.getJsParserResult(), (int)range.getStart(), (int)range.getEnd()));
    }

    private void addDocumenHint(JsHintsProvider.JsRuleContext context, List<Hint> hints, OffsetRange range) {
        hints.add(new Hint((Rule)this, Bundle.Ecma12Desc(), context.getJsParserResult().getSnapshot().getSource().getFileObject(), range, Collections.singletonList(new SwitchToEcmaXFix(context.getJsParserResult().getSnapshot(), JsVersion.ECMA12)), 600));
    }

    public Set<?> getKinds() {
        return Collections.singleton("js.other.hints");
    }

    public String getId() {
        return "ecma12.hint";
    }

    public String getDescription() {
        return Bundle.Ecma12Desc();
    }

    public String getDisplayName() {
        return Bundle.Ecma12DisplayName();
    }

    private class Ecma12Visitor
    extends PathNodeVisitor {
        private List<Hint> hints;
        private JsHintsProvider.JsRuleContext context;

        private Ecma12Visitor() {
        }

        public void process(JsHintsProvider.JsRuleContext context, List<Hint> hints) {
            this.hints = hints;
            this.context = context;
            FunctionNode root = context.getJsParserResult().getRoot();
            if (root != null) {
                context.getJsParserResult().getRoot().accept((NodeVisitor)this);
            }
        }

        public boolean enterIdentNode(IdentNode identNode) {
            if (identNode.isPrivate()) {
                Ecma12Rule.this.addHint(this.context, this.hints, new OffsetRange(identNode.getStart(), identNode.getFinish()));
            }
            return super.enterIdentNode(identNode);
        }

        public boolean enterAccessNode(AccessNode accessNode) {
            if (accessNode.getProperty().startsWith("#")) {
                Ecma12Rule.this.addHint(this.context, this.hints, new OffsetRange(accessNode.getStart(), accessNode.getFinish()));
            }
            return super.enterAccessNode(accessNode);
        }

        public boolean enterLiteralNode(LiteralNode literalNode) {
            Source source;
            String image;
            if (literalNode.isNumeric() && ((image = (source = this.context.getJsParserResult().getRoot().getSource()).getString(literalNode.getToken())).contains("_") || image.endsWith("n"))) {
                Ecma12Rule.this.addHint(this.context, this.hints, new OffsetRange(literalNode.getStart(), literalNode.getFinish()));
            }
            return super.enterLiteralNode(literalNode);
        }
    }
}

