/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ejb.wizard.mdb;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.javaee.specs.support.api.util.JndiNamespacesDefinition;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class MessageDestinationPanel
extends JPanel {
    public static final String IS_VALID = MessageDestinationPanel.class.getName() + ".IS_VALID";
    private final Map<String, MessageDestination.Type> destinationMap;
    private final boolean generated;
    private final String prefix;
    private NotificationLineSupport statusLine;
    private JLabel destinationNameLabel;
    private JTextField destinationNameText;
    private ButtonGroup destinationTypeGroup;
    private JLabel destinationTypeLabel;
    private JRadioButton queueTypeRadio;
    private JRadioButton topicTypeRadio;

    private MessageDestinationPanel(Map<String, MessageDestination.Type> destinationMap, boolean generated, String prefix) {
        this.initComponents();
        this.destinationMap = destinationMap;
        this.generated = generated;
        this.prefix = prefix;
    }

    public static MessageDestinationPanel newInstance(Map<String, MessageDestination.Type> destinationMap, boolean generated, String prefix) {
        MessageDestinationPanel mdp = new MessageDestinationPanel(destinationMap, generated, prefix);
        mdp.initialize();
        return mdp;
    }

    public void setNotificationLine(NotificationLineSupport statusLine) {
        this.statusLine = statusLine;
    }

    public String getDestinationName() {
        String name = this.destinationNameText.getText().trim();
        if (this.generated) {
            return JndiNamespacesDefinition.normalize((String)name, (String)this.prefix);
        }
        return name;
    }

    public MessageDestination.Type getDestinationType() {
        if (this.queueTypeRadio.isSelected()) {
            return MessageDestination.Type.QUEUE;
        }
        return MessageDestination.Type.TOPIC;
    }

    private void initialize() {
        this.registerListeners();
        this.verifyAndFire();
    }

    private void registerListeners() {
        this.destinationNameText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent event) {
                MessageDestinationPanel.this.verifyAndFire();
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                MessageDestinationPanel.this.verifyAndFire();
            }

            @Override
            public void changedUpdate(DocumentEvent event) {
                MessageDestinationPanel.this.verifyAndFire();
            }
        });
        this.queueTypeRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MessageDestinationPanel.this.verifyAndFire();
            }
        });
        this.topicTypeRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MessageDestinationPanel.this.verifyAndFire();
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                MessageDestinationPanel.this.verifyAndFire();
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                MessageDestinationPanel.this.verifyAndFire();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                MessageDestinationPanel.this.verifyAndFire();
            }
        });
    }

    private void setError(String key) {
        if (this.statusLine != null) {
            this.statusLine.setErrorMessage(NbBundle.getMessage(MessageDestinationPanel.class, (String)key));
        }
    }

    private void setInfo(String key) {
        if (this.statusLine != null) {
            this.statusLine.setInformationMessage(NbBundle.getMessage(MessageDestinationPanel.class, (String)key));
        }
    }

    private void verifyAndFire() {
        boolean isValid = this.verifyComponents();
        this.firePropertyChange(IS_VALID, !isValid, isValid);
    }

    private boolean verifyComponents() {
        MessageDestination.Type type;
        String destinationName = this.destinationNameText.getText();
        if (destinationName == null || destinationName.trim().length() == 0) {
            this.setInfo("ERR_NoDestinationName");
            return false;
        }
        destinationName = destinationName.trim();
        if (this.generated) {
            destinationName = JndiNamespacesDefinition.normalize((String)destinationName, (String)this.prefix);
        }
        if ((type = this.destinationMap.get(destinationName)) != null && type.equals((Object)this.getDestinationType())) {
            this.setError("ERR_DuplicateDestination");
            return false;
        }
        if (this.destinationTypeGroup.getSelection() == null) {
            this.setInfo("ERR_NoDestinationType");
            return false;
        }
        this.statusLine.clearMessages();
        return true;
    }

    private void initComponents() {
        this.destinationTypeGroup = new ButtonGroup();
        this.destinationNameLabel = new JLabel();
        this.destinationNameText = new JTextField();
        this.destinationTypeLabel = new JLabel();
        this.queueTypeRadio = new JRadioButton();
        this.topicTypeRadio = new JRadioButton();
        this.destinationNameLabel.setLabelFor(this.destinationNameText);
        Mnemonics.setLocalizedText((JLabel)this.destinationNameLabel, (String)NbBundle.getMessage(MessageDestinationPanel.class, (String)"LBL_DestinationName"));
        this.destinationTypeLabel.setLabelFor(this.queueTypeRadio);
        Mnemonics.setLocalizedText((JLabel)this.destinationTypeLabel, (String)NbBundle.getMessage(MessageDestinationPanel.class, (String)"LBL_DestinationType"));
        this.destinationTypeGroup.add(this.queueTypeRadio);
        this.queueTypeRadio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.queueTypeRadio, (String)NbBundle.getMessage(MessageDestinationPanel.class, (String)"LBL_Queue"));
        this.queueTypeRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.queueTypeRadio.setMargin(new Insets(0, 0, 0, 0));
        this.destinationTypeGroup.add(this.topicTypeRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.topicTypeRadio, (String)NbBundle.getMessage(MessageDestinationPanel.class, (String)"LBL_Topic"));
        this.topicTypeRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.topicTypeRadio.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.destinationTypeLabel).addComponent(this.destinationNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.topicTypeRadio).addComponent(this.queueTypeRadio).addComponent(this.destinationNameText, -1, 277, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.destinationNameLabel).addComponent(this.destinationNameText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.destinationTypeLabel).addComponent(this.queueTypeRadio)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.topicTypeRadio).addContainerGap(-1, Short.MAX_VALUE)));
        this.destinationNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MessageDestinationPanel.class, (String)"MessageDestinationPanel.destinationNameLabel.AccessibleContext.accessibleDescription"));
        this.queueTypeRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MessageDestinationPanel.class, (String)"MessageDestinationPanel.queueTypeRadio.AccessibleContext.accessibleDescription"));
        this.topicTypeRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MessageDestinationPanel.class, (String)"MessageDestinationPanel.topicTypeRadio.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MessageDestinationPanel.class, (String)"ACSD_AddMessageDestination"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MessageDestinationPanel.class, (String)"ACSD_AddMessageDestination"));
    }
}

