/*
 * Decompiled with CFR 0.152.
 */
package javax.security.enterprise.credential;

import java.io.UnsupportedEncodingException;
import java.util.Base64;
import javax.security.enterprise.credential.Password;
import javax.security.enterprise.credential.UsernamePasswordCredential;

public class BasicAuthenticationCredential
extends UsernamePasswordCredential {
    public BasicAuthenticationCredential(String authorizationHeader) {
        super(BasicAuthenticationCredential.parseUsername(authorizationHeader), BasicAuthenticationCredential.parsePassword(authorizationHeader));
    }

    private static String decodeHeader(String authorizationHeader) {
        String BASIC_AUTH_CHARSET = "US-ASCII";
        if (null == authorizationHeader) {
            throw new NullPointerException("authorization header");
        }
        if (authorizationHeader.isEmpty()) {
            throw new IllegalArgumentException("authorization header is empty");
        }
        Base64.Decoder decoder = Base64.getMimeDecoder();
        byte[] decodedBytes = decoder.decode(authorizationHeader);
        try {
            return new String(decodedBytes, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unknown Charset: US-ASCII", e);
        }
    }

    private static String parseUsername(String authorizationHeader) {
        String decodedAuthorizationHeader = BasicAuthenticationCredential.decodeHeader(authorizationHeader);
        int delimiterIndex = decodedAuthorizationHeader.indexOf(58);
        if (delimiterIndex > -1) {
            return decodedAuthorizationHeader.substring(0, delimiterIndex);
        }
        return decodedAuthorizationHeader;
    }

    private static Password parsePassword(String authorizationHeader) {
        String decodedAuthorizationHeader = BasicAuthenticationCredential.decodeHeader(authorizationHeader);
        int delimiterIndex = decodedAuthorizationHeader.indexOf(58);
        if (delimiterIndex > -1) {
            return new Password(decodedAuthorizationHeader.substring(delimiterIndex + 1));
        }
        return new Password("");
    }
}

