/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DeploymentContext;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DeploymentManager2;
import org.netbeans.modules.javaee.wildfly.ChangelogWildflyPlugin;
import org.netbeans.modules.javaee.wildfly.WildflyTargetModuleID;
import org.netbeans.modules.javaee.wildfly.config.WildflyMessageDestination;
import org.netbeans.modules.javaee.wildfly.deploy.WildflyDeploymentStatus;
import org.netbeans.modules.javaee.wildfly.deploy.WildflyProgressObject;
import org.netbeans.modules.javaee.wildfly.ide.commands.WildflyClient;
import org.netbeans.modules.javaee.wildfly.ide.commands.WildflyModule;
import org.netbeans.modules.javaee.wildfly.ide.ui.WildflyPluginUtils;
import org.netbeans.modules.javaee.wildfly.util.WildFlyProperties;

public class WildflyDeploymentManager
implements DeploymentManager2 {
    private static final Logger LOGGER = Logger.getLogger(WildflyDeploymentManager.class.getName());
    private static final int DEBUGGING_PORT = 8787;
    private static final int CONTROLLER_PORT = 9990;
    private final WildflyPluginUtils.Version version;
    private final boolean isWildfly;
    private final WildflyClient client;
    private static final Map<InstanceProperties, Boolean> PROPERTIES_TO_IS_RUNNING = Collections.synchronizedMap(new WeakHashMap());
    private final DeploymentFactory df;
    private final String realUri;
    private final InstanceProperties instanceProperties;
    private boolean needsRestart;

    public WildflyDeploymentManager(DeploymentFactory df, String realUri, String jbUri, String username, String password) {
        this.df = df;
        this.realUri = realUri;
        this.instanceProperties = InstanceProperties.getInstanceProperties((String)realUri);
        File serverPath = new File(this.instanceProperties.getProperty("root-dir"));
        this.version = WildflyPluginUtils.getServerVersion(serverPath);
        this.isWildfly = WildflyPluginUtils.isWildFly(serverPath);
        int controllerPort = 9990;
        String adminPort = this.instanceProperties.getProperty("admin-port");
        if (adminPort != null) {
            controllerPort = Integer.parseInt(this.instanceProperties.getProperty("admin-port"));
        }
        this.client = username != null && password != null ? new WildflyClient(this.instanceProperties, this.version, this.getHost(), controllerPort, username, password) : new WildflyClient(this.instanceProperties, this.version, this.getHost(), controllerPort);
        ChangelogWildflyPlugin.showChangelog();
    }

    public static boolean isRunningLastCheck(InstanceProperties ip) {
        return PROPERTIES_TO_IS_RUNNING.containsKey(ip) && PROPERTIES_TO_IS_RUNNING.get(ip).equals(Boolean.TRUE);
    }

    public static void setRunningLastCheck(InstanceProperties ip, Boolean isRunning) {
        PROPERTIES_TO_IS_RUNNING.put(ip, isRunning);
    }

    public ProgressObject redeploy(TargetModuleID[] tmids, DeploymentContext deployment) {
        if (this.df == null) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        WildflyProgressObject progress = new WildflyProgressObject(tmids);
        progress.fireProgressEvent(null, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.REDEPLOY, StateType.RUNNING, ""));
        try {
            if (this.getClient().deploy(deployment)) {
                for (TargetModuleID tmid : tmids) {
                    ((WildflyTargetModuleID)tmid).setContextURL(this.getClient().getWebModuleURL(tmid.getModuleID()));
                    progress.fireProgressEvent(tmid, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.COMPLETED, ""));
                }
            } else {
                progress.fireProgressEvent(null, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.REDEPLOY, StateType.FAILED, ""));
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            progress.fireProgressEvent(null, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.REDEPLOY, StateType.FAILED, ex.getMessage()));
        }
        return progress;
    }

    public ProgressObject distribute(Target[] targets, DeploymentContext deployment) {
        if (this.df == null) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        ArrayList<WildflyTargetModuleID> moduleIds = new ArrayList<WildflyTargetModuleID>(targets.length);
        for (Target target : targets) {
            moduleIds.add(new WildflyTargetModuleID(target, deployment.getModuleFile().getName(), deployment.getModule().getType(), deployment.getModuleFile().isDirectory()));
        }
        TargetModuleID[] tmids = moduleIds.toArray(new WildflyTargetModuleID[targets.length]);
        WildflyProgressObject progress = new WildflyProgressObject(tmids);
        progress.fireProgressEvent(null, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, ""));
        try {
            if (this.getClient().deploy(deployment)) {
                for (TargetModuleID tmid : tmids) {
                    tmid.setContextURL(this.getClient().getWebModuleURL(tmid.getModuleID()));
                    progress.fireProgressEvent(tmid, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.COMPLETED, ""));
                }
            } else {
                progress.fireProgressEvent(tmids[0], new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, ""));
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            progress.fireProgressEvent(tmids[0], new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, ex.getMessage()));
        }
        return progress;
    }

    public Target[] getTargets() throws IllegalStateException {
        return new Target[]{new Target(){

            public String getName() {
                return "WildFly Target";
            }

            public String getDescription() {
                return "WildFly Target";
            }
        }};
    }

    public TargetModuleID[] getRunningModules(ModuleType mt, Target[] targets) throws TargetException, IllegalStateException {
        if (this.df == null) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        ArrayList<WildflyTargetModuleID> result = new ArrayList<WildflyTargetModuleID>();
        try {
            Collection<WildflyModule> modules = this.getClient().listAvailableModules();
            if (ModuleType.EJB.equals(mt)) {
                for (WildflyModule module : modules) {
                    if (!module.getArchiveName().endsWith("jar") || !module.isRunning()) continue;
                    result.add(new WildflyTargetModuleID(targets[0], module.getArchiveName(), J2eeModule.Type.fromJsrType((Object)mt), false));
                }
            } else if (ModuleType.WAR.equals(mt)) {
                for (WildflyModule module : modules) {
                    if (!module.getArchiveName().endsWith("war") || !module.isRunning()) continue;
                    WildflyTargetModuleID moduleId = new WildflyTargetModuleID(targets[0], module.getArchiveName(), J2eeModule.Type.fromJsrType((Object)mt), false);
                    moduleId.setContextURL(module.getUrl());
                    result.add(moduleId);
                }
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return new TargetModuleID[0];
        }
        return result.toArray(new TargetModuleID[result.size()]);
    }

    public TargetModuleID[] getNonRunningModules(ModuleType mt, Target[] targets) throws TargetException, IllegalStateException {
        if (this.df == null) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        return new TargetModuleID[0];
    }

    public TargetModuleID[] getAvailableModules(ModuleType mt, Target[] targets) throws TargetException, IllegalStateException {
        if (this.df == null) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        ArrayList<WildflyTargetModuleID> result = new ArrayList<WildflyTargetModuleID>();
        try {
            Collection<WildflyModule> modules = this.getClient().listAvailableModules();
            if (ModuleType.EJB.equals(mt)) {
                for (WildflyModule module : modules) {
                    if (!module.getArchiveName().endsWith("jar") || !module.isRunning()) continue;
                    result.add(new WildflyTargetModuleID(targets[0], module.getArchiveName(), J2eeModule.Type.fromJsrType((Object)mt), false));
                }
            } else if (ModuleType.WAR.equals(mt)) {
                for (WildflyModule module : modules) {
                    if (!module.getArchiveName().endsWith("war")) continue;
                    WildflyTargetModuleID moduleId = new WildflyTargetModuleID(targets[0], module.getArchiveName(), J2eeModule.Type.fromJsrType((Object)mt), false);
                    moduleId.setContextURL(module.getUrl());
                    result.add(moduleId);
                }
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return new TargetModuleID[0];
        }
        return result.toArray(new TargetModuleID[result.size()]);
    }

    public ProgressObject distribute(Target[] targets, File file, File file1) throws IllegalStateException {
        if (this.df == null) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ProgressObject start(TargetModuleID[] tmids) throws IllegalStateException {
        WildflyProgressObject progress = new WildflyProgressObject(tmids);
        progress.fireProgressEvent(null, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.RUNNING, null));
        for (TargetModuleID tmid : tmids) {
            WildflyTargetModuleID wflyTmid = (WildflyTargetModuleID)tmid;
            try {
                if (!wflyTmid.isExploded() && !this.client.startModule(wflyTmid.getModuleID())) continue;
                progress.fireProgressEvent(tmid, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.COMPLETED, null));
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
                progress.fireProgressEvent(wflyTmid, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.FAILED, ex.getMessage()));
            }
        }
        return progress;
    }

    public ProgressObject stop(TargetModuleID[] tmids) throws IllegalStateException {
        if (this.df == null) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ProgressObject undeploy(TargetModuleID[] tmids) throws IllegalStateException {
        WildflyProgressObject progress = new WildflyProgressObject(tmids);
        progress.fireProgressEvent(tmids[0], new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.UNDEPLOY, StateType.RUNNING, null));
        try {
            if (this.client.undeploy(tmids[0].getModuleID())) {
                progress.fireProgressEvent(null, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.UNDEPLOY, StateType.COMPLETED, null));
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            progress.fireProgressEvent(null, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.UNDEPLOY, StateType.FAILED, ex.getMessage()));
        }
        return progress;
    }

    public ProgressObject redeploy(TargetModuleID[] tmids, File file, File file1) throws UnsupportedOperationException, IllegalStateException {
        if (this.df == null) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ProgressObject redeploy(TargetModuleID[] tmids, InputStream in, InputStream in1) throws UnsupportedOperationException, IllegalStateException {
        if (this.df == null) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isRedeploySupported() {
        return true;
    }

    public void release() {
    }

    public String getHost() {
        String host = InstanceProperties.getInstanceProperties((String)this.realUri).getProperty("host");
        return host;
    }

    public int getPort() {
        String port = InstanceProperties.getInstanceProperties((String)this.realUri).getProperty("port");
        return Integer.parseInt(port);
    }

    public WildflyPluginUtils.Version getServerVersion() {
        return this.version;
    }

    public int getDebuggingPort() {
        return 8787;
    }

    public InstanceProperties getInstanceProperties() {
        return this.instanceProperties;
    }

    public String getUrl() {
        return this.realUri;
    }

    public WildFlyProperties getProperties() {
        return new WildFlyProperties(this);
    }

    public boolean isWildfly() {
        return this.isWildfly;
    }

    public synchronized void setNeedsRestart(boolean needsRestart) {
        this.needsRestart = needsRestart;
    }

    public synchronized boolean getNeedsRestart() {
        return this.needsRestart;
    }

    public WildflyClient getClient() {
        return this.client;
    }

    @Deprecated
    public ProgressObject distribute(Target[] targets, InputStream in, InputStream in1) throws IllegalStateException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public ProgressObject distribute(Target[] targets, ModuleType mt, InputStream in, InputStream in1) throws IllegalStateException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public DeploymentConfiguration createConfiguration(DeployableObject d) throws InvalidModuleException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public Locale getDefaultLocale() {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public Locale getCurrentLocale() {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public void setLocale(Locale locale) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public Locale[] getSupportedLocales() {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public boolean isLocaleSupported(Locale locale) {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType dcbvt) {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType dcbvt) throws DConfigBeanVersionUnsupportedException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public ProgressObject deployMessageDestinations(Collection<WildflyMessageDestination> destinations) {
        WildflyProgressObject progress = new WildflyProgressObject(new TargetModuleID[0]);
        progress.fireProgressEvent(null, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.UNDEPLOY, StateType.RUNNING, null));
        try {
            if (this.client.addMessageDestinations(destinations, this.getInstanceProperties())) {
                progress.fireProgressEvent(null, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.UNDEPLOY, StateType.COMPLETED, null));
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            progress.fireProgressEvent(null, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.UNDEPLOY, StateType.FAILED, ex.getMessage()));
        }
        return progress;
    }
}

