/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.ide.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.javaee.wildfly.ide.ui.WildflyPluginProperties;
import org.netbeans.modules.javaee.wildfly.ide.ui.WildflyPluginUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AddServerLocationVisualPanel
extends JPanel {
    private final Set listeners = new HashSet();
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JTextField locationTextField;
    private JTextField configurationTextField;

    public AddServerLocationVisualPanel() {
        this.initComponents();
        this.setName(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"TITLE_ServerLocation"));
        this.locationTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddServerLocationVisualPanel.this.locationChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddServerLocationVisualPanel.this.locationChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddServerLocationVisualPanel.this.locationChanged();
            }
        });
        this.configurationTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddServerLocationVisualPanel.this.locationChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddServerLocationVisualPanel.this.locationChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddServerLocationVisualPanel.this.locationChanged();
            }
        });
    }

    public String getInstallLocation() {
        return this.locationTextField.getText();
    }

    public String getConfigurationLocation() {
        return this.configurationTextField.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent() {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    private void locationChanged() {
        this.fireChangeEvent();
    }

    private String browseInstallLocation() {
        String insLocation = null;
        JFileChooser chooser = this.getJFileChooser();
        int returnValue = chooser.showDialog(SwingUtilities.getWindowAncestor(this), NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_ChooseButton"));
        if (returnValue == 0) {
            insLocation = chooser.getSelectedFile().getAbsolutePath();
        }
        return insLocation;
    }

    private String browseConfiguration() {
        String insLocation = null;
        JFileChooser chooser = this.getConfigJFileChooser();
        int returnValue = chooser.showDialog(SwingUtilities.getWindowAncestor(this), NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_ChooseButton"));
        if (returnValue == 0) {
            insLocation = chooser.getSelectedFile().getAbsolutePath();
        }
        return insLocation;
    }

    private JFileChooser getJFileChooser() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_ChooserName"));
        chooser.setDialogType(2);
        chooser.setFileSelectionMode(1);
        chooser.setApproveButtonMnemonic("Choose_Button_Mnemonic".charAt(0));
        chooser.setMultiSelectionEnabled(false);
        chooser.setApproveButtonToolTipText(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_ChooserName"));
        chooser.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_ChooserName"));
        chooser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_ChooserName"));
        chooser.setSelectedFile(new File(this.locationTextField.getText().trim()));
        return chooser;
    }

    private JFileChooser getConfigJFileChooser() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_ConfigChooserName"));
        chooser.setDialogType(2);
        chooser.setFileSelectionMode(2);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.isFile() && file.getName().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return "";
            }
        });
        chooser.setApproveButtonMnemonic("Choose_Button_Mnemonic".charAt(0));
        chooser.setMultiSelectionEnabled(false);
        chooser.setApproveButtonToolTipText(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_ConfigChooserName"));
        chooser.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_ConfigChooserName"));
        chooser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_ConfigChooserName"));
        chooser.setSelectedFile(new File(this.configurationTextField.getText().trim()));
        return chooser;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.locationTextField = new JTextField();
        this.jButton1 = new JButton();
        this.jLabel2 = new JLabel();
        this.configurationTextField = new JTextField();
        this.jButton2 = new JButton();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.locationTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_InstallLocation"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.locationTextField.setColumns(15);
        this.locationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_InstallLocation"));
        this.locationTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_InstallLocation"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.locationTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_BrowseButton"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddServerLocationVisualPanel.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.jButton1, gridBagConstraints);
        this.jButton1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_BrowseButton"));
        this.jButton1.getAccessibleContext().setAccessibleDescription("ACSD_Browse_Button_InstallLoc");
        this.jLabel2.setLabelFor(this.configurationTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_ConfigurationLocation"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        gridBagConstraints.gridy = 2;
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.configurationTextField.setColumns(15);
        this.configurationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_ConfigurationLocation"));
        this.configurationTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_ConfigurationLocation"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.configurationTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_BrowseButton"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddServerLocationVisualPanel.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jButton2, gridBagConstraints);
        this.jButton2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_BrowseButton"));
        this.jButton2.getAccessibleContext().setAccessibleDescription("ACSD_Browse_Button_InstallLoc");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel1.getAccessibleContext().setAccessibleName("TITLE_AddServerLocationPanel");
        this.jPanel1.getAccessibleContext().setAccessibleDescription("AddServerLocationPanel_Desc");
        if (WildflyPluginProperties.getInstance().getInstallLocation() != null) {
            this.locationTextField.setText(WildflyPluginProperties.getInstance().getInstallLocation());
            if (WildflyPluginProperties.getInstance().getConfigLocation() != null) {
                this.configurationTextField.setText(WildflyPluginProperties.getInstance().getConfigLocation());
            } else {
                this.configurationTextField.setText(WildflyPluginUtils.getDefaultConfigurationFile(WildflyPluginProperties.getInstance().getInstallLocation()));
            }
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        String newLoc = this.browseInstallLocation();
        if (newLoc != null && !"".equals(newLoc)) {
            this.locationTextField.setText(newLoc);
            String configurationFilePath = newLoc + File.separatorChar + "standalone" + File.separatorChar + "configuration" + File.separatorChar + "standalone-full.xml";
            if (this.configurationTextField.getText() == null || this.configurationTextField.getText().isEmpty()) {
                if (new File(configurationFilePath).exists()) {
                    this.configurationTextField.setText(configurationFilePath);
                }
            } else if (!this.configurationTextField.getText().startsWith(newLoc)) {
                NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"MSG_WARN_INSTALLATION_DIFFERS_CONFIGURATION", (Object)configurationFilePath), 2);
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                if (result == NotifyDescriptor.CANCEL_OPTION) {
                    return;
                }
                this.configurationTextField.setText(configurationFilePath);
            }
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        String newLoc = this.browseConfiguration();
        if (newLoc != null && !"".equals(newLoc)) {
            this.configurationTextField.setText(newLoc);
        }
    }
}

