/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.util;

import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibrarySupport;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.util.Parameters;

public class JPAClassPathHelper {
    private final Set<ClassPath> boot;
    private final Set<ClassPath> compile;
    private final Set<ClassPath> source;
    private Set<ClassPath> moduleBoot;
    private Set<ClassPath> moduleCompile;
    private Set<ClassPath> moduleClass;
    private Set<ClassPath> moduleSource;

    public JPAClassPathHelper(Set<ClassPath> boot, Set<ClassPath> compile, Set<ClassPath> source) {
        Parameters.notNull((CharSequence)"boot", boot);
        Parameters.notNull((CharSequence)"compile", compile);
        Parameters.notNull((CharSequence)"source", source);
        this.boot = new HashSet<ClassPath>(boot);
        this.compile = new HashSet<ClassPath>(compile);
        this.source = new HashSet<ClassPath>(source);
    }

    public JPAClassPathHelper setModuleBootPaths(Set<ClassPath> moduleBoot) {
        if (moduleBoot == null) {
            moduleBoot = Collections.emptySet();
        }
        this.moduleBoot = moduleBoot;
        return this;
    }

    public JPAClassPathHelper setModuleCompilePaths(Set<ClassPath> moduleCompile) {
        if (moduleCompile == null) {
            moduleCompile = Collections.emptySet();
        }
        this.moduleCompile = moduleCompile;
        return this;
    }

    public JPAClassPathHelper setModuleClassPaths(Set<ClassPath> moduleClass) {
        if (moduleClass == null) {
            moduleClass = Collections.emptySet();
        }
        this.moduleClass = moduleClass;
        return this;
    }

    public JPAClassPathHelper setModuleSourcePaths(Set<ClassPath> moduleSource) {
        if (moduleSource == null) {
            moduleSource = Collections.emptySet();
        }
        this.moduleSource = moduleSource;
        return this;
    }

    public ClasspathInfo createClasspathInfo() {
        if (!this.ensureJPA()) {
            throw new IllegalStateException("Cannot find a Java Persistence API library");
        }
        return new ClasspathInfo.Builder(this.createProxyClassPath(this.boot)).setModuleBootPath(this.createProxyClassPath(this.moduleBoot)).setClassPath(this.createProxyClassPath(this.compile)).setModuleCompilePath(this.createProxyClassPath(this.moduleCompile)).setModuleClassPath(this.createProxyClassPath(this.moduleClass)).setSourcePath(this.createProxyClassPath(this.source)).setModuleSourcePath(this.createProxyClassPath(this.moduleSource)).build();
    }

    private boolean ensureJPA() {
        for (ClassPath classPath : this.compile) {
            if (classPath.findResource("javax/persistence/Entity.class") == null) continue;
            return true;
        }
        ClassPath jpaClassPath = this.findJPALibrary();
        if (jpaClassPath != null) {
            this.compile.add(jpaClassPath);
            return true;
        }
        return false;
    }

    private ClassPath findJPALibrary() {
        Library library = PersistenceLibrarySupport.getFirstProviderLibrary();
        if (library == null) {
            return null;
        }
        List urls = library.getContent("classpath");
        return ClassPathSupport.createClassPath((URL[])urls.toArray(new URL[urls.size()]));
    }

    private ClassPath createProxyClassPath(Set<ClassPath> classPaths) {
        return classPaths.isEmpty() ? ClassPath.EMPTY : ClassPathSupport.createProxyClassPath((ClassPath[])classPaths.toArray(new ClassPath[classPaths.size()]));
    }
}

