/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.listeners;

import java.lang.annotation.ElementType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventAdapter;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;

public class BeanValidationListener
extends DescriptorEventAdapter {
    private final ValidatorFactory validatorFactory;
    private final Class[] groupPrePersit;
    private final Class[] groupPreUpdate;
    private final Class[] groupPreRemove;
    private static final Class[] groupDefault = new Class[]{Default.class};
    private final Map<ClassDescriptor, Validator> validatorMap;

    public BeanValidationListener(ValidatorFactory validatorFactory, Class[] groupPrePersit, Class[] groupPreUpdate, Class[] groupPreRemove) {
        this.validatorFactory = validatorFactory;
        this.groupPrePersit = groupPrePersit != null ? groupPrePersit : groupDefault;
        this.groupPreUpdate = groupPreUpdate != null ? groupPreUpdate : groupDefault;
        this.groupPreRemove = groupPreRemove;
        this.validatorMap = new ConcurrentHashMap<ClassDescriptor, Validator>();
    }

    public void prePersist(DescriptorEvent event) {
        this.validateOnCallbackEvent(event, "prePersist", this.groupPrePersit);
    }

    public void aboutToUpdate(DescriptorEvent event) {
        Object source = event.getSource();
        UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)event.getSession();
        if (!unitOfWork.isObjectDeleted(source)) {
            this.validateOnCallbackEvent(event, "preUpdate", this.groupPreUpdate);
        }
    }

    public void preUpdateWithChanges(DescriptorEvent event) {
        this.aboutToUpdate(event);
    }

    public void preRemove(DescriptorEvent event) {
        if (this.groupPreRemove != null) {
            this.validateOnCallbackEvent(event, "preRemove", this.groupPreRemove);
        }
    }

    private void validateOnCallbackEvent(DescriptorEvent event, String callbackEventName, Class[] validationGroup) {
        Set<ConstraintViolation<Object>> constraintViolations;
        boolean shouldValidate;
        Object source = event.getSource();
        Validator validator = this.getValidator(event);
        boolean isBeanConstrained = this.isBeanConstrained(source, validator);
        boolean noOptimization = "true".equalsIgnoreCase((String)event.getSession().getProperty("eclipselink.beanvalidation.no-optimisation"));
        boolean bl = shouldValidate = noOptimization || isBeanConstrained;
        if (shouldValidate && (constraintViolations = this.validate(source, validationGroup, validator)).size() > 0) {
            throw new ConstraintViolationException(ExceptionLocalization.buildMessage((String)"bean_validation_constraint_violated", (Object[])new Object[]{callbackEventName, source.getClass().getName()}), constraintViolations);
        }
    }

    private Validator getValidator(DescriptorEvent event) {
        ClassDescriptor descriptor = event.getDescriptor();
        Validator res = this.validatorMap.get(descriptor);
        if (res == null) {
            AutomaticLifeCycleValidationTraversableResolver traversableResolver = new AutomaticLifeCycleValidationTraversableResolver(descriptor);
            res = this.validatorFactory.usingContext().traversableResolver((TraversableResolver)traversableResolver).getValidator();
            Validator t = this.validatorMap.put(descriptor, res);
            if (t != null) {
                res = t;
            }
        }
        return res;
    }

    private boolean isBeanConstrained(final Object source, final Validator validator) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return validator.getConstraintsForClass(source.getClass()).isBeanConstrained();
                }
            });
        }
        return validator.getConstraintsForClass(source.getClass()).isBeanConstrained();
    }

    private Set<ConstraintViolation<Object>> validate(final Object source, final Class[] validationGroup, final Validator validator) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return AccessController.doPrivileged(new PrivilegedAction<Set<ConstraintViolation<Object>>>(){

                @Override
                public Set<ConstraintViolation<Object>> run() {
                    return validator.validate(source, validationGroup);
                }
            });
        }
        return validator.validate(source, validationGroup);
    }

    private static class AutomaticLifeCycleValidationTraversableResolver
    implements TraversableResolver {
        private final ClassDescriptor descriptor;

        AutomaticLifeCycleValidationTraversableResolver(ClassDescriptor eventDescriptor) {
            this.descriptor = eventDescriptor;
        }

        public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            DatabaseMapping mapping;
            boolean reachable = true;
            String attributeName = null;
            if (this.isRootObjectPath(pathToTraversableObject) && (mapping = this.getMappingForAttributeName(attributeName = traversableProperty.getName())) != null) {
                if (mapping.isForeignReferenceMapping()) {
                    if (mapping.isLazy()) {
                        Object attributeValue = mapping.getAttributeAccessor().getAttributeValueFromObject(traversableObject);
                        reachable = ((ForeignReferenceMapping)mapping).getIndirectionPolicy().objectIsInstantiatedOrChanged(attributeValue);
                    }
                } else {
                    FetchGroupManager fetchGroupManager = this.descriptor.getFetchGroupManager();
                    if (fetchGroupManager != null) {
                        reachable = fetchGroupManager.isAttributeFetched(traversableObject, attributeName);
                    }
                }
            }
            return reachable;
        }

        public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            String attributeName;
            DatabaseMapping mapping;
            boolean cascadable = true;
            if (this.isRootObjectPath(pathToTraversableObject) && (mapping = this.getMappingForAttributeName(attributeName = traversableProperty.getName())) != null && mapping.isForeignReferenceMapping()) {
                cascadable = false;
            }
            return cascadable;
        }

        private DatabaseMapping getMappingForAttributeName(String attributeName) {
            return this.descriptor.getObjectBuilder().getMappingForAttributeName(attributeName);
        }

        private boolean isRootObjectPath(Path pathToTraversableObject) {
            return ((Path.Node)pathToTraversableObject.iterator().next()).getName() == null;
        }
    }
}

