/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;

public class TreeDuplicator {
    private final TreeMaker make;
    private final GeneratorUtilities genUtils;

    public TreeDuplicator(TreeMaker make, GeneratorUtilities genUtils) {
        this.make = make;
        this.genUtils = genUtils;
    }

    public <T extends Tree> T duplicate(T tree) {
        Object result = tree;
        switch (tree.getKind()) {
            case BREAK: {
                BreakTree t = (BreakTree)tree;
                result = this.make.setLabel(tree, (CharSequence)t.getLabel());
                break;
            }
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION_TYPE: {
                ClassTree t = (ClassTree)tree;
                result = this.make.setLabel(tree, (CharSequence)t.getSimpleName());
                break;
            }
            case CONTINUE: {
                ContinueTree t = (ContinueTree)tree;
                result = this.make.setLabel(tree, (CharSequence)t.getLabel());
                break;
            }
            case IDENTIFIER: {
                IdentifierTree t = (IdentifierTree)tree;
                result = this.make.setLabel(tree, (CharSequence)t.getName());
                break;
            }
            case LABELED_STATEMENT: {
                LabeledStatementTree t = (LabeledStatementTree)tree;
                result = this.make.setLabel(tree, (CharSequence)t.getLabel());
                break;
            }
            case MEMBER_SELECT: {
                MemberSelectTree t = (MemberSelectTree)tree;
                result = this.make.setLabel(tree, (CharSequence)t.getIdentifier());
                break;
            }
            case METHOD: {
                MethodTree t = (MethodTree)tree;
                result = this.make.setLabel(tree, (CharSequence)t.getName());
                break;
            }
            case TYPE_PARAMETER: {
                TypeParameterTree t = (TypeParameterTree)tree;
                result = this.make.setLabel(tree, (CharSequence)t.getName());
                break;
            }
            case VARIABLE: {
                VariableTree mrt = (VariableTree)tree;
                result = this.make.setLabel(tree, (CharSequence)mrt.getName());
                break;
            }
            case MEMBER_REFERENCE: {
                MemberReferenceTree mrt = (MemberReferenceTree)tree;
                result = this.make.setLabel(tree, (CharSequence)mrt.getName());
                break;
            }
            case ANNOTATION: {
                AnnotationTree t = (AnnotationTree)tree;
                result = this.make.Annotation(t.getAnnotationType(), t.getArguments());
                break;
            }
            case TYPE_ANNOTATION: {
                AnnotationTree t = (AnnotationTree)tree;
                result = this.make.Annotation(t.getAnnotationType(), t.getArguments());
                break;
            }
            case ARRAY_ACCESS: {
                ArrayAccessTree t = (ArrayAccessTree)tree;
                result = this.make.ArrayAccess(t.getIndex(), t.getIndex());
                break;
            }
            case ARRAY_TYPE: {
                ArrayTypeTree t = (ArrayTypeTree)tree;
                result = this.make.ArrayType(t.getType());
                break;
            }
            case ASSERT: {
                AssertTree t = (AssertTree)tree;
                result = this.make.Assert(t.getCondition(), t.getDetail());
                break;
            }
            case ASSIGNMENT: {
                AssignmentTree t = (AssignmentTree)tree;
                result = this.make.Assignment(t.getVariable(), t.getExpression());
                break;
            }
            case BLOCK: {
                BlockTree t = (BlockTree)tree;
                result = this.make.Block(t.getStatements(), t.isStatic());
                break;
            }
            case CASE: {
                CaseTree t = (CaseTree)tree;
                result = this.make.Case(t.getExpression(), t.getStatements());
                break;
            }
            case CATCH: {
                CatchTree t = (CatchTree)tree;
                result = this.make.Catch(t.getParameter(), t.getBlock());
                break;
            }
            case CONDITIONAL_EXPRESSION: {
                ConditionalExpressionTree t = (ConditionalExpressionTree)tree;
                result = this.make.ConditionalExpression(t.getCondition(), t.getTrueExpression(), t.getFalseExpression());
                break;
            }
            case DO_WHILE_LOOP: {
                DoWhileLoopTree t = (DoWhileLoopTree)tree;
                result = this.make.DoWhileLoop(t.getCondition(), t.getStatement());
                break;
            }
            case ENHANCED_FOR_LOOP: {
                EnhancedForLoopTree t = (EnhancedForLoopTree)tree;
                result = this.make.EnhancedForLoop(t.getVariable(), t.getExpression(), t.getStatement());
                break;
            }
            case EXPRESSION_STATEMENT: {
                ExpressionStatementTree t = (ExpressionStatementTree)tree;
                result = this.make.ExpressionStatement(t.getExpression());
                break;
            }
            case FOR_LOOP: {
                ForLoopTree t = (ForLoopTree)tree;
                result = this.make.ForLoop(t.getInitializer(), t.getCondition(), t.getUpdate(), t.getStatement());
                break;
            }
            case IF: {
                IfTree t = (IfTree)tree;
                result = this.make.If(t.getCondition(), t.getThenStatement(), t.getElseStatement());
                break;
            }
            case IMPORT: {
                ImportTree t = (ImportTree)tree;
                result = this.make.Import(t.getQualifiedIdentifier(), t.isStatic());
                break;
            }
            case INSTANCE_OF: {
                InstanceOfTree t = (InstanceOfTree)tree;
                result = this.make.InstanceOf(t.getExpression(), t.getType());
                break;
            }
            case METHOD_INVOCATION: {
                MethodInvocationTree t = (MethodInvocationTree)tree;
                result = this.make.MethodInvocation(t.getTypeArguments(), t.getMethodSelect(), t.getArguments());
                break;
            }
            case MODIFIERS: {
                ModifiersTree t = (ModifiersTree)tree;
                result = this.make.Modifiers(t.getFlags(), t.getAnnotations());
                break;
            }
            case NEW_ARRAY: {
                NewArrayTree t = (NewArrayTree)tree;
                result = this.make.NewArray(t.getType(), t.getDimensions(), t.getInitializers());
                break;
            }
            case NEW_CLASS: {
                NewClassTree t = (NewClassTree)tree;
                result = this.make.NewClass(t.getEnclosingExpression(), t.getTypeArguments(), t.getIdentifier(), t.getArguments(), t.getClassBody());
                break;
            }
            case LAMBDA_EXPRESSION: {
                LambdaExpressionTree t = (LambdaExpressionTree)tree;
                result = this.make.LambdaExpression(t.getParameters(), t.getBody());
                break;
            }
            case PARENTHESIZED: {
                ParenthesizedTree t = (ParenthesizedTree)tree;
                result = this.make.Parenthesized(t.getExpression());
                break;
            }
            case PRIMITIVE_TYPE: {
                PrimitiveTypeTree t = (PrimitiveTypeTree)tree;
                result = this.make.PrimitiveType(t.getPrimitiveTypeKind());
                break;
            }
            case RETURN: {
                ReturnTree t = (ReturnTree)tree;
                result = this.make.Return(t.getExpression());
                break;
            }
            case EMPTY_STATEMENT: {
                result = this.make.EmptyStatement();
                break;
            }
            case SWITCH: {
                SwitchTree t = (SwitchTree)tree;
                result = this.make.Switch(t.getExpression(), t.getCases());
                break;
            }
            case SYNCHRONIZED: {
                SynchronizedTree t = (SynchronizedTree)tree;
                result = this.make.Synchronized(t.getExpression(), t.getBlock());
                break;
            }
            case THROW: {
                ThrowTree t = (ThrowTree)tree;
                result = this.make.Throw(t.getExpression());
                break;
            }
            case TRY: {
                TryTree t = (TryTree)tree;
                result = this.make.Try(t.getResources(), t.getBlock(), t.getCatches(), t.getFinallyBlock());
                break;
            }
            case PARAMETERIZED_TYPE: {
                ParameterizedTypeTree t = (ParameterizedTypeTree)tree;
                result = this.make.ParameterizedType(t.getType(), t.getTypeArguments());
                break;
            }
            case UNION_TYPE: {
                UnionTypeTree t = (UnionTypeTree)tree;
                result = this.make.UnionType(t.getTypeAlternatives());
                break;
            }
            case TYPE_CAST: {
                TypeCastTree t = (TypeCastTree)tree;
                result = this.make.TypeCast(t.getType(), t.getExpression());
                break;
            }
            case WHILE_LOOP: {
                WhileLoopTree t = (WhileLoopTree)tree;
                result = this.make.WhileLoop(t.getCondition(), t.getStatement());
                break;
            }
            case BITWISE_COMPLEMENT: 
            case LOGICAL_COMPLEMENT: 
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: 
            case PREFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case UNARY_PLUS: 
            case UNARY_MINUS: {
                UnaryTree t = (UnaryTree)tree;
                result = this.make.Unary(t.getKind(), t.getExpression());
                break;
            }
            case MULTIPLY: 
            case DIVIDE: 
            case REMAINDER: 
            case PLUS: 
            case MINUS: 
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case LESS_THAN: 
            case GREATER_THAN: 
            case LESS_THAN_EQUAL: 
            case GREATER_THAN_EQUAL: 
            case EQUAL_TO: 
            case NOT_EQUAL_TO: 
            case AND: 
            case XOR: 
            case OR: 
            case CONDITIONAL_AND: 
            case CONDITIONAL_OR: {
                BinaryTree t = (BinaryTree)tree;
                result = this.make.Binary(t.getKind(), t.getLeftOperand(), t.getRightOperand());
                break;
            }
            case MULTIPLY_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case PLUS_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
            case AND_ASSIGNMENT: 
            case XOR_ASSIGNMENT: 
            case OR_ASSIGNMENT: {
                CompoundAssignmentTree t = (CompoundAssignmentTree)tree;
                result = this.make.CompoundAssignment(t.getKind(), t.getVariable(), t.getExpression());
                break;
            }
            case INT_LITERAL: 
            case LONG_LITERAL: 
            case FLOAT_LITERAL: 
            case DOUBLE_LITERAL: 
            case BOOLEAN_LITERAL: 
            case CHAR_LITERAL: 
            case STRING_LITERAL: 
            case NULL_LITERAL: {
                LiteralTree t = (LiteralTree)tree;
                result = this.make.Literal(t.getValue());
                break;
            }
            case UNBOUNDED_WILDCARD: 
            case EXTENDS_WILDCARD: 
            case SUPER_WILDCARD: {
                WildcardTree t = (WildcardTree)tree;
                result = this.make.Wildcard(t.getKind(), t.getBound());
                break;
            }
        }
        this.genUtils.copyComments(tree, result, true);
        this.genUtils.copyComments(tree, result, false);
        return result;
    }
}

