/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.actions;

import com.oracle.bmc.model.BmcException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCIProfile;
import org.netbeans.modules.cloud.oracle.actions.AbstractPasswordPanel;
import org.netbeans.modules.cloud.oracle.actions.Bundle;
import org.netbeans.modules.cloud.oracle.actions.DownloadWalletAction;
import org.netbeans.modules.cloud.oracle.actions.DownloadWalletDialog;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentItem;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentNode;
import org.netbeans.modules.cloud.oracle.database.DatabaseItem;
import org.netbeans.modules.cloud.oracle.database.DatabaseNode;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;

public class AddADBAction
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(AddADBAction.class.getName());
    private static final String DB = "db";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";

    @Override
    public void actionPerformed(ActionEvent e) {
        final HashMap result = new HashMap();
        NotifyDescriptor.ComposedInput ci = new NotifyDescriptor.ComposedInput(Bundle.AddADB(), 3, new NotifyDescriptor.ComposedInput.Callback(){
            Map<Integer, List> values = new HashMap<Integer, List>();

            public NotifyDescriptor createInput(NotifyDescriptor.ComposedInput input, int number) {
                if (number == 1) {
                    String title;
                    ArrayList tenancies = new ArrayList();
                    for (OCIProfile p : OCIManager.getDefault().getConnectedProfiles()) {
                        p.getTenancy().ifPresent(tenancies::add);
                    }
                    if (tenancies.size() == 1) {
                        this.values.put(1, AddADBAction.this.getCompartmentsAndDbs((OCIItem)tenancies.get(0)));
                        title = Bundle.SelectCompartment();
                    } else {
                        this.values.put(1, tenancies);
                        title = Bundle.SelectTenancy();
                    }
                    return AddADBAction.this.createQuickPick(this.values.get(1), title);
                }
                NotifyDescriptor prev = input.getInputs()[number - 2];
                OCIItem prevItem = null;
                if (prev instanceof NotifyDescriptor.QuickPick) {
                    Optional<Object> ti;
                    Optional<String> selected = ((NotifyDescriptor.QuickPick)prev).getItems().stream().filter(item -> item.isSelected()).map(item -> item.getLabel()).findFirst();
                    if (selected.isPresent() && (ti = this.values.get(number - 1).stream().filter(t -> ((OCIItem)t).getName().equals(selected.get())).findFirst()).isPresent()) {
                        prevItem = (OCIItem)ti.get();
                    }
                    if (prevItem instanceof DatabaseItem) {
                        result.put(AddADBAction.DB, prevItem);
                        return new NotifyDescriptor.InputLine(Bundle.EnterUsername(), Bundle.EnterUsername());
                    }
                    this.values.put(number, AddADBAction.this.getCompartmentsAndDbs(prevItem));
                    input.setEstimatedNumberOfInputs(input.getEstimatedNumberOfInputs() + 1);
                    return AddADBAction.this.createQuickPick(this.values.get(number), Bundle.SelectDatabase());
                }
                if (prev instanceof NotifyDescriptor.PasswordLine) {
                    result.put(AddADBAction.PASSWORD, ((NotifyDescriptor.PasswordLine)prev).getInputText());
                    return null;
                }
                if (prev instanceof NotifyDescriptor.InputLine) {
                    String username = ((NotifyDescriptor.InputLine)prev).getInputText();
                    if (username == null || username.trim().isEmpty()) {
                        return prev;
                    }
                    result.put(AddADBAction.USERNAME, username);
                    return new NotifyDescriptor.PasswordLine(Bundle.EnterPassword(), Bundle.EnterPassword());
                }
                return null;
            }
        });
        if (DialogDescriptor.OK_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)ci)) {
            try {
                DatabaseItem selectedDatabase = (DatabaseItem)result.get(DB);
                DownloadWalletAction action = new DownloadWalletAction(selectedDatabase);
                DownloadWalletDialog.WalletInfo info = new DownloadWalletDialog.WalletInfo(DownloadWalletDialog.getWalletsDir().getAbsolutePath(), AbstractPasswordPanel.generatePassword(), (String)result.get(USERNAME), ((String)result.get(PASSWORD)).toCharArray());
                action.addConnection(info);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private <T extends OCIItem> NotifyDescriptor.QuickPick createQuickPick(List<T> ociItems, String title) {
        List items = ociItems.stream().map(tenancy -> new NotifyDescriptor.QuickPick.Item(tenancy.getName(), tenancy.getDescription())).collect(Collectors.toList());
        return new NotifyDescriptor.QuickPick(title, title, items, false);
    }

    private List<OCIItem> getCompartmentsAndDbs(OCIItem parent) {
        ArrayList<OCIItem> items = new ArrayList<OCIItem>();
        try {
            if (parent instanceof CompartmentItem) {
                items.addAll(DatabaseNode.getDatabases().apply((CompartmentItem)parent));
            }
        }
        catch (BmcException e) {
            LOGGER.log(Level.SEVERE, "Unable to load compartment list", e);
        }
        items.addAll(CompartmentNode.getCompartments().apply(parent));
        return items;
    }
}

