/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import org.netbeans.api.visual.action.TwoStateHoverProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public final class TwoStatedMouseHoverAction
extends WidgetAction.Adapter {
    private long eventID = Integer.MIN_VALUE;
    private TwoStateHoverProvider provider;
    private Widget lastWidget;

    public TwoStatedMouseHoverAction(TwoStateHoverProvider provider) {
        this.provider = provider;
    }

    @Override
    public WidgetAction.State mouseMoved(Widget widget, WidgetAction.WidgetMouseEvent event) {
        long id = event.getEventID();
        if (id != this.eventID) {
            this.eventID = id;
            this.widgetHovered(widget);
        }
        return WidgetAction.State.REJECTED;
    }

    @Override
    public WidgetAction.State mouseExited(Widget widget, WidgetAction.WidgetMouseEvent event) {
        long id = event.getEventID();
        if (id != this.eventID) {
            this.eventID = id;
            this.widgetHovered(null);
        }
        return WidgetAction.State.REJECTED;
    }

    public void widgetHovered(Widget widget) {
        if (widget instanceof Scene) {
            widget = null;
        }
        if (this.lastWidget == widget) {
            return;
        }
        if (this.lastWidget != null) {
            this.provider.unsetHovering(this.lastWidget);
        }
        this.lastWidget = widget;
        if (widget != null) {
            this.provider.setHovering(widget);
        }
    }
}

