/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.perf;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.CreateElementUtilities;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.perf.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.netbeans.spi.java.hints.MatcherUtilities;
import org.openide.util.NbBundle;

public class Tiny {
    private static final SourceVersion RELEASE_11;
    static final boolean SC_IGNORE_SUBSTRING_DEFAULT = true;
    static final String SC_IGNORE_SUBSTRING = "ignore.substring";
    private static final Set<Tree.Kind> KEEP_PARENTHESIS;
    private static final Map<TypeKind, String[]> PARSE_METHODS;

    public static ErrorDescription stringConstructor(HintContext ctx) {
        TreePath original = (TreePath)ctx.getVariables().get("$original");
        if (ctx.getPreferences().getBoolean(SC_IGNORE_SUBSTRING, true) && (MatcherUtilities.matches((HintContext)ctx, (TreePath)original, (String)"$str1.substring($s)", (boolean)true) || MatcherUtilities.matches((HintContext)ctx, (TreePath)original, (String)"$str2.substring($s, $e)", (boolean)true))) {
            TypeElement te;
            TreePath str;
            TreePath treePath = str = ctx.getVariables().get("$str1") != null ? (TreePath)ctx.getVariables().get("$str1") : (TreePath)ctx.getVariables().get("$str2");
            assert (str != null);
            TypeMirror type = ctx.getInfo().getTrees().getTypeMirror(str);
            if (type != null && type.getKind() == TypeKind.DECLARED && (te = (TypeElement)((DeclaredType)type).asElement()).getQualifiedName().contentEquals("java.lang.String")) {
                return null;
            }
        }
        String fixDisplayName = NbBundle.getMessage(Tiny.class, (String)"FIX_StringConstructor");
        Fix f = JavaFixUtilities.rewriteFix((HintContext)ctx, (String)fixDisplayName, (TreePath)ctx.getPath(), (String)"$original");
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_StringConstructor");
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[]{f});
    }

    public static ErrorDescription stringEqualsEmpty(HintContext ctx) {
        Fix f;
        if (ctx.getInfo().getSourceVersion().compareTo(SourceVersion.RELEASE_6) >= 0) {
            String fixDisplayName = NbBundle.getMessage(Tiny.class, (String)"FIX_StringEqualsEmpty16");
            f = JavaFixUtilities.rewriteFix((HintContext)ctx, (String)fixDisplayName, (TreePath)ctx.getPath(), (String)"$string.isEmpty()");
        } else {
            boolean not = ctx.getPath().getParentPath().getLeaf().getKind() == Tree.Kind.LOGICAL_COMPLEMENT;
            String fixDisplayName = NbBundle.getMessage(Tiny.class, (String)(not ? "FIX_StringEqualsEmptyNeg" : "FIX_StringEqualsEmpty"));
            f = JavaFixUtilities.rewriteFix((HintContext)ctx, (String)fixDisplayName, (TreePath)(not ? ctx.getPath().getParentPath() : ctx.getPath()), (String)(not ? "$string.length() != 0" : "$string.length() == 0"));
        }
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_StringEqualsEmpty");
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[]{f});
    }

    public static ErrorDescription lengthOneStringIndexOf(HintContext ctx) {
        TreePath toSearch = (TreePath)ctx.getVariables().get("$toSearch");
        if (toSearch.getLeaf().getKind() != Tree.Kind.STRING_LITERAL) {
            return null;
        }
        LiteralTree lt = (LiteralTree)toSearch.getLeaf();
        final String data = (String)lt.getValue();
        if (data.length() != 1) {
            return null;
        }
        int start = (int)ctx.getInfo().getTrees().getSourcePositions().getStartPosition(ctx.getInfo().getCompilationUnit(), toSearch.getLeaf());
        int end = (int)ctx.getInfo().getTrees().getSourcePositions().getEndPosition(ctx.getInfo().getCompilationUnit(), toSearch.getLeaf());
        final String literal = ctx.getInfo().getText().substring(start, end);
        Fix f = new JavaFix(ctx.getInfo(), toSearch){

            protected String getText() {
                return NbBundle.getMessage(Tiny.class, (String)"FIX_LengthOneStringIndexOf");
            }

            protected void performRewrite(JavaFix.TransformationContext ctx) {
                String content;
                WorkingCopy wc = ctx.getWorkingCopy();
                TreePath tp = ctx.getPath();
                if ("'".equals(data)) {
                    content = "\\'";
                } else if ("\"".equals(data)) {
                    content = "\"";
                } else {
                    content = literal;
                    if (content.length() > 0 && content.charAt(0) == '\"') {
                        content = content.substring(1);
                    }
                    if (content.length() > 0 && content.charAt(content.length() - 1) == '\"') {
                        content = content.substring(0, content.length() - 1);
                    }
                }
                wc.rewrite(tp.getLeaf(), (Tree)wc.getTreeMaker().Identifier((CharSequence)("'" + content + "'")));
            }
        }.toEditorFix();
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_LengthOneStringIndexOf", (Object)literal);
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)toSearch, (String)displayName, (Fix[])new Fix[]{f});
    }

    public static ErrorDescription getClassInsteadOfDotClass(HintContext ctx) {
        TreePath O = (TreePath)ctx.getVariables().get("$O");
        if (O.getLeaf().getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
            O = new TreePath(O, ((ParameterizedTypeTree)O.getLeaf()).getType());
        }
        ctx.getVariables().put("$OO", O);
        String fixDisplayName = NbBundle.getMessage(Tiny.class, (String)"FIX_GetClassInsteadOfDotClass");
        Fix f = JavaFixUtilities.rewriteFix((HintContext)ctx, (String)fixDisplayName, (TreePath)ctx.getPath(), (String)"$OO.class");
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_GetClassInsteadOfDotClass");
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[]{f});
    }

    public static ErrorDescription constantIntern(HintContext ctx) {
        String target;
        TreePath str = (TreePath)ctx.getVariables().get("$str");
        TreePath constant = str.getLeaf().getKind() == Tree.Kind.PARENTHESIZED ? new TreePath(str, ((ParenthesizedTree)str.getLeaf()).getExpression()) : str;
        if (!Utilities.isConstantString(ctx.getInfo(), constant)) {
            return null;
        }
        String fixDisplayName = NbBundle.getMessage(Tiny.class, (String)"FIX_ConstantIntern");
        if (constant != str && KEEP_PARENTHESIS.contains((Object)ctx.getPath().getParentPath().getLeaf().getKind())) {
            target = "$str";
        } else {
            target = "$constant";
            ctx.getVariables().put("$constant", constant);
        }
        Fix f = JavaFixUtilities.rewriteFix((HintContext)ctx, (String)fixDisplayName, (TreePath)ctx.getPath(), (String)target);
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_ConstantIntern");
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[]{f});
    }

    public static ErrorDescription enumSet(HintContext ctx) {
        return Tiny.enumHint(ctx, "java.util.Set", null, "ERR_Tiny_enumSet", new Fix[0]);
    }

    public static ErrorDescription enumMap(HintContext ctx) {
        Fix[] fixes;
        Collection mvars = (Collection)ctx.getMultiVariables().get("$params$");
        if (mvars != null && mvars.isEmpty()) {
            String displayName = NbBundle.getMessage(Tiny.class, (String)"FIX_Tiny_enumMap");
            fixes = new Fix[]{JavaFixUtilities.rewriteFix((HintContext)ctx, (String)displayName, (TreePath)ctx.getPath(), (String)"new java.util.EnumMap<$param, $to>($param.class)")};
        } else {
            fixes = new Fix[]{};
        }
        return Tiny.enumHint(ctx, "java.util.Map", "java.util.EnumMap", "ERR_Tiny_enumMap", fixes);
    }

    private static ErrorDescription enumHint(HintContext ctx, String baseName, String targetTypeName, String key, Fix ... fixes) {
        Element type = ctx.getInfo().getTrees().getElement((TreePath)ctx.getVariables().get("$param"));
        if (type == null || type.getKind() != ElementKind.ENUM) {
            return null;
        }
        Element coll = ctx.getInfo().getTrees().getElement((TreePath)ctx.getVariables().get("$coll"));
        if (coll == null || coll.getKind() != ElementKind.CLASS) {
            return null;
        }
        TypeElement base = ctx.getInfo().getElements().getTypeElement(baseName);
        if (base == null) {
            return null;
        }
        Types t = ctx.getInfo().getTypes();
        if (!t.isSubtype(t.erasure(coll.asType()), t.erasure(base.asType()))) {
            return null;
        }
        if (targetTypeName != null) {
            TypeElement target = ctx.getInfo().getElements().getTypeElement(targetTypeName);
            if (target == null) {
                return null;
            }
            if (t.isSubtype(t.erasure(coll.asType()), t.erasure(target.asType()))) {
                return null;
            }
            List<? extends TypeMirror> assignedTo = CreateElementUtilities.resolveType(EnumSet.noneOf(ElementKind.class), ctx.getInfo(), ctx.getPath().getParentPath(), ctx.getPath().getLeaf(), (int)ctx.getInfo().getTrees().getSourcePositions().getEndPosition(ctx.getPath().getCompilationUnit(), ctx.getPath().getLeaf()), new TypeMirror[1], new int[1]);
            if (assignedTo != null && assignedTo.size() == 1 && t.isSubtype(t.erasure(assignedTo.get(0)), t.erasure(coll.asType()))) {
                return null;
            }
        }
        String displayName = NbBundle.getMessage(Tiny.class, (String)key);
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])fixes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ErrorDescription collectionsToArray(HintContext ctx) {
        Fix[] fixes;
        boolean pureMemberSelect = true;
        TreePath tp = (TreePath)ctx.getVariables().get("$collection");
        if (tp == null) {
            return null;
        }
        Tree msTest = tp.getLeaf();
        block4: while (true) {
            switch (msTest.getKind()) {
                case IDENTIFIER: {
                    break block4;
                }
                case MEMBER_SELECT: {
                    msTest = ((MemberSelectTree)msTest).getExpression();
                    continue block4;
                }
                default: {
                    pureMemberSelect = false;
                    break block4;
                }
            }
            break;
        }
        if (pureMemberSelect) {
            SourceVersion version = ctx.getInfo().getSourceVersion();
            TreePath type = (TreePath)ctx.getVariables().get("$clazz");
            String typeName = type.getLeaf().toString();
            if (RELEASE_11 != null && version.compareTo(RELEASE_11) >= 0) {
                String byRef = NbBundle.getMessage(Tiny.class, (String)"FIX_Tiny_collectionsToArrayByMethodRef", (Object)typeName);
                fixes = new Fix[]{JavaFixUtilities.rewriteFix((HintContext)ctx, (String)byRef, (TreePath)ctx.getPath(), (String)"$collection.toArray($clazz[]::new)")};
            } else {
                if (!Tiny.isNewArrayWithSize(type)) return null;
                String byZero = NbBundle.getMessage(Tiny.class, (String)"FIX_Tiny_collectionsToArrayByZeroArray", (Object)typeName);
                fixes = new Fix[]{JavaFixUtilities.rewriteFix((HintContext)ctx, (String)byZero, (TreePath)ctx.getPath(), (String)"$collection.toArray(new $clazz[0])")};
            }
        } else {
            fixes = new Fix[]{};
        }
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_Tiny_collectionsToArray");
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])fixes);
    }

    private static boolean isNewArrayWithSize(TreePath type) {
        Tree parent = type.getParentPath().getLeaf();
        if (parent instanceof NewArrayTree) {
            List<? extends ExpressionTree> dim = ((NewArrayTree)parent).getDimensions();
            return dim.isEmpty() ? false : dim.get(0).getKind() == Tree.Kind.METHOD_INVOCATION;
        }
        return false;
    }

    public static ErrorDescription redundantToString(HintContext ctx) {
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.TEXT_RedundantToString(), (Fix[])new Fix[]{JavaFixUtilities.rewriteFix((HintContext)ctx, (String)Bundle.FIX_RedundantToString(), (TreePath)ctx.getPath(), (String)"$v")});
    }

    public static ErrorDescription unnecessaryTempFromString(HintContext ctx) {
        String method;
        String type;
        TypeMirror destType = Tiny.getDestinationType(ctx, ctx.getPath());
        TypeMirror srcType = ctx.getInfo().getTrees().getTypeMirror(ctx.getPath());
        if (srcType == null || destType == null) {
            return null;
        }
        if (destType.getKind().isPrimitive() && !srcType.getKind().isPrimitive()) {
            srcType = ctx.getInfo().getTypes().unboxedType(srcType);
            String[] replacement = PARSE_METHODS.get((Object)srcType.getKind());
            type = replacement[0];
            method = replacement[1];
        } else if (!destType.getKind().isPrimitive() && srcType.getKind().isPrimitive()) {
            type = PARSE_METHODS.get((Object)srcType.getKind())[0];
            method = "valueOf";
        } else {
            return null;
        }
        if (srcType.getKind() == TypeKind.BOOLEAN && ctx.getInfo().getSourceVersion().compareTo(SourceVersion.RELEASE_5) < 0) {
            return null;
        }
        Fix fix = JavaFixUtilities.rewriteFix((HintContext)ctx, (String)Bundle.FIX_UnnecessaryTempFromString1(type, method), (TreePath)ctx.getPath(), (String)(type + "." + method + "($v)"));
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.TEXT_UnnecessaryTempFromString(), (Fix[])new Fix[]{fix});
    }

    private static TypeMirror getDestinationType(HintContext ctx, TreePath path) {
        TreePath parent = path.getParentPath();
        Tree parentLeaf = parent.getLeaf();
        Tree leaf = path.getLeaf();
        Trees trees = ctx.getInfo().getTrees();
        if (parentLeaf.getKind() == Tree.Kind.METHOD_INVOCATION) {
            MethodInvocationTree met = (MethodInvocationTree)parentLeaf;
            int index = met.getArguments().indexOf(leaf);
            return Tiny.paramTypeOfExecutable(trees.getTypeMirror(new TreePath(path, met.getMethodSelect())), index);
        }
        if (parentLeaf.getKind() == Tree.Kind.NEW_CLASS) {
            NewClassTree nct = (NewClassTree)parentLeaf;
            int index = nct.getArguments().indexOf(leaf);
            return Tiny.paramTypeOfExecutable(trees.getElement(new TreePath(path, nct)).asType(), index);
        }
        int pos = (int)trees.getSourcePositions().getStartPosition(path.getCompilationUnit(), leaf);
        List<? extends TypeMirror> type = CreateElementUtilities.resolveType(EnumSet.noneOf(ElementKind.class), ctx.getInfo(), parent, leaf, pos, new TypeMirror[1], new int[1]);
        if (type != null && !type.isEmpty()) {
            return type.get(0);
        }
        return null;
    }

    private static TypeMirror paramTypeOfExecutable(TypeMirror executable, int index) {
        List<? extends TypeMirror> paramTypes;
        if (index != -1 && executable != null && executable.getKind() == TypeKind.EXECUTABLE && (paramTypes = ((ExecutableType)executable).getParameterTypes()).size() > index) {
            return paramTypes.get(index);
        }
        return null;
    }

    public static ErrorDescription unnecessaryTypeToString(HintContext ctx) {
        TreePath vPath = (TreePath)ctx.getVariables().get("$v");
        TypeMirror resType = ctx.getInfo().getTrees().getTypeMirror(vPath);
        if (resType == null) {
            return null;
        }
        String[] arr = PARSE_METHODS.get((Object)resType.getKind());
        if (arr == null) {
            return null;
        }
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.TEXT_UnnecessaryTempFromString(), (Fix[])new Fix[]{JavaFixUtilities.rewriteFix((HintContext)ctx, (String)Bundle.FIX_UnnecessaryTempToString(arr[0]), (TreePath)ctx.getPath(), (String)(arr[0] + ".toString($v)"))});
    }

    public static ErrorDescription boxedPrimitiveConstruction(HintContext ctx) {
        TypeMirror resType = ctx.getInfo().getTrees().getTypeMirror(ctx.getPath());
        if (resType == null) {
            return null;
        }
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.TEXT_BoxedPrimitiveConstruction(), (Fix[])new Fix[]{JavaFixUtilities.rewriteFix((HintContext)ctx, (String)Bundle.FIX_BoxedPrimitiveConstruction(resType), (TreePath)ctx.getPath(), (String)(resType + ".valueOf($v)"))});
    }

    static {
        SourceVersion tmp;
        try {
            tmp = SourceVersion.valueOf("RELEASE_11");
        }
        catch (IllegalArgumentException ex) {
            tmp = null;
        }
        RELEASE_11 = tmp;
        KEEP_PARENTHESIS = EnumSet.of(Tree.Kind.MEMBER_SELECT);
        PARSE_METHODS = new HashMap<TypeKind, String[]>(7);
        PARSE_METHODS.put(TypeKind.BOOLEAN, new String[]{"Boolean", "parseBoolean"});
        PARSE_METHODS.put(TypeKind.BYTE, new String[]{"Byte", "parseByte"});
        PARSE_METHODS.put(TypeKind.DOUBLE, new String[]{"Double", "parseDouble"});
        PARSE_METHODS.put(TypeKind.FLOAT, new String[]{"Float", "parseFloat"});
        PARSE_METHODS.put(TypeKind.INT, new String[]{"Integer", "parseInt"});
        PARSE_METHODS.put(TypeKind.LONG, new String[]{"Long", "parseLong"});
        PARSE_METHODS.put(TypeKind.SHORT, new String[]{"Short", "parseShort"});
    }
}

