/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.ini.lexer;

import java.util.Collection;
import java.util.EnumSet;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.languages.ini.lexer.IniLexer;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

public enum IniTokenId implements TokenId
{
    INI_COMMENT("comment"),
    INI_SECTION_DELIM("section_delim"),
    INI_SECTION("section"),
    INI_KEY("key"),
    INI_EQUALS("equals"),
    INI_VALUE("value"),
    INI_WHITESPACE("whitespace"),
    INI_ERROR("error");

    private final String name;
    private static final Language<IniTokenId> LANGUAGE;

    private IniTokenId(String name) {
        this.name = name;
    }

    public String primaryCategory() {
        return this.name;
    }

    public static Language<IniTokenId> language() {
        return LANGUAGE;
    }

    static {
        LANGUAGE = new LanguageHierarchy<IniTokenId>(){

            protected Collection<IniTokenId> createTokenIds() {
                return EnumSet.allOf(IniTokenId.class);
            }

            protected Lexer<IniTokenId> createLexer(LexerRestartInfo<IniTokenId> info) {
                return IniLexer.create(info);
            }

            protected String mimeType() {
                return "text/x-ini";
            }
        }.language();
    }
}

