/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteSwiftPasswordRequest
extends BmcRequest<Void> {
    private String userId;
    private String swiftPasswordId;
    private String ifMatch;

    @ConstructorProperties(value={"userId", "swiftPasswordId", "ifMatch"})
    DeleteSwiftPasswordRequest(String userId, String swiftPasswordId, String ifMatch) {
        this.userId = userId;
        this.swiftPasswordId = swiftPasswordId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().userId(this.userId).swiftPasswordId(this.swiftPasswordId).ifMatch(this.ifMatch);
    }

    public String toString() {
        return "DeleteSwiftPasswordRequest(super=" + super.toString() + ", userId=" + this.getUserId() + ", swiftPasswordId=" + this.getSwiftPasswordId() + ", ifMatch=" + this.getIfMatch() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteSwiftPasswordRequest)) {
            return false;
        }
        DeleteSwiftPasswordRequest other = (DeleteSwiftPasswordRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$swiftPasswordId = this.getSwiftPasswordId();
        String other$swiftPasswordId = other.getSwiftPasswordId();
        if (this$swiftPasswordId == null ? other$swiftPasswordId != null : !this$swiftPasswordId.equals(other$swiftPasswordId)) {
            return false;
        }
        String this$ifMatch = this.getIfMatch();
        String other$ifMatch = other.getIfMatch();
        return !(this$ifMatch == null ? other$ifMatch != null : !this$ifMatch.equals(other$ifMatch));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteSwiftPasswordRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $swiftPasswordId = this.getSwiftPasswordId();
        result = result * 59 + ($swiftPasswordId == null ? 43 : $swiftPasswordId.hashCode());
        String $ifMatch = this.getIfMatch();
        result = result * 59 + ($ifMatch == null ? 43 : $ifMatch.hashCode());
        return result;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getSwiftPasswordId() {
        return this.swiftPasswordId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteSwiftPasswordRequest, Void> {
        private String userId;
        private String swiftPasswordId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteSwiftPasswordRequest o) {
            this.userId(o.getUserId());
            this.swiftPasswordId(o.getSwiftPasswordId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteSwiftPasswordRequest build() {
            DeleteSwiftPasswordRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder swiftPasswordId(String swiftPasswordId) {
            this.swiftPasswordId = swiftPasswordId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteSwiftPasswordRequest buildWithoutInvocationCallback() {
            return new DeleteSwiftPasswordRequest(this.userId, this.swiftPasswordId, this.ifMatch);
        }

        public String toString() {
            return "DeleteSwiftPasswordRequest.Builder(userId=" + this.userId + ", swiftPasswordId=" + this.swiftPasswordId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

