/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.org.jline.builtins;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import org.graalvm.shadowed.org.jline.builtins.NfaMatcher;
import org.graalvm.shadowed.org.jline.reader.Candidate;
import org.graalvm.shadowed.org.jline.reader.LineReader;
import org.graalvm.shadowed.org.jline.reader.ParsedLine;
import org.graalvm.shadowed.org.jline.reader.Parser;
import org.graalvm.shadowed.org.jline.reader.impl.completer.AggregateCompleter;
import org.graalvm.shadowed.org.jline.reader.impl.completer.ArgumentCompleter;
import org.graalvm.shadowed.org.jline.reader.impl.completer.StringsCompleter;
import org.graalvm.shadowed.org.jline.terminal.Terminal;
import org.graalvm.shadowed.org.jline.utils.AttributedString;
import org.graalvm.shadowed.org.jline.utils.AttributedStringBuilder;
import org.graalvm.shadowed.org.jline.utils.AttributedStyle;

public class Completers {

    public static class OptionCompleter
    implements org.graalvm.shadowed.org.jline.reader.Completer {
        private Map<String, List<String>> optionValues = new HashMap<String, List<String>>();
        private List<String> options = new ArrayList<String>();
        private Function<String, Map<String, String>> commandOptions;
        private List<org.graalvm.shadowed.org.jline.reader.Completer> argsCompleters = new ArrayList<org.graalvm.shadowed.org.jline.reader.Completer>();
        private int startPos;

        public OptionCompleter(org.graalvm.shadowed.org.jline.reader.Completer completer, Function<String, Map<String, String>> commandOptions, int startPos) {
            this.startPos = startPos;
            this.commandOptions = commandOptions;
            this.argsCompleters.add(completer);
        }

        public OptionCompleter(List<org.graalvm.shadowed.org.jline.reader.Completer> completers, Function<String, Map<String, String>> commandOptions, int startPos) {
            this.startPos = startPos;
            this.commandOptions = commandOptions;
            this.argsCompleters = new ArrayList<org.graalvm.shadowed.org.jline.reader.Completer>(completers);
        }

        public OptionCompleter(List<org.graalvm.shadowed.org.jline.reader.Completer> completers, Map<String, List<String>> optionValues, Collection<String> options, int startPos) {
            this(optionValues, options, startPos);
            this.argsCompleters = new ArrayList<org.graalvm.shadowed.org.jline.reader.Completer>(completers);
        }

        public OptionCompleter(org.graalvm.shadowed.org.jline.reader.Completer completer, Map<String, List<String>> optionValues, Collection<String> options, int startPos) {
            this(optionValues, options, startPos);
            this.argsCompleters.add(completer);
        }

        private OptionCompleter(Map<String, List<String>> optionValues, Collection<String> options, int startPos) {
            this.optionValues = new HashMap<String, List<String>>(optionValues);
            this.options.addAll(options);
            this.startPos = startPos;
        }

        @Override
        public void complete(LineReader reader, ParsedLine commandLine, List<Candidate> candidates) {
            assert (commandLine != null);
            assert (candidates != null);
            List<String> words = commandLine.words();
            String buffer = commandLine.word().substring(0, commandLine.wordCursor());
            if (buffer.startsWith("-")) {
                boolean addbuff = true;
                boolean valueCandidates = false;
                if (this.commandOptions != null) {
                    boolean longOption = buffer.startsWith("--");
                    for (Map.Entry<String, String> entry : this.commandOptions.apply(Parser.getCommand(words.get(0))).entrySet()) {
                        if (entry.getKey().startsWith(buffer)) {
                            addbuff = false;
                        }
                        if ((longOption || entry.getKey().startsWith("--")) && !longOption) continue;
                        candidates.add(new Candidate(entry.getKey(), entry.getKey(), null, entry.getValue(), null, null, true));
                    }
                } else {
                    int eq = buffer.indexOf(61);
                    if (eq < 0) {
                        ArrayList<String> usedOptions = new ArrayList<String>();
                        for (int i = this.startPos; i < words.size(); ++i) {
                            if (!words.get(i).startsWith("-")) continue;
                            String w = words.get(i);
                            int ind = w.indexOf(61);
                            if (ind < 0) {
                                usedOptions.add(w);
                                continue;
                            }
                            usedOptions.add(w.substring(0, ind));
                        }
                        for (String o : this.optionValues.keySet()) {
                            if (usedOptions.contains(o)) continue;
                            if (o.startsWith(buffer)) {
                                addbuff = false;
                            }
                            candidates.add(new Candidate(o + "=", o, null, null, null, null, false));
                        }
                        for (String o : this.options) {
                            if (usedOptions.contains(o)) continue;
                            if (o.startsWith(buffer)) {
                                addbuff = false;
                            }
                            candidates.add(new Candidate(o, o, null, null, null, null, true));
                        }
                    } else {
                        String value = buffer.substring(eq + 1);
                        String curBuf = buffer.substring(0, eq + 1);
                        String opt = buffer.substring(0, eq);
                        if (this.optionValues.containsKey(opt) && !this.optionValues.get(opt).isEmpty()) {
                            for (String v : this.optionValues.get(opt)) {
                                if (v.startsWith(value)) {
                                    valueCandidates = true;
                                    addbuff = false;
                                }
                                candidates.add(new Candidate(curBuf + v, v, null, null, null, null, true));
                            }
                        }
                    }
                }
                if (buffer.contains("=") && !buffer.endsWith("=") && !valueCandidates || addbuff) {
                    candidates.add(new Candidate(buffer, buffer, null, null, null, null, true));
                }
            } else if (this.argsCompleters.size() > 1) {
                int args = -1;
                for (int i = this.startPos; i < words.size(); ++i) {
                    if (words.get(i).startsWith("-")) continue;
                    ++args;
                }
                if (args == -1) {
                    candidates.add(new Candidate(buffer, buffer, null, null, null, null, true));
                } else if (args < this.argsCompleters.size()) {
                    this.argsCompleters.get(args).complete(reader, commandLine, candidates);
                } else {
                    this.argsCompleters.get(this.argsCompleters.size() - 1).complete(reader, commandLine, candidates);
                }
            } else {
                this.argsCompleters.get(0).complete(reader, commandLine, candidates);
            }
        }
    }

    public static class SystemCompleter
    implements org.graalvm.shadowed.org.jline.reader.Completer {
        private Map<String, List<org.graalvm.shadowed.org.jline.reader.Completer>> completers = new HashMap<String, List<org.graalvm.shadowed.org.jline.reader.Completer>>();
        private Map<String, String> aliasCommand = new HashMap<String, String>();
        private StringsCompleter commands;
        private boolean compiled = false;

        @Override
        public void complete(LineReader reader, ParsedLine commandLine, List<Candidate> candidates) {
            if (!this.compiled) {
                throw new IllegalStateException();
            }
            assert (commandLine != null);
            assert (candidates != null);
            if (commandLine.words().size() > 0) {
                if (commandLine.words().size() == 1) {
                    String buffer = commandLine.words().get(0);
                    int eq = buffer.indexOf(61);
                    if (eq < 0) {
                        this.commands.complete(reader, commandLine, candidates);
                    } else {
                        String curBuf = buffer.substring(0, eq + 1);
                        for (String c : this.completers.keySet()) {
                            candidates.add(new Candidate(AttributedString.stripAnsi(curBuf + c), c, null, null, null, null, true));
                        }
                    }
                } else {
                    String cmd = Parser.getCommand(commandLine.words().get(0));
                    if (this.command(cmd) != null) {
                        this.completers.get(this.command(cmd)).get(0).complete(reader, commandLine, candidates);
                    }
                }
            }
        }

        public boolean isCompiled() {
            return this.compiled;
        }

        private String command(String cmd) {
            String out = null;
            if (this.completers.containsKey(cmd)) {
                out = cmd;
            } else if (this.aliasCommand.containsKey(cmd)) {
                out = this.aliasCommand.get(cmd);
            }
            return out;
        }

        public void add(String command, List<org.graalvm.shadowed.org.jline.reader.Completer> completers) {
            for (org.graalvm.shadowed.org.jline.reader.Completer c : completers) {
                this.add(command, c);
            }
        }

        public void add(List<String> commands, org.graalvm.shadowed.org.jline.reader.Completer completer) {
            for (String c : commands) {
                this.add(c, completer);
            }
        }

        public void add(String command, org.graalvm.shadowed.org.jline.reader.Completer completer) {
            if (this.compiled) {
                throw new IllegalStateException();
            }
            if (!this.completers.containsKey(command)) {
                this.completers.put(command, new ArrayList());
            }
            if (completer instanceof ArgumentCompleter) {
                ((ArgumentCompleter)completer).setStrictCommand(false);
            }
            this.completers.get(command).add(completer);
        }

        public void add(SystemCompleter other) {
            if (other.isCompiled()) {
                throw new IllegalStateException();
            }
            for (Map.Entry<String, List<org.graalvm.shadowed.org.jline.reader.Completer>> entry : other.getCompleters().entrySet()) {
                for (org.graalvm.shadowed.org.jline.reader.Completer c : entry.getValue()) {
                    this.add(entry.getKey(), c);
                }
            }
            this.addAliases(other.getAliases());
        }

        public void addAliases(Map<String, String> aliasCommand) {
            if (this.compiled) {
                throw new IllegalStateException();
            }
            this.aliasCommand.putAll(aliasCommand);
        }

        public Map<String, String> getAliases() {
            return this.aliasCommand;
        }

        public void compile() {
            if (this.compiled) {
                return;
            }
            HashMap<String, List<org.graalvm.shadowed.org.jline.reader.Completer>> compiledCompleters = new HashMap<String, List<org.graalvm.shadowed.org.jline.reader.Completer>>();
            for (Map.Entry<String, List<org.graalvm.shadowed.org.jline.reader.Completer>> entry : this.completers.entrySet()) {
                if (entry.getValue().size() == 1) {
                    compiledCompleters.put(entry.getKey(), entry.getValue());
                    continue;
                }
                compiledCompleters.put(entry.getKey(), new ArrayList());
                ((List)compiledCompleters.get(entry.getKey())).add(new AggregateCompleter((Collection<org.graalvm.shadowed.org.jline.reader.Completer>)entry.getValue()));
            }
            this.completers = compiledCompleters;
            HashSet<String> cmds = new HashSet<String>(this.completers.keySet());
            cmds.addAll(this.aliasCommand.keySet());
            this.commands = new StringsCompleter((Iterable<String>)cmds);
            this.compiled = true;
        }

        public Map<String, List<org.graalvm.shadowed.org.jline.reader.Completer>> getCompleters() {
            return this.completers;
        }
    }

    public static class RegexCompleter
    implements org.graalvm.shadowed.org.jline.reader.Completer {
        private final NfaMatcher<String> matcher;
        private final Function<String, org.graalvm.shadowed.org.jline.reader.Completer> completers;
        private final ThreadLocal<LineReader> reader = new ThreadLocal();

        public RegexCompleter(String syntax, Function<String, org.graalvm.shadowed.org.jline.reader.Completer> completers) {
            this.matcher = new NfaMatcher<String>(syntax, this::doMatch);
            this.completers = completers;
        }

        @Override
        public synchronized void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
            List<String> words = line.words().subList(0, line.wordIndex());
            this.reader.set(reader);
            Set<String> next = this.matcher.matchPartial(words);
            for (String n : next) {
                this.completers.apply(n).complete(reader, new ArgumentLine(line.word(), line.wordCursor()), candidates);
            }
            this.reader.set(null);
        }

        private boolean doMatch(String arg, String name) {
            ArrayList<Candidate> candidates = new ArrayList<Candidate>();
            LineReader r = this.reader.get();
            boolean caseInsensitive = r != null && r.isSet(LineReader.Option.CASE_INSENSITIVE);
            this.completers.apply(name).complete(r, new ArgumentLine(arg, arg.length()), candidates);
            return candidates.stream().anyMatch(c -> caseInsensitive ? c.value().equalsIgnoreCase(arg) : c.value().equals(arg));
        }

        public static class ArgumentLine
        implements ParsedLine {
            private final String word;
            private final int cursor;

            public ArgumentLine(String word, int cursor) {
                this.word = word;
                this.cursor = cursor;
            }

            @Override
            public String word() {
                return this.word;
            }

            @Override
            public int wordCursor() {
                return this.cursor;
            }

            @Override
            public int wordIndex() {
                return 0;
            }

            @Override
            public List<String> words() {
                return Collections.singletonList(this.word);
            }

            @Override
            public String line() {
                return this.word;
            }

            @Override
            public int cursor() {
                return this.cursor;
            }
        }
    }

    public static class TreeCompleter
    implements org.graalvm.shadowed.org.jline.reader.Completer {
        final Map<String, org.graalvm.shadowed.org.jline.reader.Completer> completers = new HashMap<String, org.graalvm.shadowed.org.jline.reader.Completer>();
        final RegexCompleter completer;

        public TreeCompleter(Node ... nodes) {
            this(Arrays.asList(nodes));
        }

        public TreeCompleter(List<Node> nodes) {
            StringBuilder sb = new StringBuilder();
            this.addRoots(sb, nodes);
            this.completer = new RegexCompleter(sb.toString(), this.completers::get);
        }

        public static Node node(Object ... objs) {
            org.graalvm.shadowed.org.jline.reader.Completer comp = null;
            ArrayList<Candidate> cands = new ArrayList<Candidate>();
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (Object obj : objs) {
                if (obj instanceof String) {
                    cands.add(new Candidate((String)obj));
                    continue;
                }
                if (obj instanceof Candidate) {
                    cands.add((Candidate)obj);
                    continue;
                }
                if (obj instanceof Node) {
                    nodes.add((Node)obj);
                    continue;
                }
                if (obj instanceof org.graalvm.shadowed.org.jline.reader.Completer) {
                    comp = (org.graalvm.shadowed.org.jline.reader.Completer)obj;
                    continue;
                }
                throw new IllegalArgumentException();
            }
            if (comp != null) {
                if (!cands.isEmpty()) {
                    throw new IllegalArgumentException();
                }
                return new Node(comp, nodes);
            }
            if (!cands.isEmpty()) {
                return new Node((r, l, c) -> c.addAll(cands), nodes);
            }
            throw new IllegalArgumentException();
        }

        void addRoots(StringBuilder sb, List<Node> nodes) {
            if (!nodes.isEmpty()) {
                sb.append(" ( ");
                boolean first = true;
                for (Node n : nodes) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(" | ");
                    }
                    String name = "c" + this.completers.size();
                    this.completers.put(name, n.completer);
                    sb.append(name);
                    this.addRoots(sb, n.nodes);
                }
                sb.append(" ) ");
            }
        }

        @Override
        public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
            this.completer.complete(reader, line, candidates);
        }

        public static class Node {
            final org.graalvm.shadowed.org.jline.reader.Completer completer;
            final List<Node> nodes;

            public Node(org.graalvm.shadowed.org.jline.reader.Completer completer, List<Node> nodes) {
                this.completer = completer;
                this.nodes = nodes;
            }
        }
    }

    public static class FileNameCompleter
    implements org.graalvm.shadowed.org.jline.reader.Completer {
        @Override
        public void complete(LineReader reader, ParsedLine commandLine, List<Candidate> candidates) {
            assert (commandLine != null);
            assert (candidates != null);
            String buffer = commandLine.word().substring(0, commandLine.wordCursor());
            String sep = this.getSeparator(reader.isSet(LineReader.Option.USE_FORWARD_SLASH));
            int lastSep = buffer.lastIndexOf(sep);
            try {
                Path current;
                String curBuf;
                if (lastSep >= 0) {
                    curBuf = buffer.substring(0, lastSep + 1);
                    current = curBuf.startsWith("~") ? (curBuf.startsWith("~" + sep) ? this.getUserHome().resolve(curBuf.substring(2)) : this.getUserHome().getParent().resolve(curBuf.substring(1))) : this.getUserDir().resolve(curBuf);
                } else {
                    curBuf = "";
                    current = this.getUserDir();
                }
                try (DirectoryStream<Path> directory = Files.newDirectoryStream(current, this::accept);){
                    directory.forEach(p -> {
                        String value = curBuf + p.getFileName().toString();
                        if (Files.isDirectory(p, new LinkOption[0])) {
                            candidates.add(new Candidate(value + (reader.isSet(LineReader.Option.AUTO_PARAM_SLASH) ? sep : ""), this.getDisplay(reader.getTerminal(), (Path)p), null, null, reader.isSet(LineReader.Option.AUTO_REMOVE_SLASH) ? sep : null, null, false));
                        } else {
                            candidates.add(new Candidate(value, this.getDisplay(reader.getTerminal(), (Path)p), null, null, null, null, true));
                        }
                    });
                }
                catch (IOException iOException) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected boolean accept(Path path) {
            try {
                return !Files.isHidden(path);
            }
            catch (IOException e) {
                return false;
            }
        }

        protected Path getUserDir() {
            return Paths.get(System.getProperty("user.dir"), new String[0]);
        }

        protected Path getUserHome() {
            return Paths.get(System.getProperty("user.home"), new String[0]);
        }

        protected String getSeparator(boolean useForwardSlash) {
            return useForwardSlash ? "/" : this.getUserDir().getFileSystem().getSeparator();
        }

        protected String getDisplay(Terminal terminal, Path p) {
            String name = p.getFileName().toString();
            if (Files.isDirectory(p, new LinkOption[0])) {
                AttributedStringBuilder sb = new AttributedStringBuilder();
                sb.styled(AttributedStyle.BOLD.foreground(1), (CharSequence)name);
                sb.append("/");
                name = sb.toAnsi(terminal);
            } else if (Files.isSymbolicLink(p)) {
                AttributedStringBuilder sb = new AttributedStringBuilder();
                sb.styled(AttributedStyle.BOLD.foreground(1), (CharSequence)name);
                sb.append("@");
                name = sb.toAnsi(terminal);
            }
            return name;
        }
    }

    public static class FilesCompleter
    extends FileNameCompleter {
        private final Supplier<Path> currentDir;
        private final boolean forceSlash;

        public FilesCompleter(File currentDir) {
            this(currentDir.toPath(), false);
        }

        public FilesCompleter(File currentDir, boolean forceSlash) {
            this(currentDir.toPath(), forceSlash);
        }

        public FilesCompleter(Path currentDir) {
            this(currentDir, false);
        }

        public FilesCompleter(Path currentDir, boolean forceSlash) {
            this.currentDir = () -> currentDir;
            this.forceSlash = forceSlash;
        }

        public FilesCompleter(Supplier<Path> currentDir) {
            this(currentDir, false);
        }

        public FilesCompleter(Supplier<Path> currentDir, boolean forceSlash) {
            this.currentDir = currentDir;
            this.forceSlash = forceSlash;
        }

        @Override
        protected Path getUserDir() {
            return this.currentDir.get();
        }

        @Override
        protected String getSeparator(boolean useForwardSlash) {
            return this.forceSlash || useForwardSlash ? "/" : this.getUserDir().getFileSystem().getSeparator();
        }
    }

    public static class DirectoriesCompleter
    extends FileNameCompleter {
        private final Supplier<Path> currentDir;
        private final boolean forceSlash;

        public DirectoriesCompleter(File currentDir) {
            this(currentDir.toPath(), false);
        }

        public DirectoriesCompleter(File currentDir, boolean forceSlash) {
            this(currentDir.toPath(), forceSlash);
        }

        public DirectoriesCompleter(Path currentDir) {
            this(currentDir, false);
        }

        public DirectoriesCompleter(Path currentDir, boolean forceSlash) {
            this.currentDir = () -> currentDir;
            this.forceSlash = forceSlash;
        }

        public DirectoriesCompleter(Supplier<Path> currentDir) {
            this(currentDir, false);
        }

        public DirectoriesCompleter(Supplier<Path> currentDir, boolean forceSlash) {
            this.currentDir = currentDir;
            this.forceSlash = forceSlash;
        }

        @Override
        protected Path getUserDir() {
            return this.currentDir.get();
        }

        @Override
        protected String getSeparator(boolean useForwardSlash) {
            return this.forceSlash || useForwardSlash ? "/" : this.getUserDir().getFileSystem().getSeparator();
        }

        @Override
        protected boolean accept(Path path) {
            return Files.isDirectory(path, new LinkOption[0]) && super.accept(path);
        }
    }

    public static class Completer
    implements org.graalvm.shadowed.org.jline.reader.Completer {
        private final CompletionEnvironment environment;

        public Completer(CompletionEnvironment environment) {
            this.environment = environment;
        }

        @Override
        public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
            if (line.wordIndex() == 0) {
                this.completeCommand(candidates);
            } else {
                this.tryCompleteArguments(reader, line, candidates);
            }
        }

        protected void tryCompleteArguments(LineReader reader, ParsedLine line, List<Candidate> candidates) {
            List<CompletionData> cmd;
            String command = line.words().get(0);
            String resolved = this.environment.resolveCommand(command);
            Map<String, List<CompletionData>> comp = this.environment.getCompletions();
            if (comp != null && (cmd = comp.get(resolved)) != null) {
                this.completeCommandArguments(reader, line, candidates, cmd);
            }
        }

        protected void completeCommandArguments(LineReader reader, ParsedLine line, List<Candidate> candidates, List<CompletionData> completions) {
            for (CompletionData completion : completions) {
                Object res;
                boolean isOption = line.word().startsWith("-");
                String prevOption = line.wordIndex() >= 2 && line.words().get(line.wordIndex() - 1).startsWith("-") ? line.words().get(line.wordIndex() - 1) : null;
                String key = UUID.randomUUID().toString();
                boolean conditionValue = true;
                if (completion.condition != null) {
                    res = Boolean.FALSE;
                    try {
                        res = this.environment.evaluate(reader, line, completion.condition);
                    }
                    catch (Throwable t) {
                        t.getCause();
                    }
                    conditionValue = this.isTrue(res);
                }
                if (conditionValue && isOption && completion.options != null) {
                    for (String opt : completion.options) {
                        candidates.add(new Candidate(opt, opt, "options", completion.description, null, key, true));
                    }
                    continue;
                }
                if (!isOption && prevOption != null && completion.argument != null && completion.options != null && completion.options.contains(prevOption)) {
                    res = null;
                    try {
                        res = this.environment.evaluate(reader, line, completion.argument);
                    }
                    catch (Throwable opt) {
                        // empty catch block
                    }
                    if (res instanceof Candidate) {
                        candidates.add((Candidate)res);
                        continue;
                    }
                    if (res instanceof String) {
                        candidates.add(new Candidate((String)res, (String)res, null, null, null, null, true));
                        continue;
                    }
                    if (res instanceof Collection) {
                        for (Object s : (Collection)res) {
                            if (s instanceof Candidate) {
                                candidates.add((Candidate)s);
                                continue;
                            }
                            if (!(s instanceof String)) continue;
                            candidates.add(new Candidate((String)s, (String)s, null, null, null, null, true));
                        }
                        continue;
                    }
                    if (res == null || !res.getClass().isArray()) continue;
                    int l = Array.getLength(res);
                    for (int i = 0; i < l; ++i) {
                        Object s = Array.get(res, i);
                        if (s instanceof Candidate) {
                            candidates.add((Candidate)s);
                            continue;
                        }
                        if (!(s instanceof String)) continue;
                        candidates.add(new Candidate((String)s, (String)s, null, null, null, null, true));
                    }
                    continue;
                }
                if (isOption || completion.argument == null) continue;
                res = null;
                try {
                    res = this.environment.evaluate(reader, line, completion.argument);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (res instanceof Candidate) {
                    candidates.add((Candidate)res);
                    continue;
                }
                if (res instanceof String) {
                    candidates.add(new Candidate((String)res, (String)res, null, completion.description, null, null, true));
                    continue;
                }
                if (!(res instanceof Collection)) continue;
                for (Object s : (Collection)res) {
                    if (s instanceof Candidate) {
                        candidates.add((Candidate)s);
                        continue;
                    }
                    if (!(s instanceof String)) continue;
                    candidates.add(new Candidate((String)s, (String)s, null, completion.description, null, null, true));
                }
            }
        }

        protected void completeCommand(List<Candidate> candidates) {
            Set<String> commands = this.environment.getCommands();
            for (String command : commands) {
                List<CompletionData> completions;
                String name = this.environment.commandName(command);
                boolean resolved = command.equals(this.environment.resolveCommand(name));
                if (name.startsWith("_")) continue;
                String desc = null;
                Map<String, List<CompletionData>> comp = this.environment.getCompletions();
                if (comp != null && (completions = comp.get(command)) != null) {
                    for (CompletionData completion : completions) {
                        if (completion.description == null || completion.options != null || completion.argument != null || completion.condition != null) continue;
                        desc = completion.description;
                    }
                }
                String key = UUID.randomUUID().toString();
                if (desc != null) {
                    candidates.add(new Candidate(command, command, null, desc, null, key, true));
                    if (!resolved) continue;
                    candidates.add(new Candidate(name, name, null, desc, null, key, true));
                    continue;
                }
                candidates.add(new Candidate(command, command, null, null, null, key, true));
                if (!resolved) continue;
                candidates.add(new Candidate(name, name, null, null, null, key, true));
            }
        }

        private boolean isTrue(Object result) {
            if (result == null) {
                return false;
            }
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            if (result instanceof Number && 0 == ((Number)result).intValue()) {
                return false;
            }
            return !"".equals(result) && !"0".equals(result);
        }
    }

    public static class CompletionData {
        public final List<String> options;
        public final String description;
        public final String argument;
        public final String condition;

        public CompletionData(List<String> options, String description, String argument, String condition) {
            this.options = options;
            this.description = description;
            this.argument = argument;
            this.condition = condition;
        }
    }

    public static interface CompletionEnvironment {
        public Map<String, List<CompletionData>> getCompletions();

        public Set<String> getCommands();

        public String resolveCommand(String var1);

        public String commandName(String var1);

        public Object evaluate(LineReader var1, ParsedLine var2, String var3) throws Exception;
    }
}

