/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.PredefinedSymbols;
import org.netbeans.modules.php.editor.model.EnumScope;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.TraitScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.CaseDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.EnumDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.UseTraitStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintErrorRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class IncorrectEnumHintError
extends HintErrorRule {
    private static final Map<String, String> FORBIDDEN_MAGIC_METHODS = new HashMap<String, String>();
    private static final Map<String, String> FORBIDDEN_BACKED_ENUM_METHODS = new HashMap<String, String>();
    private FileObject fileObject;

    public String getDisplayName() {
        return Bundle.IncorrectEnumHintError_displayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileScope fileScope = context.fileScope;
        this.fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileScope != null && this.fileObject != null) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor();
            phpParseResult.getProgram().accept(checkVisitor);
            for (CaseDeclaration incorrectEnumCase : checkVisitor.getIncorrectEnumCases()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.addHint(incorrectEnumCase, Bundle.IncorrectEnumHintError_incorrectEnumCases(), hints);
            }
            for (Expression incorrectBackingTypes : checkVisitor.getIncorrectBackingTypes()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.addHint(incorrectBackingTypes, Bundle.IncorrectEnumHintError_incorrectEnumBackingTypes(), hints);
            }
            for (FieldsDeclaration incorrectEnumProperty : checkVisitor.getIncorrectEnumProperties()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.addHint(incorrectEnumProperty, Bundle.IncorrectEnumHintError_incorrectEnumProperties(), hints);
            }
            Collection<? extends EnumScope> declaredEnums = ModelUtils.getDeclaredEnums(fileScope);
            for (EnumScope enumScope : declaredEnums) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.checkTraits(enumScope.getTraits(), enumScope, hints, checkVisitor.getUseTraits());
                boolean isBackedEnum = enumScope.getBackingType() != null;
                this.checkMethods(enumScope.getDeclaredMethods(), isBackedEnum, hints);
            }
        }
    }

    private void checkTraits(Collection<? extends TraitScope> traits, EnumScope enumScope, List<Hint> hints, Map<EnumDeclaration, UseTraitStatement> useTraits) {
        for (TraitScope traitScope : traits) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkTraits(traitScope.getTraits(), enumScope, hints, useTraits);
            Collection<? extends FieldElement> declaredFields = traitScope.getDeclaredFields();
            if (declaredFields.isEmpty()) continue;
            UseTraitStatement useTraitStatement = null;
            for (Map.Entry<EnumDeclaration, UseTraitStatement> entry : useTraits.entrySet()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                if (entry.getKey().getName().getStartOffset() != enumScope.getNameRange().getStart()) continue;
                useTraitStatement = entry.getValue();
                break;
            }
            this.addHint(useTraitStatement, Bundle.IncorrectEnumHintError_incorrectEnumPropertiesWithTrait(traitScope.getName()), hints);
        }
    }

    private void checkMethods(Collection<? extends MethodScope> methods, boolean isBackedEnum, List<Hint> hints) {
        for (MethodScope methodScope : methods) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (methodScope.isConstructor()) {
                this.addHint(methodScope, Bundle.IncorrectEnumHintError_incorrectEnumConstructor(), hints);
                continue;
            }
            String methodName = methodScope.getName().toLowerCase();
            if ("cases".equals(methodName)) {
                this.addHint(methodScope, Bundle.IncorrectEnumHintError_incorrectEnumMethodCases(), hints);
                continue;
            }
            if (FORBIDDEN_MAGIC_METHODS.containsKey(methodName)) {
                this.addHint(methodScope, Bundle.IncorrectEnumHintError_incorrectEnumMagicMethod(FORBIDDEN_MAGIC_METHODS.get(methodName)), hints);
                continue;
            }
            if (!isBackedEnum || !FORBIDDEN_BACKED_ENUM_METHODS.containsKey(methodName)) continue;
            this.addHint(methodScope, Bundle.IncorrectEnumHintError_incorrectBackedEnumMethod(FORBIDDEN_BACKED_ENUM_METHODS.get(methodName)), hints);
        }
    }

    private void addHint(ASTNode node, String description, List<Hint> hints) {
        this.addHint(node, description, hints, Collections.emptyList());
    }

    private void addHint(ASTNode node, String description, List<Hint> hints, List<HintFix> fixes) {
        hints.add(new Hint((Rule)this, description, this.fileObject, new OffsetRange(node.getStartOffset(), node.getEndOffset()), fixes, 500));
    }

    private void addHint(ModelElement element, String description, List<Hint> hints) {
        this.addHint(element, description, hints, Collections.emptyList());
    }

    private void addHint(ModelElement element, String description, List<Hint> hints, List<HintFix> fixes) {
        hints.add(new Hint((Rule)this, description, this.fileObject, element.getNameRange(), fixes, 500));
    }

    static {
        for (String methodName : PredefinedSymbols.MAGIC_METHODS) {
            if ("__call".equals(methodName) || "__callStatic".equals(methodName) || "__invoke".equals(methodName)) continue;
            FORBIDDEN_MAGIC_METHODS.put(methodName.toLowerCase(), methodName);
        }
        FORBIDDEN_BACKED_ENUM_METHODS.put("from", "from");
        FORBIDDEN_BACKED_ENUM_METHODS.put("tryfrom", "tryFrom");
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final Set<CaseDeclaration> incorrectEnumCases = new HashSet<CaseDeclaration>();
        private final Set<Expression> incorrectBackingTypes = new HashSet<Expression>();
        private final Set<FieldsDeclaration> incorrectEnumProperties = new HashSet<FieldsDeclaration>();
        private final Map<EnumDeclaration, UseTraitStatement> useTraits = new HashMap<EnumDeclaration, UseTraitStatement>();

        private CheckVisitor() {
        }

        @Override
        public void visit(ClassDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.scan(node.getAttributes());
            this.scan(node.getName());
            this.scan(node.getSuperClass());
            this.scan(node.getInterfaes());
            this.checkEnumCases(node.getBody().getStatements());
        }

        @Override
        public void visit(TraitDeclaration traitDeclaration) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.scan(traitDeclaration.getAttributes());
            this.scan(traitDeclaration.getName());
            this.scan(traitDeclaration.getBody());
            this.checkEnumCases(traitDeclaration.getBody().getStatements());
        }

        private void checkEnumCases(List<Statement> statements) {
            for (Statement statement : statements) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                if (statement instanceof CaseDeclaration) {
                    this.incorrectEnumCases.add((CaseDeclaration)statement);
                }
                this.scan(statement);
            }
        }

        @Override
        public void visit(EnumDeclaration node) {
            String name;
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.scan(node.getAttributes());
            this.scan(node.getName());
            this.scan(node.getInterfaes());
            Expression backingType = node.getBackingType();
            if (backingType != null && !"string".equals(name = CodeUtils.extractQualifiedName(backingType)) && !"int".equals(name)) {
                this.incorrectBackingTypes.add(backingType);
            }
            this.scan(node.getBackingType());
            this.checkStatements(node.getBody().getStatements(), node);
        }

        private void checkStatements(List<Statement> statements, EnumDeclaration node) {
            for (Statement statement : statements) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                if (statement instanceof FieldsDeclaration) {
                    this.incorrectEnumProperties.add((FieldsDeclaration)statement);
                } else if (statement instanceof UseTraitStatement) {
                    this.useTraits.put(node, (UseTraitStatement)statement);
                }
                this.scan(statement);
            }
        }

        public Set<CaseDeclaration> getIncorrectEnumCases() {
            return Collections.unmodifiableSet(this.incorrectEnumCases);
        }

        public Set<Expression> getIncorrectBackingTypes() {
            return Collections.unmodifiableSet(this.incorrectBackingTypes);
        }

        public Set<FieldsDeclaration> getIncorrectEnumProperties() {
            return Collections.unmodifiableSet(this.incorrectEnumProperties);
        }

        public Map<EnumDeclaration, UseTraitStatement> getUseTraits() {
            return Collections.unmodifiableMap(this.useTraits);
        }
    }
}

