/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.i18n.FactoryRegistry;
import org.netbeans.modules.i18n.I18nOptions;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public final class I18nUtil {
    public static final String HELP_ID_I18N = "internation.internation";
    public static final String HELP_ID_AUTOINSERT = "internation.autoinsert";
    public static final String HELP_ID_MANINSERT = "internation.maninsert";
    public static final String HELP_ID_FORMED = "internation.formed";
    public static final String HELP_ID_TESTING = "internation.testing";
    public static final String HELP_ID_WIZARD = "internation.wizard";
    public static final String HELP_ID_CUSTOM = "internation.custom";
    public static final String HELP_ID_ADDPARAMS = "internation.addparams";
    public static final String HELP_ID_REPLFORMAT = "internation.replformat";
    public static final String HELP_ID_RUNLOCALE = "internation.runlocale";
    public static final String PE_REPLACE_CODE_HELP_ID = "i18n.pe.replacestring";
    public static final String PE_I18N_REGEXP_HELP_ID = "i18n.pe.i18nregexp";
    public static final String PE_BUNDLE_CODE_HELP_ID = "i18n.pe.bundlestring";
    public static final String PE_TEST_REGEXP_HELP_ID = "i18n.pe.testregexp";
    public static final String PE_I18N_STRING_HELP_ID = "i18n.pe.i18nString";
    private static final String DEFAULT_STANDARD_REPLACE_FORMAT = "java.util.ResourceBundle.getBundle(\"{bundleNameSlashes}\").getString(\"{key}\")";
    private static final String DEFAULT_NETBEANS_REPLACE_FORMAT = "org.openide.util.NbBundle.getMessage({sourceFileName}.class, \"{key}\")";
    private static List<String> initFormatItems;
    private static List<String> initHelpItems;
    private static List<String> replaceFormatItems;
    private static List<String> replaceHelpItems;
    private static List<String> regExpItems;
    private static List<String> regExpHelpItems;
    private static List<String> i18nRegExpItems;

    public static List<String> getInitFormatItems() {
        if (initFormatItems == null) {
            initFormatItems = new ArrayList<String>(2);
            initFormatItems.add("java.util.ResourceBundle.getBundle(\"{bundleNameSlashes}\")");
            initFormatItems.add("org.openide.util.NbBundle.getBundle({sourceFileName}.class)");
        }
        return initFormatItems;
    }

    public static List<String> getInitHelpItems() {
        if (initHelpItems == null) {
            ResourceBundle bundle = I18nUtil.getBundle();
            initHelpItems = new ArrayList<String>(3);
            initHelpItems.add(bundle.getString("TXT_PackageNameSlashes"));
            initHelpItems.add(bundle.getString("TXT_PackageNameDots"));
            initHelpItems.add(bundle.getString("TXT_SourceDataObjectName"));
        }
        return initHelpItems;
    }

    public static List<String> getReplaceFormatItems() {
        if (replaceFormatItems == null) {
            replaceFormatItems = new ArrayList<String>(7);
            replaceFormatItems.add("{identifier}.getString(\"{key}\")");
            replaceFormatItems.add("Utilities.getString(\"{key}\")");
            replaceFormatItems.add(DEFAULT_STANDARD_REPLACE_FORMAT);
            replaceFormatItems.add("org.openide.util.NbBundle.getBundle({sourceFileName}.class).getString(\"{key}\")");
            replaceFormatItems.add("java.text.MessageFormat.format(java.util.ResourceBundle.getBundle(\"{bundleNameSlashes}\").getString(\"{key}\"), {arguments})");
            replaceFormatItems.add(DEFAULT_NETBEANS_REPLACE_FORMAT);
            replaceFormatItems.add("org.openide.util.NbBundle.getMessage({sourceFileName}.class, \"{key}\", {arguments})");
        }
        return replaceFormatItems;
    }

    public static String getDefaultReplaceFormat(boolean nbProject) {
        return nbProject ? DEFAULT_NETBEANS_REPLACE_FORMAT : DEFAULT_STANDARD_REPLACE_FORMAT;
    }

    public static List<String> getReplaceHelpItems() {
        if (replaceHelpItems == null) {
            ResourceBundle bundle = I18nUtil.getBundle();
            replaceHelpItems = new ArrayList<String>(6);
            replaceHelpItems.add(bundle.getString("TXT_FieldIdentifier"));
            replaceHelpItems.add(bundle.getString("TXT_KeyHelp"));
            replaceHelpItems.add(bundle.getString("TXT_PackageNameSlashes"));
            replaceHelpItems.add(bundle.getString("TXT_PackageNameDots"));
            replaceHelpItems.add(bundle.getString("TXT_SourceDataObjectName"));
            replaceHelpItems.add(bundle.getString("TXT_Arguments"));
        }
        return replaceHelpItems;
    }

    public static List<String> getRegExpItems() {
        if (regExpItems == null) {
            regExpItems = new ArrayList<String>(4);
            regExpItems.add("(getString|getBundle)[:space:]*\\([:space:]*{hardString}|//[:space:]*NOI18|getMessage[:space:]*\\(([:alnum:]|[:punct:]|[:space:])*,[:space:]*{hardString}");
            regExpItems.add("(getString|getBundle)[:space:]*\\([:space:]*{hardString}");
            regExpItems.add("//[:space:]*NOI18N");
            regExpItems.add("(getString|getBundle)[:space:]*\\([:space:]*|getMessage[:space:]*\\(([:alnum:]|[:punct:]|[:space:])*,[:space:]*{hardString}|//[:space:]*NOI18N");
        }
        return regExpItems;
    }

    public static List<String> getI18nRegExpItems() {
        if (i18nRegExpItems == null) {
            i18nRegExpItems = new ArrayList<String>(2);
            i18nRegExpItems.add("getString[:space:]*\\([:space:]*{hardString}");
            i18nRegExpItems.add("(getString[:space:]*\\([:space:]*|getMessage[:space:]*\\(([:alnum:]|[:punct:]|[:space:])*,[:space:]*){hardString}");
        }
        return i18nRegExpItems;
    }

    public static boolean containsAcceptedDataObject(DataFolder folder) {
        DataObject[] children = folder.getChildren();
        DataObject[] folders = new DataObject[children.length];
        int foldersCount = 0;
        for (DataObject child : children) {
            if (child instanceof DataFolder) {
                folders[foldersCount++] = child;
                continue;
            }
            if (!FactoryRegistry.hasFactory(child.getClass())) continue;
            return true;
        }
        for (int i = 0; i < foldersCount; ++i) {
            if (!I18nUtil.containsAcceptedDataObject((DataFolder)children[i])) continue;
            return true;
        }
        return false;
    }

    public static List<DataObject> getAcceptedDataObjects(DataObject.Container folder) {
        DataObject[] children;
        ArrayList<DataObject> accepted = new ArrayList<DataObject>();
        VisibilityQuery visQuery = VisibilityQuery.getDefault();
        for (DataObject child : children = folder.getChildren()) {
            if (!visQuery.isVisible(child.getPrimaryFile())) continue;
            if (child instanceof DataObject.Container) {
                accepted.addAll(I18nUtil.getAcceptedDataObjects((DataObject.Container)child));
                continue;
            }
            if (!FactoryRegistry.hasFactory(child.getClass())) continue;
            accepted.add(child);
        }
        return accepted;
    }

    public static ResourceBundle getBundle() {
        return NbBundle.getBundle(I18nUtil.class);
    }

    public static I18nOptions getOptions() {
        return I18nOptions.getDefault();
    }
}

