/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ContextRootConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DatasourceConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DeploymentPlanConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.javaee.wildfly.config.ResourceConfigurationHelper;
import org.netbeans.modules.javaee.wildfly.config.WildflyDatasource;
import org.netbeans.modules.javaee.wildfly.config.WildflyDeploymentConfiguration;
import org.netbeans.modules.javaee.wildfly.config.gen.EjbRefType;
import org.netbeans.modules.javaee.wildfly.config.gen.JbossWeb;
import org.netbeans.modules.javaee.wildfly.config.gen.MessageDestinationRefType;
import org.netbeans.modules.javaee.wildfly.config.gen.ResourceRefType;
import org.netbeans.modules.javaee.wildfly.ide.ui.WildflyPluginUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class WarDeploymentConfiguration
extends WildflyDeploymentConfiguration
implements ModuleConfiguration,
ContextRootConfiguration,
DatasourceConfiguration,
DeploymentPlanConfiguration,
PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(WarDeploymentConfiguration.class.getName());
    private File jbossWebFile;
    private JbossWeb jbossWeb;

    public WarDeploymentConfiguration(J2eeModule j2eeModule) {
        this(j2eeModule, null, true);
    }

    public WarDeploymentConfiguration(J2eeModule j2eeModule, WildflyPluginUtils.Version version, boolean isWildFly) {
        super(j2eeModule, version, isWildFly);
        this.jbossWebFile = j2eeModule.getDeploymentConfigurationFile("WEB-INF/jboss-web.xml");
        this.getJbossWeb();
        if (this.deploymentDescriptorDO == null) {
            try {
                if (FileUtil.toFileObject((File)this.jbossWebFile) != null) {
                    this.deploymentDescriptorDO = DataObject.find((FileObject)FileUtil.toFileObject((File)this.jbossWebFile));
                    this.deploymentDescriptorDO.addPropertyChangeListener((PropertyChangeListener)this);
                }
            }
            catch (DataObjectNotFoundException donfe) {
                LOGGER.log(Level.WARNING, null, donfe);
            }
        }
    }

    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[]{this});
    }

    public void dispose() {
    }

    public String getContextRoot() throws ConfigurationException {
        JbossWeb jbossWeb = this.getJbossWeb();
        if (jbossWeb == null) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotReadContextRoot", (Object)this.jbossWebFile.getAbsolutePath());
            throw new ConfigurationException(msg);
        }
        if (jbossWeb.getContextRoot() == null || jbossWeb.getContextRoot().isEmpty()) {
            try {
                if (this.j2eeModule.getArchive() != null) {
                    return this.formatContextPath(this.j2eeModule.getArchive().getName());
                }
                if (this.j2eeModule.getUrl() != null) {
                    if (this.j2eeModule.getUrl().endsWith(".war")) {
                        return this.formatContextPath(this.j2eeModule.getUrl().substring(0, this.j2eeModule.getUrl().length() - 4));
                    }
                    return this.formatContextPath(this.j2eeModule.getUrl());
                }
            }
            catch (IOException ex) {
                return this.formatContextPath(jbossWeb.getContextRoot());
            }
        }
        return this.formatContextPath(jbossWeb.getContextRoot());
    }

    private String formatContextPath(String contextRoot) {
        if (!contextRoot.startsWith("/")) {
            return '/' + contextRoot;
        }
        return contextRoot;
    }

    public void setContextRoot(String contextPath) throws ConfigurationException {
        String currentCP = "";
        if (contextPath != null) {
            currentCP = contextPath;
        }
        if (!this.isCorrectCP(currentCP)) {
            String ctxRoot = currentCP;
            StringTokenizer tok = new StringTokenizer(currentCP, "/");
            StringBuilder buf = new StringBuilder();
            while (tok.hasMoreTokens()) {
                buf.append('/').append(tok.nextToken());
            }
            ctxRoot = buf.toString();
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_invalidCP", (Object)currentCP), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            currentCP = ctxRoot;
        }
        final String newContextPath = currentCP;
        if (!this.getContextRoot().equals(newContextPath)) {
            this.modifyJbossWeb(new JbossWebModifier(){

                @Override
                public void modify(JbossWeb jbossWeb) {
                    jbossWeb.setContextRoot(newContextPath);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        if (evt.getPropertyName() == "modified" && newValue == Boolean.FALSE) {
            if (evt.getSource() == this.deploymentDescriptorDO) {
                WarDeploymentConfiguration warDeploymentConfiguration = this;
                synchronized (warDeploymentConfiguration) {
                    this.jbossWeb = null;
                }
            }
        } else if (evt.getOldValue() == null) {
            if (newValue instanceof ResourceRef) {
                ResourceRef resourceRef = (ResourceRef)newValue;
                try {
                    String resType = resourceRef.getResType();
                    if ("javax.sql.DataSource".equals(resType)) {
                        this.addResReference(resourceRef.getResRefName(), "java:/" + resourceRef.getResRefName());
                    } else if ("javax.mail.Session".equals(resType)) {
                        this.addMailReference(resourceRef.getResRefName());
                    } else if ("javax.jms.ConnectionFactory".equals(resType)) {
                        this.addConnectionFactoryReference(resourceRef.getResRefName());
                    }
                }
                catch (ConfigurationException ce) {
                    LOGGER.log(Level.WARNING, null, ce);
                }
            } else if (newValue instanceof EjbRef) {
                EjbRef ejbRef = (EjbRef)newValue;
                try {
                    String ejbRefType = ejbRef.getEjbRefType();
                    if ("Session".equals(ejbRefType) || "Entity".equals(ejbRefType)) {
                        this.addEjbReference(ejbRef.getEjbRefName(), ejbRef.getEjbRefName());
                    }
                }
                catch (ConfigurationException ce) {
                    LOGGER.log(Level.WARNING, null, ce);
                }
            } else if (newValue instanceof MessageDestinationRef) {
                MessageDestinationRef messageDestinationRef = (MessageDestinationRef)newValue;
                try {
                    String messageDestinationType = messageDestinationRef.getMessageDestinationType();
                    String destPrefix = "javax.jms.Queue".equals(messageDestinationType) ? "queue/" : "topic/";
                    this.addMsgDestReference(messageDestinationRef.getMessageDestinationRefName(), destPrefix);
                }
                catch (ConfigurationException ce) {
                    LOGGER.log(Level.WARNING, null, ce);
                }
            }
        }
    }

    @Override
    public void bindDatasourceReference(String referenceName, String jndiName) throws ConfigurationException {
        this.addResReference(referenceName, jndiName);
    }

    @Override
    public String findDatasourceJndiName(String referenceName) throws ConfigurationException {
        ResourceRefType[] resourceRefs;
        for (ResourceRefType resourceRef : resourceRefs = this.getJbossWeb().getResourceRef()) {
            String jndiName;
            String rrn = resourceRef.getResRefName();
            if (!referenceName.equals(rrn) || (jndiName = resourceRef.getJndiName()) == null) continue;
            return WildflyDatasource.getJndiName(jndiName);
        }
        return null;
    }

    private void addResReference(final String name, final String jndiName) throws ConfigurationException {
        this.modifyJbossWeb(new JbossWebModifier(){

            @Override
            public void modify(JbossWeb modifiedJbossWeb) {
                ResourceRefType[] resourceRefs = modifiedJbossWeb.getResourceRef();
                for (int i = 0; i < resourceRefs.length; ++i) {
                    String rrn = resourceRefs[i].getResRefName();
                    if (!name.equals(rrn)) continue;
                    return;
                }
                ResourceRefType newRR = new ResourceRefType();
                newRR.setResRefName(name);
                newRR.setJndiName(jndiName);
                modifiedJbossWeb.addResourceRef(newRR);
            }
        });
    }

    private void addMailReference(final String name) throws ConfigurationException {
        this.modifyJbossWeb(new JbossWebModifier(){

            @Override
            public void modify(JbossWeb modifiedJbossWeb) {
                ResourceRefType[] resourceRefs = modifiedJbossWeb.getResourceRef();
                for (int i = 0; i < resourceRefs.length; ++i) {
                    String rrn = resourceRefs[i].getResRefName();
                    if (!name.equals(rrn)) continue;
                    return;
                }
                ResourceRefType newRR = new ResourceRefType();
                newRR.setResRefName(name);
                newRR.setJndiName("java:Mail");
                modifiedJbossWeb.addResourceRef(newRR);
            }
        });
    }

    @Override
    public void bindMessageDestinationReference(String referenceName, String connectionFactoryName, String destName, MessageDestination.Type type) throws ConfigurationException {
        this.addConnectionFactoryReference(connectionFactoryName);
        String jndiName = null;
        if (MessageDestination.Type.QUEUE.equals((Object)type)) {
            jndiName = "queue/" + destName;
        } else if (MessageDestination.Type.TOPIC.equals((Object)type)) {
            jndiName = "topic/" + destName;
        }
        this.addMsgDestReference(referenceName, jndiName);
    }

    private void addConnectionFactoryReference(final String name) throws ConfigurationException {
        this.modifyJbossWeb(new JbossWebModifier(){

            @Override
            public void modify(JbossWeb modifiedJbossWeb) {
                ResourceRefType[] resourceRefs = modifiedJbossWeb.getResourceRef();
                for (int i = 0; i < resourceRefs.length; ++i) {
                    String rrn = resourceRefs[i].getResRefName();
                    if (!name.equals(rrn)) continue;
                    return;
                }
                ResourceRefType newRR = new ResourceRefType();
                newRR.setResRefName(name);
                newRR.setJndiName("ConnectionFactory");
                modifiedJbossWeb.addResourceRef(newRR);
            }
        });
    }

    private void addMsgDestReference(final String name, final String jndiName) throws ConfigurationException {
        this.modifyJbossWeb(new JbossWebModifier(){

            @Override
            public void modify(JbossWeb modifiedJbossWeb) {
                MessageDestinationRefType[] mdRefs;
                for (MessageDestinationRefType mdRef : mdRefs = modifiedJbossWeb.getMessageDestinationRef()) {
                    String mdrn = mdRef.getMessageDestinationRefName();
                    if (!name.equals(mdrn)) continue;
                    return;
                }
                MessageDestinationRefType mdr = new MessageDestinationRefType();
                mdr.setMessageDestinationRefName(name);
                mdr.setJndiName(jndiName);
                modifiedJbossWeb.addMessageDestinationRef(mdr);
            }
        });
    }

    @Override
    public void bindEjbReference(String referenceName, String ejbName) throws ConfigurationException {
        if (Double.parseDouble(this.j2eeModule.getModuleVersion()) > 2.4) {
            return;
        }
        this.addEjbReference(referenceName, ejbName);
    }

    private void addEjbReference(final String referenceName, final String ejbName) throws ConfigurationException {
        this.modifyJbossWeb(new JbossWebModifier(){

            @Override
            public void modify(JbossWeb modifiedJbossWeb) {
                EjbRefType[] ejbRefs;
                for (EjbRefType ejbRef : ejbRefs = modifiedJbossWeb.getEjbRef()) {
                    String ern = ejbRef.getEjbRefName();
                    if (!referenceName.equals(ern)) continue;
                    return;
                }
                EjbRefType newER = new EjbRefType();
                newER.setEjbRefName(referenceName);
                newER.setJndiName(ejbName);
                modifiedJbossWeb.addEjbRef(newER);
            }
        });
    }

    public synchronized JbossWeb getJbossWeb() {
        if (this.jbossWeb == null) {
            if (this.jbossWebFile.exists()) {
                try {
                    this.jbossWeb = JbossWeb.createGraph(this.jbossWebFile);
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.WARNING, null, ioe);
                }
                catch (RuntimeException runtimeException) {}
            } else {
                this.jbossWeb = this.generateJbossWeb();
            }
        }
        return this.jbossWeb;
    }

    public void save(OutputStream os) throws ConfigurationException {
        JbossWeb jbossWeb = this.getJbossWeb();
        if (jbossWeb == null) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_cannotSaveNotParseableConfFile", (Object)this.jbossWebFile.getAbsolutePath());
            throw new ConfigurationException(msg);
        }
        try {
            jbossWeb.write(os);
        }
        catch (IOException ioe) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotUpdateFile", (Object)this.jbossWebFile.getAbsolutePath());
            throw new ConfigurationException(msg, (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyJbossWeb(JbossWebModifier modifier) throws ConfigurationException {
        if (this.deploymentDescriptorDO == null && FileUtil.toFileObject((File)this.jbossWebFile) == null) {
            ResourceConfigurationHelper.writeFile(this.jbossWebFile, this.jbossWeb);
            try {
                this.deploymentDescriptorDO = DataObject.find((FileObject)FileUtil.toFileObject((File)this.jbossWebFile));
            }
            catch (DataObjectNotFoundException ex) {
                throw new ConfigurationException("Couldn't save jboss-web.xml", (Throwable)ex);
            }
            this.deploymentDescriptorDO.addPropertyChangeListener((PropertyChangeListener)this);
        }
        if (this.deploymentDescriptorDO == null) {
            return;
        }
        assert (this.deploymentDescriptorDO != null) : "DataObject has not been initialized yet";
        try {
            EditorCookie editor = (EditorCookie)this.deploymentDescriptorDO.getCookie(EditorCookie.class);
            StyledDocument doc = editor.getDocument();
            if (doc == null) {
                doc = editor.openDocument();
            }
            JbossWeb newJbossWeb = null;
            try {
                byte[] docString = doc.getText(0, doc.getLength()).getBytes();
                newJbossWeb = JbossWeb.createGraph(new ByteArrayInputStream(docString));
            }
            catch (RuntimeException e) {
                JbossWeb oldJbossWeb = this.getJbossWeb();
                if (oldJbossWeb == null) {
                    String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_jbossXmlCannotParse", (Object)this.jbossWebFile.getAbsolutePath());
                    throw new ConfigurationException(msg);
                }
                NotifyDescriptor.Confirmation notDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_jbossWebXmlNotValid"), 2);
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
                if (result == NotifyDescriptor.CANCEL_OPTION) {
                    return;
                }
                newJbossWeb = oldJbossWeb;
            }
            modifier.modify(newJbossWeb);
            boolean modified = this.deploymentDescriptorDO.isModified();
            ResourceConfigurationHelper.replaceDocument(doc, newJbossWeb);
            if (!modified) {
                SaveCookie cookie = (SaveCookie)this.deploymentDescriptorDO.getCookie(SaveCookie.class);
                if (cookie != null) {
                    cookie.save();
                }
            } else {
                ResourceConfigurationHelper.writeFile(this.jbossWebFile, this.jbossWeb);
            }
            WarDeploymentConfiguration warDeploymentConfiguration = this;
            synchronized (warDeploymentConfiguration) {
                this.jbossWeb = newJbossWeb;
            }
        }
        catch (BadLocationException ble) {
            LOGGER.log(Level.WARNING, null, ble);
        }
        catch (IOException ioe) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotUpdateFile", (Object)this.jbossWebFile.getAbsolutePath());
            throw new ConfigurationException(msg, (Throwable)ioe);
        }
    }

    private JbossWeb generateJbossWeb() {
        JbossWeb jbossWeb = new JbossWeb(null, 2);
        if (jbossWeb._getSchemaLocation() == null) {
            jbossWeb.createAttribute("xmlns:xsi", "xmlns:xsi", 513, null, "http://www.w3.org/2001/XMLSchema-instance");
            jbossWeb.setAttributeValue("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            jbossWeb.createAttribute("xsi:schemaLocation", "xsi:schemaLocation", 513, null, this.getJbossWebSchemaLocation());
            jbossWeb._setSchemaLocation(this.getJbossWebSchemaLocation());
            jbossWeb.setVersion(this.getJbossWebVersion());
        }
        jbossWeb.setContextRoot("");
        return jbossWeb;
    }

    private String getJbossWebVersion() {
        if (this.version == null || WildflyPluginUtils.WILDFLY_8_0_0.compareTo(this.version) <= 0) {
            return "8.0";
        }
        if (WildflyPluginUtils.EAP_6_3_0.compareTo(this.version) <= 0) {
            return "7.2";
        }
        return "7.1";
    }

    private String getJbossWebSchemaLocation() {
        if (this.version == null || WildflyPluginUtils.WILDFLY_8_0_0.compareTo(this.version) <= 0) {
            return "http://www.jboss.com/xml/ns/javaee http://www.jboss.org/schema/jbossas/jboss-web_8_0.xsd";
        }
        if (WildflyPluginUtils.EAP_6_3_0.compareTo(this.version) <= 0) {
            return "http://www.jboss.com/xml/ns/javaee http://www.jboss.org/schema/jbossas/jboss-web_7_2.xsd";
        }
        return "http://www.jboss.com/xml/ns/javaee http://www.jboss.org/schema/jbossas/jboss-web_7_1.xsd";
    }

    private boolean isCorrectCP(String contextPath) {
        boolean correct = true;
        if (!"".equals(contextPath) && !contextPath.startsWith("/")) {
            correct = false;
        } else if (contextPath.endsWith("/")) {
            correct = false;
        } else if (contextPath.indexOf("//") >= 0) {
            correct = false;
        }
        return correct;
    }

    private static interface JbossWebModifier {
        public void modify(JbossWeb var1);
    }
}

