/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.netbeans.api.editor.fold.FoldTemplate;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.core.spi.multiview.text.MultiViewEditorElement;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.spi.DefaultLanguageConfig;
import org.netbeans.modules.languages.hcl.BasicHCLLexer;
import org.netbeans.modules.languages.hcl.Bundle;
import org.netbeans.modules.languages.hcl.HCLParserResult;
import org.netbeans.modules.languages.hcl.HCLStructureScanner;
import org.netbeans.modules.languages.hcl.HCLTokenId;
import org.netbeans.modules.languages.hcl.NbHCLParser;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.fold.FoldTypeProvider;
import org.netbeans.spi.lexer.EmbeddingPresence;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.openide.util.Lookup;

public class HCLLanguage
extends DefaultLanguageConfig {
    public static final String MIME_TYPE = "text/x-hcl";
    private static final Language<HCLTokenId> language = new LanguageHierarchy<HCLTokenId>(){

        protected String mimeType() {
            return HCLLanguage.MIME_TYPE;
        }

        protected Lexer<HCLTokenId> createLexer(LexerRestartInfo<HCLTokenId> info) {
            return new BasicHCLLexer(info);
        }

        protected Collection<HCLTokenId> createTokenIds() {
            return EnumSet.allOf(HCLTokenId.class);
        }

        protected LanguageEmbedding<?> embedding(Token<HCLTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
            return HCLTokenId.INTERPOLATION == token.id() ? LanguageEmbedding.create((Language)this.language(), (int)0, (int)0) : null;
        }

        protected EmbeddingPresence embeddingPresence(HCLTokenId id) {
            return HCLTokenId.INTERPOLATION == id ? EmbeddingPresence.CACHED_FIRST_QUERY : EmbeddingPresence.NONE;
        }
    }.language();

    public Language getLexerLanguage() {
        return language;
    }

    public String getDisplayName() {
        return Bundle.HCLResolver();
    }

    public String getPreferredExtension() {
        return "hcl";
    }

    public String getLineCommentPrefix() {
        return "#";
    }

    public Parser getParser() {
        return new NbHCLParser<HCLParserResult>(HCLParserResult::new);
    }

    public boolean hasStructureScanner() {
        return true;
    }

    public boolean isIdentifierChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '-';
    }

    public StructureScanner getStructureScanner() {
        return new HCLStructureScanner();
    }

    public static MultiViewEditorElement createMultiViewEditorElement(Lookup context) {
        return new MultiViewEditorElement(context);
    }

    public static class HCLFold
    implements FoldTypeProvider {
        public static final FoldType HEREDOC = FoldType.create((String)"heredoc", (String)Bundle.FT_label_heredoc(), (FoldTemplate)new FoldTemplate(2, 0, Bundle.FT_template_heredoc()));
        public static final FoldType TUPLE = FoldType.create((String)"tuple", (String)Bundle.FT_label_tuple(), (FoldTemplate)new FoldTemplate(1, 1, Bundle.FT_template_tuple()));
        public static final FoldType OBJECT = FoldType.create((String)"object", (String)Bundle.FT_label_object(), (FoldTemplate)new FoldTemplate(1, 1, Bundle.FT_template_object()));
        private static final List<FoldType> SUPPORTED = Arrays.asList(FoldType.CODE_BLOCK, FoldType.COMMENT, HEREDOC, FoldType.INITIAL_COMMENT, OBJECT, TUPLE);

        public Collection getValues(Class type) {
            return type == FoldType.class ? SUPPORTED : null;
        }

        public boolean inheritable() {
            return true;
        }
    }
}

