/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.api;

import java.util.Collection;
import org.netbeans.modules.bugtracking.BugtrackingOwnerSupport;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.RepositoryRegistry;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.spi.RepositoryQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class RepositoryQuery {
    private static RepositoryQuery instance;

    private RepositoryQuery() {
    }

    public static Repository getRepository(FileObject fileObject, boolean askIfUnknown) {
        if (fileObject == null) {
            return null;
        }
        RepositoryQuery rq = RepositoryQuery.getInstance();
        Collection<? extends RepositoryQueryImplementation> impls = rq.getImplementations();
        for (RepositoryQueryImplementation repositoryQueryImplementation : impls) {
            String url = repositoryQueryImplementation.getRepositoryUrl(fileObject);
            if (url == null) continue;
            Collection<RepositoryImpl> repos = RepositoryRegistry.getInstance().getKnownRepositories(false);
            for (RepositoryImpl r : repos) {
                if (!r.getUrl().equals(url)) continue;
                return r.getRepository();
            }
        }
        return rq.getRepositoryIntern(fileObject, askIfUnknown);
    }

    private static synchronized RepositoryQuery getInstance() {
        if (instance == null) {
            instance = new RepositoryQuery();
        }
        return instance;
    }

    private Collection<? extends RepositoryQueryImplementation> getImplementations() {
        Collection result = Lookup.getDefault().lookupAll(RepositoryQueryImplementation.class);
        return result;
    }

    private Repository getRepositoryIntern(FileObject fileObject, boolean askIfUnknown) {
        RepositoryImpl impl = BugtrackingOwnerSupport.getInstance().getRepository(fileObject, askIfUnknown);
        return impl != null ? impl.getRepository() : null;
    }
}

