/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component;

import com.sun.faces.facelets.tag.faces.ComponentSupport;
import com.sun.faces.util.Util;
import jakarta.el.ELException;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.application.Application;
import jakarta.faces.component.AttachedObjectListHolder;
import jakarta.faces.component.ContextCallback;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.PartialStateHolder;
import jakarta.faces.component.StateHolder;
import jakarta.faces.component.StateHolderSaver;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.UniqueIdVendor;
import jakarta.faces.component.behavior.Behavior;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.BehaviorEvent;
import jakarta.faces.event.ComponentSystemEventListener;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.FacesListener;
import jakarta.faces.event.PostAddToViewEvent;
import jakarta.faces.event.PostValidateEvent;
import jakarta.faces.event.PreRemoveFromViewEvent;
import jakarta.faces.event.PreRenderComponentEvent;
import jakarta.faces.event.PreValidateEvent;
import jakarta.faces.event.SystemEvent;
import jakarta.faces.event.SystemEventListener;
import jakarta.faces.render.Renderer;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class UIComponentBase
extends UIComponent {
    private static Logger LOGGER = Logger.getLogger("jakarta.faces.component", "jakarta.faces.LogStrings");
    private static final String ADDED = UIComponentBase.class.getName() + ".ADDED";
    private static final int MY_STATE = 0;
    private static final int CHILD_STATE = 1;
    private Map<Class<?>, Map<String, PropertyDescriptor>> descriptors;
    private Map<String, PropertyDescriptor> propertyDescriptorMap;
    private Map<Class<? extends SystemEvent>, List<SystemEventListener>> listenersByEventClass;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private AttributesMap attributes;
    private String id;
    private String clientId;
    private UIComponent parent;
    private List<UIComponent> children;
    private Map<String, UIComponent> facets;
    private AttachedObjectListHolder<FacesListener> listeners;
    private boolean transientFlag;
    private BehaviorsMap behaviors;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final Iterator<UIComponent> EMPTY_ITERATOR = new Iterator<UIComponent>(){

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UIComponent next() {
            throw new NoSuchElementException("Empty Iterator");
        }

        @Override
        public boolean hasNext() {
            return false;
        }
    };

    public UIComponentBase() {
        this.populateDescriptorsMapIfNecessary();
    }

    @Override
    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new AttributesMap(this);
        }
        return this.attributes;
    }

    @Override
    public Map<String, Object> getPassThroughAttributes(boolean create) {
        PassThroughAttributesMap passThroughAttributes = (PassThroughAttributesMap)this.getStateHelper().get((Serializable)((Object)UIComponent.PropertyKeys.passThroughAttributes));
        if (passThroughAttributes == null && create) {
            passThroughAttributes = new PassThroughAttributesMap();
            this.getStateHelper().put((Serializable)((Object)UIComponent.PropertyKeys.passThroughAttributes), passThroughAttributes);
        }
        return passThroughAttributes;
    }

    @Override
    public String getClientId(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.clientId == null) {
            Renderer renderer;
            UIComponent namingContainerAncestor = this.getNamingContainerAncestor();
            String parentId = this.getParentId(context, namingContainerAncestor);
            this.clientId = this.getId();
            if (this.clientId == null) {
                this.setId(this.generateId(context, namingContainerAncestor));
                this.clientId = this.getId();
            }
            if (parentId != null) {
                this.clientId = this.addParentId(context, parentId, this.clientId);
            }
            if ((renderer = this.getRenderer(context)) != null) {
                this.clientId = renderer.convertClientId(context, this.clientId);
            }
        }
        return this.clientId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        if (this.id == null || !this.id.equals(id)) {
            UIComponentBase.validateId(id);
            this.id = id;
        }
        this.clientId = null;
    }

    @Override
    public UIComponent getParent() {
        return this.parent;
    }

    @Override
    public void setParent(UIComponent parent) {
        if (parent == null) {
            if (this.parent != null) {
                this.doPreRemoveProcessing(FacesContext.getCurrentInstance(), this);
                this.parent = parent;
            }
            this.compositeParent = null;
        } else {
            this.parent = parent;
            if (this.getAttributes().get(ADDED) == null) {
                this.getAttributes().put(ADDED, Boolean.TRUE);
                this.doPostAddProcessing(FacesContext.getCurrentInstance(), this);
                this.getAttributes().remove(ADDED);
            }
        }
    }

    @Override
    public boolean isRendered() {
        return Boolean.valueOf(this.getStateHelper().eval((Serializable)((Object)UIComponent.PropertyKeys.rendered), Boolean.TRUE).toString());
    }

    @Override
    public void setRendered(boolean rendered) {
        this.getStateHelper().put((Serializable)((Object)UIComponent.PropertyKeys.rendered), rendered);
    }

    @Override
    public String getRendererType() {
        return (String)this.getStateHelper().eval((Serializable)((Object)UIComponent.PropertyKeys.rendererType));
    }

    @Override
    public void setRendererType(String rendererType) {
        this.getStateHelper().put((Serializable)((Object)UIComponent.PropertyKeys.rendererType), rendererType);
    }

    @Override
    public boolean getRendersChildren() {
        Renderer renderer;
        if (this.getRendererType() != null && (renderer = this.getRenderer(this.getFacesContext())) != null) {
            return renderer.getRendersChildren();
        }
        return false;
    }

    @Override
    public List<UIComponent> getChildren() {
        if (this.children == null) {
            this.children = new ChildrenList(this);
        }
        return this.children;
    }

    @Override
    public int getChildCount() {
        if (this.children != null) {
            return this.children.size();
        }
        return 0;
    }

    @Override
    public UIComponent findComponent(String expression) {
        if (expression == null) {
            throw new NullPointerException();
        }
        if (expression.isEmpty()) {
            throw new IllegalArgumentException("\"\"");
        }
        char sepChar = UINamingContainer.getSeparatorChar(FacesContext.getCurrentInstance());
        UIComponent base = this.findBaseComponent(expression, sepChar);
        if (expression.charAt(0) == sepChar) {
            expression = expression.substring(1);
        }
        return this.evaluateSearchExpression(base, expression, String.valueOf(sepChar));
    }

    @Override
    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        return super.invokeOnComponent(context, clientId, callback);
    }

    @Override
    public Map<String, UIComponent> getFacets() {
        if (this.facets == null) {
            this.facets = new FacetsMap(this);
        }
        return this.facets;
    }

    @Override
    public int getFacetCount() {
        if (this.facets != null) {
            return this.facets.size();
        }
        return 0;
    }

    @Override
    public UIComponent getFacet(String name) {
        if (this.facets != null) {
            return this.facets.get(name);
        }
        return null;
    }

    @Override
    public Iterator<UIComponent> getFacetsAndChildren() {
        int childCount = this.getChildCount();
        int facetCount = this.getFacetCount();
        if (childCount == 0 && facetCount == 0) {
            return EMPTY_ITERATOR;
        }
        if (childCount == 0) {
            return Collections.unmodifiableCollection(this.getFacets().values()).iterator();
        }
        if (facetCount == 0) {
            return Collections.unmodifiableList(this.getChildren()).iterator();
        }
        return new FacetsAndChildrenIterator(this);
    }

    @Override
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event == null) {
            throw new NullPointerException();
        }
        if (event instanceof BehaviorEvent) {
            BehaviorEvent behaviorEvent = (BehaviorEvent)event;
            Behavior behavior = behaviorEvent.getBehavior();
            behavior.broadcast(behaviorEvent);
        }
        if (this.listeners == null) {
            return;
        }
        for (FacesListener listener : this.listeners.asArray(FacesListener.class)) {
            if (!event.isAppropriateListener(listener)) continue;
            event.processListener(listener);
        }
    }

    @Override
    public void decode(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            Renderer renderer = this.getRenderer(context);
            if (renderer != null) {
                renderer.decode(context, this);
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Can't get Renderer for type " + rendererType);
            }
        }
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        this.pushComponentToEL(context, null);
        if (!this.isRendered()) {
            return;
        }
        context.getApplication().publishEvent(context, PreRenderComponentEvent.class, this);
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            Renderer renderer = this.getRenderer(context);
            if (renderer != null) {
                renderer.encodeBegin(context, this);
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Can't get Renderer for type " + rendererType);
            }
        }
    }

    @Override
    public void encodeChildren(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        if (this.getRendererType() != null) {
            Renderer renderer = this.getRenderer(context);
            if (renderer != null) {
                renderer.encodeChildren(context, this);
            }
        } else if (this.getChildCount() > 0) {
            for (UIComponent child : this.getChildren()) {
                child.encodeAll(context);
            }
        }
    }

    @Override
    public void encodeEnd(FacesContext context) throws IOException {
        Renderer renderer;
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            this.popComponentFromEL(context);
            return;
        }
        if (this.getRendererType() != null && (renderer = this.getRenderer(context)) != null) {
            renderer.encodeEnd(context, this);
        }
        this.popComponentFromEL(context);
    }

    @Override
    protected void addFacesListener(FacesListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            this.listeners = new AttachedObjectListHolder();
        }
        this.listeners.add(listener);
    }

    @Override
    protected FacesListener[] getFacesListeners(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (!FacesListener.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException();
        }
        if (this.listeners == null) {
            return (FacesListener[])Array.newInstance(clazz, 0);
        }
        FacesListener[] listeners = this.listeners.asArray(FacesListener.class);
        if (listeners.length == 0) {
            return (FacesListener[])Array.newInstance(clazz, 0);
        }
        ArrayList<FacesListener> results = new ArrayList<FacesListener>(listeners.length);
        for (FacesListener listener : listeners) {
            if (!clazz.isAssignableFrom(listener.getClass())) continue;
            results.add(listener);
        }
        return results.toArray((FacesListener[])Array.newInstance(clazz, results.size()));
    }

    @Override
    protected void removeFacesListener(FacesListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void queueEvent(FacesEvent event) {
        if (event == null) {
            throw new NullPointerException();
        }
        UIComponent parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException();
        }
        parent.queueEvent(event);
    }

    @Override
    public void subscribeToEvent(Class<? extends SystemEvent> eventClass, ComponentSystemEventListener componentListener) {
        if (Util.isAnyNull((Object[])new Object[]{eventClass, componentListener})) {
            throw new NullPointerException();
        }
        if (this.initialStateMarked()) {
            this.initialState = false;
        }
        if (this.listenersByEventClass == null) {
            this.listenersByEventClass = new HashMap<Class<? extends SystemEvent>, List<SystemEventListener>>(3, 1.0f);
        }
        UIComponent.ComponentSystemEventListenerAdapter facesLifecycleListener = new UIComponent.ComponentSystemEventListenerAdapter(componentListener, this);
        List<SystemEventListener> listenersForEventClass = this.listenersByEventClass.get(eventClass);
        if (listenersForEventClass == null) {
            listenersForEventClass = new ArrayList<SystemEventListener>(3);
            this.listenersByEventClass.put(eventClass, listenersForEventClass);
        }
        if (!listenersForEventClass.contains(facesLifecycleListener)) {
            listenersForEventClass.add(facesLifecycleListener);
        }
    }

    @Override
    public void unsubscribeFromEvent(Class<? extends SystemEvent> eventClass, ComponentSystemEventListener componentListener) {
        if (Util.isAnyNull((Object[])new Object[]{eventClass, componentListener})) {
            throw new NullPointerException();
        }
        List<SystemEventListener> listeners = this.getListenersForEventClass(eventClass);
        if (!Util.isEmpty(listeners)) {
            Iterator<SystemEventListener> i = listeners.iterator();
            while (i.hasNext()) {
                ComponentSystemEventListener existingListener = ((UIComponent.ComponentSystemEventListenerAdapter)i.next()).getWrapped();
                if (!existingListener.equals(componentListener)) continue;
                i.remove();
                break;
            }
        }
    }

    @Override
    public List<SystemEventListener> getListenersForEventClass(Class<? extends SystemEvent> eventClass) {
        if (eventClass == null) {
            throw new NullPointerException();
        }
        if (this.listenersByEventClass != null) {
            return this.listenersByEventClass.getOrDefault(eventClass, Collections.emptyList());
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, null);
        try {
            Iterator<UIComponent> kids = this.getFacetsAndChildren();
            while (kids.hasNext()) {
                UIComponent kid = kids.next();
                kid.processDecodes(context);
            }
            try {
                this.decode(context);
            }
            catch (RuntimeException e) {
                context.renderResponse();
                throw e;
            }
        }
        finally {
            this.popComponentFromEL(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, null);
        try {
            Application application = context.getApplication();
            application.publishEvent(context, PreValidateEvent.class, this);
            Iterator<UIComponent> kids = this.getFacetsAndChildren();
            while (kids.hasNext()) {
                UIComponent kid = kids.next();
                kid.processValidators(context);
            }
            application.publishEvent(context, PostValidateEvent.class, this);
        }
        finally {
            this.popComponentFromEL(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, null);
        try {
            Iterator<UIComponent> kids = this.getFacetsAndChildren();
            while (kids.hasNext()) {
                UIComponent kid = kids.next();
                kid.processUpdates(context);
            }
        }
        finally {
            this.popComponentFromEL(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object processSaveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.isTransient()) {
            return null;
        }
        Object[] stateStruct = new Object[2];
        Object[] childState = EMPTY_ARRAY;
        this.pushComponentToEL(context, null);
        try {
            stateStruct[0] = this.saveState(context);
            int count = this.getChildCount() + this.getFacetCount();
            if (count > 0) {
                ArrayList<Object> stateList = new ArrayList<Object>(count);
                this.collectChildState(context, stateList);
                this.collectFacetsState(context, stateList);
                childState = stateList.toArray();
            }
        }
        finally {
            this.popComponentFromEL(context);
        }
        stateStruct[1] = childState;
        return stateStruct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRestoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.pushComponentToEL(context, null);
        try {
            Object[] stateStruct = (Object[])state;
            Object[] childState = (Object[])stateStruct[1];
            this.restoreState(context, stateStruct[0]);
            int i = this.restoreChildState(context, childState);
            this.restoreFacetsState(context, childState, i);
        }
        finally {
            this.popComponentFromEL(context);
        }
    }

    @Override
    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    @Override
    protected Renderer getRenderer(FacesContext context) {
        Renderer renderer = null;
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            renderer = context.getRenderKit().getRenderer(this.getFamily(), rendererType);
            if (renderer == null && LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Can't get Renderer for type " + rendererType);
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            String id = this.getId();
            LOGGER.fine("No renderer-type for component " + id != null ? id : this.getClass().getName());
        }
        return renderer;
    }

    @Override
    public void markInitialState() {
        super.markInitialState();
        if (this.listeners != null) {
            this.listeners.markInitialState();
        }
        if (this.listenersByEventClass != null) {
            for (List list : this.listenersByEventClass.values()) {
                if (!(list instanceof PartialStateHolder)) continue;
                ((PartialStateHolder)((Object)list)).markInitialState();
            }
        }
        if (this.behaviors != null) {
            for (Map.Entry entry : this.behaviors.entrySet()) {
                for (ClientBehavior behavior : (List)entry.getValue()) {
                    if (!(behavior instanceof PartialStateHolder)) continue;
                    ((PartialStateHolder)((Object)behavior)).markInitialState();
                }
            }
        }
    }

    @Override
    public void clearInitialState() {
        super.clearInitialState();
        if (this.listeners != null) {
            this.listeners.clearInitialState();
        }
        if (this.listenersByEventClass != null) {
            for (List list : this.listenersByEventClass.values()) {
                if (!(list instanceof PartialStateHolder)) continue;
                ((PartialStateHolder)((Object)list)).clearInitialState();
            }
        }
        if (this.behaviors != null) {
            for (Map.Entry entry : this.behaviors.entrySet()) {
                for (ClientBehavior behavior : (List)entry.getValue()) {
                    if (!(behavior instanceof PartialStateHolder)) continue;
                    ((PartialStateHolder)((Object)behavior)).clearInitialState();
                }
            }
        }
    }

    @Override
    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object[] values = null;
        if (this.initialStateMarked()) {
            Object savedFacesListeners = this.listeners != null ? this.listeners.saveState(context) : null;
            Object savedSysEventListeners = this.saveSystemEventListeners(context);
            Object savedBehaviors = this.saveBehaviorsState(context);
            Object savedBindings = null;
            if (this.bindings != null) {
                savedBindings = this.saveBindingsState(context);
            }
            Object savedHelper = null;
            if (this.stateHelper != null) {
                savedHelper = this.stateHelper.saveState(context);
            }
            if (Util.isAllNull((Object[])new Object[]{savedFacesListeners, savedSysEventListeners, savedBehaviors, savedBindings, savedHelper})) {
                return null;
            }
            if (values == null || values.length != 5) {
                values = new Object[]{savedFacesListeners, savedSysEventListeners, savedBehaviors, savedBindings, savedHelper};
            }
            return values;
        }
        if (values == null || values.length != 6) {
            values = new Object[6];
        }
        values[0] = this.listeners != null ? this.listeners.saveState(context) : null;
        values[1] = this.saveSystemEventListeners(context);
        values[2] = this.saveBehaviorsState(context);
        if (this.bindings != null) {
            values[3] = this.saveBindingsState(context);
        }
        if (this.stateHelper != null) {
            values[4] = this.stateHelper.saveState(context);
        }
        values[5] = this.id;
        return values;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            return;
        }
        Object[] values = (Object[])state;
        if (values[0] != null) {
            if (this.listeners == null) {
                this.listeners = new AttachedObjectListHolder();
            }
            this.listeners.restoreState(context, values[0]);
        }
        if (values[1] != null) {
            Map<Class<? extends SystemEvent>, List<SystemEventListener>> restoredListeners = this.restoreSystemEventListeners(context, values[1]);
            if (this.listenersByEventClass != null) {
                this.listenersByEventClass.putAll(restoredListeners);
            } else {
                this.listenersByEventClass = restoredListeners;
            }
        }
        if (values[2] != null) {
            this.behaviors = this.restoreBehaviorsState(context, values[2]);
        }
        if (values[3] != null) {
            this.bindings = UIComponentBase.restoreBindingsState(context, values[3]);
        }
        if (values[4] != null) {
            this.getStateHelper().restoreState(context, values[4]);
        }
        if (values.length == 6 && values[5] != null) {
            this.id = (String)values[5];
        }
    }

    @Override
    public boolean isTransient() {
        return this.transientFlag;
    }

    @Override
    public void setTransient(boolean transientFlag) {
        this.transientFlag = transientFlag;
    }

    public static Object saveAttachedState(FacesContext context, Object attachedObject) {
        Serializable result;
        if (context == null) {
            throw new NullPointerException();
        }
        if (attachedObject == null) {
            return null;
        }
        Class<?> mapOrCollectionClass = attachedObject.getClass();
        boolean newWillSucceed = true;
        try {
            int modifiers = mapOrCollectionClass.getModifiers();
            newWillSucceed = Modifier.isPublic(modifiers);
            if (newWillSucceed) {
                newWillSucceed = null != mapOrCollectionClass.getConstructor(new Class[0]);
            }
        }
        catch (Exception e) {
            newWillSucceed = false;
        }
        if (newWillSucceed && attachedObject instanceof Collection) {
            Collection attachedCollection = (Collection)attachedObject;
            ArrayList<StateHolderSaver> resultList = new ArrayList<StateHolderSaver>(attachedCollection.size() + 1);
            resultList.add(new StateHolderSaver(context, mapOrCollectionClass));
            for (Object item : attachedCollection) {
                if (item == null || item instanceof StateHolder && ((StateHolder)item).isTransient()) continue;
                resultList.add(new StateHolderSaver(context, item));
            }
            result = resultList;
        } else if (newWillSucceed && attachedObject instanceof Map) {
            Map attachedMap = (Map)attachedObject;
            ArrayList<StateHolderSaver> resultList = new ArrayList<StateHolderSaver>(attachedMap.size() * 2 + 1);
            resultList.add(new StateHolderSaver(context, mapOrCollectionClass));
            for (Map.Entry entry : attachedMap.entrySet()) {
                Object value;
                Object key = entry.getKey();
                if (key instanceof StateHolder && ((StateHolder)key).isTransient() || (value = entry.getValue()) instanceof StateHolder && ((StateHolder)value).isTransient()) continue;
                resultList.add(new StateHolderSaver(context, key));
                resultList.add(new StateHolderSaver(context, value));
            }
            result = resultList;
        } else {
            result = new StateHolderSaver(context, attachedObject);
        }
        return result;
    }

    public static Object restoreAttachedState(FacesContext context, Object stateObj) throws IllegalStateException {
        Object result;
        if (null == context) {
            throw new NullPointerException();
        }
        if (null == stateObj) {
            return null;
        }
        if (stateObj instanceof List) {
            List stateList = (List)stateObj;
            StateHolderSaver collectionSaver = (StateHolderSaver)stateList.get(0);
            Class mapOrCollection = (Class)collectionSaver.restore(context);
            if (Collection.class.isAssignableFrom(mapOrCollection)) {
                Collection retCollection = null;
                try {
                    retCollection = (Collection)mapOrCollection.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, e.toString(), e);
                    }
                    throw new IllegalStateException("Unknown object type");
                }
                int len = stateList.size();
                for (int i = 1; i < len; ++i) {
                    try {
                        retCollection.add(((StateHolderSaver)stateList.get(i)).restore(context));
                        continue;
                    }
                    catch (ClassCastException cce) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, cce.toString(), cce);
                        }
                        throw new IllegalStateException("Unknown object type");
                    }
                }
                result = retCollection;
            } else {
                Map retMap = null;
                try {
                    retMap = (Map)mapOrCollection.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, e.toString(), e);
                    }
                    throw new IllegalStateException("Unknown object type");
                }
                int len = stateList.size();
                for (int i = 1; i < len; i += 2) {
                    try {
                        retMap.put(((StateHolderSaver)stateList.get(i)).restore(context), ((StateHolderSaver)stateList.get(i + 1)).restore(context));
                        continue;
                    }
                    catch (ClassCastException cce) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, cce.toString(), cce);
                        }
                        throw new IllegalStateException("Unknown object type");
                    }
                }
                result = retMap;
            }
        } else if (stateObj instanceof StateHolderSaver) {
            StateHolderSaver saver = (StateHolderSaver)stateObj;
            result = saver.restore(context);
        } else {
            throw new IllegalStateException("Unknown object type");
        }
        return result;
    }

    private static Map<String, ValueExpression> restoreBindingsState(FacesContext context, Object state) {
        if (state == null) {
            return null;
        }
        Object[] values = (Object[])state;
        String[] names = (String[])values[0];
        Object[] states = (Object[])values[1];
        HashMap<String, ValueExpression> bindings = new HashMap<String, ValueExpression>(names.length);
        for (int i = 0; i < names.length; ++i) {
            bindings.put(names[i], (ValueExpression)UIComponentBase.restoreAttachedState(context, states[i]));
        }
        return bindings;
    }

    private Object saveBindingsState(FacesContext context) {
        if (this.bindings == null) {
            return null;
        }
        Object[] values = new Object[2];
        values[0] = this.bindings.keySet().toArray(new String[this.bindings.size()]);
        Object[] bindingValues = this.bindings.values().toArray();
        for (int i = 0; i < bindingValues.length; ++i) {
            bindingValues[i] = UIComponentBase.saveAttachedState(context, bindingValues[i]);
        }
        values[1] = bindingValues;
        return values;
    }

    private Object saveSystemEventListeners(FacesContext ctx) {
        if (this.listenersByEventClass == null) {
            return null;
        }
        int size = this.listenersByEventClass.size();
        Object[][] listeners = new Object[size][2];
        int idx = 0;
        boolean savedState = false;
        for (Map.Entry<Class<? extends SystemEvent>, List<SystemEventListener>> e : this.listenersByEventClass.entrySet()) {
            Object[] target = listeners[idx++];
            target[0] = e.getKey();
            target[1] = UIComponentBase.saveAttachedState(ctx, e.getValue());
            if (target[1] == null) {
                target[0] = null;
                continue;
            }
            savedState = true;
        }
        return savedState ? listeners : null;
    }

    private Map<Class<? extends SystemEvent>, List<SystemEventListener>> restoreSystemEventListeners(FacesContext ctx, Object state) {
        if (state == null) {
            return null;
        }
        Object[][] listeners = (Object[][])state;
        HashMap<Class<? extends SystemEvent>, List<SystemEventListener>> m = new HashMap<Class<? extends SystemEvent>, List<SystemEventListener>>(listeners.length, 1.0f);
        for (Object[] source : listeners) {
            m.put((Class)source[0], (List)UIComponentBase.restoreAttachedState(ctx, source[1]));
        }
        return m;
    }

    Map<String, PropertyDescriptor> getDescriptorMap() {
        return this.propertyDescriptorMap;
    }

    private void doPostAddProcessing(FacesContext context, UIComponent added) {
        if (this.parent.isInView()) {
            UIComponentBase.publishAfterViewEvents(context, context.getApplication(), added);
        }
    }

    private void doPreRemoveProcessing(FacesContext context, UIComponent toRemove) {
        if (this.parent.isInView()) {
            UIComponentBase.disconnectFromView(context, context.getApplication(), toRemove);
        }
    }

    public void addClientBehavior(String eventName, ClientBehavior behavior) {
        this.assertClientBehaviorHolder();
        Collection<String> eventNames = this.getEventNames();
        if (eventNames == null) {
            throw new IllegalStateException("Attempting to add a Behavior to a component that does not support any event types. getEventTypes() must return a non-null Set.");
        }
        if (eventNames.contains(eventName)) {
            ArrayList<ClientBehavior> eventBehaviours;
            if (this.initialStateMarked() && this.behaviors != null) {
                for (Map.Entry<String, List<ClientBehavior>> entry : this.behaviors.entrySet()) {
                    for (ClientBehavior b : entry.getValue()) {
                        if (!(b instanceof PartialStateHolder)) continue;
                        ((PartialStateHolder)((Object)behavior)).clearInitialState();
                    }
                }
            }
            if (null == this.behaviors) {
                HashMap<String, List<ClientBehavior>> modifiableMap = new HashMap<String, List<ClientBehavior>>(5, 1.0f);
                this.behaviors = new BehaviorsMap(modifiableMap);
            }
            if (null == (eventBehaviours = (ArrayList<ClientBehavior>)this.behaviors.get(eventName))) {
                eventBehaviours = new ArrayList<ClientBehavior>(3);
                this.behaviors.getModifiableMap().put(eventName, eventBehaviours);
            }
            eventBehaviours.add(behavior);
        }
    }

    public Collection<String> getEventNames() {
        this.assertClientBehaviorHolder();
        return null;
    }

    public Map<String, List<ClientBehavior>> getClientBehaviors() {
        if (null == this.behaviors) {
            return Collections.emptyMap();
        }
        return this.behaviors;
    }

    public String getDefaultEventName() {
        this.assertClientBehaviorHolder();
        return null;
    }

    private void assertClientBehaviorHolder() {
        if (!this.isClientBehaviorHolder()) {
            throw new IllegalStateException("Attempting to use a Behavior feature with a component that does not support any event types. Component must implement BehaviourHolder interface.");
        }
    }

    private boolean isClientBehaviorHolder() {
        return ClientBehaviorHolder.class.isInstance(this);
    }

    private Object saveBehaviorsState(FacesContext context) {
        Object[] state = null;
        if (null != this.behaviors && this.behaviors.size() > 0) {
            boolean stateWritten = false;
            Object[] attachedBehaviors = new Object[this.behaviors.size()];
            int i = 0;
            for (List eventBehaviors : this.behaviors.values()) {
                Object[] attachedEventBehaviors = new Object[eventBehaviors.size()];
                for (int j = 0; j < attachedEventBehaviors.length; ++j) {
                    Object object = attachedEventBehaviors[j] = this.initialStateMarked() ? this.saveBehavior(context, (ClientBehavior)eventBehaviors.get(j)) : UIComponentBase.saveAttachedState(context, eventBehaviors.get(j));
                    if (stateWritten) continue;
                    stateWritten = attachedEventBehaviors[j] != null;
                }
                attachedBehaviors[i++] = attachedEventBehaviors;
            }
            if (stateWritten) {
                state = new Object[]{this.behaviors.keySet().toArray(new String[this.behaviors.size()]), attachedBehaviors};
            }
        }
        return state;
    }

    private BehaviorsMap restoreBehaviorsState(FacesContext context, Object state) {
        if (null != state) {
            Object[] values = (Object[])state;
            String[] names = (String[])values[0];
            Object[] attachedBehaviors = (Object[])values[1];
            if (!this.initialStateMarked()) {
                HashMap<String, List<ClientBehavior>> modifiableMap = new HashMap<String, List<ClientBehavior>>(names.length, 1.0f);
                for (int i = 0; i < attachedBehaviors.length; ++i) {
                    Object[] attachedEventBehaviors = (Object[])attachedBehaviors[i];
                    ArrayList<ClientBehavior> eventBehaviors = new ArrayList<ClientBehavior>(attachedBehaviors.length);
                    for (int j = 0; j < attachedEventBehaviors.length; ++j) {
                        eventBehaviors.add((ClientBehavior)UIComponentBase.restoreAttachedState(context, attachedEventBehaviors[j]));
                    }
                    modifiableMap.put(names[i], eventBehaviors);
                }
                return new BehaviorsMap(modifiableMap);
            }
            int len = names.length;
            for (int i = 0; i < len; ++i) {
                if (this.behaviors == null) continue;
                List existingBehaviors = (List)this.behaviors.get(names[i]);
                this.restoreBehaviors(context, existingBehaviors, (Object[])attachedBehaviors[i]);
            }
            return this.behaviors;
        }
        return null;
    }

    private Object saveBehavior(FacesContext ctx, ClientBehavior behavior) {
        return behavior instanceof StateHolder ? ((StateHolder)((Object)behavior)).saveState(ctx) : null;
    }

    private void restoreBehaviors(FacesContext ctx, List<ClientBehavior> existingBehaviors, Object[] state) {
        int len = state.length;
        for (int i = 0; i < len; ++i) {
            ClientBehavior behavior = existingBehaviors.get(i);
            if (state[i] == null || !(behavior instanceof StateHolder)) continue;
            if (state[i] instanceof StateHolderSaver) {
                ((StateHolderSaver)state[i]).restore(ctx);
                continue;
            }
            ((StateHolder)((Object)behavior)).restoreState(ctx, state[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void publishAfterViewEvents(FacesContext context, Application application, UIComponent component) {
        component.setInView(true);
        try {
            ArrayList<UIComponent> clist;
            component.pushComponentToEL(context, component);
            application.publishEvent(context, PostAddToViewEvent.class, component);
            if (component.getChildCount() > 0) {
                clist = new ArrayList<UIComponent>(component.getChildren());
                for (UIComponent c : clist) {
                    UIComponentBase.publishAfterViewEvents(context, application, c);
                }
            }
            if (component.getFacetCount() > 0) {
                clist = new ArrayList<UIComponent>(component.getFacets().values());
                for (UIComponent c : clist) {
                    UIComponentBase.publishAfterViewEvents(context, application, c);
                }
            }
        }
        finally {
            component.popComponentFromEL(context);
        }
    }

    private static void disconnectFromView(FacesContext context, Application application, UIComponent component) {
        application.publishEvent(context, PreRemoveFromViewEvent.class, component);
        component.setInView(false);
        component.compositeParent = null;
        if (component.getChildCount() > 0) {
            List<UIComponent> children = component.getChildren();
            for (UIComponent c : children) {
                UIComponentBase.disconnectFromView(context, application, c);
            }
        }
        if (component.getFacetCount() > 0) {
            Map<String, UIComponent> facets = component.getFacets();
            for (UIComponent c : facets.values()) {
                UIComponentBase.disconnectFromView(context, application, c);
            }
        }
    }

    private void populateDescriptorsMapIfNecessary() {
        PropertyDescriptor[] propertyDescriptors;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Class<?> clazz = this.getClass();
        if (facesContext != null && facesContext.getExternalContext() != null && facesContext.getExternalContext().getApplicationMap() != null) {
            Map<String, Object> applicationMap = facesContext.getExternalContext().getApplicationMap();
            if (!applicationMap.containsKey("com.sun.faces.compnent.COMPONENT_DESCRIPTORS_MAP")) {
                applicationMap.put("com.sun.faces.compnent.COMPONENT_DESCRIPTORS_MAP", new ConcurrentHashMap());
            }
            this.descriptors = (Map)applicationMap.get("com.sun.faces.compnent.COMPONENT_DESCRIPTORS_MAP");
            this.propertyDescriptorMap = this.descriptors.get(clazz);
        }
        if (this.propertyDescriptorMap == null && (propertyDescriptors = this.getPropertyDescriptors()) != null) {
            this.propertyDescriptorMap = new HashMap<String, PropertyDescriptor>(propertyDescriptors.length, 1.0f);
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                this.propertyDescriptorMap.put(propertyDescriptor.getName(), propertyDescriptor);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "fine.component.populating_descriptor_map", new Object[]{clazz, Thread.currentThread().getName()});
            }
            if (this.descriptors != null && !this.descriptors.containsKey(clazz)) {
                this.descriptors.put(clazz, this.propertyDescriptorMap);
            }
        }
    }

    private PropertyDescriptor[] getPropertyDescriptors() {
        try {
            return Introspector.getBeanInfo(this.getClass()).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new FacesException(e);
        }
    }

    private String addParentId(FacesContext context, String parentId, String childId) {
        return new StringBuilder(parentId.length() + 1 + childId.length()).append(parentId).append(UINamingContainer.getSeparatorChar(context)).append(childId).toString();
    }

    private String getParentId(FacesContext context, UIComponent parent) {
        if (parent == null) {
            return null;
        }
        return parent.getContainerClientId(context);
    }

    private String generateId(FacesContext context, UIComponent namingContainerAncestor) {
        if (namingContainerAncestor instanceof UniqueIdVendor) {
            return ((UniqueIdVendor)((Object)namingContainerAncestor)).createUniqueId(context, null);
        }
        return context.getViewRoot().createUniqueId();
    }

    private UIComponent getNamingContainerAncestor() {
        for (UIComponent namingContainer = this.getParent(); namingContainer != null; namingContainer = namingContainer.getParent()) {
            if (!(namingContainer instanceof NamingContainer)) continue;
            return namingContainer;
        }
        return null;
    }

    private static void eraseParent(UIComponent component) {
        List<UIComponent> children;
        int index;
        UIComponent parent = component.getParent();
        if (parent == null) {
            return;
        }
        if (parent.getChildCount() > 0 && (index = (children = parent.getChildren()).indexOf(component)) >= 0) {
            children.remove(index);
            return;
        }
        if (parent.getFacetCount() > 0) {
            Map<String, UIComponent> facets = parent.getFacets();
            Iterator<Map.Entry<String, UIComponent>> entries = facets.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<String, UIComponent> entry = entries.next();
                if (entry.getValue() != component) continue;
                entries.remove();
                return;
            }
        }
        throw new IllegalStateException("Parent was not null, but this component not related");
    }

    private static void validateId(String id) {
        if (id == null) {
            return;
        }
        int idLength = id.length();
        if (idLength < 1) {
            throw new IllegalArgumentException("Empty id attribute is not allowed");
        }
        for (int i = 0; i < idLength; ++i) {
            char c = id.charAt(i);
            if (!(i == 0 ? !Character.isLetter(c) && c != '_' : !Character.isLetter(c) && !Character.isDigit(c) && c != '-' && c != '_')) continue;
            throw new IllegalArgumentException(id);
        }
    }

    private UIComponent findBaseComponent(String expression, char sepChar) {
        UIComponent base = this;
        if (expression.charAt(0) == sepChar) {
            while (base.getParent() != null) {
                base = base.getParent();
            }
            expression = expression.substring(1);
        } else if (!(base instanceof NamingContainer)) {
            while (base.getParent() != null && !(base instanceof NamingContainer)) {
                base = base.getParent();
            }
        }
        return base;
    }

    private UIComponent evaluateSearchExpression(UIComponent base, String expression, String SEPARATOR_STRING) {
        UIComponent result = null;
        String[] segments = expression.split(SEPARATOR_STRING);
        int i = 0;
        int length = segments.length - 1;
        while (i < segments.length) {
            result = UIComponentBase.findComponent(base, segments[i], i == 0);
            if (i == 0 && result == null && segments[i].equals(base.getId())) {
                result = base;
            }
            if (result != null && !(result instanceof NamingContainer) && length > 0) {
                throw new IllegalArgumentException(segments[i]);
            }
            if (result == null) break;
            base = result;
            ++i;
            --length;
        }
        return result;
    }

    private static UIComponent findComponent(UIComponent base, String id, boolean checkId) {
        if (checkId && id.equals(base.getId())) {
            return base;
        }
        UIComponent component = null;
        Iterator<UIComponent> i = base.getFacetsAndChildren();
        while (i.hasNext()) {
            UIComponent kid = i.next();
            if (!(kid instanceof NamingContainer)) {
                if (checkId && id.equals(kid.getId())) {
                    component = kid;
                    break;
                }
                component = UIComponentBase.findComponent(kid, id, true);
                if (component == null) continue;
                break;
            }
            if (!id.equals(kid.getId())) continue;
            component = kid;
            break;
        }
        return component;
    }

    private List<Object> collectChildState(FacesContext context, List<Object> stateList) {
        if (this.getChildCount() > 0) {
            for (UIComponent kid : this.getChildren()) {
                if (kid.isTransient()) continue;
                stateList.add(kid.processSaveState(context));
            }
        }
        return stateList;
    }

    private List<Object> collectFacetsState(FacesContext context, List<Object> stateList) {
        if (this.getFacetCount() > 0) {
            for (Map.Entry<String, UIComponent> entry : this.getFacets().entrySet()) {
                UIComponent facet = entry.getValue();
                if (facet.isTransient()) continue;
                Object facetState = facet.processSaveState(context);
                Object[] facetSaveState = new Object[]{entry.getKey(), facetState};
                stateList.add(facetSaveState);
            }
        }
        return stateList;
    }

    private int restoreChildState(FacesContext context, Object[] childState) {
        int i = 0;
        if (this.getChildCount() > 0) {
            for (UIComponent kid : this.getChildren()) {
                Object currentState;
                if (kid.isTransient() || i >= childState.length || (currentState = childState[i++]) == null) continue;
                kid.processRestoreState(context, currentState);
            }
        }
        return i;
    }

    private void restoreFacetsState(FacesContext context, Object[] childState, int i) {
        if (this.getFacetCount() > 0) {
            int facetsSize = this.getFacets().size();
            for (int j = 0; j < facetsSize && i < childState.length; ++j) {
                Object[] facetSaveState;
                if ((facetSaveState = (Object[])childState[i++]) == null) continue;
                String facetName = (String)facetSaveState[0];
                Object facetState = facetSaveState[1];
                UIComponent facet = this.getFacets().get(facetName);
                facet.processRestoreState(context, facetState);
            }
        }
    }

    private static class PassThroughAttributesMap<K, V>
    extends ConcurrentHashMap<String, Object>
    implements Serializable {
        private static final long serialVersionUID = 4230540513272170861L;

        private PassThroughAttributesMap() {
        }

        @Override
        public Object put(String key, Object value) {
            if (null == key || null == value) {
                throw new NullPointerException();
            }
            this.validateKey(key);
            return super.put(key, value);
        }

        @Override
        public Object putIfAbsent(String key, Object value) {
            if (null == key || null == value) {
                throw new NullPointerException();
            }
            this.validateKey(key);
            return super.putIfAbsent(key, value);
        }

        private void validateKey(Object key) {
            if (!(key instanceof String) || key instanceof ValueExpression || !(key instanceof Serializable)) {
                throw new IllegalArgumentException();
            }
        }
    }

    private static class BehaviorsMap
    extends AbstractMap<String, List<ClientBehavior>> {
        private Map<String, List<ClientBehavior>> unmodifiableMap;
        private Map<String, List<ClientBehavior>> modifiableMap;

        private BehaviorsMap(Map<String, List<ClientBehavior>> modifiableMap) {
            this.modifiableMap = modifiableMap;
            this.unmodifiableMap = Collections.unmodifiableMap(modifiableMap);
        }

        @Override
        public Set<Map.Entry<String, List<ClientBehavior>>> entrySet() {
            return this.unmodifiableMap.entrySet();
        }

        private Map<String, List<ClientBehavior>> getModifiableMap() {
            return this.modifiableMap;
        }
    }

    private static class FacetsMapValuesIterator
    implements Iterator<UIComponent> {
        private FacetsMap map = null;
        private Iterator<String> iterator = null;
        private Object last = null;

        public FacetsMapValuesIterator(FacetsMap map) {
            this.map = map;
            this.iterator = map.keySetIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public UIComponent next() {
            this.last = this.iterator.next();
            return (UIComponent)this.map.get(this.last);
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.map.remove(this.last);
            this.last = null;
        }
    }

    private static class FacetsMapValues
    extends AbstractCollection<UIComponent> {
        private FacetsMap map;

        public FacetsMapValues(FacetsMap map) {
            this.map = map;
        }

        @Override
        public boolean add(UIComponent o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Iterator<UIComponent> iterator() {
            return new FacetsMapValuesIterator(this.map);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    private static class FacetsMapKeySetIterator
    implements Iterator<String> {
        private FacetsMap map = null;
        private Iterator<String> iterator = null;
        private String last = null;

        public FacetsMapKeySetIterator(FacetsMap map) {
            this.map = map;
            this.iterator = map.keySetIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            this.last = this.iterator.next();
            return this.last;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.map.remove(this.last);
            this.last = null;
        }
    }

    private static class FacetsMapKeySet
    extends AbstractSet<String> {
        private FacetsMap map = null;

        public FacetsMapKeySet(FacetsMap map) {
            this.map = map;
        }

        @Override
        public boolean add(String o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends String> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            for (Object item : c) {
                if (this.map.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Iterator<String> iterator() {
            return new FacetsMapKeySetIterator(this.map);
        }

        @Override
        public boolean remove(Object o) {
            if (this.map.containsKey(o)) {
                this.map.remove(o);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection c) {
            boolean result = false;
            for (Object item : c) {
                if (!this.map.containsKey(item)) continue;
                this.map.remove(item);
                result = true;
            }
            return result;
        }

        @Override
        public boolean retainAll(Collection c) {
            boolean result = false;
            Iterator<String> v = this.iterator();
            while (v.hasNext()) {
                if (c.contains(v.next())) continue;
                v.remove();
                result = true;
            }
            return result;
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    private static class FacetsMapEntrySetIterator
    implements Iterator<Map.Entry<String, UIComponent>> {
        private FacetsMap map = null;
        private Iterator<String> iterator = null;
        private Map.Entry<String, UIComponent> last = null;

        public FacetsMapEntrySetIterator(FacetsMap map) {
            this.map = map;
            this.iterator = map.keySetIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<String, UIComponent> next() {
            this.last = new FacetsMapEntrySetEntry(this.map, this.iterator.next());
            return this.last;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.map.remove(this.last.getKey());
            this.last = null;
        }
    }

    private static class FacetsMapEntrySetEntry
    implements Map.Entry<String, UIComponent> {
        private FacetsMap map;
        private String key;

        public FacetsMapEntrySetEntry(FacetsMap map, String key) {
            this.map = map;
            this.key = key;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (this.key == null ? e.getKey() != null : !this.key.equals(e.getKey())) {
                return false;
            }
            UIComponent v = (UIComponent)this.map.get(this.key);
            return !(v == null ? e.getValue() != null : !v.equals(e.getValue()));
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public UIComponent getValue() {
            return (UIComponent)this.map.get(this.key);
        }

        @Override
        public int hashCode() {
            Object value = this.map.get(this.key);
            return (this.key == null ? 0 : this.key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        @Override
        public UIComponent setValue(UIComponent value) {
            UIComponent previous = (UIComponent)this.map.get(this.key);
            this.map.put(this.key, value);
            return previous;
        }
    }

    private static class FacetsMapEntrySet
    extends AbstractSet<Map.Entry<String, UIComponent>> {
        private FacetsMap map = null;

        public FacetsMapEntrySet(FacetsMap map) {
            this.map = map;
        }

        @Override
        public boolean add(Map.Entry<String, UIComponent> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<String, UIComponent>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object v = e.getValue();
            if (!this.map.containsKey(k)) {
                return false;
            }
            if (v == null) {
                return this.map.get(k) == null;
            }
            return v.equals(this.map.get(k));
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<String, UIComponent>> iterator() {
            return new FacetsMapEntrySetIterator(this.map);
        }

        @Override
        public boolean remove(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Object k = ((Map.Entry)o).getKey();
            if (this.map.containsKey(k)) {
                this.map.remove(k);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection c) {
            boolean result = false;
            for (Object element : c) {
                if (!this.remove(element)) continue;
                result = true;
            }
            return result;
        }

        @Override
        public boolean retainAll(Collection c) {
            boolean result = false;
            Iterator<Map.Entry<String, UIComponent>> v = this.iterator();
            while (v.hasNext()) {
                if (c.contains(v.next())) continue;
                v.remove();
                result = true;
            }
            return result;
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    private static class FacetsMap
    extends HashMap<String, UIComponent> {
        private static final long serialVersionUID = -1444791615672259097L;
        private UIComponent component;
        private FacesContext context;

        public FacetsMap(UIComponent component) {
            super(3, 1.0f);
            this.component = component;
            this.context = component.getFacesContext();
        }

        @Override
        public void clear() {
            Iterator<String> keys = this.keySet().iterator();
            while (keys.hasNext()) {
                keys.next();
                keys.remove();
            }
            super.clear();
        }

        @Override
        public Set<Map.Entry<String, UIComponent>> entrySet() {
            return new FacetsMapEntrySet(this);
        }

        @Override
        public Set<String> keySet() {
            return new FacetsMapKeySet(this);
        }

        @Override
        public UIComponent put(String key, UIComponent value) {
            if (key == null || value == null) {
                throw new NullPointerException();
            }
            if (!(key instanceof String) || !(value instanceof UIComponent)) {
                throw new ClassCastException();
            }
            UIComponent previous = (UIComponent)super.get(key);
            if (previous != null) {
                ComponentSupport.removeFromDescendantMarkIdCache((UIComponent)this.component, (UIComponent)previous);
                previous.setParent(null);
            }
            ComponentSupport.addToDescendantMarkIdCache((UIComponent)this.component, (UIComponent)value);
            UIComponentBase.eraseParent(value);
            UIComponent result = super.put(key, value);
            value.setParent(this.component);
            return result;
        }

        @Override
        public void putAll(Map<? extends String, ? extends UIComponent> map) {
            if (map == null) {
                throw new NullPointerException();
            }
            for (Map.Entry<? extends String, ? extends UIComponent> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public UIComponent remove(Object key) {
            UIComponent previous = (UIComponent)this.get(key);
            if (previous != null) {
                if (ComponentSupport.isNotRenderingResponse((FacesContext)this.context)) {
                    ComponentSupport.removeFromDescendantMarkIdCache((UIComponent)this.component, (UIComponent)previous);
                }
                previous.setParent(null);
            }
            super.remove(key);
            return previous;
        }

        @Override
        public Collection<UIComponent> values() {
            return new FacetsMapValues(this);
        }

        Iterator<String> keySetIterator() {
            return new ArrayList(super.keySet()).iterator();
        }
    }

    private static final class FacetsAndChildrenIterator
    implements Iterator<UIComponent> {
        private Iterator<UIComponent> iterator;
        private boolean childMode;
        private UIComponent c;

        public FacetsAndChildrenIterator(UIComponent c) {
            this.c = c;
            this.childMode = false;
        }

        private void update() {
            if (this.iterator == null) {
                if (this.c.getFacetCount() != 0) {
                    this.iterator = this.c.getFacets().values().iterator();
                    this.childMode = false;
                } else if (this.c.getChildCount() != 0) {
                    this.iterator = this.c.getChildren().iterator();
                    this.childMode = true;
                } else {
                    this.iterator = EMPTY_ITERATOR;
                    this.childMode = true;
                }
            } else if (!this.childMode && !this.iterator.hasNext() && this.c.getChildCount() != 0) {
                this.iterator = this.c.getChildren().iterator();
                this.childMode = true;
            }
        }

        @Override
        public boolean hasNext() {
            this.update();
            return this.iterator.hasNext();
        }

        @Override
        public UIComponent next() {
            this.update();
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ChildrenListIterator
    implements ListIterator<UIComponent> {
        private ChildrenList list;
        private int index;
        private int last = -1;

        public ChildrenListIterator(ChildrenList list) {
            this.list = list;
            this.index = 0;
        }

        public ChildrenListIterator(ChildrenList list, int index) {
            this.list = list;
            if (index < 0 || index > list.size()) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.list.size();
        }

        @Override
        public UIComponent next() {
            try {
                UIComponent o = (UIComponent)this.list.get(this.index);
                this.last = this.index++;
                return o;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException(String.valueOf(this.index));
            }
        }

        @Override
        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            this.list.remove(this.last);
            if (this.last < this.index) {
                --this.index;
            }
            this.last = -1;
        }

        @Override
        public void add(UIComponent o) {
            this.last = -1;
            this.list.add(this.index++, o);
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 1;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public UIComponent previous() {
            try {
                int current = this.index - 1;
                UIComponent o = (UIComponent)this.list.get(current);
                this.last = current;
                this.index = current;
                return o;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void set(UIComponent o) {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            this.list.set(this.last, o);
        }
    }

    private static class ChildrenList
    extends ArrayList<UIComponent> {
        private static final long serialVersionUID = 8926987612679576963L;
        private UIComponent component;
        private FacesContext context;

        public ChildrenList(UIComponent component) {
            super(6);
            this.component = component;
            this.context = component.getFacesContext();
        }

        @Override
        public void add(int index, UIComponent element) {
            if (element == null) {
                throw new NullPointerException();
            }
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException();
            }
            ComponentSupport.addToDescendantMarkIdCache((UIComponent)this.component, (UIComponent)element);
            UIComponentBase.eraseParent(element);
            super.add(index, element);
            element.setParent(this.component);
        }

        @Override
        public boolean add(UIComponent element) {
            if (element == null) {
                throw new NullPointerException();
            }
            ComponentSupport.addToDescendantMarkIdCache((UIComponent)this.component, (UIComponent)element);
            UIComponentBase.eraseParent(element);
            boolean result = super.add(element);
            element.setParent(this.component);
            return result;
        }

        @Override
        public boolean addAll(Collection<? extends UIComponent> collection) {
            Iterator<? extends UIComponent> elements = new ArrayList<UIComponent>(collection).iterator();
            boolean changed = false;
            while (elements.hasNext()) {
                UIComponent element = elements.next();
                if (element == null) {
                    throw new NullPointerException();
                }
                this.add(element);
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean addAll(int index, Collection<? extends UIComponent> collection) {
            Iterator<? extends UIComponent> elements = new ArrayList<UIComponent>(collection).iterator();
            boolean changed = false;
            while (elements.hasNext()) {
                UIComponent element = elements.next();
                if (element == null) {
                    throw new NullPointerException();
                }
                this.add(index++, element);
                changed = true;
            }
            return changed;
        }

        @Override
        public void clear() {
            int n = this.size();
            if (n < 1) {
                return;
            }
            for (int i = 0; i < n; ++i) {
                UIComponent child = (UIComponent)this.get(i);
                if (ComponentSupport.isNotRenderingResponse((FacesContext)this.context)) {
                    ComponentSupport.removeFromDescendantMarkIdCache((UIComponent)this.component, (UIComponent)child);
                }
                child.setParent(null);
            }
            super.clear();
        }

        @Override
        public Iterator<UIComponent> iterator() {
            return new ChildrenListIterator(this);
        }

        @Override
        public ListIterator<UIComponent> listIterator() {
            return new ChildrenListIterator(this);
        }

        @Override
        public ListIterator<UIComponent> listIterator(int index) {
            return new ChildrenListIterator(this, index);
        }

        @Override
        public UIComponent remove(int index) {
            UIComponent child = (UIComponent)this.get(index);
            if (ComponentSupport.isNotRenderingResponse((FacesContext)this.context)) {
                ComponentSupport.removeFromDescendantMarkIdCache((UIComponent)this.component, (UIComponent)child);
            }
            child.setParent(null);
            super.remove(index);
            return child;
        }

        @Override
        public boolean remove(Object elementObj) {
            UIComponent element = (UIComponent)elementObj;
            if (element == null) {
                throw new NullPointerException();
            }
            if (ComponentSupport.isNotRenderingResponse((FacesContext)this.context)) {
                ComponentSupport.removeFromDescendantMarkIdCache((UIComponent)this.component, (UIComponent)element);
            }
            if (super.indexOf(element) != -1) {
                element.setParent(null);
            }
            return super.remove(element);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean result = false;
            for (Object elements : collection) {
                if (!this.remove(elements)) continue;
                result = true;
            }
            return result;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            Iterator<UIComponent> items = this.iterator();
            while (items.hasNext()) {
                if (collection.contains(items.next())) continue;
                items.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public UIComponent set(int index, UIComponent element) {
            if (element == null) {
                throw new NullPointerException();
            }
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            ComponentSupport.addToDescendantMarkIdCache((UIComponent)this.component, (UIComponent)element);
            UIComponentBase.eraseParent(element);
            UIComponent previous = (UIComponent)this.get(index);
            ComponentSupport.removeFromDescendantMarkIdCache((UIComponent)this.component, (UIComponent)previous);
            super.set(index, element);
            previous.setParent(null);
            element.setParent(this.component);
            return previous;
        }
    }

    private static class AttributesMap
    implements Map<String, Object>,
    Serializable {
        private static final String ATTRIBUTES_THAT_ARE_SET_KEY = UIComponentBase.class.getName() + ".attributesThatAreSet";
        private transient Map<String, PropertyDescriptor> pdMap;
        private transient ConcurrentMap<String, Method> readMap;
        private transient UIComponent component;
        private static final long serialVersionUID = -6773035086539772945L;

        private AttributesMap(UIComponent component) {
            this.component = component;
            this.pdMap = ((UIComponentBase)component).getDescriptorMap();
        }

        @Override
        public boolean containsKey(Object keyObj) {
            if (ATTRIBUTES_THAT_ARE_SET_KEY.equals(keyObj)) {
                return true;
            }
            String key = (String)keyObj;
            PropertyDescriptor pd = this.getPropertyDescriptor(key);
            if (pd == null) {
                Map attributes = (Map)this.component.getStateHelper().get((Serializable)((Object)UIComponent.PropertyKeys.attributes));
                if (attributes != null) {
                    return attributes.containsKey(key);
                }
                return false;
            }
            return false;
        }

        @Override
        public Object get(Object keyObj) {
            ValueExpression ve;
            String key = (String)keyObj;
            Object result = null;
            if (key == null) {
                throw new NullPointerException();
            }
            if (ATTRIBUTES_THAT_ARE_SET_KEY.equals(key)) {
                result = this.component.getStateHelper().get((Serializable)((Object)UIComponent.PropertyKeysPrivate.attributesThatAreSet));
            }
            Map attributes = (Map)this.component.getStateHelper().get((Serializable)((Object)UIComponent.PropertyKeys.attributes));
            if (null == result) {
                PropertyDescriptor pd = this.getPropertyDescriptor(key);
                if (pd != null) {
                    try {
                        Method putResult;
                        Method readMethod;
                        if (null == this.readMap) {
                            this.readMap = new ConcurrentHashMap<String, Method>();
                        }
                        if (null == (readMethod = (Method)this.readMap.get(key)) && null != (putResult = this.readMap.putIfAbsent(key, readMethod = pd.getReadMethod()))) {
                            readMethod = putResult;
                        }
                        if (readMethod == null) {
                            throw new IllegalArgumentException(key);
                        }
                        result = readMethod.invoke((Object)this.component, EMPTY_OBJECT_ARRAY);
                    }
                    catch (IllegalAccessException e) {
                        throw new FacesException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new FacesException(e.getTargetException());
                    }
                } else if (attributes != null && attributes.containsKey(key)) {
                    result = attributes.get(key);
                }
            }
            if (null == result && (ve = this.component.getValueExpression(key)) != null) {
                try {
                    result = ve.getValue(this.component.getFacesContext().getELContext());
                }
                catch (ELException e) {
                    throw new FacesException(e);
                }
            }
            return result;
        }

        @Override
        public Object put(String keyValue, Object value) {
            if (keyValue == null) {
                throw new NullPointerException();
            }
            if (ATTRIBUTES_THAT_ARE_SET_KEY.equals(keyValue)) {
                if (this.component.attributesThatAreSet == null && value instanceof List) {
                    this.component.getStateHelper().put((Serializable)((Object)UIComponent.PropertyKeysPrivate.attributesThatAreSet), value);
                }
                return null;
            }
            PropertyDescriptor pd = this.getPropertyDescriptor(keyValue);
            if (pd != null) {
                try {
                    Method writeMethod;
                    Object result = null;
                    Method readMethod = pd.getReadMethod();
                    if (readMethod != null) {
                        result = readMethod.invoke((Object)this.component, EMPTY_OBJECT_ARRAY);
                    }
                    if ((writeMethod = pd.getWriteMethod()) == null) {
                        throw new IllegalArgumentException("Setter not found for property " + keyValue);
                    }
                    writeMethod.invoke((Object)this.component, value);
                    return result;
                }
                catch (IllegalAccessException e) {
                    throw new FacesException(e);
                }
                catch (InvocationTargetException e) {
                    throw new FacesException(e.getTargetException());
                }
            }
            if (value == null) {
                throw new NullPointerException();
            }
            List sProperties = (List)this.component.getStateHelper().get((Serializable)((Object)UIComponent.PropertyKeysPrivate.attributesThatAreSet));
            if (sProperties == null) {
                this.component.getStateHelper().add((Serializable)((Object)UIComponent.PropertyKeysPrivate.attributesThatAreSet), keyValue);
            } else if (!sProperties.contains(keyValue)) {
                this.component.getStateHelper().add((Serializable)((Object)UIComponent.PropertyKeysPrivate.attributesThatAreSet), keyValue);
            }
            return this.putAttribute(keyValue, value);
        }

        @Override
        public void putAll(Map<? extends String, ?> map) {
            if (map == null) {
                throw new NullPointerException();
            }
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Object remove(Object keyObj) {
            String key = (String)keyObj;
            if (key == null) {
                throw new NullPointerException();
            }
            if (ATTRIBUTES_THAT_ARE_SET_KEY.equals(key)) {
                return null;
            }
            PropertyDescriptor pd = this.getPropertyDescriptor(key);
            if (pd != null) {
                throw new IllegalArgumentException(key);
            }
            Map<String, Object> attributes = this.getAttributes();
            if (attributes != null) {
                this.component.getStateHelper().remove((Serializable)((Object)UIComponent.PropertyKeysPrivate.attributesThatAreSet), key);
                return this.component.getStateHelper().remove((Serializable)((Object)UIComponent.PropertyKeys.attributes), key);
            }
            return null;
        }

        @Override
        public int size() {
            Map<String, Object> attributes = this.getAttributes();
            return attributes != null ? attributes.size() : 0;
        }

        @Override
        public boolean isEmpty() {
            Map<String, Object> attributes = this.getAttributes();
            return attributes == null || attributes.isEmpty();
        }

        @Override
        public boolean containsValue(Object value) {
            Map<String, Object> attributes = this.getAttributes();
            return attributes != null && attributes.containsValue(value);
        }

        @Override
        public void clear() {
            this.component.getStateHelper().remove((Serializable)((Object)UIComponent.PropertyKeys.attributes));
            this.component.getStateHelper().remove((Serializable)((Object)UIComponent.PropertyKeysPrivate.attributesThatAreSet));
        }

        @Override
        public Set<String> keySet() {
            Map<String, Object> attributes = this.getAttributes();
            if (attributes != null) {
                return Collections.unmodifiableSet(attributes.keySet());
            }
            return Collections.emptySet();
        }

        @Override
        public Collection<Object> values() {
            Map<String, Object> attributes = this.getAttributes();
            if (attributes != null) {
                return Collections.unmodifiableCollection(attributes.values());
            }
            return Collections.emptyList();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            Map<String, Object> attributes = this.getAttributes();
            if (attributes != null) {
                return Collections.unmodifiableSet(attributes.entrySet());
            }
            return Collections.emptySet();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Map)) {
                return false;
            }
            Map t = (Map)o;
            if (t.size() != this.size()) {
                return false;
            }
            try {
                Iterator<Map.Entry<String, Object>> iterator = this.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Object> e;
                    Map.Entry<String, Object> entry = e = iterator.next();
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    if (!(value == null ? t.get(key) != null || !t.containsKey(key) : !value.equals(t.get(key)))) continue;
                    return false;
                }
            }
            catch (ClassCastException | NullPointerException unused) {
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Map.Entry<String, Object> o : this.entrySet()) {
                h += ((Object)o).hashCode();
            }
            return h;
        }

        private Map<String, Object> getAttributes() {
            return (Map)this.component.getStateHelper().get((Serializable)((Object)UIComponent.PropertyKeys.attributes));
        }

        private Object putAttribute(String key, Object value) {
            return this.component.getStateHelper().put((Serializable)((Object)UIComponent.PropertyKeys.attributes), key, value);
        }

        PropertyDescriptor getPropertyDescriptor(String name) {
            if (this.pdMap != null) {
                return this.pdMap.get(name);
            }
            return null;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this.component.getClass());
            out.writeObject(this.component.saveState(FacesContext.getCurrentInstance()));
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            Class clazz = (Class)in.readObject();
            try {
                this.component = (UIComponent)clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            this.component.restoreState(FacesContext.getCurrentInstance(), in.readObject());
        }
    }
}

