/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html;

import com.vladsch.flexmark.html.AttributeProvider;
import com.vladsch.flexmark.html.IndependentAttributeProviderFactory;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.LinkResolverContext;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class EmbeddedAttributeProvider
implements AttributeProvider {
    public static final IndependentAttributeProviderFactory Factory = new IndependentAttributeProviderFactory(){

        @Override
        public AttributeProvider apply(LinkResolverContext context) {
            return new EmbeddedAttributeProvider();
        }
    };

    private EmbeddedAttributeProvider() {
    }

    @Override
    public void setAttributes(Node node, AttributablePart part, Attributes attributes) {
        Node firstChild;
        if (part == AttributablePart.NODE && (firstChild = node.getChildOfType(new Class[]{EmbeddedNodeAttributes.class})) instanceof EmbeddedNodeAttributes) {
            attributes.addValues(((EmbeddedNodeAttributes)firstChild).attributes);
        }
    }

    public static class EmbeddedNodeAttributes
    extends Node {
        final Attributes attributes;

        public EmbeddedNodeAttributes(Node parent, Attributes attributes) {
            super((BasedSequence)parent.getChars().subSequence(0, 0));
            this.attributes = attributes;
        }

        public BasedSequence[] getSegments() {
            return Node.EMPTY_SEGMENTS;
        }

        public void astString(StringBuilder out, boolean withExtra) {
            out.append(EmbeddedNodeAttributes.class.getSimpleName());
            out.append("[").append(this.getStartOffset()).append(", ").append(this.getEndOffset()).append("]");
            out.append(", attributes: ").append(this.attributes.toString());
            if (withExtra) {
                this.getAstExtra(out);
            }
        }

        public void astExtraChars(StringBuilder out) {
        }
    }
}

