/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.editor;

import com.sun.source.util.Trees;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import org.netbeans.api.editor.caret.MoveCaretsOrigin;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.modules.java.preprocessorbridge.spi.WrapperFactory;
import org.netbeans.modules.jshell.editor.Bundle;
import org.netbeans.modules.jshell.editor.CompletionFilter;
import org.netbeans.modules.jshell.editor.ExecutingGlassPanel;
import org.netbeans.modules.jshell.editor.OverrideEditorActions;
import org.netbeans.modules.jshell.env.JShellEnvironment;
import org.netbeans.modules.jshell.env.ShellEvent;
import org.netbeans.modules.jshell.env.ShellListener;
import org.netbeans.modules.jshell.env.ShellRegistry;
import org.netbeans.modules.jshell.env.ShellStatus;
import org.netbeans.modules.jshell.model.ConsoleEvent;
import org.netbeans.modules.jshell.model.ConsoleListener;
import org.netbeans.modules.jshell.model.ConsoleModel;
import org.netbeans.modules.jshell.model.ConsoleSection;
import org.netbeans.modules.jshell.model.Rng;
import org.netbeans.modules.jshell.support.ShellSession;
import org.netbeans.spi.editor.caret.CascadingNavigationFilter;
import org.netbeans.spi.editor.caret.NavigationFilterBypass;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="JShellEditor", iconBase="org/netbeans/modules/jshell/resources/jshell-terminal.png", persistenceType=2)
public class ConsoleEditor
extends CloneableEditor {
    private ShellSession session;
    private CL cl;
    private Lookup lookup;
    private JShellEnvironment env;
    private volatile boolean detached;
    private ExecutingGlassPanel executeWaitPanel;
    private JLabel initializingPanel;
    private JComponent progressIndicator;
    private JLayeredPane lastLayeredPane;

    public ConsoleEditor() {
        this.lookup = Lookup.EMPTY;
    }

    public ConsoleEditor(CloneableEditorSupport support, Lookup lookup) {
        super(support);
        this.lookup = lookup;
    }

    protected void componentOpened() {
        super.componentOpened();
    }

    protected void componentShowing() {
        super.componentShowing();
        if (this.session == null) {
            Node n = (Node)this.lookup.lookup(Node.class);
            if (n != null) {
                this.getLookup();
                this.setActivatedNodes(new Node[]{n});
            }
            this.initialize();
            if (this.session == null && this.pane != null) {
                this.pane.addPropertyChangeListener("document", e -> this.initialize());
            }
        } else {
            this.updateHourglass();
        }
    }

    protected void componentHidden() {
        this.removeProgressIndicator();
        super.componentHidden();
    }

    private void updateHourglass() {
        ShellStatus status = this.env.getStatus();
        if (status == ShellStatus.STARTING) {
            this.showProgressIndicator(this.prepareInitPanel(), 0, null);
            return;
        }
        if (status == ShellStatus.EXECUTE) {
            String label = this.env.getSession().getExecutionLabel();
            ConsoleModel model = this.session.getModel();
            ConsoleSection e = model.getExecutingSection();
            if (e != null) {
                this.showHourglass(e.getEnd(), label);
                return;
            }
        }
        this.removeProgressIndicator();
    }

    protected void componentClosed() {
        this.removeProgressIndicator();
        super.componentClosed();
        this.pane = null;
        if (this.cloneableEditorSupport().getOpenedPanes() == null && this.session != null) {
            try {
                this.session.getEnv().shutdown();
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private synchronized void detachFromSession() {
        this.session.getModel().removeConsoleListener(this.cl);
        this.cl = null;
        this.detached = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        assert (SwingUtilities.isEventDispatchThread());
        JEditorPane pane = this.getEditorPane();
        if (pane == null) {
            return;
        }
        this.pane = pane;
        Document d = this.getEditorPane().getDocument();
        ShellSession s = ShellSession.get(d);
        if (s == null || s == this.session) {
            return;
        }
        if (s != this.session && this.session != null) {
            this.detachFromSession();
        }
        JShellEnvironment env = ShellRegistry.get().getOwnerEnvironment(s.getConsoleFile());
        this.session = s;
        ConsoleEditor consoleEditor = this;
        synchronized (consoleEditor) {
            this.detached = false;
            this.cl = new CL();
            this.session.getModel().addConsoleListener(this.cl);
        }
        if (env != null && env != this.env) {
            this.env = env;
            env.addShellListener(this.cl);
        }
        this.session.post(() -> SwingUtilities.invokeLater(this::initialResetCaret));
        pane.setNavigationFilter((NavigationFilter)((Object)new NavFilter()));
        d.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ConsoleEditor.this.maybeDiscardEdits();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ConsoleEditor.this.maybeDiscardEdits();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ConsoleEditor.this.maybeDiscardEdits();
            }
        });
        d.putProperty(WrapperFactory.class, new WrapperFactory(){

            public Trees wrapTrees(Trees trees) {
                return new CompletionFilter(trees);
            }
        });
        SwingUtilities.invokeLater(this::updateHourglass);
    }

    private void initialResetCaret() {
        this.resetEditableArea(true);
    }

    private void resetEditableArea(boolean caret) {
        if (this.pane == null || this.pane.getDocument() == null) {
            return;
        }
        Document document = this.pane.getDocument();
        document.render(() -> {
            if (this.detached) {
                return;
            }
            LineDocument ld = (LineDocument)LineDocumentUtils.as((Document)document, LineDocument.class);
            if (ld == null) {
                return;
            }
            ConsoleModel model = this.session.getModel();
            ConsoleSection input = model.getInputSection();
            if (input != null) {
                int commandStart = input.getPartBegin();
                if (commandStart > 0 && commandStart < document.getLength()) {
                    return;
                }
                if (caret) {
                    this.pane.setCaretPosition(commandStart);
                }
            }
        });
    }

    private void maybeDiscardEdits() {
        ShellStatus s = this.env.getStatus();
        ShellSession session = this.env.getSession();
        if (session == null || session.getModel() == null) {
            return;
        }
        if (session.getModel().isWritingResponse()) {
            OverrideEditorActions.flushUndoQueue(this.env.getConsoleDocument());
        } else if (s == ShellStatus.INIT || s == ShellStatus.EXECUTE || s == ShellStatus.STARTING) {
            OverrideEditorActions.flushUndoQueue(this.env.getConsoleDocument());
        }
    }

    private void updateStatusAndActivate() {
        this.updateHourglass();
        ShellStatus s = this.env.getStatus();
        if (s == ShellStatus.READY) {
            this.requestVisible();
            OverrideEditorActions.flushUndoQueue(this.env.getConsoleDocument());
        } else if (s == ShellStatus.EXECUTE) {
            OverrideEditorActions.flushUndoQueue(this.env.getConsoleDocument());
        }
    }

    private ExecutingGlassPanel prepareWaitPanel() {
        if (this.executeWaitPanel == null) {
            ExecutingGlassPanel p = new ExecutingGlassPanel();
            p.addStopListener(this::stopExecution);
            this.executeWaitPanel = p;
        }
        return this.executeWaitPanel;
    }

    private JComponent prepareInitPanel() {
        JLabel l = this.initializingPanel;
        if (this.initializingPanel == null) {
            l = new JLabel(Bundle.MSG_Initializing(), 10);
            l.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("org/netbeans/modules/jshell/resources/wait16.gif")));
            this.initializingPanel = l;
        }
        return this.initializingPanel;
    }

    private void stopExecution(ActionEvent e) {
        Action a = this.pane.getActionMap().get("jshell-stop");
        a.actionPerformed(e);
    }

    private void removeProgressIndicator() {
        if (this.lastLayeredPane == null || this.progressIndicator == null) {
            return;
        }
        this.progressIndicator.setVisible(false);
        JLayeredPane lp = this.lastLayeredPane;
        lp.remove(this.progressIndicator);
        lp.repaint();
        this.progressIndicator = null;
    }

    private void showProgressIndicator(JComponent indicator, int position, String label) {
        this.removeProgressIndicator();
        try {
            if (this.pane == null) {
                return;
            }
            Rectangle r = this.pane.getUI().modelToView(this.pane, position);
            JLayeredPane lp = JLayeredPane.getLayeredPaneAbove(this.pane);
            if (lp == null) {
                return;
            }
            if (r == null) {
                r = new Rectangle();
            }
            lp.add(indicator, JLayeredPane.POPUP_LAYER, 0);
            r.setSize(indicator.getPreferredSize());
            Rectangle converted = SwingUtilities.convertRectangle(this.pane, r, lp);
            indicator.setBounds(converted);
            indicator.setVisible(true);
            this.lastLayeredPane = lp;
            this.progressIndicator = indicator;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void showHourglass(int offset, String label) {
        ExecutingGlassPanel panel = this.prepareWaitPanel();
        panel.setMessage(label);
        this.showProgressIndicator(panel, offset + 1, label);
    }

    public int getPersistenceType() {
        return 2;
    }

    private class CL
    implements ConsoleListener,
    Runnable,
    PropertyChangeListener,
    ShellListener {
        private boolean caret;
        private ShellSession saveSession;

        private CL() {
            this.saveSession = ConsoleEditor.this.session;
        }

        @Override
        public void shellCreated(ShellEvent ev) {
        }

        @Override
        public void shellSettingsChanged(ShellEvent ev) {
        }

        @Override
        public void shellStatusChanged(ShellEvent ev) {
            SwingUtilities.invokeLater(() -> ConsoleEditor.this.updateStatusAndActivate());
        }

        @Override
        public void shellStarted(ShellEvent ev) {
            if (ConsoleEditor.this.session != ConsoleEditor.this.env.getSession()) {
                SwingUtilities.invokeLater(() -> ConsoleEditor.this.initialize());
            }
        }

        @Override
        public void shellShutdown(ShellEvent ev) {
            ConsoleEditor.this.env.removeShellListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == ConsoleEditor.this.session && "active".equals(evt.getPropertyName()) && evt.getNewValue() != Boolean.TRUE) {
                ConsoleEditor.this.detachFromSession();
            }
        }

        @Override
        public void run() {
            if (ConsoleEditor.this.detached || ConsoleEditor.this.session != this.saveSession) {
                return;
            }
            ConsoleEditor.this.resetEditableArea(this.caret);
        }

        @Override
        public void sectionCreated(ConsoleEvent e) {
            if (e.containsInput()) {
                this.caret = true;
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void sectionUpdated(ConsoleEvent e) {
            if (e.containsInput()) {
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void executing(ConsoleEvent e) {
            SwingUtilities.invokeLater(() -> ConsoleEditor.this.updateHourglass());
        }

        @Override
        public void closed(ConsoleEvent e) {
            ConsoleEditor.this.detachFromSession();
        }
    }

    private class NavFilter
    extends CascadingNavigationFilter {
        private JEditorPane lastPane;

        private NavFilter() {
        }

        public void moveDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
            if (this.handle(fb, dot, bias, true)) {
                super.moveDot(fb, dot, bias);
            }
        }

        private void setMoveDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias, boolean setOrMove) {
            if (setOrMove) {
                super.moveDot(fb, dot, bias);
            } else {
                super.setDot(fb, dot, bias);
            }
        }

        private boolean handle(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias, boolean setOrMove) {
            JEditorPane p = ConsoleEditor.this.pane;
            if (p == null) {
                return true;
            }
            this.lastPane = p;
            if (p.getClientProperty("navigational.action") == null) {
                if (!(fb instanceof NavigationFilterBypass)) {
                    return true;
                }
                MoveCaretsOrigin orig = ((NavigationFilterBypass)fb).getOrigin();
                if (!"navigation.action".equals(orig.getActionType())) {
                    return true;
                }
            }
            int current = fb.getCaret().getDot();
            ConsoleSection input = ConsoleEditor.this.session.getModel().getInputSection();
            if (input == null) {
                return true;
            }
            int s = input.getStart();
            int e = input.getEnd();
            try {
                if (current >= s && current <= e) {
                    if (dot >= s && dot <= e) {
                        return this.filterWithinSection(input, fb, dot, bias, setOrMove);
                    }
                    return this.filterOutOfSection(input, fb, dot, bias, setOrMove);
                }
                return true;
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return true;
            }
        }

        private boolean filterWithinSection(ConsoleSection s, NavigationFilter.FilterBypass fb, int dot, Position.Bias bias, boolean setOrMove) {
            Caret c = fb.getCaret();
            int curPos = c.getDot();
            LineDocument ld = (LineDocument)LineDocumentUtils.as((Document)this.lastPane.getDocument(), LineDocument.class);
            if (ld == null) {
                return true;
            }
            int curLine = LineDocumentUtils.getLineStart((LineDocument)ld, (int)c.getDot());
            int dotLine = LineDocumentUtils.getLineStart((LineDocument)ld, (int)dot);
            for (Rng range : s.getPartRanges()) {
                if (range.start > dot) {
                    if (curLine == dotLine) {
                        if (curPos == curLine) {
                            this.setMoveDot(fb, range.start, bias, setOrMove);
                            return false;
                        }
                        if (curPos < range.start) {
                            return true;
                        }
                    }
                    if (dot == dotLine) {
                        if (curPos == range.start) {
                            return true;
                        }
                        this.setMoveDot(fb, range.start, bias, setOrMove);
                        return false;
                    }
                    if (dotLine == curLine) {
                        dot = dotLine - 1;
                        this.setMoveDot(fb, Math.max(0, dot), bias, setOrMove);
                        return false;
                    }
                    this.setMoveDot(fb, range.start, bias, setOrMove);
                    return false;
                }
                if (range.end >= dot) break;
            }
            return true;
        }

        private boolean filterOutOfSection(ConsoleSection s, NavigationFilter.FilterBypass fb, int dot, Position.Bias bias, boolean setOrMove) throws BadLocationException {
            int ref;
            Caret c = fb.getCaret();
            Point magPosition = c.getMagicCaretPosition();
            int curPos = c.getDot();
            if (magPosition == null) {
                int nDot;
                if (curPos == s.getPartBegin() || curPos == s.getEnd()) {
                    return true;
                }
                if (dot < s.getPartBegin() && curPos != s.getStart()) {
                    nDot = s.getPartBegin();
                } else if (dot > s.getEnd() && curPos != s.getEnd()) {
                    nDot = s.getEnd();
                } else {
                    return true;
                }
                this.setMoveDot(fb, nDot, bias, setOrMove);
                return false;
            }
            LineDocument ld = (LineDocument)LineDocumentUtils.as((Document)this.lastPane.getDocument(), LineDocument.class);
            if (ld == null) {
                return true;
            }
            int curLine = LineDocumentUtils.getLineStart((LineDocument)ld, (int)c.getDot());
            if (dot < s.getStart()) {
                ref = LineDocumentUtils.getLineStart((LineDocument)ld, (int)s.getStart());
            } else if (dot >= s.getEnd()) {
                ref = LineDocumentUtils.getLineStart((LineDocument)ld, (int)s.getEnd());
            } else {
                return true;
            }
            if (curLine == ref) {
                return true;
            }
            Rectangle rect = this.lastPane.getUI().modelToView(this.lastPane, ref);
            rect.x = magPosition.x;
            int pos = this.lastPane.getUI().viewToModel(this.lastPane, rect.getLocation());
            if (pos < 0) {
                return true;
            }
            for (Rng range : s.getPartRanges()) {
                if (range.start > pos) {
                    pos = range.start;
                    break;
                }
                if (range.end >= pos) break;
            }
            this.setMoveDot(fb, pos, bias, setOrMove);
            return false;
        }

        public void setDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
            if (this.handle(fb, dot, bias, false)) {
                super.setDot(fb, dot, bias);
            }
        }
    }
}

