/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.jaxb.model;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.jaxb.api.model.JAXBWizModel;
import org.netbeans.modules.xml.jaxb.api.model.events.JAXBWizEvent;
import org.netbeans.modules.xml.jaxb.api.model.events.JAXBWizEventListener;
import org.netbeans.modules.xml.jaxb.cfg.schema.Schema;
import org.netbeans.modules.xml.jaxb.cfg.schema.Schemas;
import org.netbeans.modules.xml.jaxb.model.events.JAXBWizEventImpl;
import org.netbeans.modules.xml.jaxb.util.ProjectHelper;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class JAXBWizModelImpl
implements JAXBWizModel {
    private List<JAXBWizEventListener> listeners = null;
    private Project project;
    private boolean swallowCfgFileEditEvent = false;

    public JAXBWizModelImpl(Project prj) {
        this.project = prj;
    }

    @Override
    public synchronized void addJAXBWizEventListener(JAXBWizEventListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<JAXBWizEventListener>();
        }
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeJAXBWizEventListener(JAXBWizEventListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void fireSchemaAddedEvent(Schemas ss, Schema schema) {
        JAXBWizEventImpl event = new JAXBWizEventImpl(ss, null, schema, JAXBWizEvent.JAXBWizEventType.EVENT_BINDING_ADDED);
        this.dispatchEvent(event);
    }

    public void fireSchemaChangedEvent(Schemas ss, Schema oS, Schema nS) {
        JAXBWizEventImpl event = new JAXBWizEventImpl(ss, oS, nS, JAXBWizEvent.JAXBWizEventType.EVENT_BINDING_CHANGED);
        this.dispatchEvent(event);
    }

    public void fireSchemaDeletedEvent(Schemas ss, Schema oS) {
        JAXBWizEventImpl event = new JAXBWizEventImpl(ss, oS, null, JAXBWizEvent.JAXBWizEventType.EVENT_BINDING_DELETED);
        this.dispatchEvent(event);
    }

    public void fireCfgFileEditedEvent(Schemas ss) {
        JAXBWizEventImpl event = new JAXBWizEventImpl(ss, null, null, JAXBWizEvent.JAXBWizEventType.EVENT_CFG_FILE_EDITED);
        this.dispatchEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent(JAXBWizEvent event) {
        ArrayList<JAXBWizEventListener> lss = new ArrayList<JAXBWizEventListener>();
        JAXBWizModelImpl jAXBWizModelImpl = this;
        synchronized (jAXBWizModelImpl) {
            if (this.listeners != null) {
                lss.addAll(this.listeners);
            }
        }
        JAXBWizEvent.JAXBWizEventType eventType = event.getEventType();
        for (JAXBWizEventListener ls : lss) {
            try {
                switch (eventType) {
                    case EVENT_BINDING_ADDED: {
                        ls.bindingAdded(event);
                        break;
                    }
                    case EVENT_BINDING_CHANGED: {
                        ls.bindingChanged(event);
                        break;
                    }
                    case EVENT_BINDING_DELETED: {
                        ls.bindingDeleted(event);
                        break;
                    }
                    case EVENT_CFG_FILE_EDITED: {
                        ls.configFileEdited(event);
                    }
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSchema(Schema schema) {
        JAXBWizModelImpl jAXBWizModelImpl;
        Schemas scs = ProjectHelper.getXMLBindingSchemas(this.project);
        try {
            jAXBWizModelImpl = this;
            synchronized (jAXBWizModelImpl) {
                this.swallowCfgFileEditEvent = true;
            }
            ProjectHelper.addSchema(this.project, scs, schema);
            this.fireSchemaAddedEvent(scs, schema);
        }
        finally {
            jAXBWizModelImpl = this;
            synchronized (jAXBWizModelImpl) {
                this.swallowCfgFileEditEvent = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeSchema(Schema os, Schema ns) {
        JAXBWizModelImpl jAXBWizModelImpl;
        Schemas scs = ProjectHelper.getXMLBindingSchemas(this.project);
        try {
            jAXBWizModelImpl = this;
            synchronized (jAXBWizModelImpl) {
                this.swallowCfgFileEditEvent = true;
            }
            ProjectHelper.removeSchema(this.project, scs, os);
            ProjectHelper.addSchema(this.project, scs, ns);
            this.fireSchemaChangedEvent(scs, os, ns);
        }
        finally {
            jAXBWizModelImpl = this;
            synchronized (jAXBWizModelImpl) {
                this.swallowCfgFileEditEvent = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSchema(Schema schema) {
        JAXBWizModelImpl jAXBWizModelImpl;
        Schemas scs = ProjectHelper.getXMLBindingSchemas(this.project);
        try {
            jAXBWizModelImpl = this;
            synchronized (jAXBWizModelImpl) {
                this.swallowCfgFileEditEvent = true;
            }
            ProjectHelper.removeSchema(this.project, scs, schema);
            this.fireSchemaDeletedEvent(scs, schema);
        }
        finally {
            jAXBWizModelImpl = this;
            synchronized (jAXBWizModelImpl) {
                this.swallowCfgFileEditEvent = false;
            }
        }
    }

    private final class JaxbCfgChangeListener
    extends FileChangeAdapter {
        private JaxbCfgChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshNodes() {
            boolean skipEvent = false;
            JAXBWizModelImpl jAXBWizModelImpl = JAXBWizModelImpl.this;
            synchronized (jAXBWizModelImpl) {
                skipEvent = JAXBWizModelImpl.this.swallowCfgFileEditEvent;
            }
            if (!skipEvent) {
                Schemas scs = ProjectHelper.getXMLBindingSchemas(JAXBWizModelImpl.this.project);
                JAXBWizModelImpl.this.fireCfgFileEditedEvent(scs);
            }
        }

        public void fileChanged(FileEvent fe) {
            this.refreshNodes();
        }

        public void fileRenamed(FileEvent fe) {
            this.refreshNodes();
        }

        public void fileDataCreated(FileEvent fe) {
            FileObject fo = ProjectHelper.getFOForBindingConfigFile(JAXBWizModelImpl.this.project);
            if (fo != null && fo.isValid()) {
                this.refreshNodes();
            }
        }

        public void fileDeleted(FileEvent fe) {
            this.refreshNodes();
        }
    }
}

