/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.analysis.analyzer.field;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.jakarta.web.beans.analysis.CdiAnalysisResult;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.AnnotationUtil;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.FieldElementAnalyzer;
import org.netbeans.modules.jakarta.web.beans.hints.EditorAnnotationsHelper;
import org.openide.util.NbBundle;

public class DelegateFieldAnalizer
implements FieldElementAnalyzer.FieldAnalyzer {
    @Override
    public void analyze(VariableElement element, TypeMirror elementType, TypeElement parent, AtomicBoolean cancel, CdiAnalysisResult result) {
        EditorAnnotationsHelper helper;
        Element clazz;
        CompilationInfo compInfo = result.getInfo();
        if (!AnnotationUtil.hasAnnotation(element, "jakarta.decorator.Delegate", compInfo)) {
            return;
        }
        result.requireCdiEnabled(element);
        if (!AnnotationUtil.hasAnnotation(element, "jakarta.inject.Inject", compInfo)) {
            result.addError(element, NbBundle.getMessage(DelegateFieldAnalizer.class, (String)"ERR_DelegateHasNoInject"));
        }
        if (!AnnotationUtil.hasAnnotation(clazz = element.getEnclosingElement(), "jakarta.decorator.Decorator", compInfo)) {
            result.addError(element, NbBundle.getMessage(DelegateFieldAnalizer.class, (String)"ERR_DelegateIsNotInDecorator"));
        }
        if ((helper = EditorAnnotationsHelper.getInstance(result)) != null) {
            helper.addDelegate(result, element);
        }
        if (cancel.get()) {
            return;
        }
        this.checkDelegateType(element, elementType, parent, result);
    }

    private void checkDelegateType(VariableElement element, TypeMirror elementType, TypeElement parent, CdiAnalysisResult result) {
        Collection<TypeMirror> decoratedTypes = DelegateFieldAnalizer.getDecoratedTypes(parent, result.getInfo());
        for (TypeMirror decoratedType : decoratedTypes) {
            if (result.getInfo().getTypes().isSubtype(elementType, decoratedType)) continue;
            result.addError(element, NbBundle.getMessage(DelegateFieldAnalizer.class, (String)"ERR_DelegateTypeHasNoDecoratedType"));
            return;
        }
    }

    public static Collection<TypeMirror> getDecoratedTypes(TypeElement element, CompilationInfo info) {
        TypeElement serializable = info.getElements().getTypeElement(Serializable.class.getCanonicalName());
        LinkedList<TypeMirror> result = new LinkedList<TypeMirror>();
        DelegateFieldAnalizer.collectDecoratedTypes(element.asType(), result, serializable, info);
        return result;
    }

    private static void collectDecoratedTypes(TypeMirror type, Collection<TypeMirror> result, TypeElement serializable, CompilationInfo info) {
        List<? extends TypeMirror> directSupertypes = info.getTypes().directSupertypes(type);
        for (TypeMirror typeMirror : directSupertypes) {
            Element element = info.getTypes().asElement(typeMirror);
            if (element == null || element.equals(serializable)) continue;
            if (element.getKind() == ElementKind.INTERFACE) {
                result.add(typeMirror);
            }
            DelegateFieldAnalizer.collectDecoratedTypes(typeMirror, result, serializable, info);
        }
    }
}

