/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.tomcat5.deploy.TomcatManager;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class TomcatFactory
implements DeploymentFactory {
    public static final String SERVER_ID_50 = "Tomcat";
    public static final String SERVER_ID_55 = "Tomcat55";
    public static final String SERVER_ID_60 = "Tomcat60";
    public static final String SERVER_ID_70 = "Tomcat70";
    public static final String SERVER_ID_80 = "Tomcat80";
    public static final String SERVER_ID_90 = "Tomcat90";
    public static final String SERVER_ID_100 = "Tomcat100";
    public static final String SERVER_ID_101 = "Tomcat101";
    public static final String SERVER_ID_110 = "Tomcat110";
    public static final String TOMCAT_URI_PREFIX_50 = "tomcat:";
    public static final String TOMCAT_URI_PREFIX_55 = "tomcat55:";
    public static final String TOMCAT_URI_PREFIX_60 = "tomcat60:";
    public static final String TOMCAT_URI_PREFIX_70 = "tomcat70:";
    public static final String TOMCAT_URI_PREFIX_80 = "tomcat80:";
    public static final String TOMCAT_URI_PREFIX_90 = "tomcat90:";
    public static final String TOMCAT_URI_PREFIX_100 = "tomcat100:";
    public static final String TOMCAT_URI_PREFIX_101 = "tomcat101:";
    public static final String TOMCAT_URI_PREFIX_110 = "tomcat110:";
    public static final String TOMCAT_URI_HOME_PREFIX = "home=";
    public static final String TOMCAT_URI_BASE_PREFIX = ":base=";
    static final Pattern TOMEE_JAR_PATTERN = Pattern.compile("tomee-common-(\\d+(\\.\\d+)*).*\\.jar");
    static final Pattern TOMEE_WEBPROFILE_JAR_PATTERN = Pattern.compile("openejb-api-(\\d+(\\.\\d+)*).*\\.jar");
    static final Pattern TOMEE_JAXRS_JAR_PATTERN = Pattern.compile("jettison-(\\d+(\\.\\d+)*).*\\.jar");
    static final Pattern TOMEE_MICROPROFILE_JAR_PATTERN = Pattern.compile("microprofile-config-api-(\\d+(\\.\\d+)*).*\\.jar");
    static final Pattern TOMEE_PLUS_JAR_PATTERN = Pattern.compile("activemq-protobuf-(\\d+(\\.\\d+)*).*\\.jar");
    static final Pattern TOMEE_PLUME_JAR_PATTERN = Pattern.compile("eclipselink-(\\d+(\\.\\d+)*).*\\.jar");
    private static final String GENERIC_DISCONNECTED_URI_PREFIX = "tomcat-any:";
    private static final String GENERIC_DISCONNECTED_URI = "tomcat-any:jakarta-tomcat-generic";
    private static final String DISCONNECTED_URI_50 = "tomcat:jakarta-tomcat-5.0.x";
    private static final String DISCONNECTED_URI_55 = "tomcat55:jakarta-tomcat-5.5.x";
    private static final String DISCONNECTED_URI_60 = "tomcat60:apache-tomcat-6.0.x";
    private static final String DISCONNECTED_URI_70 = "tomcat70:apache-tomcat-7.0.x";
    private static final String DISCONNECTED_URI_80 = "tomcat80:apache-tomcat-8.0.x";
    private static final String DISCONNECTED_URI_90 = "tomcat90:apache-tomcat-9.0.x";
    private static final String DISCONNECTED_URI_100 = "tomcat100:apache-tomcat-10.0.x";
    private static final String DISCONNECTED_URI_101 = "tomcat101:apache-tomcat-10.1.x";
    private static final String DISCONNECTED_URI_110 = "tomcat110:apache-tomcat-11.0.x";
    private static final Set<String> DISCONNECTED_URIS = new HashSet<String>();
    private static TomcatFactory instance;
    private static final WeakHashMap managerCache;
    private static final Logger LOGGER;

    private TomcatFactory() {
    }

    public static TomcatFactory create50() {
        return TomcatFactory.getInstance();
    }

    public static synchronized TomcatFactory getInstance() {
        if (instance == null) {
            instance = new TomcatFactory();
            DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)instance);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentManager getDeploymentManager(String uri, String uname, String passwd) throws DeploymentManagerCreationException {
        if (!this.handlesURI(uri)) {
            throw new DeploymentManagerCreationException("Invalid URI:" + uri);
        }
        InstanceProperties ip = InstanceProperties.getInstanceProperties((String)uri);
        if (ip == null && !DISCONNECTED_URIS.contains(uri)) {
            throw new DeploymentManagerCreationException("Tomcat instance: " + uri + " is not registered in the IDE.");
        }
        TomcatFactory tomcatFactory = this;
        synchronized (tomcatFactory) {
            TomcatManager tm = (TomcatManager)managerCache.get(ip);
            if (tm == null) {
                try {
                    TomcatManager.TomcatVersion version = TomcatFactory.getTomcatVersion(uri);
                    tm = new TomcatManager(true, TomcatFactory.stripUriPrefix(uri, version), version);
                    managerCache.put(ip, tm);
                }
                catch (IllegalArgumentException iae) {
                    DeploymentManagerCreationException t = new DeploymentManagerCreationException("Cannot create deployment manager for Tomcat instance: " + uri + ".");
                    throw (DeploymentManagerCreationException)t.initCause(iae);
                }
            }
            return tm;
        }
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        return this.getDeploymentManager(uri, null, null);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(TomcatFactory.class, (String)"LBL_TomcatFactory");
    }

    public String getProductVersion() {
        return NbBundle.getMessage(TomcatFactory.class, (String)"LBL_TomcatFactoryVersion");
    }

    public boolean handlesURI(String str) {
        return str != null && (str.startsWith(TOMCAT_URI_PREFIX_50) || str.startsWith(TOMCAT_URI_PREFIX_55) || str.startsWith(TOMCAT_URI_PREFIX_60) || str.startsWith(TOMCAT_URI_PREFIX_70) || str.startsWith(TOMCAT_URI_PREFIX_80) || str.startsWith(TOMCAT_URI_PREFIX_90) || str.startsWith(TOMCAT_URI_PREFIX_100) || str.startsWith(TOMCAT_URI_PREFIX_101) || str.startsWith(TOMCAT_URI_PREFIX_110));
    }

    public static String getTomcatVersionString(File catalinaHome) throws IllegalStateException {
        File catalinaJar = new File(catalinaHome, "lib/catalina.jar");
        File coyoteJar = new File(catalinaHome, "lib/tomcat-coyote.jar");
        if (!catalinaJar.exists()) {
            catalinaJar = new File(catalinaHome, "server/lib/catalina.jar");
            coyoteJar = new File(catalinaHome, "server/lib/tomcat-coyote.jar");
        }
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{Utilities.toURI((File)catalinaJar).toURL(), Utilities.toURI((File)coyoteJar).toURL()});
            Class<?> serverInfo = loader.loadClass("org.apache.catalina.util.ServerInfo");
            try {
                Method method = serverInfo.getMethod("getServerNumber", new Class[0]);
                String version = (String)method.invoke(serverInfo, new Object[0]);
                return version;
            }
            catch (NoSuchMethodException method) {
                Method method2 = serverInfo.getMethod("getServerInfo", new Class[0]);
                String version = (String)method2.invoke(serverInfo, new Object[0]);
                int idx = version.indexOf(47);
                if (idx > 0) {
                    return version.substring(idx + 1);
                }
                throw new IllegalStateException("Cannot identify the version of the server.");
            }
        }
        catch (ReflectiveOperationException | MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static TomcatManager.TomcatVersion getTomcatVersion(File catalinaHome) throws IllegalStateException {
        String version = null;
        try {
            version = TomcatFactory.getTomcatVersionString(catalinaHome);
        }
        catch (IllegalStateException | UnsupportedClassVersionError ex) {
            LOGGER.log(Level.INFO, null, ex);
            return TomcatFactory.getTomcatVersionFallback(catalinaHome);
        }
        return TomcatFactory.getTomcatVersion(version, TomcatManager.TomcatVersion.TOMCAT_80);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static TomcatManager.TomcatVersion getTomcatVersionFallback(File catalinaHome) throws IllegalStateException {
        File lib = new File(catalinaHome, "common" + File.separator + "lib");
        if (lib.isDirectory()) {
            File tasks = new File(catalinaHome, "bin" + File.separator + "catalina-tasks.xml");
            if (!tasks.isFile()) return TomcatManager.TomcatVersion.TOMCAT_50;
            return TomcatManager.TomcatVersion.TOMCAT_55;
        }
        File bootstrapJar = new File(catalinaHome, "bin" + File.separator + "bootstrap.jar");
        if (!bootstrapJar.exists()) {
            return null;
        }
        try (JarFile jar = new JarFile(bootstrapJar);){
            Manifest manifest = jar.getManifest();
            String specificationVersion = null;
            if (manifest != null) {
                specificationVersion = manifest.getMainAttributes().getValue("Specification-Version");
            }
            if (specificationVersion == null) return TomcatManager.TomcatVersion.TOMCAT_50;
            specificationVersion = specificationVersion.trim();
            TomcatManager.TomcatVersion tomcatVersion = TomcatFactory.getTomcatVersion(specificationVersion, TomcatManager.TomcatVersion.TOMCAT_55);
            return tomcatVersion;
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, null, e);
        }
        return TomcatManager.TomcatVersion.TOMCAT_50;
    }

    private static TomcatManager.TomcatVersion getTomcatVersion(String version, TomcatManager.TomcatVersion defaultVersion) throws IllegalStateException {
        if (version.startsWith("5.0.")) {
            return TomcatManager.TomcatVersion.TOMCAT_50;
        }
        if (version.startsWith("5.5.")) {
            return TomcatManager.TomcatVersion.TOMCAT_55;
        }
        if (version.startsWith("6.")) {
            return TomcatManager.TomcatVersion.TOMCAT_60;
        }
        if (version.startsWith("7.")) {
            return TomcatManager.TomcatVersion.TOMCAT_70;
        }
        if (version.startsWith("8.")) {
            return TomcatManager.TomcatVersion.TOMCAT_80;
        }
        if (version.startsWith("9.")) {
            return TomcatManager.TomcatVersion.TOMCAT_90;
        }
        if (version.startsWith("10.0")) {
            return TomcatManager.TomcatVersion.TOMCAT_100;
        }
        if (version.startsWith("10.1")) {
            return TomcatManager.TomcatVersion.TOMCAT_101;
        }
        if (version.startsWith("11.")) {
            return TomcatManager.TomcatVersion.TOMCAT_110;
        }
        int dotIndex = version.indexOf(46);
        if (dotIndex > 0) {
            try {
                int major = Integer.parseInt(version.substring(0, dotIndex));
                if (major > 9) {
                    return TomcatManager.TomcatVersion.TOMCAT_90;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultVersion;
    }

    private static TomcatManager.TomcatVersion getTomcatVersion(String uri) throws IllegalStateException {
        if (uri.startsWith(TOMCAT_URI_PREFIX_110)) {
            return TomcatManager.TomcatVersion.TOMCAT_110;
        }
        if (uri.startsWith(TOMCAT_URI_PREFIX_101)) {
            return TomcatManager.TomcatVersion.TOMCAT_101;
        }
        if (uri.startsWith(TOMCAT_URI_PREFIX_100)) {
            return TomcatManager.TomcatVersion.TOMCAT_100;
        }
        if (uri.startsWith(TOMCAT_URI_PREFIX_90)) {
            return TomcatManager.TomcatVersion.TOMCAT_90;
        }
        if (uri.startsWith(TOMCAT_URI_PREFIX_80)) {
            return TomcatManager.TomcatVersion.TOMCAT_80;
        }
        if (uri.startsWith(TOMCAT_URI_PREFIX_70)) {
            return TomcatManager.TomcatVersion.TOMCAT_70;
        }
        if (uri.startsWith(TOMCAT_URI_PREFIX_60)) {
            return TomcatManager.TomcatVersion.TOMCAT_60;
        }
        if (uri.startsWith(TOMCAT_URI_PREFIX_55)) {
            return TomcatManager.TomcatVersion.TOMCAT_55;
        }
        return TomcatManager.TomcatVersion.TOMCAT_50;
    }

    public static TomcatManager.TomEEVersion getTomEEVersion(File catalinaHome, File catalinaBase) throws IllegalStateException {
        File tomee = TomcatFactory.getTomEEJar(catalinaHome);
        return TomcatFactory.getTomEEVersion(tomee);
    }

    public static TomcatManager.TomEEType getTomEEType(File catalinaHome, File catalinaBase) throws IllegalStateException {
        File tomee = TomcatFactory.getTomEEJar(catalinaHome);
        return TomcatFactory.getTomEEType(tomee.getParentFile());
    }

    @NonNull
    public static TomcatManager.TomEEType getTomEEType(@NonNull File libFolder) {
        File[] children = libFolder.listFiles();
        TomcatManager.TomEEType type = TomcatManager.TomEEType.TOMEE_OPENEJB;
        if (children != null) {
            for (File file : children) {
                if (TOMEE_PLUME_JAR_PATTERN.matcher(file.getName()).matches()) {
                    if (type.ordinal() >= TomcatManager.TomEEType.TOMEE_PLUME.ordinal()) continue;
                    return TomcatManager.TomEEType.TOMEE_PLUME;
                }
                if (TOMEE_PLUS_JAR_PATTERN.matcher(file.getName()).matches()) {
                    if (type.ordinal() >= TomcatManager.TomEEType.TOMEE_PLUS.ordinal()) continue;
                    type = TomcatManager.TomEEType.TOMEE_PLUS;
                    continue;
                }
                if (TOMEE_MICROPROFILE_JAR_PATTERN.matcher(file.getName()).matches()) {
                    if (type.ordinal() >= TomcatManager.TomEEType.TOMEE_MICROPROFILE.ordinal()) continue;
                    type = TomcatManager.TomEEType.TOMEE_MICROPROFILE;
                    continue;
                }
                if (TOMEE_JAXRS_JAR_PATTERN.matcher(file.getName()).matches()) {
                    if (type.ordinal() >= TomcatManager.TomEEType.TOMEE_JAXRS.ordinal()) continue;
                    type = TomcatManager.TomEEType.TOMEE_JAXRS;
                    continue;
                }
                if (!TOMEE_JAR_PATTERN.matcher(file.getName()).matches() || type.ordinal() >= TomcatManager.TomEEType.TOMEE_WEBPROFILE.ordinal()) continue;
                type = TomcatManager.TomEEType.TOMEE_WEBPROFILE;
            }
        }
        return type;
    }

    public static TomcatManager.TomEEVersion getTomEEVersion(File tomeeJar) throws IllegalStateException {
        Matcher matcher;
        if (tomeeJar != null && (matcher = TOMEE_JAR_PATTERN.matcher(tomeeJar.getName())).matches()) {
            String versionString = matcher.group(1);
            return TomcatFactory.getTomEEVersion(versionString, TomcatManager.TomEEVersion.TOMEE_15);
        }
        return null;
    }

    @CheckForNull
    public static File getTomEEWebAppJar(File catalinaHome, File catalinaBase) {
        File ret = TomcatFactory.getTomEEWebAppJar(catalinaHome);
        if (ret != null) {
            return ret;
        }
        if (catalinaBase != null) {
            return TomcatFactory.getTomEEWebAppJar(catalinaBase);
        }
        return null;
    }

    @CheckForNull
    public static File getTomEEWebAppJar(File parent) {
        File webApps = new File(parent, "webapps");
        File[] children = webApps.listFiles(pathname -> pathname.isDirectory());
        if (children != null) {
            for (File child : children) {
                File jar = TomcatFactory.getTomEEJar(child);
                if (jar == null) continue;
                return jar;
            }
        }
        return null;
    }

    private static File getTomEEJar(File parentDir) throws IllegalStateException {
        File libDir = new File(parentDir, "lib");
        String[] names = libDir.list((dir, name) -> TOMEE_JAR_PATTERN.matcher(name).matches());
        if (names != null && names.length > 0) {
            return new File(libDir, names[0]);
        }
        return null;
    }

    private static TomcatManager.TomEEVersion getTomEEVersion(String version, TomcatManager.TomEEVersion defaultVersion) throws IllegalStateException {
        if (version.startsWith("1.5.")) {
            return TomcatManager.TomEEVersion.TOMEE_15;
        }
        if (version.startsWith("1.6.")) {
            return TomcatManager.TomEEVersion.TOMEE_16;
        }
        if (version.startsWith("1.7.")) {
            return TomcatManager.TomEEVersion.TOMEE_17;
        }
        if (version.startsWith("7.")) {
            return TomcatManager.TomEEVersion.TOMEE_70;
        }
        if (version.startsWith("7.1.")) {
            return TomcatManager.TomEEVersion.TOMEE_71;
        }
        if (version.startsWith("8.")) {
            return TomcatManager.TomEEVersion.TOMEE_80;
        }
        if (version.startsWith("9.")) {
            return TomcatManager.TomEEVersion.TOMEE_90;
        }
        return defaultVersion;
    }

    private static String stripUriPrefix(String uri, TomcatManager.TomcatVersion tomcatVersion) {
        if (uri.startsWith(GENERIC_DISCONNECTED_URI_PREFIX)) {
            return uri.substring(GENERIC_DISCONNECTED_URI_PREFIX.length());
        }
        switch (tomcatVersion) {
            case TOMCAT_110: {
                return uri.substring(TOMCAT_URI_PREFIX_110.length());
            }
            case TOMCAT_101: {
                return uri.substring(TOMCAT_URI_PREFIX_101.length());
            }
            case TOMCAT_100: {
                return uri.substring(TOMCAT_URI_PREFIX_100.length());
            }
            case TOMCAT_90: {
                return uri.substring(TOMCAT_URI_PREFIX_90.length());
            }
            case TOMCAT_80: {
                return uri.substring(TOMCAT_URI_PREFIX_80.length());
            }
            case TOMCAT_70: {
                return uri.substring(TOMCAT_URI_PREFIX_70.length());
            }
            case TOMCAT_60: {
                return uri.substring(TOMCAT_URI_PREFIX_60.length());
            }
            case TOMCAT_55: {
                return uri.substring(TOMCAT_URI_PREFIX_55.length());
            }
        }
        return uri.substring(TOMCAT_URI_PREFIX_50.length());
    }

    static {
        Collections.addAll(DISCONNECTED_URIS, DISCONNECTED_URI_50, DISCONNECTED_URI_55, DISCONNECTED_URI_60, DISCONNECTED_URI_70, DISCONNECTED_URI_80, DISCONNECTED_URI_90, DISCONNECTED_URI_100, DISCONNECTED_URI_101, DISCONNECTED_URI_110, GENERIC_DISCONNECTED_URI);
        managerCache = new WeakHashMap();
        LOGGER = Logger.getLogger(TomcatFactory.class.getName());
    }
}

