/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth;

import com.oracle.bmc.Region;
import com.oracle.bmc.auth.AbstractFederationClientAuthenticationDetailsProviderBuilder;
import com.oracle.bmc.auth.AbstractRequestingAuthenticationDetailsProvider;
import com.oracle.bmc.auth.AuthCachingPolicy;
import com.oracle.bmc.auth.ConfigurableRefreshOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.ProvidesConfigurableRefresh;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.auth.SessionKeySupplier;
import com.oracle.bmc.auth.X509CertificateSupplier;
import com.oracle.bmc.auth.internal.FederationClient;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthCachingPolicy(cacheKeyId=false, cachePrivateKey=false)
public class InstancePrincipalsAuthenticationDetailsProvider
extends AbstractRequestingAuthenticationDetailsProvider
implements RegionProvider,
RefreshableOnNotAuthenticatedProvider<String>,
ConfigurableRefreshOnNotAuthenticatedProvider<String> {
    private static final Logger LOG = LoggerFactory.getLogger(InstancePrincipalsAuthenticationDetailsProvider.class);
    private final Region region;

    private InstancePrincipalsAuthenticationDetailsProvider(FederationClient federationClient, SessionKeySupplier sessionKeySupplier, Region region) {
        super(federationClient, sessionKeySupplier);
        this.region = region;
    }

    public static InstancePrincipalsAuthenticationDetailsProviderBuilder builder() {
        return new InstancePrincipalsAuthenticationDetailsProviderBuilder();
    }

    @Deprecated
    public String refreshSecurityToken() {
        return this.federationClient.refreshAndGetSecurityToken();
    }

    @Override
    public String refresh() {
        return this.federationClient.refreshAndGetSecurityToken();
    }

    @Override
    public String refreshIfExpiringWithin(Duration time) {
        return this.refreshIfExpiringWithin(time, true);
    }

    @Override
    public String refreshIfExpiringWithin(Duration time, boolean refreshKeys) {
        if (this.federationClient instanceof ProvidesConfigurableRefresh) {
            return ((ProvidesConfigurableRefresh)((Object)this.federationClient)).refreshAndGetSecurityTokenIfExpiringWithin(time, refreshKeys);
        }
        return this.federationClient.refreshAndGetSecurityToken();
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    public static class InstancePrincipalsAuthenticationDetailsProviderBuilder
    extends AbstractFederationClientAuthenticationDetailsProviderBuilder<InstancePrincipalsAuthenticationDetailsProviderBuilder, InstancePrincipalsAuthenticationDetailsProvider> {
        @Override
        protected InstancePrincipalsAuthenticationDetailsProvider buildProvider(SessionKeySupplier sessionKeySupplierToUse) {
            return new InstancePrincipalsAuthenticationDetailsProvider(this.federationClient, sessionKeySupplierToUse, this.region);
        }

        @Override
        public InstancePrincipalsAuthenticationDetailsProvider build() {
            LOG.info("Instance principals authentication can only be used on OCI compute instances. Please confirm this code is running on an OCI compute instance.\nSee https://docs.oracle.com/en-us/iaas/Content/Identity/Tasks/callingservicesfrominstances.htm for more info.");
            this.autoDetectUsingMetadataUrl();
            return (InstancePrincipalsAuthenticationDetailsProvider)super.build();
        }

        @Override
        public InstancePrincipalsAuthenticationDetailsProviderBuilder federationEndpoint(String federationEndpoint) {
            return (InstancePrincipalsAuthenticationDetailsProviderBuilder)super.federationEndpoint(federationEndpoint);
        }

        @Override
        public InstancePrincipalsAuthenticationDetailsProviderBuilder leafCertificateSupplier(X509CertificateSupplier leafCertificateSupplier) {
            return (InstancePrincipalsAuthenticationDetailsProviderBuilder)super.leafCertificateSupplier(leafCertificateSupplier);
        }
    }
}

