/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib.api.properties;

import java.util.Collection;
import org.netbeans.modules.css.lib.api.properties.Node;

public class GrammarParseTreeConvertor {
    static Node createParseTreeWithOnlyNamedNodes(Node root) {
        return GrammarParseTreeConvertor.convert(root);
    }

    private static Node convert(Node node) {
        Node converted;
        if (node instanceof Node.GroupNodeImpl) {
            Node.GroupNodeImpl gen = (Node.GroupNodeImpl)node;
            Node.GroupNodeImpl copy = new Node.GroupNodeImpl(gen.getGrammarElement());
            converted = copy;
            GrammarParseTreeConvertor.gatherNonAnonymousNodes(gen, copy.modifiableChildren());
        } else if (node instanceof Node.ResolvedTokenNode) {
            converted = node;
        } else {
            throw new IllegalStateException();
        }
        return converted;
    }

    private static void gatherNonAnonymousNodes(Node node, Collection<Node> children) {
        for (Node child : node.children()) {
            if (GrammarParseTreeConvertor.isAnonymousNode(child)) {
                GrammarParseTreeConvertor.gatherNonAnonymousNodes(child, children);
                continue;
            }
            children.add(GrammarParseTreeConvertor.convert(child));
        }
    }

    private static boolean isAnonymousNode(Node child) {
        return child.name() == null;
    }
}

