/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.project;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;

public final class ShellProjectUtils {
    public static boolean isJShellRunEnabled(Project p) {
        J2SEPropertyEvaluator prjEval = (J2SEPropertyEvaluator)p.getLookup().lookup(J2SEPropertyEvaluator.class);
        if (prjEval != null) {
            return Boolean.parseBoolean(prjEval.evaluator().evaluate("${jshell.run.enable}"));
        }
        return false;
    }

    public static Project getSessionProject(Session s) {
        Map m = (Map)s.lookupFirst(null, Map.class);
        if (m == null) {
            return null;
        }
        Object bd = m.get("baseDir");
        if (bd instanceof File) {
            FileObject fob = FileUtil.toFileObject((File)((File)bd));
            if (fob == null || !fob.isFolder()) {
                return null;
            }
            try {
                Project p = ProjectManager.getDefault().findProject(fob);
                return p;
            }
            catch (IOException | IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }
        return null;
    }

    public static boolean isNormalRoot(SourceGroup sg) {
        return UnitTestForSourceQuery.findSources((FileObject)sg.getRootFolder()).length == 0;
    }

    public static JavaPlatform findPlatform(ClassPath bootCP) {
        Set<URL> roots = ShellProjectUtils.to2Roots(bootCP);
        for (JavaPlatform platform : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            Set<URL> platformRoots = ShellProjectUtils.to2Roots(platform.getBootstrapLibraries());
            if (!platformRoots.containsAll(roots)) continue;
            return platform;
        }
        return null;
    }

    public static Set<URL> to2Roots(ClassPath bootCP) {
        HashSet<URL> roots = new HashSet<URL>();
        for (ClassPath.Entry e : bootCP.entries()) {
            roots.add(e.getURL());
        }
        return roots;
    }

    public static Collection<String> findProjectImportedModules(Project project, Collection<String> in) {
        HashSet<String> result;
        HashSet<String> hashSet = result = in != null ? in : new HashSet<String>();
        if (project == null) {
            return result;
        }
        for (SourceGroup sg : ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            if (!ShellProjectUtils.isNormalRoot(sg)) continue;
            ClasspathInfo cpi = ClasspathInfo.create((FileObject)sg.getRootFolder());
            ClassPath mcp = cpi.getClassPath(ClasspathInfo.PathKind.COMPILE);
            for (FileObject r : mcp.getRoots()) {
                URL u = URLMapper.findURL((FileObject)r, (int)0);
                String modName = SourceUtils.getModuleName((URL)u);
                if (modName == null) continue;
                result.add(modName);
            }
        }
        return result;
    }

    public static Set<String> findProjectModules(Project project, Set<String> in) {
        HashSet<String> result;
        HashSet<String> hashSet = result = in != null ? in : new HashSet<String>();
        if (project == null) {
            return result;
        }
        for (SourceGroup sg : ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            FileObject fo;
            if (!ShellProjectUtils.isNormalRoot(sg) || (fo = sg.getRootFolder().getFileObject("module-info.java")) == null) continue;
            URL u = URLMapper.findURL((FileObject)sg.getRootFolder(), (int)0);
            BinaryForSourceQuery.Result r = BinaryForSourceQuery.findBinaryRoots((URL)u);
            for (URL u2 : r.getRoots()) {
                String modName = SourceUtils.getModuleName((URL)u2, (boolean)true);
                if (modName == null) continue;
                result.add(modName);
            }
        }
        return result;
    }

    public static Map<String, Collection<String>> findProjectModulesAndPackages(Project project) {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        if (project == null) {
            return result;
        }
        for (SourceGroup sg : ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            if (!ShellProjectUtils.isNormalRoot(sg)) continue;
            URL u = URLMapper.findURL((FileObject)sg.getRootFolder(), (int)0);
            BinaryForSourceQuery.Result r = BinaryForSourceQuery.findBinaryRoots((URL)u);
            for (URL u2 : r.getRoots()) {
                FileObject root;
                Collection<String> pkgs;
                String modName = SourceUtils.getModuleName((URL)u2, (boolean)true);
                if (modName == null || (pkgs = ShellProjectUtils.getPackages(root = URLMapper.findFileObject((URL)u))).isEmpty()) continue;
                Collection oldPkgs = (Collection)result.get(modName);
                if (oldPkgs != null) {
                    oldPkgs.addAll(pkgs);
                    continue;
                }
                result.put(modName, pkgs);
            }
        }
        return result;
    }

    private static Collection<String> getPackages(FileObject root) {
        ClasspathInfo cpi = ClasspathInfo.create((FileObject)root);
        ClasspathInfo rootCpi = new ClasspathInfo.Builder(cpi.getClassPath(ClasspathInfo.PathKind.BOOT)).setClassPath(cpi.getClassPath(ClasspathInfo.PathKind.COMPILE)).setModuleSourcePath(cpi.getClassPath(ClasspathInfo.PathKind.MODULE_SOURCE)).setModuleCompilePath(cpi.getClassPath(ClasspathInfo.PathKind.MODULE_COMPILE)).setSourcePath(ClassPathSupport.createClassPath((FileObject[])new FileObject[]{root})).build();
        HashSet<String> pkgs = new HashSet<String>(rootCpi.getClassIndex().getPackageNames("", false, Collections.singleton(ClassIndex.SearchScope.SOURCE)));
        pkgs.remove("");
        return pkgs;
    }

    public static boolean isModularProject(Project project) {
        if (project == null) {
            return false;
        }
        JavaPlatform platform = ShellProjectUtils.findPlatform(project);
        if (platform == null || !ShellProjectUtils.isModularJDK(platform)) {
            return false;
        }
        String s = SourceLevelQuery.getSourceLevel((FileObject)project.getProjectDirectory());
        if (s == null || new SpecificationVersion("9").compareTo(new SpecificationVersion(s)) > 0) {
            return false;
        }
        for (SourceGroup sg : ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            if (!ShellProjectUtils.isNormalRoot(sg) || sg.getRootFolder().getFileObject("module-info.java") == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isModularJDK(JavaPlatform pl) {
        Specification plSpec;
        SpecificationVersion jvmversion;
        return pl != null && (jvmversion = (plSpec = pl.getSpecification()).getVersion()).compareTo(new SpecificationVersion("9")) >= 0;
    }

    public static ClassPath projectRuntimeModulePath(Project project) {
        ArrayList<ClassPath> delegates = new ArrayList<ClassPath>();
        for (SourceGroup sg : ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            ClassPath del = ClassPath.getClassPath((FileObject)sg.getRootFolder(), (String)"modules/execute");
            if (del == null || del.entries().isEmpty()) continue;
            delegates.add(del);
        }
        return ClassPathSupport.createProxyClassPath((ClassPath[])delegates.toArray(new ClassPath[delegates.size()]));
    }

    public static ClassPath projecRuntimeClassPath(Project project) {
        if (project == null) {
            return null;
        }
        boolean modular = ShellProjectUtils.isModularProject(project);
        ArrayList<ClassPath> delegates = new ArrayList<ClassPath>();
        for (SourceGroup sg : ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            ClassPath del;
            if (!ShellProjectUtils.isNormalRoot(sg) || (del = modular ? ClassPath.getClassPath((FileObject)sg.getRootFolder(), (String)"modules/execute-classpath") : ClassPath.getClassPath((FileObject)sg.getRootFolder(), (String)"classpath/execute")) == null || del.entries().isEmpty()) continue;
            delegates.add(del);
        }
        return ClassPathSupport.createProxyClassPath((ClassPath[])delegates.toArray(new ClassPath[delegates.size()]));
    }

    @NonNull
    public static List<String[]> compilerPathOptions(Project project) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        ArrayList<String> exportMods = new ArrayList<String>(ShellProjectUtils.findProjectImportedModules(project, ShellProjectUtils.findProjectModules(project, null)));
        boolean modular = ShellProjectUtils.isModularProject(project);
        if (exportMods.isEmpty() || !modular) {
            return result;
        }
        Collections.sort(exportMods);
        result.add(new String[]{"--add-modules", String.join((CharSequence)",", exportMods)});
        Map<String, Collection<String>> packages = ShellProjectUtils.findProjectModulesAndPackages(project);
        for (Map.Entry<String, Collection<String>> en : packages.entrySet()) {
            String p = en.getKey();
            Collection<String> vals = en.getValue();
            for (String v : vals) {
                result.add(new String[]{"--add-exports", String.format("%s/%s=ALL-UNNAMED", p, v)});
            }
        }
        return result;
    }

    @NonNull
    public static List<String> launchVMOptions(Project project) {
        ArrayList<String> exportMods = new ArrayList<String>(ShellProjectUtils.findProjectImportedModules(project, ShellProjectUtils.findProjectModules(project, null)));
        ArrayList<String> addReads = new ArrayList<String>();
        boolean modular = ShellProjectUtils.isModularProject(project);
        if (exportMods.isEmpty() || !modular) {
            return addReads;
        }
        exportMods.add("jdk.jshell");
        Collections.sort(exportMods);
        addReads.add("--add-modules");
        addReads.add(String.join((CharSequence)",", exportMods));
        addReads.add("--add-reads");
        addReads.add("jdk.jshell=ALL-UNNAMED");
        Map<String, Collection<String>> packages = ShellProjectUtils.findProjectModulesAndPackages(project);
        for (Map.Entry<String, Collection<String>> en : packages.entrySet()) {
            String p = en.getKey();
            Collection<String> vals = en.getValue();
            for (String v : vals) {
                addReads.add("--add-exports");
                addReads.add(String.format("%s/%s=ALL-UNNAMED", p, v));
            }
        }
        return addReads;
    }

    public static FileObject findProjectRoots(Project project, List<URL> urls) {
        if (project == null) {
            return null;
        }
        FileObject ret = null;
        HashSet<URL> knownURLs = new HashSet<URL>();
        for (SourceGroup sg : ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            if (!ShellProjectUtils.isNormalRoot(sg)) continue;
            if (urls != null) {
                URL u = URLMapper.findURL((FileObject)sg.getRootFolder(), (int)0);
                BinaryForSourceQuery.Result r = BinaryForSourceQuery.findBinaryRoots((URL)u);
                for (URL ru : r.getRoots()) {
                    if (FileUtil.isArchiveArtifact((URL)ru) || !knownURLs.add(ru)) continue;
                    urls.add(ru);
                }
            }
            if (ret != null) continue;
            ret = sg.getRootFolder();
        }
        return ret;
    }

    public static JavaPlatform findPlatform(Project project) {
        FileObject ref = ShellProjectUtils.findProjectRoots(project, null);
        if (ref == null) {
            return null;
        }
        JavaPlatform platform = ShellProjectUtils.findPlatform(ClassPath.getClassPath((FileObject)ref, (String)"classpath/boot"));
        return platform != null ? platform : JavaPlatform.getDefault();
    }

    public static boolean isCompileOnSave(Project p) {
        J2SEPropertyEvaluator prjEval = (J2SEPropertyEvaluator)p.getLookup().lookup(J2SEPropertyEvaluator.class);
        if (prjEval == null) {
            return RunUtils.isCompileOnSaveEnabled((Project)p);
        }
        String compileOnSaveProperty = prjEval.evaluator().getProperty("compile.on.save");
        if (compileOnSaveProperty == null || !Boolean.valueOf(compileOnSaveProperty).booleanValue()) {
            return false;
        }
        Map props = prjEval.evaluator().getProperties();
        if (props == null) {
            return false;
        }
        for (Map.Entry e : props.entrySet()) {
            if (!((String)e.getKey()).startsWith("compile.on.save.unsupported") || e.getValue() == null || !Boolean.valueOf((String)e.getValue()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static String quoteCmdArg(String s) {
        if (s.indexOf(32) == -1) {
            return s;
        }
        return "\"" + s + "\"";
    }

    public static List<String> quoteCmdArgs(List<String> args) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String a : args) {
            ret.add(ShellProjectUtils.quoteCmdArg(a));
        }
        return ret;
    }
}

