/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.languages.hcl.HCLParserResult;
import org.netbeans.modules.languages.hcl.SourceRef;
import org.netbeans.modules.languages.hcl.ast.HCLAttribute;
import org.netbeans.modules.languages.hcl.ast.HCLBlock;
import org.netbeans.modules.languages.hcl.ast.HCLCollection;
import org.netbeans.modules.languages.hcl.ast.HCLDocument;
import org.netbeans.modules.languages.hcl.ast.HCLElement;
import org.netbeans.modules.languages.hcl.ast.HCLExpression;
import org.netbeans.modules.languages.hcl.ast.HCLFunction;
import org.netbeans.modules.languages.hcl.ast.HCLIdentifier;
import org.netbeans.modules.languages.hcl.ast.HCLVariable;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;

public class HCLSemanticAnalyzer
extends SemanticAnalyzer<HCLParserResult> {
    private volatile boolean cancelled;
    private Map<OffsetRange, Set<ColoringAttributes>> highlights = Collections.emptyMap();

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.highlights;
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    public final void run(HCLParserResult result, SchedulerEvent event) {
        this.resume();
        Highlighter h = this.createHighlighter(result);
        result.getDocument().accept(h);
        this.highlights = h.work;
    }

    protected Highlighter createHighlighter(HCLParserResult result) {
        return new DefaultHighlighter(result.getReferences());
    }

    public int getPriority() {
        return 0;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
        this.cancelled = true;
    }

    protected class DefaultHighlighter
    extends Highlighter {
        public DefaultHighlighter(SourceRef refs) {
            super(refs);
        }

        @Override
        protected boolean visitBlock(HCLBlock block) {
            if (block.getParent() instanceof HCLDocument) {
                List<HCLIdentifier> decl = block.getDeclaration();
                HCLIdentifier type = decl.get(0);
                this.mark(type, ColoringAttributes.CLASS_SET);
                if (decl.size() > 1) {
                    for (int i = 1; i < decl.size(); ++i) {
                        HCLIdentifier id = decl.get(i);
                        this.mark(id, ColoringAttributes.CONSTRUCTOR_SET);
                    }
                }
            }
            return false;
        }

        @Override
        protected boolean visitAttribute(HCLAttribute attr) {
            this.mark(attr.getName(), ColoringAttributes.FIELD_SET);
            return false;
        }

        @Override
        protected boolean visitExpression(HCLExpression expr) {
            if (expr instanceof HCLFunction) {
                HCLFunction func = (HCLFunction)expr;
                this.mark(func.getName(), ColoringAttributes.CONSTRUCTOR_SET);
            }
            if (expr instanceof HCLCollection.Object) {
                HCLCollection.Object obj = (HCLCollection.Object)expr;
                for (HCLExpression hCLExpression : obj.getKeys()) {
                    if (!(hCLExpression instanceof HCLVariable)) continue;
                    this.mark(hCLExpression, ColoringAttributes.FIELD_SET);
                }
            }
            return false;
        }
    }

    protected abstract class Highlighter
    extends HCLElement.BAEVisitor {
        protected final Map<OffsetRange, Set<ColoringAttributes>> work = new HashMap<OffsetRange, Set<ColoringAttributes>>();
        protected final SourceRef refs;

        protected Highlighter(SourceRef refs) {
            this.refs = refs;
        }

        @Override
        public final boolean visit(HCLElement e) {
            if (HCLSemanticAnalyzer.this.isCancelled()) {
                return true;
            }
            return super.visit(e);
        }

        protected final void mark(HCLElement e, Set<ColoringAttributes> attrs) {
            this.refs.getOffsetRange(e).ifPresent(range -> this.work.put((OffsetRange)range, attrs));
        }
    }
}

