/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.navigation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.jakarta.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.jakarta.web.beans.navigation.InjectableTreeNode;
import org.netbeans.modules.jakarta.web.beans.navigation.JavaHierarchyModel;
import org.openide.filesystems.FileObject;

public final class EventsModel
extends DefaultTreeModel
implements JavaHierarchyModel {
    private static final long serialVersionUID = -4924076156788647582L;
    private static final Logger LOG = Logger.getLogger(EventsModel.class.getName());
    private MetadataModel<WebBeansModel> myModel;
    private List<ElementHandle<VariableElement>> myHandles;

    public EventsModel(List<VariableElement> fields, CompilationController controller, MetadataModel<WebBeansModel> model) {
        super(null);
        this.myModel = model;
        this.myHandles = new ArrayList<ElementHandle<VariableElement>>(fields.size());
        for (VariableElement field : fields) {
            ElementHandle handle = ElementHandle.create((Element)field);
            this.myHandles.add((ElementHandle<VariableElement>)handle);
        }
        this.update(fields, controller);
    }

    @Override
    public void fireTreeNodesChanged() {
        super.fireTreeNodesChanged(this, this.getPathToRoot((TreeNode)this.getRoot()), null, null);
    }

    @Override
    public void update() {
        this.updateHandles(this.myHandles);
    }

    private void update(List<VariableElement> vars, CompilationController controller) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (VariableElement var : vars) {
            FileObject fileObject = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)var), (ClasspathInfo)controller.getClasspathInfo());
            InjectableTreeNode<VariableElement> node = new InjectableTreeNode<VariableElement>(fileObject, var, (DeclaredType)controller.getElementUtilities().enclosingTypeElement((Element)var).asType(), false, (CompilationInfo)controller);
            root.add(node);
        }
        this.setRoot(root);
    }

    private void updateHandles(final List<ElementHandle<VariableElement>> handles) {
        try {
            this.getModel().runReadAction((MetadataModelAction)new MetadataModelAction<WebBeansModel, Void>(){

                public Void run(WebBeansModel model) {
                    ArrayList<VariableElement> list = new ArrayList<VariableElement>(handles.size());
                    for (ElementHandle handle : handles) {
                        VariableElement var = (VariableElement)handle.resolve((CompilationInfo)model.getCompilationController());
                        if (var == null) continue;
                        list.add(var);
                    }
                    EventsModel.this.update(list, model.getCompilationController());
                    return null;
                }
            });
            return;
        }
        catch (MetadataModelException e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private MetadataModel<WebBeansModel> getModel() {
        return this.myModel;
    }
}

