/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.StackTrace;
import org.netbeans.lib.profiler.heap.TagBounds;

class StackTraceSegment
extends TagBounds {
    private static final int SERIALNUM_DIV = 16;
    HprofHeap hprofHeap;
    final int threadSerialNumberOffset;
    final int stackTraceSerialNumberOffset;
    final int lengthOffset;
    final int framesListOffset;
    final int numberOfFramesOffset;
    final int timeOffset;
    private Map serialNumToStackTrace;

    StackTraceSegment(HprofHeap heap, long start, long end) {
        super(5, start, end);
        this.hprofHeap = heap;
        this.timeOffset = 1;
        this.lengthOffset = this.timeOffset + 4;
        this.stackTraceSerialNumberOffset = this.lengthOffset + 4;
        this.threadSerialNumberOffset = this.stackTraceSerialNumberOffset + 4;
        this.numberOfFramesOffset = this.threadSerialNumberOffset + 4;
        this.framesListOffset = this.numberOfFramesOffset + 4;
    }

    StackTrace getStackTraceBySerialNumber(long stackTraceSerialNumber) {
        this.initSerialNumToFrame();
        Long initialOffset = (Long)this.serialNumToStackTrace.get(stackTraceSerialNumber / 16L);
        if (initialOffset == null) {
            initialOffset = new Long(this.startOffset);
        }
        long[] offset = new long[]{initialOffset};
        while (offset[0] < this.endOffset) {
            long start = offset[0];
            long serialNumber = this.readStackTraceTag(offset);
            if (serialNumber != stackTraceSerialNumber) continue;
            return new StackTrace(this, start);
        }
        return null;
    }

    private HprofByteBuffer getDumpBuffer() {
        HprofByteBuffer dumpBuffer = this.hprofHeap.dumpBuffer;
        return dumpBuffer;
    }

    private int readStackTraceTag(long[] offset) {
        long start = offset[0];
        if (this.hprofHeap.readTag(offset) != 5) {
            return 0;
        }
        return this.getDumpBuffer().getInt(start + (long)this.stackTraceSerialNumberOffset);
    }

    private synchronized void initSerialNumToFrame() {
        if (this.serialNumToStackTrace == null) {
            long[] offset = new long[]{this.startOffset};
            this.serialNumToStackTrace = new HashMap();
            while (offset[0] < this.endOffset) {
                long start = offset[0];
                long serialNumber = this.readStackTraceTag(offset);
                Long serialNumberMask = serialNumber / 16L;
                Long minOffset = (Long)this.serialNumToStackTrace.get(serialNumberMask);
                if (minOffset != null && minOffset <= start) continue;
                this.serialNumToStackTrace.put(serialNumberMask, start);
            }
        }
    }
}

