/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Options;
import java.util.HashMap;
import java.util.Map;

public enum Target {
    JDK1_1("1.1", 45, 3),
    JDK1_2("1.2", 46, 0),
    JDK1_3("1.3", 47, 0),
    JDK1_4("1.4", 48, 0),
    JDK1_5("5", 49, 0),
    JDK1_6("6", 50, 0),
    JDK1_7("7", 51, 0),
    JDK1_8("8", 52, 0),
    JDK1_9("9", 53, 0),
    JDK1_10("10", 54, 0),
    JDK1_11("11", 55, 0),
    JDK1_12("12", 56, 0),
    JDK1_13("13", 57, 0),
    JDK1_14("14", 58, 0),
    JDK1_15("15", 59, 0),
    JDK1_16("16", 60, 0),
    JDK1_17("17", 61, 0),
    JDK1_18("18", 62, 0),
    JDK1_19("19", 63, 0),
    JDK1_20("20", 64, 0),
    JDK1_21("21", 65, 0),
    JDK1_22("22", 66, 0);

    private static final Context.Key<Target> targetKey;
    public static final Target MIN;
    private static final Target MAX;
    public static final Target DEFAULT;
    private static final Map<String, Target> tab;
    public final String name;
    public final int majorVersion;
    public final int minorVersion;

    public static Target instance(Context context) {
        Target instance = context.get(targetKey);
        if (instance == null) {
            Options options = Options.instance(context);
            String targetString = options.get(Option.TARGET);
            if (targetString != null) {
                instance = Target.lookup(targetString);
            }
            if (instance == null) {
                instance = DEFAULT;
            }
            context.put(targetKey, instance);
        }
        return instance;
    }

    private Target(String name, int majorVersion, int minorVersion) {
        this.name = name;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public static Target lookup(String name) {
        return tab.get(name);
    }

    public boolean isSupported() {
        return this.compareTo(MIN) >= 0;
    }

    public char syntheticNameChar() {
        return '$';
    }

    public boolean hasMethodParameters() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean hasStringConcatFactory() {
        return this.compareTo(JDK1_9) >= 0;
    }

    public String multiReleaseValue() {
        return Integer.toString(this.ordinal() - JDK1_1.ordinal() + 1);
    }

    public boolean allApiModulesAreRoots() {
        return this.compareTo(JDK1_11) >= 0;
    }

    public boolean hasNestmateAccess() {
        return this.compareTo(JDK1_11) >= 0;
    }

    public boolean runtimeUseNestAccess() {
        return this.compareTo(JDK1_15) >= 0;
    }

    public boolean hasVirtualPrivateInvoke() {
        return this.compareTo(JDK1_11) >= 0;
    }

    public boolean hasSealedClasses() {
        return this.compareTo(JDK1_15) >= 0;
    }

    public boolean obsoleteAccStrict() {
        return this.compareTo(JDK1_17) >= 0;
    }

    public boolean optimizeOuterThis() {
        return this.compareTo(JDK1_18) >= 0;
    }

    static {
        targetKey = new Context.Key();
        MIN = JDK1_8;
        DEFAULT = MAX = Target.values()[Target.values().length - 1];
        tab = new HashMap<String, Target>();
        for (Target t : Target.values()) {
            tab.put(t.name, t);
        }
        tab.put("1.5", JDK1_5);
        tab.put("1.6", JDK1_6);
        tab.put("1.7", JDK1_7);
        tab.put("1.8", JDK1_8);
        tab.put("1.9", JDK1_9);
        tab.put("1.10", JDK1_10);
    }
}

