/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.source.util.TaskEvent;
import com.sun.tools.javac.api.MultiTaskListener;
import com.sun.tools.javac.code.ClassFinder;
import com.sun.tools.javac.code.DeferredCompletionFailureHandler;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.ModuleFinder;
import com.sun.tools.javac.code.Preview;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Analyzer;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.CompileStates;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Flow;
import com.sun.tools.javac.comp.LambdaToMethod;
import com.sun.tools.javac.comp.Lower;
import com.sun.tools.javac.comp.Modules;
import com.sun.tools.javac.comp.Todo;
import com.sun.tools.javac.comp.TransLiterals;
import com.sun.tools.javac.comp.TransPatterns;
import com.sun.tools.javac.comp.TransTypes;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.jvm.ClassWriter;
import com.sun.tools.javac.jvm.Gen;
import com.sun.tools.javac.jvm.JNIWriter;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.platform.PlatformDescription;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.Pretty;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.RichDiagnosticFormatter;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.InvalidPathException;
import java.nio.file.ReadOnlyFileSystemException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.processing.Processor;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ElementVisitor;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class JavaCompiler {
    public static final Context.Key<JavaCompiler> compilerKey = new Context.Key();
    private static final String versionRBName = "com.sun.tools.javac.resources.version";
    private static ResourceBundle versionRB;
    private static final CompilePolicy DEFAULT_COMPILE_POLICY;
    public Log log;
    boolean optionsCheckingInitiallyDisabled;
    JCDiagnostic.Factory diagFactory;
    protected TreeMaker make;
    protected ClassFinder finder;
    protected ClassReader reader;
    protected ClassWriter writer;
    protected JNIWriter jniWriter;
    protected Enter enter;
    protected Symtab syms;
    protected Source source;
    protected Preview preview;
    protected Gen gen;
    protected Names names;
    protected Attr attr;
    protected Analyzer analyzer;
    protected Check chk;
    protected Flow flow;
    protected Modules modules;
    protected ModuleFinder moduleFinder;
    protected JCDiagnostic.Factory diags;
    protected DeferredCompletionFailureHandler dcfh;
    protected TransTypes transTypes;
    protected Lower lower;
    protected Annotate annotate;
    protected final Name completionFailureName;
    protected Types types;
    protected JavaFileManager fileManager;
    protected ParserFactory parserFactory;
    protected MultiTaskListener taskListener;
    protected final Symbol.Completer sourceCompleter = sym -> this.readSourceFile((Symbol.ClassSymbol)sym);
    protected Options options;
    protected Context context;
    protected boolean annotationProcessingOccurred;
    protected boolean implicitSourceFilesRead;
    private boolean enterDone;
    protected CompileStates compileStates;
    public boolean verbose;
    public boolean sourceOutput;
    public boolean lineDebugInfo;
    public boolean genEndPos;
    protected boolean devVerbose;
    protected boolean processPcks;
    protected boolean werror;
    protected boolean explicitAnnotationProcessingRequested = false;
    protected CompilePolicy compilePolicy;
    protected ImplicitSourcePolicy implicitSourcePolicy;
    public boolean verboseCompilePolicy;
    public CompileStates.CompileState shouldStopPolicyIfError;
    public CompileStates.CompileState shouldStopPolicyIfNoError;
    public Todo todo;
    public List<Closeable> closeables = List.nil();
    protected Set<JavaFileObject> inputFiles = new HashSet<JavaFileObject>();
    private final Symbol silentFail;
    public boolean keepComments = false;
    private boolean hasBeenUsed = false;
    private long start_msec = 0L;
    public long elapsed_msec = 0L;
    private List<JCTree.JCClassDecl> rootClasses;
    boolean processAnnotations = false;
    Log.DeferredDiagnosticHandler deferredDiagnosticHandler;
    private JavacProcessingEnvironment procEnvImpl = null;
    HashMap<Env<AttrContext>, Queue<Pair<Env<AttrContext>, JCTree.JCClassDecl>>> desugaredEnvs = new HashMap();

    public static JavaCompiler instance(Context context) {
        JavaCompiler instance = context.get(compilerKey);
        if (instance == null) {
            instance = new JavaCompiler(context);
        }
        return instance;
    }

    public static String version() {
        return JavaCompiler.version("release");
    }

    public static String fullVersion() {
        return JavaCompiler.version("full");
    }

    private static String version(String key) {
        if (versionRB == null) {
            try {
                versionRB = ResourceBundle.getBundle(versionRBName);
            }
            catch (MissingResourceException e) {
                return Log.getLocalizedString("version.not.available", new Object[0]);
            }
        }
        try {
            return versionRB.getString(key);
        }
        catch (MissingResourceException e) {
            return Log.getLocalizedString("version.not.available", new Object[0]);
        }
    }

    public JavaCompiler(Context context) {
        PlatformDescription platformProvider;
        this.context = context;
        context.put(compilerKey, this);
        if (context.get(JavaFileManager.class) == null) {
            JavacFileManager.preRegister(context);
        }
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.diagFactory = JCDiagnostic.Factory.instance(context);
        this.finder = ClassFinder.instance(context);
        this.reader = ClassReader.instance(context);
        this.make = TreeMaker.instance(context);
        this.writer = ClassWriter.instance(context);
        this.jniWriter = JNIWriter.instance(context);
        this.enter = Enter.instance(context);
        this.todo = Todo.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        this.parserFactory = ParserFactory.instance(context);
        this.compileStates = CompileStates.instance(context);
        try {
            this.syms = Symtab.instance(context);
        }
        catch (Symbol.CompletionFailure ex) {
            this.log.error(CompilerProperties.Errors.CantAccess(ex.sym, ex.getDetailValue()));
        }
        this.source = Source.instance(context);
        this.preview = Preview.instance(context);
        this.attr = Attr.instance(context);
        this.analyzer = Analyzer.instance(context);
        this.chk = Check.instance(context);
        this.gen = Gen.instance(context);
        this.flow = Flow.instance(context);
        this.transTypes = TransTypes.instance(context);
        this.lower = Lower.instance(context);
        this.annotate = Annotate.instance(context);
        this.types = Types.instance(context);
        this.taskListener = MultiTaskListener.instance(context);
        this.modules = Modules.instance(context);
        this.moduleFinder = ModuleFinder.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.dcfh = DeferredCompletionFailureHandler.instance(context);
        this.finder.sourceCompleter = this.sourceCompleter;
        this.modules.findPackageInFile = this::findPackageInFile;
        this.moduleFinder.moduleNameFromSourceReader = this::readModuleName;
        this.options = Options.instance(context);
        this.optionsCheckingInitiallyDisabled = this.options.isSet(Option.XLINT_CUSTOM, "-options") || this.options.isSet(Option.XLINT_CUSTOM, "none");
        this.verbose = this.options.isSet(Option.VERBOSE);
        this.sourceOutput = this.options.isSet(Option.PRINTSOURCE);
        this.lineDebugInfo = this.options.isUnset(Option.G_CUSTOM) || this.options.isSet(Option.G_CUSTOM, "lines");
        this.genEndPos = this.options.isSet(Option.XJCOV) || context.get(DiagnosticListener.class) != null;
        this.devVerbose = this.options.isSet("dev");
        this.processPcks = this.options.isSet("process.packages");
        this.werror = this.options.isSet(Option.WERROR);
        this.verboseCompilePolicy = this.options.isSet("verboseCompilePolicy");
        this.compilePolicy = CompilePolicy.decode(this.options.get("compilePolicy"));
        this.implicitSourcePolicy = ImplicitSourcePolicy.decode(this.options.get("-implicit"));
        Name name = this.completionFailureName = this.options.isSet("failcomplete") ? this.names.fromString(this.options.get("failcomplete")) : null;
        this.shouldStopPolicyIfError = this.options.isSet("should-stop.at") ? CompileStates.CompileState.valueOf(this.options.get("should-stop.at")) : (this.options.isSet("should-stop.ifError") ? CompileStates.CompileState.valueOf(this.options.get("should-stop.ifError")) : CompileStates.CompileState.INIT);
        CompileStates.CompileState compileState = this.shouldStopPolicyIfNoError = this.options.isSet("should-stop.ifNoError") ? CompileStates.CompileState.valueOf(this.options.get("should-stop.ifNoError")) : CompileStates.CompileState.GENERATE;
        if (this.options.isUnset("diags.legacy")) {
            this.log.setDiagnosticFormatter(RichDiagnosticFormatter.instance(context));
        }
        if ((platformProvider = context.get(PlatformDescription.class)) != null) {
            this.closeables = this.closeables.prepend(platformProvider);
        }
        this.silentFail = new Symbol(Kinds.Kind.ABSENT_TYP, 0L, this.names.empty, Type.noType, this.syms.rootPackage){

            @Override
            public <R, P> R accept(ElementVisitor<R, P> v, P p) {
                return v.visitUnknown(this, p);
            }

            @Override
            public boolean exists() {
                return false;
            }
        };
    }

    protected boolean shouldStop(CompileStates.CompileState cs) {
        CompileStates.CompileState shouldStopPolicy = this.errorCount() > 0 || this.unrecoverableError() ? this.shouldStopPolicyIfError : this.shouldStopPolicyIfNoError;
        return cs.isAfter(shouldStopPolicy);
    }

    public int errorCount() {
        if (this.werror && this.log.nerrors == 0 && this.log.nwarnings > 0) {
            this.log.error(CompilerProperties.Errors.WarningsAndWerror);
        }
        return this.log.nerrors;
    }

    protected final <T> Queue<T> stopIfError(CompileStates.CompileState cs, Queue<T> queue) {
        return this.shouldStop(cs) ? new ListBuffer() : queue;
    }

    protected final <T> List<T> stopIfError(CompileStates.CompileState cs, List<T> list) {
        return this.shouldStop(cs) ? List.nil() : list;
    }

    public int warningCount() {
        return this.log.nwarnings;
    }

    public CharSequence readSource(JavaFileObject filename) {
        try {
            this.inputFiles.add(filename);
            return filename.getCharContent(false);
        }
        catch (IOException e) {
            this.log.error(CompilerProperties.Errors.ErrorReadingFile(filename, JavacFileManager.getMessage(e)));
            return null;
        }
    }

    protected JCTree.JCCompilationUnit parse(JavaFileObject filename, CharSequence content) {
        return this.parse(filename, content, false);
    }

    private JCTree.JCCompilationUnit parse(JavaFileObject filename, CharSequence content, boolean silent) {
        TaskEvent e;
        long msec = JavaCompiler.now();
        JCTree.JCCompilationUnit tree = this.make.TopLevel(List.nil());
        if (content != null) {
            if (this.verbose) {
                this.log.printVerbose("parsing.started", filename);
            }
            if (!this.taskListener.isEmpty() && !silent) {
                e = new TaskEvent(TaskEvent.Kind.PARSE, filename);
                this.taskListener.started(e);
                this.keepComments = true;
                this.genEndPos = true;
            }
            JavacParser parser = this.parserFactory.newParser(content, this.keepComments(), this.genEndPos, this.lineDebugInfo, filename.isNameCompatible("module-info", JavaFileObject.Kind.SOURCE));
            tree = parser.parseCompilationUnit();
            if (this.verbose) {
                this.log.printVerbose("parsing.done", Long.toString(JavaCompiler.elapsed(msec)));
            }
        }
        tree.sourcefile = filename;
        if (content != null && !this.taskListener.isEmpty() && !silent) {
            e = new TaskEvent(TaskEvent.Kind.PARSE, tree);
            this.taskListener.finished(e);
        }
        return tree;
    }

    protected boolean keepComments() {
        return this.keepComments || this.sourceOutput;
    }

    @Deprecated
    public JCTree.JCCompilationUnit parse(String filename) {
        JavacFileManager fm = (JavacFileManager)this.fileManager;
        return this.parse(fm.getJavaFileObjectsFromStrings(List.of(filename)).iterator().next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCTree.JCCompilationUnit parse(JavaFileObject filename) {
        JavaFileObject prev = this.log.useSource(filename);
        try {
            JCTree.JCCompilationUnit t = this.parse(filename, this.readSource(filename));
            if (t.endPositions != null) {
                this.log.setEndPosTable(filename, t.endPositions);
            }
            JCTree.JCCompilationUnit jCCompilationUnit = t;
            return jCCompilationUnit;
        }
        finally {
            this.log.useSource(prev);
        }
    }

    public Symbol resolveBinaryNameOrIdent(String name) {
        String typeName;
        Symbol.ModuleSymbol msym;
        int sep = name.indexOf(47);
        if (sep == -1) {
            msym = this.modules.getDefaultModule();
            typeName = name;
        } else if (Source.Feature.MODULES.allowedInSource(this.source)) {
            Name modName = this.names.fromString(name.substring(0, sep));
            msym = this.moduleFinder.findModule(modName);
            typeName = name.substring(sep + 1);
        } else {
            this.log.error(CompilerProperties.Errors.InvalidModuleSpecifier(name));
            return this.silentFail;
        }
        return this.resolveBinaryNameOrIdent(msym, typeName);
    }

    public Symbol resolveBinaryNameOrIdent(Symbol.ModuleSymbol msym, String name) {
        try {
            Name flatname = this.names.fromString(name.replace("/", "."));
            return this.finder.loadClass(msym, flatname);
        }
        catch (Symbol.CompletionFailure ignore) {
            return this.resolveIdent(msym, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Symbol resolveIdent(Symbol.ModuleSymbol msym, String name) {
        if (name.equals("")) {
            return this.syms.errSymbol;
        }
        JavaFileObject prev = this.log.useSource(null);
        try {
            JCTree.JCExpression tree = null;
            for (String s : name.split("\\.", -1)) {
                if (!SourceVersion.isIdentifier(s)) {
                    Symbol.ClassSymbol classSymbol = this.syms.errSymbol;
                    return classSymbol;
                }
                tree = tree == null ? this.make.Ident(this.names.fromString(s)) : this.make.Select(tree, this.names.fromString(s));
            }
            JCTree.JCCompilationUnit toplevel = this.make.TopLevel(List.nil());
            toplevel.modle = msym;
            toplevel.packge = msym.unnamedPackage;
            Symbol symbol = this.attr.attribIdent(tree, toplevel);
            return symbol;
        }
        finally {
            this.log.useSource(prev);
        }
    }

    JavaFileObject genCode(Env<AttrContext> env, JCTree.JCClassDecl cdef) throws IOException {
        try {
            if (this.gen.genClass(env, cdef) && this.errorCount() == 0) {
                return this.writer.writeClass(cdef.sym);
            }
        }
        catch (ClassWriter.PoolOverflow ex) {
            this.log.error(cdef.pos(), CompilerProperties.Errors.LimitPool);
        }
        catch (ClassWriter.StringOverflow ex) {
            this.log.error(cdef.pos(), CompilerProperties.Errors.LimitStringOverflow(ex.value.substring(0, 20)));
        }
        catch (Symbol.CompletionFailure ex) {
            this.chk.completionError(cdef.pos(), ex);
        }
        return null;
    }

    JavaFileObject printSource(Env<AttrContext> env, JCTree.JCClassDecl cdef) throws IOException {
        JavaFileObject outFile = this.fileManager.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, cdef.sym.flatname.toString(), JavaFileObject.Kind.SOURCE, null);
        if (this.inputFiles.contains(outFile)) {
            this.log.error(cdef.pos(), CompilerProperties.Errors.SourceCantOverwriteInputFile(outFile));
            return null;
        }
        try (BufferedWriter out = new BufferedWriter(outFile.openWriter());){
            new Pretty(out, true).printUnit(env.toplevel, cdef);
            if (this.verbose) {
                this.log.printVerbose("wrote.file", outFile.getName());
            }
        }
        return outFile;
    }

    private void readSourceFile(Symbol.ClassSymbol c) throws Symbol.CompletionFailure {
        this.readSourceFile(null, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSourceFile(JCTree.JCCompilationUnit tree, Symbol.ClassSymbol c) throws Symbol.CompletionFailure {
        TaskEvent e;
        if (this.completionFailureName == c.fullname) {
            throw new Symbol.CompletionFailure(c, () -> this.diagFactory.fragment(CompilerProperties.Fragments.UserSelectedCompletionFailure), this.dcfh);
        }
        JavaFileObject filename = c.classfile;
        JavaFileObject prev = this.log.useSource(filename);
        if (tree == null) {
            try {
                tree = this.parse(filename, filename.getCharContent(false));
            }
            catch (IOException e2) {
                this.log.error(CompilerProperties.Errors.ErrorReadingFile(filename, JavacFileManager.getMessage(e2)));
                tree = this.make.TopLevel(List.nil());
            }
            finally {
                this.log.useSource(prev);
            }
        }
        if (!this.taskListener.isEmpty()) {
            e = new TaskEvent(TaskEvent.Kind.ENTER, tree);
            this.taskListener.started(e);
        }
        if (!this.modules.enter(List.of(tree), c)) {
            throw new Symbol.CompletionFailure(c, () -> this.diags.fragment(CompilerProperties.Fragments.CantResolveModules), this.dcfh);
        }
        this.enter.complete(List.of(tree), c);
        if (!this.taskListener.isEmpty()) {
            e = new TaskEvent(TaskEvent.Kind.ENTER, tree);
            this.taskListener.finished(e);
        }
        if (this.enter.getEnv(c) == null) {
            boolean isPkgInfo = tree.sourcefile.isNameCompatible("package-info", JavaFileObject.Kind.SOURCE);
            boolean isModuleInfo = tree.sourcefile.isNameCompatible("module-info", JavaFileObject.Kind.SOURCE);
            if (isModuleInfo) {
                if (this.enter.getEnv(tree.modle) == null) {
                    JCDiagnostic diag = this.diagFactory.fragment(CompilerProperties.Fragments.FileDoesNotContainModule);
                    throw new ClassFinder.BadClassFile(c, filename, diag, this.diagFactory, this.dcfh);
                }
            } else if (isPkgInfo) {
                if (this.enter.getEnv(tree.packge) == null) {
                    JCDiagnostic diag = this.diagFactory.fragment(CompilerProperties.Fragments.FileDoesNotContainPackage(c.location()));
                    throw new ClassFinder.BadClassFile(c, filename, diag, this.diagFactory, this.dcfh);
                }
            } else {
                JCDiagnostic diag = this.diagFactory.fragment(CompilerProperties.Fragments.FileDoesntContainClass(c.getQualifiedName()));
                throw new ClassFinder.BadClassFile(c, filename, diag, this.diagFactory, this.dcfh);
            }
        }
        this.implicitSourceFilesRead = true;
    }

    public void compile(List<JavaFileObject> sourceFileObject) throws Throwable {
        this.compile(sourceFileObject, List.nil(), null, List.nil());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(Collection<JavaFileObject> sourceFileObjects, Collection<String> classnames, Iterable<? extends Processor> processors, Collection<String> addModules) {
        block29: {
            if (!this.taskListener.isEmpty()) {
                this.taskListener.started(new TaskEvent(TaskEvent.Kind.COMPILATION));
            }
            if (this.hasBeenUsed) {
                this.checkReusable();
            }
            this.hasBeenUsed = true;
            this.options.put(Option.XLINT_CUSTOM.primaryName + "-" + Lint.LintCategory.OPTIONS.option, "true");
            this.options.remove(Option.XLINT_CUSTOM.primaryName + Lint.LintCategory.OPTIONS.option);
            this.start_msec = JavaCompiler.now();
            try {
                this.initProcessAnnotations(processors, sourceFileObjects, classnames);
                for (String className : classnames) {
                    int sep = className.indexOf(47);
                    if (sep == -1) continue;
                    this.modules.addExtraAddModules(className.substring(0, sep));
                }
                for (String moduleName : addModules) {
                    this.modules.addExtraAddModules(moduleName);
                }
                this.processAnnotations(this.enterTrees(this.stopIfError(CompileStates.CompileState.ENTER, this.initModules(this.stopIfError(CompileStates.CompileState.ENTER, this.parseFiles(sourceFileObjects))))), classnames);
                if (this.taskListener.isEmpty() && this.implicitSourcePolicy == ImplicitSourcePolicy.NONE) {
                    this.todo.retainFiles(this.inputFiles);
                }
                if (!CompileStates.CompileState.ATTR.isAfter(this.shouldStopPolicyIfNoError)) {
                    switch (this.compilePolicy.ordinal()) {
                        case 0: {
                            this.generate(this.desugar(this.flow(this.attribute(this.todo))));
                            break;
                        }
                        case 1: {
                            Queue<Queue<Env<AttrContext>>> q = this.todo.groupByFile();
                            while (!q.isEmpty() && !this.shouldStop(CompileStates.CompileState.ATTR)) {
                                this.generate(this.desugar(this.flow(this.attribute(q.remove()))));
                            }
                            break;
                        }
                        case 2: {
                            while (!this.todo.isEmpty()) {
                                this.generate(this.desugar(this.flow(this.attribute((Env)this.todo.remove()))));
                            }
                            break;
                        }
                        default: {
                            Assert.error("unknown compile policy");
                        }
                    }
                }
                if (!this.verbose) break block29;
            }
            catch (Abort ex) {
                block30: {
                    try {
                        if (this.devVerbose) {
                            ex.printStackTrace(System.err);
                        }
                        if (this.deferredDiagnosticHandler != null) {
                            this.deferredDiagnosticHandler.reportDeferredDiagnostics();
                            this.log.popDiagnosticHandler(this.deferredDiagnosticHandler);
                        }
                        if (!this.verbose) break block30;
                    }
                    catch (Throwable throwable) {
                        if (this.verbose) {
                            this.elapsed_msec = JavaCompiler.elapsed(this.start_msec);
                            this.log.printVerbose("total", Long.toString(this.elapsed_msec));
                        }
                        this.reportDeferredDiagnostics();
                        if (!this.log.hasDiagnosticListener()) {
                            this.printCount("error", this.errorCount());
                            this.printCount("warn", this.warningCount());
                            this.printSuppressedCount(this.errorCount(), this.log.nsuppressederrors, "count.error.recompile");
                            this.printSuppressedCount(this.warningCount(), this.log.nsuppressedwarns, "count.warn.recompile");
                        }
                        if (!this.taskListener.isEmpty()) {
                            this.taskListener.finished(new TaskEvent(TaskEvent.Kind.COMPILATION));
                        }
                        this.close();
                        if (this.procEnvImpl != null) {
                            this.procEnvImpl.close();
                        }
                        throw throwable;
                    }
                    this.elapsed_msec = JavaCompiler.elapsed(this.start_msec);
                    this.log.printVerbose("total", Long.toString(this.elapsed_msec));
                }
                this.reportDeferredDiagnostics();
                if (!this.log.hasDiagnosticListener()) {
                    this.printCount("error", this.errorCount());
                    this.printCount("warn", this.warningCount());
                    this.printSuppressedCount(this.errorCount(), this.log.nsuppressederrors, "count.error.recompile");
                    this.printSuppressedCount(this.warningCount(), this.log.nsuppressedwarns, "count.warn.recompile");
                }
                if (!this.taskListener.isEmpty()) {
                    this.taskListener.finished(new TaskEvent(TaskEvent.Kind.COMPILATION));
                }
                this.close();
                if (this.procEnvImpl != null) {
                    this.procEnvImpl.close();
                }
            }
            this.elapsed_msec = JavaCompiler.elapsed(this.start_msec);
            this.log.printVerbose("total", Long.toString(this.elapsed_msec));
        }
        this.reportDeferredDiagnostics();
        if (!this.log.hasDiagnosticListener()) {
            this.printCount("error", this.errorCount());
            this.printCount("warn", this.warningCount());
            this.printSuppressedCount(this.errorCount(), this.log.nsuppressederrors, "count.error.recompile");
            this.printSuppressedCount(this.warningCount(), this.log.nsuppressedwarns, "count.warn.recompile");
        }
        if (!this.taskListener.isEmpty()) {
            this.taskListener.finished(new TaskEvent(TaskEvent.Kind.COMPILATION));
        }
        this.close();
        if (this.procEnvImpl != null) {
            this.procEnvImpl.close();
        }
    }

    protected void checkReusable() {
        throw new AssertionError((Object)"attempt to reuse JavaCompiler");
    }

    public List<JCTree.JCCompilationUnit> parseFiles(Iterable<JavaFileObject> fileObjects) {
        return InitialFileParser.instance(this.context).parse(fileObjects);
    }

    public List<JCTree.JCCompilationUnit> parseFiles(Iterable<JavaFileObject> fileObjects, boolean force) {
        if (!force && this.shouldStop(CompileStates.CompileState.PARSE)) {
            return List.nil();
        }
        ListBuffer<JCTree.JCCompilationUnit> trees = new ListBuffer<JCTree.JCCompilationUnit>();
        HashSet<JavaFileObject> filesSoFar = new HashSet<JavaFileObject>();
        for (JavaFileObject fileObject : fileObjects) {
            if (filesSoFar.contains(fileObject)) continue;
            filesSoFar.add(fileObject);
            trees.append(this.parse(fileObject));
        }
        return trees.toList();
    }

    public boolean continueAfterProcessAnnotations() {
        return !this.shouldStop(CompileStates.CompileState.ATTR);
    }

    public List<JCTree.JCCompilationUnit> initModules(List<JCTree.JCCompilationUnit> roots) {
        this.modules.initModules(roots);
        if (roots.isEmpty()) {
            this.enterDone();
        }
        return roots;
    }

    public List<JCTree.JCCompilationUnit> enterTrees(List<JCTree.JCCompilationUnit> roots) {
        TaskEvent e;
        if (!this.taskListener.isEmpty()) {
            for (JCTree.JCCompilationUnit jCCompilationUnit : roots) {
                e = new TaskEvent(TaskEvent.Kind.ENTER, jCCompilationUnit);
                this.taskListener.started(e);
            }
        }
        this.enter.main(roots);
        this.enterDone();
        if (!this.taskListener.isEmpty()) {
            for (JCTree.JCCompilationUnit jCCompilationUnit : roots) {
                e = new TaskEvent(TaskEvent.Kind.ENTER, jCCompilationUnit);
                this.taskListener.finished(e);
            }
        }
        if (this.sourceOutput) {
            ListBuffer<JCTree.JCClassDecl> cdefs = new ListBuffer<JCTree.JCClassDecl>();
            for (JCTree.JCCompilationUnit unit : roots) {
                List<JCTree> defs = unit.defs;
                while (defs.nonEmpty()) {
                    Object a = defs.head;
                    if (a instanceof JCTree.JCClassDecl) {
                        JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)a;
                        cdefs.append(classDecl);
                    }
                    defs = defs.tail;
                }
            }
            this.rootClasses = cdefs.toList();
        }
        for (JCTree.JCCompilationUnit jCCompilationUnit : roots) {
            this.inputFiles.add(jCCompilationUnit.sourcefile);
        }
        return roots;
    }

    public void initProcessAnnotations(Iterable<? extends Processor> processors, Collection<? extends JavaFileObject> initialFiles, Collection<String> initialClassNames) {
        if (processors != null && processors.iterator().hasNext()) {
            this.explicitAnnotationProcessingRequested = true;
        }
        if (this.options.isSet(Option.PROC, "none")) {
            this.processAnnotations = false;
        } else if (this.procEnvImpl == null) {
            this.procEnvImpl = JavacProcessingEnvironment.instance(this.context);
            this.procEnvImpl.setProcessors(processors);
            this.processAnnotations = this.procEnvImpl.atLeastOneProcessor();
            if (this.processAnnotations) {
                if (!this.explicitAnnotationProcessingRequested() && !this.optionsCheckingInitiallyDisabled) {
                    this.log.note(CompilerProperties.Notes.ImplicitAnnotationProcessing);
                }
                this.options.put("parameters", "parameters");
                this.reader.saveParameterNames = true;
                this.keepComments = true;
                this.genEndPos = true;
                if (!this.taskListener.isEmpty()) {
                    this.taskListener.started(new TaskEvent(TaskEvent.Kind.ANNOTATION_PROCESSING));
                }
                this.deferredDiagnosticHandler = new Log.DeferredDiagnosticHandler(this.log);
                this.procEnvImpl.getFiler().setInitialState(initialFiles, initialClassNames);
            } else {
                this.procEnvImpl.close();
            }
        }
    }

    public void processAnnotations(List<JCTree.JCCompilationUnit> roots) {
        this.processAnnotations(roots, List.nil());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAnnotations(List<JCTree.JCCompilationUnit> roots, Collection<String> classnames) {
        block20: {
            if (this.shouldStop(CompileStates.CompileState.PROCESS) && this.processAnnotations) {
                this.deferredDiagnosticHandler.reportDeferredDiagnostics();
                this.log.popDiagnosticHandler(this.deferredDiagnosticHandler);
                return;
            }
            if (!this.processAnnotations) {
                if (this.options.isSet(Option.PROC, "only")) {
                    this.log.warning(CompilerProperties.Warnings.ProcProcOnlyRequestedNoProcs);
                    this.todo.clear();
                }
                if (!classnames.isEmpty()) {
                    this.log.error(CompilerProperties.Errors.ProcNoExplicitAnnotationProcessingRequested(classnames));
                }
                Assert.checkNull(this.deferredDiagnosticHandler);
                return;
            }
            Assert.checkNonNull(this.deferredDiagnosticHandler);
            try {
                List<Symbol.ClassSymbol> classSymbols = List.nil();
                List<Object> pckSymbols = List.nil();
                if (!classnames.isEmpty()) {
                    if (!this.explicitAnnotationProcessingRequested()) {
                        this.log.error(CompilerProperties.Errors.ProcNoExplicitAnnotationProcessingRequested(classnames));
                        this.deferredDiagnosticHandler.reportDeferredDiagnostics();
                        this.log.popDiagnosticHandler(this.deferredDiagnosticHandler);
                        return;
                    }
                    boolean errors = false;
                    for (String nameStr : classnames) {
                        Symbol sym = this.resolveBinaryNameOrIdent(nameStr);
                        if (sym == null || sym.kind == Kinds.Kind.PCK && !this.processPcks || sym.kind == Kinds.Kind.ABSENT_TYP) {
                            if (sym != this.silentFail) {
                                this.log.error(CompilerProperties.Errors.ProcCantFindClass(nameStr));
                            }
                            errors = true;
                            continue;
                        }
                        try {
                            if (sym.kind == Kinds.Kind.PCK) {
                                sym.complete();
                            }
                            if (sym.exists()) {
                                if (sym.kind == Kinds.Kind.PCK) {
                                    pckSymbols = pckSymbols.prepend((Symbol.PackageSymbol)sym);
                                    continue;
                                }
                                classSymbols = classSymbols.prepend((Symbol.ClassSymbol)sym);
                                continue;
                            }
                            Assert.check(sym.kind == Kinds.Kind.PCK);
                            this.log.warning(CompilerProperties.Warnings.ProcPackageDoesNotExist(nameStr));
                            pckSymbols = pckSymbols.prepend((Symbol.PackageSymbol)sym);
                        }
                        catch (Symbol.CompletionFailure e) {
                            this.log.error(CompilerProperties.Errors.ProcCantFindClass(nameStr));
                            errors = true;
                        }
                    }
                    if (errors) {
                        this.deferredDiagnosticHandler.reportDeferredDiagnostics();
                        this.log.popDiagnosticHandler(this.deferredDiagnosticHandler);
                        return;
                    }
                }
                try {
                    this.annotationProcessingOccurred = this.procEnvImpl.doProcessing(roots, classSymbols, pckSymbols, this.deferredDiagnosticHandler);
                }
                finally {
                    this.procEnvImpl.close();
                }
            }
            catch (Symbol.CompletionFailure ex) {
                this.log.error(CompilerProperties.Errors.CantAccess(ex.sym, ex.getDetailValue()));
                if (this.deferredDiagnosticHandler == null) break block20;
                this.deferredDiagnosticHandler.reportDeferredDiagnostics();
                this.log.popDiagnosticHandler(this.deferredDiagnosticHandler);
            }
        }
    }

    private boolean unrecoverableError() {
        if (this.deferredDiagnosticHandler != null) {
            for (JCDiagnostic d : this.deferredDiagnosticHandler.getDiagnostics()) {
                if (d.getKind() != Diagnostic.Kind.ERROR || d.isFlagSet(JCDiagnostic.DiagnosticFlag.RECOVERABLE)) continue;
                return true;
            }
        }
        return false;
    }

    boolean explicitAnnotationProcessingRequested() {
        return this.explicitAnnotationProcessingRequested || JavaCompiler.explicitAnnotationProcessingRequested(this.options, this.fileManager);
    }

    static boolean explicitAnnotationProcessingRequested(Options options, JavaFileManager fileManager) {
        return options.isSet(Option.PROCESSOR) || options.isSet(Option.PROCESSOR_PATH) || options.isSet(Option.PROCESSOR_MODULE_PATH) || options.isSet(Option.PROC, "only") || options.isSet(Option.PROC, "full") || options.isSet(Option.A) || options.isSet(Option.XPRINT) || fileManager.hasLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH);
    }

    public void setDeferredDiagnosticHandler(Log.DeferredDiagnosticHandler deferredDiagnosticHandler) {
        this.deferredDiagnosticHandler = deferredDiagnosticHandler;
    }

    public Queue<Env<AttrContext>> attribute(Queue<Env<AttrContext>> envs) {
        ListBuffer<Env<AttrContext>> results = new ListBuffer<Env<AttrContext>>();
        while (!envs.isEmpty()) {
            results.append(this.attribute(envs.remove()));
        }
        return this.stopIfError(CompileStates.CompileState.ATTR, results);
    }

    public Env<AttrContext> attribute(Env<AttrContext> env) {
        if (this.compileStates.isDone(env, CompileStates.CompileState.ATTR)) {
            return env;
        }
        if (this.verboseCompilePolicy) {
            this.printNote("[attribute " + env.enclClass.sym + "]");
        }
        if (this.verbose) {
            this.log.printVerbose("checking.attribution", env.enclClass.sym);
        }
        if (!this.taskListener.isEmpty()) {
            TaskEvent e = this.newAnalyzeTaskEvent(env);
            this.taskListener.started(e);
        }
        JavaFileObject prev = this.log.useSource(env.enclClass.sym.sourcefile != null ? env.enclClass.sym.sourcefile : env.toplevel.sourcefile);
        try {
            this.attr.attrib(env);
            if (this.errorCount() > 0 && !this.shouldStop(CompileStates.CompileState.ATTR)) {
                this.attr.postAttr(env.tree);
            }
            this.compileStates.put(env, CompileStates.CompileState.ATTR);
        }
        finally {
            this.log.useSource(prev);
        }
        return env;
    }

    public Queue<Env<AttrContext>> flow(Queue<Env<AttrContext>> envs) {
        ListBuffer<Env<AttrContext>> results = new ListBuffer<Env<AttrContext>>();
        for (Env env : envs) {
            this.flow(env, results);
        }
        return this.stopIfError(CompileStates.CompileState.FLOW, results);
    }

    public Queue<Env<AttrContext>> flow(Env<AttrContext> env) {
        ListBuffer<Env<AttrContext>> results = new ListBuffer<Env<AttrContext>>();
        this.flow(env, results);
        return this.stopIfError(CompileStates.CompileState.FLOW, results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flow(Env<AttrContext> env, Queue<Env<AttrContext>> results) {
        if (this.compileStates.isDone(env, CompileStates.CompileState.FLOW)) {
            results.add(env);
            return;
        }
        try {
            if (this.shouldStop(CompileStates.CompileState.FLOW)) {
                return;
            }
            if (this.verboseCompilePolicy) {
                this.printNote("[flow " + env.enclClass.sym + "]");
            }
            JavaFileObject prev = this.log.useSource(env.enclClass.sym.sourcefile != null ? env.enclClass.sym.sourcefile : env.toplevel.sourcefile);
            try {
                this.make.at(0);
                TreeMaker localMake = this.make.forToplevel(env.toplevel);
                this.flow.analyzeTree(env, localMake);
                this.compileStates.put(env, CompileStates.CompileState.FLOW);
                if (this.shouldStop(CompileStates.CompileState.FLOW)) {
                    return;
                }
                this.analyzer.flush(env);
                results.add(env);
            }
            finally {
                this.log.useSource(prev);
            }
        }
        finally {
            if (!this.taskListener.isEmpty()) {
                TaskEvent e = this.newAnalyzeTaskEvent(env);
                this.taskListener.finished(e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TaskEvent newAnalyzeTaskEvent(Env<AttrContext> env) {
        Symbol.ClassSymbol sym;
        JCTree.JCCompilationUnit toplevel = env.toplevel;
        if (env.enclClass.sym == this.syms.predefClass) {
            if (TreeInfo.isModuleInfo(toplevel)) {
                sym = toplevel.modle.module_info;
                return new TaskEvent(TaskEvent.Kind.ANALYZE, toplevel, sym);
            } else {
                if (!TreeInfo.isPackageInfo(toplevel)) throw new IllegalStateException("unknown env.toplevel");
                sym = toplevel.packge.package_info;
            }
            return new TaskEvent(TaskEvent.Kind.ANALYZE, toplevel, sym);
        } else {
            sym = env.enclClass.sym;
        }
        return new TaskEvent(TaskEvent.Kind.ANALYZE, toplevel, sym);
    }

    public Queue<Pair<Env<AttrContext>, JCTree.JCClassDecl>> desugar(Queue<Env<AttrContext>> envs) {
        ListBuffer<Pair<Env<AttrContext>, JCTree.JCClassDecl>> results = new ListBuffer<Pair<Env<AttrContext>, JCTree.JCClassDecl>>();
        for (Env env : envs) {
            this.desugar(env, results);
        }
        return this.stopIfError(CompileStates.CompileState.FLOW, results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void desugar(final Env<AttrContext> env, Queue<Pair<Env<AttrContext>, JCTree.JCClassDecl>> results) {
        if (this.shouldStop(CompileStates.CompileState.TRANSTYPES)) {
            return;
        }
        if (this.implicitSourcePolicy == ImplicitSourcePolicy.NONE && !this.inputFiles.contains(env.toplevel.sourcefile)) {
            return;
        }
        if (!this.modules.multiModuleMode && env.toplevel.modle != this.modules.getDefaultModule()) {
            return;
        }
        if (this.compileStates.isDone(env, CompileStates.CompileState.LOWER)) {
            results.addAll((Collection<Pair<Env<AttrContext>, JCTree.JCClassDecl>>)this.desugaredEnvs.get(env));
            return;
        }
        class ScanNested
        extends TreeScanner {
            Set<Env<AttrContext>> dependencies = new LinkedHashSet<Env<AttrContext>>();
            protected boolean hasLambdas;
            protected boolean hasPatterns;

            ScanNested() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visitClassDef(JCTree.JCClassDecl node) {
                Type st = JavaCompiler.this.types.supertype(node.sym.type);
                boolean envForSuperTypeFound = false;
                while (!envForSuperTypeFound && st.hasTag(TypeTag.CLASS)) {
                    Symbol.ClassSymbol c = st.tsym.outermostClass();
                    Env<AttrContext> stEnv = JavaCompiler.this.enter.getEnv(c);
                    if (stEnv != null && env != stEnv) {
                        if (this.dependencies.add(stEnv)) {
                            boolean prevHasLambdas = this.hasLambdas;
                            boolean prevHasPatterns = this.hasPatterns;
                            try {
                                this.scan(stEnv.tree);
                            }
                            finally {
                                this.hasLambdas = prevHasLambdas;
                                this.hasPatterns = prevHasPatterns;
                            }
                        }
                        envForSuperTypeFound = true;
                    }
                    st = JavaCompiler.this.types.supertype(st);
                }
                super.visitClassDef(node);
            }

            @Override
            public void visitLambda(JCTree.JCLambda tree) {
                this.hasLambdas = true;
                super.visitLambda(tree);
            }

            @Override
            public void visitReference(JCTree.JCMemberReference tree) {
                this.hasLambdas = true;
                super.visitReference(tree);
            }

            @Override
            public void visitBindingPattern(JCTree.JCBindingPattern tree) {
                this.hasPatterns = true;
                super.visitBindingPattern(tree);
            }

            @Override
            public void visitRecordPattern(JCTree.JCRecordPattern that) {
                this.hasPatterns = true;
                super.visitRecordPattern(that);
            }

            @Override
            public void visitSwitch(JCTree.JCSwitch tree) {
                this.hasPatterns |= tree.patternSwitch;
                super.visitSwitch(tree);
            }

            @Override
            public void visitSwitchExpression(JCTree.JCSwitchExpression tree) {
                this.hasPatterns |= tree.patternSwitch;
                super.visitSwitchExpression(tree);
            }
        }
        ScanNested scanner = new ScanNested();
        scanner.scan(env.tree);
        for (Env<AttrContext> dep : scanner.dependencies) {
            if (this.compileStates.isDone(dep, CompileStates.CompileState.FLOW)) continue;
            this.desugaredEnvs.put(dep, this.desugar(this.flow(this.attribute(dep))));
        }
        if (this.shouldStop(CompileStates.CompileState.TRANSTYPES)) {
            return;
        }
        if (this.verboseCompilePolicy) {
            this.printNote("[desugar " + env.enclClass.sym + "]");
        }
        JavaFileObject prev = this.log.useSource(env.enclClass.sym.sourcefile != null ? env.enclClass.sym.sourcefile : env.toplevel.sourcefile);
        try {
            JCTree untranslated = env.tree;
            this.make.at(0);
            TreeMaker localMake = this.make.forToplevel(env.toplevel);
            if (env.tree.hasTag(JCTree.Tag.PACKAGEDEF) || env.tree.hasTag(JCTree.Tag.MODULEDEF)) {
                if (!this.sourceOutput) {
                    if (this.shouldStop(CompileStates.CompileState.LOWER)) {
                        return;
                    }
                    List<JCTree> def = this.lower.translateTopLevelClass(env, env.tree, localMake);
                    if (def.head != null) {
                        Assert.check(def.tail.isEmpty());
                        results.add(new Pair<Env<AttrContext>, JCTree.JCClassDecl>(env, (JCTree.JCClassDecl)def.head));
                    }
                }
                return;
            }
            if (this.shouldStop(CompileStates.CompileState.TRANSTYPES)) {
                return;
            }
            env.tree = this.transTypes.translateTopLevelClass(env.tree, localMake);
            this.compileStates.put(env, CompileStates.CompileState.TRANSTYPES);
            if (this.shouldStop(CompileStates.CompileState.TRANSLITERALS)) {
                return;
            }
            env.tree = TransLiterals.instance(this.context).translateTopLevelClass(env, env.tree, localMake);
            this.compileStates.put(env, CompileStates.CompileState.TRANSLITERALS);
            if (this.shouldStop(CompileStates.CompileState.TRANSPATTERNS)) {
                return;
            }
            if (scanner.hasPatterns) {
                env.tree = TransPatterns.instance(this.context).translateTopLevelClass(env, env.tree, localMake);
            }
            this.compileStates.put(env, CompileStates.CompileState.TRANSPATTERNS);
            if (scanner.hasLambdas) {
                if (this.shouldStop(CompileStates.CompileState.UNLAMBDA)) {
                    return;
                }
                env.tree = LambdaToMethod.instance(this.context).translateTopLevelClass(env, env.tree, localMake);
                this.compileStates.put(env, CompileStates.CompileState.UNLAMBDA);
            }
            if (this.shouldStop(CompileStates.CompileState.LOWER)) {
                return;
            }
            if (this.sourceOutput) {
                JCTree.JCClassDecl classDecl;
                JCTree.JCClassDecl cdef = (JCTree.JCClassDecl)env.tree;
                if (untranslated instanceof JCTree.JCClassDecl && this.rootClasses.contains(classDecl = (JCTree.JCClassDecl)untranslated)) {
                    results.add(new Pair<Env<AttrContext>, JCTree.JCClassDecl>(env, cdef));
                }
                return;
            }
            List<JCTree> cdefs = this.lower.translateTopLevelClass(env, env.tree, localMake);
            this.compileStates.put(env, CompileStates.CompileState.LOWER);
            if (this.shouldStop(CompileStates.CompileState.LOWER)) {
                return;
            }
            List<JCTree> l = cdefs;
            while (l.nonEmpty()) {
                JCTree.JCClassDecl cdef = (JCTree.JCClassDecl)l.head;
                results.add(new Pair<Env<AttrContext>, JCTree.JCClassDecl>(env, cdef));
                l = l.tail;
            }
        }
        finally {
            this.log.useSource(prev);
        }
    }

    public void generate(Queue<Pair<Env<AttrContext>, JCTree.JCClassDecl>> queue) {
        this.generate(queue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(Queue<Pair<Env<AttrContext>, JCTree.JCClassDecl>> queue, Queue<JavaFileObject> results) {
        if (this.shouldStop(CompileStates.CompileState.GENERATE)) {
            return;
        }
        for (Pair pair : queue) {
            Env env = (Env)pair.fst;
            JCTree.JCClassDecl cdef = (JCTree.JCClassDecl)pair.snd;
            if (this.verboseCompilePolicy) {
                this.printNote("[generate " + (this.sourceOutput ? " source" : "code") + " " + cdef.sym + "]");
            }
            if (!this.taskListener.isEmpty()) {
                TaskEvent e = new TaskEvent(TaskEvent.Kind.GENERATE, env.toplevel, cdef.sym);
                this.taskListener.started(e);
            }
            JavaFileObject prev = this.log.useSource(env.enclClass.sym.sourcefile != null ? env.enclClass.sym.sourcefile : env.toplevel.sourcefile);
            try {
                JavaFileObject file;
                if (this.sourceOutput) {
                    file = this.printSource(env, cdef);
                } else {
                    if (this.fileManager.hasLocation(StandardLocation.NATIVE_HEADER_OUTPUT) && this.jniWriter.needsHeader(cdef.sym)) {
                        this.jniWriter.write(cdef.sym);
                    }
                    file = this.genCode(env, cdef);
                }
                if (results != null && file != null) {
                    results.add(file);
                }
            }
            catch (IOException | UncheckedIOException | FileSystemNotFoundException | InvalidPathException | ReadOnlyFileSystemException ex) {
                this.log.error(cdef.pos(), CompilerProperties.Errors.ClassCantWrite(cdef.sym, ex.getMessage()));
                return;
            }
            finally {
                this.log.useSource(prev);
            }
            if (this.taskListener.isEmpty()) continue;
            TaskEvent e = new TaskEvent(TaskEvent.Kind.GENERATE, env.toplevel, cdef.sym);
            this.taskListener.finished(e);
        }
    }

    Map<JCTree.JCCompilationUnit, Queue<Env<AttrContext>>> groupByFile(Queue<Env<AttrContext>> envs) {
        LinkedHashMap<JCTree.JCCompilationUnit, Queue<Env<AttrContext>>> map = new LinkedHashMap<JCTree.JCCompilationUnit, Queue<Env<AttrContext>>>();
        for (Env env : envs) {
            ListBuffer sublist = (ListBuffer)map.get(env.toplevel);
            if (sublist == null) {
                sublist = new ListBuffer();
                map.put(env.toplevel, sublist);
            }
            sublist.add(env);
        }
        return map;
    }

    JCTree.JCClassDecl removeMethodBodies(JCTree.JCClassDecl cdef) {
        final boolean isInterface = (cdef.mods.flags & 0x200L) != 0L;
        class MethodBodyRemover
        extends TreeTranslator {
            MethodBodyRemover() {
            }

            @Override
            public void visitMethodDef(JCTree.JCMethodDecl tree) {
                tree.mods.flags &= 0xFFFFFFFFFFFFFFDFL;
                for (JCTree.JCVariableDecl vd : tree.params) {
                    vd.mods.flags &= 0xFFFFFFFFFFFFFFEFL;
                }
                tree.body = null;
                super.visitMethodDef(tree);
            }

            @Override
            public void visitVarDef(JCTree.JCVariableDecl tree) {
                if (tree.init != null && tree.init.type.constValue() == null) {
                    tree.init = null;
                }
                super.visitVarDef(tree);
            }

            @Override
            public void visitClassDef(JCTree.JCClassDecl tree) {
                ListBuffer<JCTree> newdefs = new ListBuffer<JCTree>();
                List<JCTree> it = tree.defs;
                while (it.tail != null) {
                    JCTree t = (JCTree)it.head;
                    switch (t.getTag()) {
                        case CLASSDEF: {
                            if (!isInterface && (((JCTree.JCClassDecl)t).mods.flags & 5L) == 0L && ((((JCTree.JCClassDecl)t).mods.flags & 2L) != 0L || ((JCTree.JCClassDecl)t).sym.packge().getQualifiedName() != JavaCompiler.this.names.java_lang)) break;
                            newdefs.append(t);
                            break;
                        }
                        case METHODDEF: {
                            if (!isInterface && (((JCTree.JCMethodDecl)t).mods.flags & 5L) == 0L && ((JCTree.JCMethodDecl)t).sym.name != JavaCompiler.this.names.init && ((((JCTree.JCMethodDecl)t).mods.flags & 2L) != 0L || ((JCTree.JCMethodDecl)t).sym.packge().getQualifiedName() != JavaCompiler.this.names.java_lang)) break;
                            newdefs.append(t);
                            break;
                        }
                        case VARDEF: {
                            if (!isInterface && (((JCTree.JCVariableDecl)t).mods.flags & 5L) == 0L && ((((JCTree.JCVariableDecl)t).mods.flags & 2L) != 0L || ((JCTree.JCVariableDecl)t).sym.packge().getQualifiedName() != JavaCompiler.this.names.java_lang)) break;
                            newdefs.append(t);
                            break;
                        }
                    }
                    it = it.tail;
                }
                tree.defs = newdefs.toList();
                super.visitClassDef(tree);
            }
        }
        MethodBodyRemover r = new MethodBodyRemover();
        return r.translate(cdef);
    }

    public void reportDeferredDiagnostics() {
        if (this.errorCount() == 0 && this.annotationProcessingOccurred && this.implicitSourceFilesRead && this.implicitSourcePolicy == ImplicitSourcePolicy.UNSET) {
            if (this.explicitAnnotationProcessingRequested()) {
                this.log.warning(CompilerProperties.Warnings.ProcUseImplicit);
            } else {
                this.log.warning(CompilerProperties.Warnings.ProcUseProcOrImplicit);
            }
        }
        this.chk.reportDeferredDiagnostics();
        this.preview.reportDeferredDiagnostics();
        if (this.log.compressedOutput) {
            this.log.mandatoryNote(null, CompilerProperties.Notes.CompressedDiags);
        }
    }

    public void enterDone() {
        this.enterDone = true;
        this.annotate.enterDone();
    }

    public boolean isEnterDone() {
        return this.enterDone;
    }

    private Name readModuleName(JavaFileObject fo) {
        return this.parseAndGetName(fo, t -> {
            JCTree.JCModuleDecl md = t.getModuleDecl();
            return md != null ? TreeInfo.fullName(md.getName()) : null;
        });
    }

    private Name findPackageInFile(JavaFileObject fo) {
        return this.parseAndGetName(fo, t -> t.getPackage() != null ? TreeInfo.fullName(t.getPackage().getPackageName()) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Name parseAndGetName(JavaFileObject fo, Function<JCTree.JCCompilationUnit, Name> tree2Name) {
        Log.DiscardDiagnosticHandler dh = new Log.DiscardDiagnosticHandler(this.log);
        JavaFileObject prevSource = this.log.useSource(fo);
        try {
            JCTree.JCCompilationUnit t = this.parse(fo, fo.getCharContent(false), true);
            Name name = tree2Name.apply(t);
            return name;
        }
        catch (IOException e) {
            Name name = null;
            return name;
        }
        finally {
            this.log.popDiagnosticHandler(dh);
            this.log.useSource(prevSource);
        }
    }

    public void close() {
        this.rootClasses = null;
        this.finder = null;
        this.reader = null;
        this.make = null;
        this.writer = null;
        this.enter = null;
        if (this.todo != null) {
            this.todo.clear();
        }
        this.todo = null;
        this.parserFactory = null;
        this.syms = null;
        this.source = null;
        this.attr = null;
        this.chk = null;
        this.gen = null;
        this.flow = null;
        this.transTypes = null;
        this.lower = null;
        this.annotate = null;
        this.types = null;
        this.log.flush();
        try {
            this.fileManager.flush();
        }
        catch (IOException e) {
            throw new Abort(e);
        }
        finally {
            if (this.names != null) {
                this.names.dispose();
            }
            this.names = null;
            Throwable fatalError = null;
            for (Closeable c : this.closeables) {
                try {
                    c.close();
                }
                catch (IOException e) {
                    if (fatalError == null) {
                        JCDiagnostic msg = this.diagFactory.fragment(CompilerProperties.Fragments.FatalErrCantClose);
                        fatalError = new FatalError(msg, (Throwable)e);
                        continue;
                    }
                    fatalError.addSuppressed(e);
                }
            }
            if (fatalError != null) {
                throw fatalError;
            }
            this.closeables = List.nil();
        }
    }

    protected void printNote(String lines) {
        this.log.printRawLines(Log.WriterKind.NOTICE, lines);
    }

    public void printCount(String kind, int count) {
        if (count != 0) {
            String key = count == 1 ? "count." + kind : "count." + kind + ".plural";
            this.log.printLines(Log.WriterKind.ERROR, key, String.valueOf(count));
            this.log.flush(Log.WriterKind.ERROR);
        }
    }

    private void printSuppressedCount(int shown, int suppressed, String diagKey) {
        if (suppressed > 0) {
            int total = shown + suppressed;
            this.log.printLines(Log.WriterKind.ERROR, diagKey, String.valueOf(shown), String.valueOf(total));
            this.log.flush(Log.WriterKind.ERROR);
        }
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    private static long elapsed(long then) {
        return JavaCompiler.now() - then;
    }

    public void newRound() {
        this.inputFiles.clear();
        this.todo.clear();
    }

    static {
        DEFAULT_COMPILE_POLICY = CompilePolicy.BY_TODO;
    }

    protected static enum CompilePolicy {
        SIMPLE,
        BY_FILE,
        BY_TODO;


        static CompilePolicy decode(String option) {
            if (option == null) {
                return DEFAULT_COMPILE_POLICY;
            }
            if (option.equals("simple")) {
                return SIMPLE;
            }
            if (option.equals("byfile")) {
                return BY_FILE;
            }
            if (option.equals("bytodo")) {
                return BY_TODO;
            }
            return DEFAULT_COMPILE_POLICY;
        }
    }

    protected static enum ImplicitSourcePolicy {
        NONE,
        CLASS,
        UNSET;


        static ImplicitSourcePolicy decode(String option) {
            if (option == null) {
                return UNSET;
            }
            if (option.equals("none")) {
                return NONE;
            }
            if (option.equals("class")) {
                return CLASS;
            }
            return UNSET;
        }
    }

    public static class InitialFileParser
    implements InitialFileParserIntf {
        public static final Context.Key<InitialFileParserIntf> initialParserKey = new Context.Key();
        private final JavaCompiler compiler;

        public static InitialFileParserIntf instance(Context context) {
            InitialFileParserIntf instance = context.get(initialParserKey);
            if (instance == null) {
                instance = new InitialFileParser(context);
            }
            return instance;
        }

        private InitialFileParser(Context context) {
            context.put(initialParserKey, this);
            this.compiler = JavaCompiler.instance(context);
        }

        @Override
        public List<JCTree.JCCompilationUnit> parse(Iterable<JavaFileObject> fileObjects) {
            return this.compiler.parseFiles(fileObjects, false);
        }
    }

    public static interface InitialFileParserIntf {
        public List<JCTree.JCCompilationUnit> parse(Iterable<JavaFileObject> var1);
    }
}

