/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.ApisupportAntUtils;
import org.netbeans.modules.apisupport.project.NbModuleType;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.api.EditableManifest;
import org.netbeans.modules.apisupport.project.api.LayerHandle;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.ClusterUtils;
import org.netbeans.modules.apisupport.project.universe.HarnessVersion;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NbModuleProjectGenerator {
    public static final String PLATFORM_PROPERTIES_PATH = "nbproject/platform.properties";
    private static final String loggerName = "org.netbeans.ui.metrics.nbmodule";
    private static final String loggerKey = "USG_PROJECT_CREATE_NBMODULE";

    private NbModuleProjectGenerator() {
    }

    private static void logUsage(String type) {
        LogRecord logRecord = new LogRecord(Level.INFO, loggerKey);
        logRecord.setLoggerName(loggerName);
        logRecord.setParameters(new Object[]{type});
        Logger.getLogger(loggerName).log(logRecord);
    }

    public static void createStandAloneModule(final File projectDir, final String cnb, final String name, final String bundlePath, final String layerPath, final String platformID, final boolean osgi, final boolean tests) throws IOException {
        try {
            NbModuleProjectGenerator.logUsage("StandAloneModule");
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    FileObject dirFO = FileUtil.createFolder((File)projectDir);
                    if (ProjectManager.getDefault().findProject(dirFO) != null) {
                        throw new IllegalArgumentException("Already a project in " + dirFO);
                    }
                    NbModuleProjectGenerator.createProjectXML(dirFO, cnb, NbModuleType.STANDALONE, osgi);
                    NbModuleProjectGenerator.createPlatformProperties(dirFO, platformID);
                    NbModuleProjectGenerator.createManifest(dirFO, cnb, bundlePath, layerPath, osgi);
                    if (bundlePath != null) {
                        NbModuleProjectGenerator.createBundle(dirFO, bundlePath, name);
                    }
                    if (layerPath != null) {
                        NbModuleProjectGenerator.createLayerInSrc(dirFO, layerPath);
                    }
                    NbModuleProjectGenerator.createEmptyTestDir(dirFO, tests);
                    NbModuleProjectGenerator.createInitialProperties(dirFO);
                    ModuleList.refresh();
                    ProjectManager.getDefault().clearNonProjectCache();
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    public static void createSuiteComponentModule(final File projectDir, final String cnb, final String name, final String bundlePath, final String layerPath, final File suiteDir, final boolean osgi, final boolean tests) throws IOException {
        try {
            NbModuleProjectGenerator.logUsage("SuiteComponentModule");
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    FileObject dirFO = FileUtil.createFolder((File)projectDir);
                    if (ProjectManager.getDefault().findProject(dirFO) != null) {
                        throw new IllegalArgumentException("Already a project in " + dirFO);
                    }
                    NbModuleProjectGenerator.createProjectXML(dirFO, cnb, NbModuleType.SUITE_COMPONENT, osgi);
                    NbModuleProjectGenerator.createSuiteProperties(dirFO, suiteDir);
                    NbModuleProjectGenerator.createManifest(dirFO, cnb, bundlePath, layerPath, osgi);
                    if (bundlePath != null) {
                        NbModuleProjectGenerator.createBundle(dirFO, bundlePath, name);
                    }
                    if (layerPath != null) {
                        NbModuleProjectGenerator.createLayerInSrc(dirFO, layerPath);
                    }
                    NbModuleProjectGenerator.createEmptyTestDir(dirFO, tests);
                    NbModuleProjectGenerator.createInitialProperties(dirFO);
                    ModuleList.refresh();
                    ProjectManager.getDefault().clearNonProjectCache();
                    NbModuleProjectGenerator.appendToSuite(cnb, dirFO, suiteDir);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    public static void createSuiteLibraryModule(final File projectDir, final String cnb, final String name, final String bundlePath, final File suiteDir, final File license, final File[] jars) throws IOException {
        try {
            NbModuleProjectGenerator.logUsage("SuiteLibraryModule");
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    FileObject dirFO = FileUtil.createFolder((File)projectDir);
                    if (ProjectManager.getDefault().findProject(dirFO) != null) {
                        throw new IllegalArgumentException("Already a project in " + dirFO);
                    }
                    EditableProperties props = new EditableProperties(true);
                    props.put("is.autoload", "true");
                    TreeSet<String> packageList = new TreeSet<String>();
                    HashMap<String, String> classPathExtensions = new HashMap<String, String>();
                    for (File jar : jars) {
                        try {
                            String[] entry = ApisupportAntUtils.copyClassPathExtensionJar(projectDir, jar);
                            if (entry == null) continue;
                            classPathExtensions.put(entry[0], entry[1]);
                            ApisupportAntUtils.scanJarForPackageNames(packageList, jar);
                        }
                        catch (IOException e) {
                            Util.err.notify((Throwable)e);
                        }
                    }
                    if (license != null && license.exists()) {
                        FileObject fo = FileUtil.toFileObject((File)license);
                        try {
                            FileUtil.copyFile((FileObject)fo, (FileObject)dirFO, (String)fo.getName());
                            props.put("license.file", "${basedir}/" + fo.getNameExt());
                        }
                        catch (IOException e) {
                            Util.err.notify((Throwable)e);
                        }
                    }
                    ProjectXMLManager.generateLibraryModuleTemplate(NbModuleProjectGenerator.createFileObject(dirFO, "nbproject/project.xml"), cnb, NbModuleType.SUITE_COMPONENT, packageList, classPathExtensions);
                    NbModuleProjectGenerator.createSuiteProperties(dirFO, suiteDir);
                    NbModuleProjectGenerator.createManifest(dirFO, cnb, bundlePath, null, false);
                    NbModuleProjectGenerator.createBundle(dirFO, bundlePath, name);
                    FileObject bundleFO = NbModuleProjectGenerator.createFileObject(dirFO, "nbproject/project.properties");
                    Util.storeProperties((FileObject)bundleFO, (EditableProperties)props);
                    ModuleList.refresh();
                    ProjectManager.getDefault().clearNonProjectCache();
                    NbModuleProjectGenerator.appendToSuite(cnb, dirFO, suiteDir);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    public static void createNetBeansOrgModule(final File projectDir, final String cnb, final String name, final String bundlePath, final String layerPath, final boolean osgi) throws IOException {
        try {
            NbModuleProjectGenerator.logUsage("NetBeansOrgModule");
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    File nborg = ModuleList.findNetBeansOrg(projectDir);
                    if (nborg == null) {
                        throw new IllegalArgumentException(projectDir + " doesn't point to a top-level directory within the netbeans.org main or contrib repositories");
                    }
                    FileObject dirFO = FileUtil.createFolder((File)projectDir);
                    if (ProjectManager.getDefault().findProject(dirFO) != null) {
                        throw new IllegalArgumentException("Already a project in " + dirFO);
                    }
                    NbModuleProjectGenerator.createNetBeansOrgBuildXML(dirFO, cnb, nborg);
                    NbModuleProjectGenerator.createProjectXML(dirFO, cnb, NbModuleType.NETBEANS_ORG, osgi);
                    NbModuleProjectGenerator.createManifest(dirFO, cnb, bundlePath, layerPath, osgi);
                    NbModuleProjectGenerator.createBundle(dirFO, bundlePath, name);
                    if (layerPath != null) {
                        NbModuleProjectGenerator.createLayerInSrc(dirFO, layerPath);
                    }
                    NbModuleProjectGenerator.createEmptyTestDir(dirFO, false);
                    NbModuleProjectGenerator.createInitialProperties(dirFO);
                    ModuleList.refresh();
                    ProjectManager.getDefault().clearNonProjectCache();
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    private static void createProjectXML(FileObject projectDir, String cnb, NbModuleType type, boolean osgi) throws IOException {
        String[] stringArray;
        if (osgi) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "org.netbeans.libs.osgi";
        } else {
            stringArray = new String[]{};
        }
        String[] deps = stringArray;
        ProjectXMLManager.generateEmptyModuleTemplate(NbModuleProjectGenerator.createFileObject(projectDir, "nbproject/project.xml"), cnb, type, deps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createNetBeansOrgBuildXML(FileObject projectDir, String cnb, File nborg) throws IOException {
        FileObject buildScript = NbModuleProjectGenerator.createFileObject(projectDir, "build.xml");
        Document prjDoc = XMLUtil.createDocument((String)"project", null, null, null);
        Element prjEl = prjDoc.getDocumentElement();
        prjEl.setAttribute("name", PropertyUtils.relativizeFile((File)nborg, (File)FileUtil.toFile((FileObject)projectDir)));
        prjEl.setAttribute("default", "netbeans");
        prjEl.setAttribute("basedir", ".");
        Element el = prjDoc.createElement("description");
        el.appendChild(prjDoc.createTextNode("Builds, tests, and runs the project " + cnb));
        prjEl.appendChild(el);
        el = prjDoc.createElement("import");
        el.setAttribute("file", PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)projectDir), (File)new File(nborg, "nbbuild/templates/projectized.xml")));
        prjEl.appendChild(el);
        try (OutputStream os = buildScript.getOutputStream();){
            XMLUtil.write((Document)prjDoc, (OutputStream)os, (String)"UTF-8");
        }
    }

    public static void createSuiteProperties(FileObject projectDir, File suiteDir) throws IOException {
        String suitePropertiesLocation;
        String suiteLocation;
        File projectDirF = FileUtil.toFile((FileObject)projectDir);
        String rel = PropertyUtils.relativizeFile((File)projectDirF, (File)suiteDir);
        if (rel != null) {
            suiteLocation = "${basedir}/" + rel;
            suitePropertiesLocation = "nbproject/suite.properties";
        } else {
            suiteLocation = suiteDir.getAbsolutePath();
            suitePropertiesLocation = "nbproject/private/suite-private.properties";
        }
        EditableProperties props = new EditableProperties(true);
        props.setProperty("suite.dir", suiteLocation);
        FileObject suiteProperties = projectDir.getFileObject(suitePropertiesLocation);
        if (suiteProperties == null || !suiteProperties.isValid()) {
            suiteProperties = NbModuleProjectGenerator.createFileObject(projectDir, suitePropertiesLocation);
        }
        Util.storeProperties((FileObject)suiteProperties, (EditableProperties)props);
    }

    private static void appendToSuite(String cnb, FileObject projectDir, File suiteDir) throws IOException {
        File projectDirF = FileUtil.toFile((FileObject)projectDir);
        File suiteGlobalPropsFile = new File(suiteDir, "nbproject/project.properties");
        FileObject suiteGlobalPropFO = suiteGlobalPropsFile.exists() ? FileUtil.toFileObject((File)suiteGlobalPropsFile) : NbModuleProjectGenerator.createFileObject(suiteGlobalPropsFile);
        EditableProperties globalProps = Util.loadProperties((FileObject)suiteGlobalPropFO);
        String projectPropKey = "project." + cnb;
        String rel = PropertyUtils.relativizeFile((File)suiteDir, (File)projectDirF);
        if (rel != null) {
            globalProps.setProperty(projectPropKey, rel);
        } else {
            File suitePrivPropsFile = new File(suiteDir, "nbproject/private/private.properties");
            FileObject suitePrivPropFO = suitePrivPropsFile.exists() ? FileUtil.toFileObject((File)suitePrivPropsFile) : NbModuleProjectGenerator.createFileObject(suitePrivPropsFile);
            EditableProperties privProps = Util.loadProperties((FileObject)suitePrivPropFO);
            privProps.setProperty(projectPropKey, projectDirF.getAbsolutePath());
            Util.storeProperties((FileObject)suitePrivPropFO, (EditableProperties)privProps);
        }
        String modulesProp = globalProps.getProperty("modules");
        if (modulesProp == null) {
            modulesProp = "";
        }
        if (modulesProp.length() > 0) {
            modulesProp = modulesProp + ":";
        }
        modulesProp = modulesProp + "${" + projectPropKey + "}";
        globalProps.setProperty("modules", modulesProp.split("(?<=:)", -1));
        Util.storeProperties((FileObject)suiteGlobalPropFO, (EditableProperties)globalProps);
    }

    private static void createPlatformProperties(FileObject projectDir, String platformID) throws IOException {
        FileObject plafPropsFO = NbModuleProjectGenerator.createFileObject(projectDir, PLATFORM_PROPERTIES_PATH);
        EditableProperties props = new EditableProperties(true);
        props.put("nbplatform.active", platformID);
        NbPlatform plaf = NbPlatform.getPlatformByID(platformID);
        if (plaf != null && plaf.getHarnessVersion().compareTo(HarnessVersion.V65) > 0) {
            File[] files;
            ArrayList<String> clusterPath = new ArrayList<String>();
            for (File file : files = plaf.getDestDir().listFiles()) {
                if (!ClusterUtils.isValidCluster(file)) continue;
                clusterPath.add(SuiteProperties.toPlatformClusterEntry(file.getName()));
            }
            props.setProperty("cluster.path", SuiteUtils.getAntProperty(clusterPath));
        }
        Util.storeProperties((FileObject)plafPropsFO, (EditableProperties)props);
    }

    private static void createManifest(FileObject projectDir, String cnb, String bundlePath, String layerPath, boolean osgi) throws IOException {
        FileObject manifestFO = NbModuleProjectGenerator.createFileObject(projectDir, "manifest.mf");
        NbModuleProjectGenerator.createManifest(manifestFO, cnb, "1.0", bundlePath, layerPath, osgi);
    }

    static void createManifest(FileObject manifest, String cnb, String specVer, String bundlePath, String layerPath, boolean osgi) throws IOException {
        EditableManifest em = new EditableManifest();
        if (osgi) {
            em.setAttribute("Bundle-SymbolicName", cnb, null);
            em.setAttribute("Bundle-Version", specVer, null);
            em.setAttribute("Bundle-Localization", bundlePath.replaceFirst("[.]properties$", ""), null);
            em.setAttribute("Bundle-Name", "%OpenIDE-Module-Name", null);
        } else {
            em.setAttribute("OpenIDE-Module", cnb, null);
            em.setAttribute("OpenIDE-Module-Specification-Version", specVer, null);
            em.setAttribute("OpenIDE-Module-Localizing-Bundle", bundlePath, null);
        }
        em.setAttribute("AutoUpdate-Show-In-Client", Boolean.TRUE.toString(), null);
        if (layerPath != null) {
            em.setAttribute("OpenIDE-Module-Layer", layerPath, null);
        }
        Util.storeManifest((FileObject)manifest, (EditableManifest)em);
    }

    private static void createBundle(FileObject projectDir, String bundlePath, String name) throws IOException {
        String pathToBundle = "src/" + bundlePath.replace('\\', '/');
        FileObject bundleFO = NbModuleProjectGenerator.createFileObject(projectDir, pathToBundle);
        EditableProperties props = new EditableProperties(true);
        props.put("OpenIDE-Module-Name", name);
        Util.storeProperties((FileObject)bundleFO, (EditableProperties)props);
    }

    private static void createLayerInSrc(FileObject projectDir, String layerPath) throws IOException {
        LayerHandle.createLayer((FileObject)projectDir, (String)("src/" + layerPath));
    }

    private static void createEmptyTestDir(FileObject projectDir, boolean tests) throws IOException {
        if (tests) {
            FileUtil.createFolder((FileObject)projectDir, (String)"test/unit/src");
        }
    }

    private static void createInitialProperties(FileObject projectDir) throws IOException {
        EditableProperties props = new EditableProperties(false);
        props.put("javac.source", "1.8");
        props.put("javac.compilerargs", "-Xlint -Xlint:-serial");
        FileObject f = NbModuleProjectGenerator.createFileObject(projectDir, "nbproject/project.properties");
        Util.storeProperties((FileObject)f, (EditableProperties)props);
    }

    private static FileObject createFileObject(FileObject dir, String relToDir) throws IOException {
        FileObject createdFO = dir.getFileObject(relToDir);
        if (createdFO != null) {
            throw new IllegalArgumentException("File " + createdFO + " already exists.");
        }
        createdFO = FileUtil.createData((FileObject)dir, (String)relToDir);
        return createdFO;
    }

    private static FileObject createFileObject(File fileToCreate) throws IOException {
        File parent = fileToCreate.getParentFile();
        if (parent == null) {
            throw new IllegalArgumentException("Cannot create: " + fileToCreate);
        }
        if (!parent.exists()) {
            parent.mkdirs();
        }
        return NbModuleProjectGenerator.createFileObject(FileUtil.toFileObject((File)parent), fileToCreate.getName());
    }
}

