/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.dashboard;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.dashboard.DefaultDashboardDisplayer;
import org.netbeans.spi.dashboard.DashboardDisplayer;
import org.netbeans.spi.dashboard.DashboardWidget;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class DashboardManager {
    private static final DashboardManager INSTANCE = new DashboardManager();
    private List<DashboardDisplayer.WidgetReference> mainWidgets;
    private DashboardDisplayer mainDisplayer;

    public void show() {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(this::show);
            return;
        }
        if (this.mainDisplayer == null) {
            this.mainDisplayer = DashboardManager.findMainDisplayer();
        }
        if (this.mainWidgets == null) {
            this.mainWidgets = DashboardManager.findMainWidgets();
        }
        this.mainDisplayer.show("Main", this.mainWidgets);
    }

    private static DashboardDisplayer findMainDisplayer() {
        return DefaultDashboardDisplayer.findOrDefault();
    }

    private static List<DashboardDisplayer.WidgetReference> findMainWidgets() {
        FileObject folder = FileUtil.getConfigFile((String)"Dashboard/Main");
        if (folder == null) {
            return List.of();
        }
        List files = FileUtil.getOrder(Arrays.asList(folder.getChildren()), (boolean)true);
        ArrayList<DashboardDisplayer.WidgetReference> widgetRefs = new ArrayList<DashboardDisplayer.WidgetReference>();
        for (FileObject file : files) {
            String id = "Main/" + file.getName();
            DashboardWidget widget = (DashboardWidget)FileUtil.getConfigObject((String)file.getPath(), DashboardWidget.class);
            if (widget == null) continue;
            widgetRefs.add(new DashboardDisplayer.WidgetReference(id, widget, file));
        }
        return List.copyOf(widgetRefs);
    }

    public static DashboardManager getDefault() {
        return INSTANCE;
    }
}

