/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.gradle;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectActionContext;
import org.netbeans.modules.gradle.api.BuildPropertiesSupport;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.GradleTask;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.api.execute.ActionMapping;
import org.netbeans.modules.gradle.api.execute.GradleExecConfiguration;
import org.netbeans.modules.gradle.api.execute.RunConfig;
import org.netbeans.modules.gradle.api.execute.RunUtils;
import org.netbeans.modules.micronaut.AbstractMicronautArtifacts;
import org.netbeans.modules.project.dependency.ArtifactSpec;
import org.netbeans.modules.project.dependency.ProjectArtifactsQuery;
import org.netbeans.modules.project.dependency.spi.ProjectArtifactsImplementation;
import org.openide.util.BaseUtilities;
import org.openide.util.Lookup;

public class MicronautGradleArtifactsImpl
implements ProjectArtifactsImplementation<R> {
    private static final String EXTENSION_GRAAL_VM_NATIVE = "graalVmNative";
    private static final String TASK_NATIVE_COMPILE = "nativeCompile";
    private final Project project;

    public MicronautGradleArtifactsImpl(Project project) {
        this.project = project;
    }

    public int getOrder() {
        return 9000;
    }

    public R evaluate(ProjectArtifactsQuery.Filter filter) {
        ActionMapping mapping;
        NbGradleProject gp = NbGradleProject.get((Project)this.project);
        GradleBaseProject gbp = GradleBaseProject.get((Project)this.project);
        if (gp == null || gbp == null) {
            return null;
        }
        if (filter.getClassifier() != null && !"<any>".equals(filter.getClassifier()) && !"native-image".equals(filter.getClassifier())) {
            return null;
        }
        if (filter.getArtifactType() != null && !"<all>".equals(filter.getArtifactType()) && !"exe".equals(filter.getArtifactType())) {
            return null;
        }
        String action = "build";
        GradleExecConfiguration cfg = null;
        Lookup lkp = Lookup.EMPTY;
        if (filter.getBuildContext() != null) {
            ProjectActionContext pac = filter.getBuildContext();
            if (pac.getProjectAction() != null) {
                action = pac.getProjectAction();
            }
            if (pac.getConfiguration() != null) {
                cfg = (GradleExecConfiguration)pac.getConfiguration();
            }
        }
        if ((mapping = RunUtils.findActionMapping((Project)this.project, (String)action, cfg)) == null) {
            mapping = new TaskActionMapping(action);
        }
        String[] args = RunUtils.evaluateActionArgs((Project)this.project, (String)action, (String)mapping.getArgs(), (Lookup)lkp);
        RunConfig rc = RunUtils.createRunConfig((Project)this.project, (String)action, (String)"Searching for artifacts", (Lookup)Lookup.EMPTY, (GradleExecConfiguration)cfg, Collections.emptySet(), (String[])args);
        if (!rc.getCommandLine().getTasks().contains(TASK_NATIVE_COMPILE)) {
            boolean found = false;
            for (String t : rc.getCommandLine().getTasks()) {
                GradleTask task = gbp.getTaskByName(t);
                if (task == null) continue;
                for (GradleTask pred : gbp.getTaskPredecessors(task, false)) {
                    if (pred.isExternal() || !TASK_NATIVE_COMPILE.equals(pred.getName())) continue;
                    found = true;
                }
            }
            if (!found) {
                return null;
            }
        }
        return new R(this.project, gbp, gp, filter);
    }

    public Project findProject(R r) {
        return r.project;
    }

    public List<ArtifactSpec> findArtifacts(R r) {
        return r.getArtifacts();
    }

    public Collection<ArtifactSpec> findExcludedArtifacts(R r) {
        return r.getExcludedArtifacts();
    }

    public void handleChangeListener(R r, ChangeListener l, boolean add) {
        if (add) {
            r.addChangeListener(l);
        } else {
            r.removeChangeListener(l);
        }
    }

    public boolean computeSupportsChanges(R r) {
        return true;
    }

    private static final class TaskActionMapping
    implements ActionMapping {
        private final String task;

        public TaskActionMapping(String task) {
            this.task = task;
        }

        public String getName() {
            return this.task;
        }

        public String getDisplayName() {
            return this.task;
        }

        public String getArgs() {
            return this.task;
        }

        public ActionMapping.ReloadRule getReloadRule() {
            return ActionMapping.ReloadRule.DEFAULT;
        }

        public String getReloadArgs() {
            return "";
        }

        public boolean isApplicable(Set<String> plugins) {
            return true;
        }

        public boolean isRepeatable() {
            return false;
        }

        public int compareTo(ActionMapping o) {
            return -1;
        }
    }

    static class R
    extends AbstractMicronautArtifacts {
        private final Project project;
        private final GradleBaseProject gbp;
        private final NbGradleProject gp;
        private List<ChangeListener> listeners;

        public R(Project project, GradleBaseProject gbp, NbGradleProject gp, ProjectArtifactsQuery.Filter query) {
            super(project, query);
            this.project = project;
            this.gbp = gbp;
            this.gp = gp;
        }

        @Override
        protected List<ArtifactSpec> compute() {
            Path filename;
            BuildPropertiesSupport props = BuildPropertiesSupport.get((Project)this.project);
            if (props == null) {
                return Collections.emptyList();
            }
            BuildPropertiesSupport.Property outFile = props.findTaskProperty(MicronautGradleArtifactsImpl.TASK_NATIVE_COMPILE, "outputFile");
            if (outFile != null && outFile.getStringValue() != null) {
                filename = Paths.get(outFile.getStringValue(), new String[0]);
            } else {
                Path fn;
                BuildPropertiesSupport.Property extensionImageName = props.findExtensionProperty(MicronautGradleArtifactsImpl.EXTENSION_GRAAL_VM_NATIVE, "binaries.main.imageName");
                BuildPropertiesSupport.Property taskImageName = props.findTaskProperty(MicronautGradleArtifactsImpl.TASK_NATIVE_COMPILE, "executableName");
                BuildPropertiesSupport.Property outputDir = props.findTaskProperty(MicronautGradleArtifactsImpl.TASK_NATIVE_COMPILE, "outputDirectory");
                Path dir = outputDir != null && outputDir.getStringValue() != null ? Paths.get(outputDir.getStringValue(), new String[0]) : this.gbp.getBuildDir().toPath().resolve(Paths.get("native", MicronautGradleArtifactsImpl.TASK_NATIVE_COMPILE));
                if (taskImageName != null && taskImageName.getStringValue() != null) {
                    fn = Paths.get(taskImageName.getStringValue(), new String[0]);
                } else if (extensionImageName != null && extensionImageName.getStringValue() != null) {
                    String s = extensionImageName.getStringValue();
                    if (BaseUtilities.isWindows()) {
                        s = s + ".exe";
                    }
                    fn = Paths.get(s, new String[0]);
                } else {
                    String s = this.gbp.getName();
                    if (BaseUtilities.isWindows()) {
                        s = s + ".exe";
                    }
                    fn = Paths.get(s, new String[0]);
                }
                filename = dir.resolve(fn);
            }
            ArtifactSpec spec = ArtifactSpec.builder((String)this.gbp.getGroup(), (String)this.gbp.getName(), (String)(this.gbp.isVersionSpecified() ? this.gbp.getVersion() : null), (Object)this.project).classifier("native-image").type("exe").location(filename.toUri()).build();
            return Collections.singletonList(spec);
        }

        @Override
        protected void attach(PropertyChangeListener l) {
            this.gp.addPropertyChangeListener(l);
        }

        @Override
        protected void detach(PropertyChangeListener l) {
            this.gp.removePropertyChangeListener(l);
        }

        @Override
        protected boolean accept(PropertyChangeEvent e) {
            return "ProjectInfo".equals(e.getPropertyName());
        }
    }
}

