/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.bundle.bindex;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.osgi.impl.bundle.obr.resource.BundleInfo;
import org.osgi.impl.bundle.obr.resource.RepositoryImpl;
import org.osgi.impl.bundle.obr.resource.ResourceImpl;
import org.osgi.impl.bundle.obr.resource.Tag;

public class Index {
    static String repositoryFileName = "repository.xml";
    static URL licenseURL = null;
    static boolean quiet = false;
    static String name = "Untitled";
    static String urlTemplate = null;
    static URL root;
    static RepositoryImpl repository;

    public static void main(String[] args) throws Exception {
        System.err.println("Bundle Indexer | v2.3");
        System.err.println("(c) 2007 OSGi, All Rights Reserved");
        HashSet resources = new HashSet();
        root = new File("").getAbsoluteFile().toURL();
        repository = new RepositoryImpl(root);
        int i = 0;
        while (i < args.length) {
            try {
                if (args[i].startsWith("-n")) {
                    name = args[++i];
                } else if (args[i].startsWith("-r")) {
                    repositoryFileName = args[++i];
                    repository = new RepositoryImpl(new File(repositoryFileName).getAbsoluteFile().toURL());
                } else if (args[i].startsWith("-q")) {
                    quiet = true;
                } else if (args[i].startsWith("-d")) {
                    root = new File(args[++i]).toURL();
                } else if (args[i].startsWith("-t")) {
                    urlTemplate = args[++i];
                } else if (args[i].startsWith("-l")) {
                    licenseURL = new URL(new File("").toURL(), args[++i]);
                } else if (args[i].startsWith("-help")) {
                    System.err.println("bindex [-t \"%s\" symbolic name \"%v\" version \"%f\" filename \"%p\" dirpath ] [-d rootFile] [ -r repository.(xml|zip) ] [-help] [-l file:license.html ] [-quiet] <jar file>*");
                } else {
                    Index.recurse(resources, new File(args[i]));
                }
            }
            catch (Exception e) {
                System.err.println("Error in " + args[i] + " : " + e.getMessage());
                e.printStackTrace();
            }
            ++i;
        }
        ArrayList sorted = new ArrayList(resources);
        Collections.sort(sorted, new Comparator(){

            public int compare(Object r1, Object r2) {
                String s1 = Index.getName((ResourceImpl)r1);
                String s2 = Index.getName((ResourceImpl)r2);
                return s1.compareTo(s2);
            }
        });
        Tag tag = Index.doIndex(sorted);
        if (repositoryFileName != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            pw.println("<?xml version='1.0' encoding='utf-8'?>");
            pw.println("<?xml-stylesheet type='text/xsl' href='http://www2.osgi.org/www/obr2html.xsl'?>");
            tag.print(0, pw);
            pw.close();
            byte[] buffer = out.toByteArray();
            String name = "repository.xml";
            FileOutputStream fout = new FileOutputStream(repositoryFileName);
            if (repositoryFileName.endsWith(".zip")) {
                ZipOutputStream zip = new ZipOutputStream(fout);
                CRC32 checksum = new CRC32();
                checksum.update(buffer);
                ZipEntry ze = new ZipEntry(name);
                ze.setSize(buffer.length);
                ze.setCrc(checksum.getValue());
                zip.putNextEntry(ze);
                zip.write(buffer, 0, buffer.length);
                zip.closeEntry();
                zip.close();
            } else {
                fout.write(buffer);
            }
            fout.close();
        }
        if (!quiet) {
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(System.out));
            pw.println("<?xml version='1.0' encoding='utf-8'?>");
            pw.println("<?xml-stylesheet type='text/xsl' href='http://www2.osgi.org/www/obr2html.xsl'?>");
            tag.print(0, pw);
            pw.close();
        }
    }

    static String getName(ResourceImpl impl) {
        String s = impl.getSymbolicName();
        if (s != null) {
            return s;
        }
        return "no-symbolic-name";
    }

    static void recurse(Set resources, File path) throws Exception {
        if (path.isDirectory()) {
            String[] list = path.list();
            int i = 0;
            while (i < list.length) {
                Index.recurse(resources, new File(path, list[i]));
                ++i;
            }
        } else if (path.getName().endsWith(".jar")) {
            BundleInfo info = new BundleInfo(repository, path);
            ResourceImpl resource = info.build();
            if (urlTemplate != null) {
                Index.doTemplate(path, resource);
            } else {
                resource.setURL(path.toURL());
            }
            resources.add(resource);
        }
    }

    static void doTemplate(File path, ResourceImpl resource) throws MalformedURLException {
        String dir = path.getAbsoluteFile().getParentFile().getAbsoluteFile().toURL().toString();
        if (dir.endsWith("/")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        if (dir.startsWith(root.toString())) {
            dir = dir.substring(root.toString().length());
        }
        String url = urlTemplate.replaceAll("%v", "" + resource.getVersion());
        url = url.replaceAll("%s", resource.getSymbolicName());
        url = url.replaceAll("%f", path.getName());
        url = url.replaceAll("%p", dir);
        resource.setURL(new URL(url));
    }

    static Tag doIndex(Collection resources) throws IOException {
        Tag repository = new Tag("repository");
        repository.addAttribute("lastmodified", new Date());
        repository.addAttribute("name", name);
        Iterator i = resources.iterator();
        while (i.hasNext()) {
            ResourceImpl resource = (ResourceImpl)i.next();
            repository.addContent(resource.toXML());
        }
        return repository;
    }

    static void addToZip(ZipOutputStream zip, String name, InputStream actual) throws IOException {
        byte[] buffer = Index.readAll(actual, 0);
        actual.close();
        CRC32 checksum = new CRC32();
        checksum.update(buffer);
        ZipEntry ze = new ZipEntry(name);
        ze.setSize(buffer.length);
        ze.setCrc(checksum.getValue());
        zip.putNextEntry(ze);
        zip.write(buffer, 0, buffer.length);
        zip.closeEntry();
    }

    static byte[] readAll(InputStream in, int offset) throws IOException {
        byte[] temp = new byte[4096];
        int size = in.read(temp, 0, temp.length);
        if (size <= 0) {
            return new byte[offset];
        }
        byte[] result = Index.readAll(in, offset + size);
        System.arraycopy(temp, 0, result, offset, size);
        return result;
    }
}

