/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.admin;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.modules.payara.tooling.PayaraIdeException;
import org.netbeans.modules.payara.tooling.admin.CommandTarget;
import org.netbeans.modules.payara.tooling.admin.ResultList;
import org.netbeans.modules.payara.tooling.admin.RunnerHttpClass;
import org.netbeans.modules.payara.tooling.admin.RunnerHttpListResources;
import org.netbeans.modules.payara.tooling.admin.RunnerRestClass;
import org.netbeans.modules.payara.tooling.admin.RunnerRestListResources;
import org.netbeans.modules.payara.tooling.admin.ServerAdmin;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.logging.Logger;

@RunnerHttpClass(runner=RunnerHttpListResources.class)
@RunnerRestClass(runner=RunnerRestListResources.class)
public class CommandListResources
extends CommandTarget {
    private static final Logger LOGGER = new Logger(CommandListResources.class);
    private static final String COMMAND_PREFIX = "list-";
    private static final String COMMAND_SUFFIX = "s";

    public static ResultList<String> listResources(PayaraServer server, String cmdSuffix, String target) throws PayaraIdeException {
        String METHOD = "listResources";
        CommandListResources command = new CommandListResources(CommandListResources.command(cmdSuffix), target);
        Future future = ServerAdmin.exec(server, command);
        try {
            return (ResultList)future.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException ie) {
            throw new PayaraIdeException(LOGGER.excMsg("listResources", "exception"), ie);
        }
    }

    public static String command(String resourceCmdSuffix) {
        StringBuilder sb = new StringBuilder(COMMAND_PREFIX.length() + COMMAND_SUFFIX.length() + resourceCmdSuffix.length());
        sb.append(COMMAND_PREFIX);
        sb.append(resourceCmdSuffix);
        sb.append(COMMAND_SUFFIX);
        return sb.toString();
    }

    public CommandListResources(String command, String target) {
        super(command, target);
    }
}

