/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.util.List;
import java.util.Stack;
import org.netbeans.modules.java.graph.DependencyGraphScene;
import org.netbeans.modules.java.graph.GraphNodeImplementation;
import org.netbeans.modules.java.graph.GraphNodeVisitor;
import org.netbeans.modules.maven.graph.MavenDependencyNode;

public class ScopesVisitor
implements GraphNodeVisitor<MavenDependencyNode> {
    private final DependencyGraphScene scene;
    private GraphNodeImplementation root;
    private final Stack<GraphNodeImplementation> path;
    private final List<String> scopes;

    public ScopesVisitor(DependencyGraphScene scene, List<String> scopes) {
        this.scene = scene;
        this.path = new Stack();
        this.scopes = scopes;
    }

    public boolean visit(MavenDependencyNode node) {
        if (this.root == null) {
            this.root = node;
        }
        if (this.scene.isIncluded((GraphNodeImplementation)node)) {
            node.hightlightScopes(this.scopes);
            this.path.push(node);
            return true;
        }
        return false;
    }

    public boolean endVisit(MavenDependencyNode node) {
        if (this.scene.isIncluded((GraphNodeImplementation)node)) {
            this.path.pop();
        }
        return true;
    }
}

