/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.dependency.reload;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.event.ChangeEvent;
import org.netbeans.modules.project.dependency.ProjectReload;
import org.netbeans.modules.project.dependency.reload.ProjectReloadInternal;
import org.netbeans.modules.project.dependency.reload.ProjectStateListener;
import org.netbeans.modules.project.dependency.reload.ReloadApiAccessor;
import org.netbeans.modules.project.dependency.reload.ReloadSpiAccessor;
import org.netbeans.modules.project.dependency.spi.ProjectReloadImplementation;

class Forwarder
implements ProjectStateListener {
    private final Map<ProjectReloadImplementation.ProjectStateData, ProjectReloadImplementation.ProjectStateData> forwardMap;
    private final ProjectReload.ProjectState invalidateTo;

    Forwarder(Map<ProjectReloadImplementation.ProjectStateData, ProjectReloadImplementation.ProjectStateData> forwardMap, ProjectReload.ProjectState invalidateTo) {
        this.forwardMap = forwardMap;
        for (ProjectReloadImplementation.ProjectStateData d : forwardMap.keySet()) {
            ReloadSpiAccessor.get().addProjectStateListener(d, this);
        }
        this.invalidateTo = invalidateTo;
    }

    @Override
    public void fireDataInconsistent(ProjectReloadImplementation.ProjectStateData d, Class<?> dataClass) {
        ProjectReloadImplementation.ProjectStateData f = this.forwardMap.get(d);
        if (f != null) {
            f.fireDataInconsistent(dataClass);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof ProjectReloadImplementation.ProjectStateData) {
            ProjectReloadImplementation.ProjectStateData d = (ProjectReloadImplementation.ProjectStateData)e.getSource();
            ProjectReloadImplementation.ProjectStateData f = this.forwardMap.get(d);
            if (f != null) {
                f.fireChanged(!d.isValid(), !d.isConsistent());
                f.fireFileSetChanged(d.getChangedFiles());
            }
        } else if (e.getSource() instanceof ProjectReload.ProjectState) {
            ProjectReload.ProjectState s = (ProjectReload.ProjectState)e.getSource();
            ReloadApiAccessor.get().updateProjectState(this.invalidateTo, !s.isValid(), !s.isConsistent(), null, null, null);
        }
    }

    static Forwarder create(ProjectReload.ProjectState cached, ProjectReloadInternal.StateParts parts, ProjectReload.ProjectState now, boolean check) {
        ProjectReloadInternal.StateParts oldParts = ReloadApiAccessor.get().getParts(cached);
        IdentityHashMap<ProjectReloadImplementation.ProjectStateData, ProjectReloadImplementation.ProjectStateData> forwardMap = new IdentityHashMap<ProjectReloadImplementation.ProjectStateData, ProjectReloadImplementation.ProjectStateData>();
        for (Map.Entry en : parts.entrySet()) {
            ProjectReloadImplementation.ProjectStateData nd = (ProjectReloadImplementation.ProjectStateData)en.getValue();
            ProjectReloadImplementation.ProjectStateData od = (ProjectReloadImplementation.ProjectStateData)oldParts.get(en.getKey());
            if (check && !Objects.equals(od, nd)) {
                return null;
            }
            if (nd == od) continue;
            forwardMap.put(nd, od);
        }
        Forwarder f = new Forwarder(forwardMap, cached);
        ReloadApiAccessor.get().updateProjectState(cached, false, false, null, null, now);
        if (now != null) {
            now.addChangeListener(f);
        }
        return f;
    }
}

