/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.samples;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class JavaFXSampleProjectGenerator {
    private static final String PROJECT_CONFIGURATION_NAMESPACE = "http://www.netbeans.org/ns/j2se-project/3";
    private static final String ANT_BASED_PROJECT_NAMESPACE = "http://www.netbeans.org/ns/project/1";

    private JavaFXSampleProjectGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject createProjectFromTemplate(FileObject template, File projectLocation, String name, String platformName) throws IOException {
        assert (template != null && projectLocation != null && name != null);
        FileObject prjLoc = JavaFXSampleProjectGenerator.createProjectFolder(projectLocation);
        if (template.getExt().endsWith("zip")) {
            block16: {
                JavaFXSampleProjectGenerator.unzip(template.getInputStream(), prjLoc);
                try {
                    File projXml = FileUtil.toFile((FileObject)prjLoc.getFileObject("nbproject/project.xml"));
                    Document doc = XMLUtil.parse((InputSource)new InputSource(Utilities.toURI((File)projXml).toString()), (boolean)false, (boolean)true, null, null);
                    NodeList nlist = doc.getElementsByTagNameNS(PROJECT_CONFIGURATION_NAMESPACE, "name");
                    if (nlist == null) break block16;
                    for (int i = 0; i < nlist.getLength(); ++i) {
                        Node n = nlist.item(i);
                        if (n.getNodeType() != 1) continue;
                        Element e = (Element)n;
                        JavaFXSampleProjectGenerator.replaceText(e, name);
                    }
                    if (!platformName.equals("default_platform")) {
                        Element root = doc.getDocumentElement();
                        Element config = XMLUtil.findElement((Element)root, (String)"configuration", (String)ANT_BASED_PROJECT_NAMESPACE);
                        Element data = XMLUtil.findElement((Element)config, (String)"data", (String)PROJECT_CONFIGURATION_NAMESPACE);
                        Node insertBefore = null;
                        for (Element e : XMLUtil.findSubElements((Element)data)) {
                            String n = e.getNodeName();
                            if ("name".equals(n) || "minimum-ant-version".equals(n)) continue;
                            insertBefore = e;
                            break;
                        }
                        Element explicitPlatformEl = insertBefore.getOwnerDocument().createElementNS(PROJECT_CONFIGURATION_NAMESPACE, "explicit-platform");
                        explicitPlatformEl.setAttribute("explicit-source-supported", "true");
                        data.insertBefore(explicitPlatformEl, insertBefore);
                    }
                    JavaFXSampleProjectGenerator.saveXml(doc, prjLoc, "nbproject/project.xml");
                    FileObject projectProps = prjLoc.getFileObject("nbproject/project.properties");
                    if (projectProps == null) break block16;
                    FileLock lock = projectProps.lock();
                    try {
                        EditableProperties props = new EditableProperties(false);
                        try (InputStream in = projectProps.getInputStream();){
                            props.load(in);
                        }
                        props.setProperty("platform.active", platformName);
                        try (OutputStream out = projectProps.getOutputStream(lock);){
                            props.store(out);
                        }
                    }
                    finally {
                        lock.releaseLock();
                    }
                }
                catch (Exception e) {
                    throw new IOException(e.toString());
                }
            }
            prjLoc.refresh(false);
        }
        return prjLoc;
    }

    private static FileObject createProjectFolder(File projectFolder) throws IOException {
        FileObject projLoc;
        Stack<String> nameStack = new Stack<String>();
        while ((projLoc = FileUtil.toFileObject((File)projectFolder)) == null) {
            nameStack.push(projectFolder.getName());
            projectFolder = projectFolder.getParentFile();
        }
        while (!nameStack.empty()) {
            projLoc = projLoc.createFolder((String)nameStack.pop());
            assert (projLoc != null);
        }
        return projLoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(InputStream source, FileObject targetFolder) throws IOException {
        try (ZipInputStream zip = new ZipInputStream(source);){
            ZipEntry ent;
            while ((ent = zip.getNextEntry()) != null) {
                if (ent.isDirectory()) {
                    FileUtil.createFolder((FileObject)targetFolder, (String)ent.getName());
                    continue;
                }
                FileObject destFile = FileUtil.createData((FileObject)targetFolder, (String)ent.getName());
                FileLock lock = destFile.lock();
                try (OutputStream out = destFile.getOutputStream(lock);){
                    FileUtil.copy((InputStream)zip, (OutputStream)out);
                }
                finally {
                    lock.releaseLock();
                }
            }
        }
    }

    private static File createPrivateProperties(FileObject fo) throws IOException {
        String[] nameElements = "nbproject/private/private.properties".split("/");
        for (int i = 0; i < nameElements.length - 1; ++i) {
            FileObject tmp = fo.getFileObject(nameElements[i]);
            if (tmp == null) {
                tmp = fo.createFolder(nameElements[i]);
            }
            fo = tmp;
        }
        fo = fo.createData(nameElements[nameElements.length - 1]);
        return FileUtil.toFile((FileObject)fo);
    }

    private static void replaceText(Element parent, String name) {
        NodeList l = parent.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            if (l.item(i).getNodeType() != 3) continue;
            Text text = (Text)l.item(i);
            text.setNodeValue(name);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveXml(Document doc, FileObject dir, String path) throws IOException {
        FileObject xml = FileUtil.createData((FileObject)dir, (String)path);
        FileLock lock = xml.lock();
        try (OutputStream os = xml.getOutputStream(lock);){
            XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
        }
        finally {
            lock.releaseLock();
        }
    }
}

