/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.messages;

import java.io.IOException;
import java.io.Writer;
import nu.validator.messages.MessageTextHandler;
import org.xml.sax.SAXException;

public class TextMessageTextHandler
implements MessageTextHandler {
    private final Writer writer;
    private final boolean asciiQuotes;

    public TextMessageTextHandler(Writer writer, boolean asciiQuotes) {
        this.writer = writer;
        this.asciiQuotes = asciiQuotes;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            int end = start + length;
            block6: for (int i = start; i < end; ++i) {
                char c = ch[i];
                switch (c) {
                    case '\n': 
                    case '\r': {
                        if (start < i) {
                            this.writer.write(ch, start, i - start);
                        }
                        start = i + 1;
                        this.writer.write(8617);
                        continue block6;
                    }
                    case '\u2018': 
                    case '\u2019': {
                        if (!this.asciiQuotes) continue block6;
                        if (start < i) {
                            this.writer.write(ch, start, i - start);
                        }
                        start = i + 1;
                        this.writer.write(39);
                    }
                }
            }
            if (start < end) {
                this.writer.write(ch, start, end - start);
            }
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void endCode() throws SAXException {
        try {
            if (this.asciiQuotes) {
                this.writer.write(34);
            } else {
                this.writer.write(8221);
            }
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void endLink() throws SAXException {
    }

    @Override
    public void startCode() throws SAXException {
        try {
            if (this.asciiQuotes) {
                this.writer.write(34);
            } else {
                this.writer.write(8220);
            }
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void startLink(String href, String title) throws SAXException {
    }
}

