/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSource;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.modules.cloud.oracle.assets.KubernetesUtils;
import org.netbeans.modules.cloud.oracle.assets.PropertiesGenerator;
import org.netbeans.modules.cloud.oracle.compute.ClusterItem;

public class ConfigMapProvider {
    private static final String APP = "app";
    public static final String VOLUME_MOUNT_PATH = "/etc/conf";
    public static final String ENVIRONMENT = "oraclecloud";
    public static final String CONFIG_VOLUME_NAME = "configuration";
    public static final String BOOTSTRAP_PROPERTIES_FILE = "bootstrap-oraclecloud.properties";
    public static final String APPLICATION_PROPERTIES_FILE = "application-oraclecloud.properties";
    private final String projectName;
    private final ClusterItem cluster;
    private final PropertiesGenerator propertiesGenerator;

    public ConfigMapProvider(String projectName, ClusterItem cluster) {
        this.projectName = projectName;
        this.cluster = cluster;
        this.propertiesGenerator = new PropertiesGenerator(false);
    }

    public String getMicronautConfigFiles() {
        return VOLUME_MOUNT_PATH + "/" + APPLICATION_PROPERTIES_FILE + "," + VOLUME_MOUNT_PATH + "/" + BOOTSTRAP_PROPERTIES_FILE;
    }

    public void createConfigMap() {
        KubernetesUtils.runWithClient(this.cluster, client -> {
            ConfigMapList cmList = (ConfigMapList)((NonNamespaceOperation)client.configMaps().inNamespace(this.cluster.getNamespace())).list();
            ConfigMap configMap = (ConfigMap)KubernetesUtils.findResource(client, (KubernetesResourceList<? extends HasMetadata>)cmList, this.projectName);
            if (configMap != null) {
                this.updateConfigMap((KubernetesClient)client);
                return;
            }
            this.createConfigMap((KubernetesClient)client);
        });
    }

    public ConfigMapVolumeSource getVolumeSource() {
        return ((ConfigMapVolumeSourceBuilder)((ConfigMapVolumeSourceFluent.ItemsNested)((ConfigMapVolumeSourceFluent.ItemsNested)((ConfigMapVolumeSourceBuilder)((ConfigMapVolumeSourceFluent.ItemsNested)((ConfigMapVolumeSourceFluent.ItemsNested)((ConfigMapVolumeSourceBuilder)new ConfigMapVolumeSourceBuilder().withName(this.projectName)).addNewItem().withKey(APPLICATION_PROPERTIES_FILE)).withPath(APPLICATION_PROPERTIES_FILE)).endItem()).addNewItem().withKey(BOOTSTRAP_PROPERTIES_FILE)).withPath(BOOTSTRAP_PROPERTIES_FILE)).endItem()).build();
    }

    private void updateConfigMap(KubernetesClient client) {
        Map<String, String> applicationProperties = this.propertiesGenerator.getApplication();
        Map<String, String> bootstrapProperties = this.propertiesGenerator.getBootstrap();
        ((Resource)((NonNamespaceOperation)client.configMaps().inNamespace(this.cluster.getNamespace())).withName(this.projectName)).edit(cm -> ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapBuilder)new ConfigMapBuilder(cm).removeFromData(APPLICATION_PROPERTIES_FILE)).removeFromData(BOOTSTRAP_PROPERTIES_FILE)).addToData(APPLICATION_PROPERTIES_FILE, this.toFileLikeKeys(applicationProperties))).addToData(BOOTSTRAP_PROPERTIES_FILE, this.toFileLikeKeys(bootstrapProperties))).build());
    }

    private ConfigMap createConfigMap(KubernetesClient client) {
        Map<String, String> applicationProperties = this.propertiesGenerator.getApplication();
        Map<String, String> bootstrapProperties = this.propertiesGenerator.getBootstrap();
        ConfigMap configMap = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(this.projectName)).addToLabels(APP, this.projectName)).endMetadata()).addToData(APPLICATION_PROPERTIES_FILE, this.toFileLikeKeys(applicationProperties))).addToData(BOOTSTRAP_PROPERTIES_FILE, this.toFileLikeKeys(bootstrapProperties))).build();
        return (ConfigMap)((Resource)((NonNamespaceOperation)client.configMaps().inNamespace(this.cluster.getNamespace())).resource((Object)configMap)).create();
    }

    private String toFileLikeKeys(Map<String, String> properties) {
        StringBuilder res = new StringBuilder("");
        TreeMap<String, String> sortedProperties = new TreeMap<String, String>(properties);
        for (Map.Entry<String, String> entry : sortedProperties.entrySet()) {
            res.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        return res.toString();
    }
}

