/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.branding;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.api.ManifestManager;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.spi.BrandingModel;
import org.netbeans.modules.apisupport.project.spi.BrandingSupport;
import org.netbeans.modules.apisupport.project.spi.PlatformJarProvider;
import org.netbeans.modules.apisupport.project.ui.branding.AbstractBrandingPanel;
import org.netbeans.modules.apisupport.project.ui.branding.ResourceBundleKeyPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.EditAction;
import org.openide.actions.OpenAction;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class InternationalizationResourceBundleBrandingPanel
extends AbstractBrandingPanel
implements ExplorerManager.Provider {
    private static final Logger LOG = Logger.getLogger(InternationalizationResourceBundleBrandingPanel.class.getName());
    private final ExplorerManager manager;
    private RootNode rootNode;
    private final AbstractNode waitRoot;
    private static final String WAIT_ICON_PATH = "org/netbeans/modules/apisupport/project/suite/resources/wait.png";
    private RequestProcessor.Task refreshTask = null;
    private RequestProcessor RPforRefresh = new RequestProcessor(InternationalizationResourceBundleBrandingPanel.class.getName() + " - refresh", 1);
    private EditRBAction editRBAction = (EditRBAction)SystemAction.get(EditRBAction.class);
    private OpenRBAction openRBAction = (OpenRBAction)SystemAction.get(OpenRBAction.class);
    private ExpandAllAction expandAllAction = (ExpandAllAction)SystemAction.get(ExpandAllAction.class);
    private String searchString = null;
    private SearchListener searchListener = new SearchListener();
    private RequestProcessor.Task searchTask = null;
    private RequestProcessor RPforSearch = new RequestProcessor(InternationalizationResourceBundleBrandingPanel.class.getName() + " - search", 1);
    private BrandingModel branding;
    private Project prj;
    private static final RequestProcessor RP = new RequestProcessor(InternationalizationResourceBundleBrandingPanel.class.getName(), 1, true);
    private boolean initialized = false;
    private JComboBox localeComboBox;
    private JLabel localeLabel;
    private JTextField searchField;
    private JLabel searchLabel;
    private BeanTreeView view;
    private final JScrollPane scrollPane = new JScrollPane();

    public InternationalizationResourceBundleBrandingPanel(BrandingModel model) {
        super(InternationalizationResourceBundleBrandingPanel.getMessage("LBL_InternationalizationResourceBundleTab"), model);
        this.initComponents();
        this.searchField.getDocument().addDocumentListener(this.searchListener);
        this.searchField.addFocusListener(this.searchListener);
        this.manager = new ExplorerManager();
        this.rootNode = null;
        this.waitRoot = this.getWaitRoot();
        this.waitRoot.setName(InternationalizationResourceBundleBrandingPanel.getMessage("LBL_ResourceBundlesList"));
        this.waitRoot.setDisplayName(InternationalizationResourceBundleBrandingPanel.getMessage("LBL_ResourceBundlesList"));
        this.manager.setRootContext((Node)this.waitRoot);
        this.branding = this.getBranding();
        this.prj = this.branding.getProject();
        this.attachListeners();
    }

    private void initComponents() {
        this.view = new MyTree();
        this.searchLabel = new JLabel();
        this.searchField = new JTextField();
        this.localeLabel = new JLabel();
        this.localeComboBox = new JComboBox();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                InternationalizationResourceBundleBrandingPanel.this.formComponentShown(evt);
            }
        });
        this.searchLabel.setHorizontalAlignment(11);
        this.searchLabel.setLabelFor(this.searchField);
        Mnemonics.setLocalizedText((JLabel)this.searchLabel, (String)NbBundle.getMessage(InternationalizationResourceBundleBrandingPanel.class, (String)"InternationalizationResourceBundleBrandingPanel.searchLabel.text"));
        this.searchField.setText(NbBundle.getMessage(InternationalizationResourceBundleBrandingPanel.class, (String)"InternationalizationResourceBundleBrandingPanel.searchField.text"));
        Mnemonics.setLocalizedText((JLabel)this.localeLabel, (String)NbBundle.getMessage(InternationalizationResourceBundleBrandingPanel.class, (String)"InternationalizationResourceBundleBrandingPanel.localeLabel.text"));
        Locale[] locales = Locale.getAvailableLocales();
        Comparator<Locale> localeComparator = new Comparator<Locale>(){

            @Override
            public int compare(Locale o1, Locale o2) {
                return o1.toString().compareTo(o2.toString());
            }
        };
        Arrays.sort(locales, localeComparator);
        this.localeComboBox.setModel(new DefaultComboBoxModel<Locale>(locales));
        this.localeComboBox.setSelectedItem(Locale.getDefault());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.view, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.localeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.localeComboBox, -2, -1, -2).addGap(6, 6, 6).addComponent(this.searchLabel, -1, 94, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchField, -2, 209, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchField, -2, -1, -2).addComponent(this.searchLabel).addComponent(this.localeComboBox, -2, -1, -2).addComponent(this.localeLabel)).addGap(12, 12, 12).addComponent((Component)this.view, -1, 258, Short.MAX_VALUE).addContainerGap()));
        this.searchLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InternationalizationResourceBundleBrandingPanel.class, (String)"InternationalizationResourceBundleBrandingPanel.searchLabel.AccessibleContext.accessibleDescription"));
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.initialized) {
            this.refresh();
            this.initialized = true;
        }
        this.view.requestFocusInWindow();
    }

    private void refresh() {
        if (this.refreshTask == null) {
            this.refreshTask = this.RPforRefresh.create(new Runnable(){

                @Override
                public void run() {
                    InternationalizationResourceBundleBrandingPanel.this.prepareTree(InternationalizationResourceBundleBrandingPanel.this.loadPlatformJars());
                }
            });
        }
        this.refreshTask.schedule(0);
    }

    private Set<File> loadPlatformJars() {
        HashSet<File> jars = new HashSet<File>();
        PlatformJarProvider pjp = (PlatformJarProvider)this.prj.getLookup().lookup(PlatformJarProvider.class);
        if (pjp != null) {
            try {
                jars.addAll(pjp.getPlatformJars());
            }
            catch (IOException x) {
                LOG.log(Level.INFO, null, x);
            }
        }
        return jars;
    }

    private void prepareTree(Set<File> jars) {
        LinkedList<BundleNode> resourcebundlenodes = new LinkedList<BundleNode>();
        Set<File> brandableJars = this.branding.getBrandableJars();
        jars.retainAll(brandableJars);
        for (File file : jars) {
            try {
                URI juri = Utilities.toURI((File)file);
                JarFile jf = new JarFile(file);
                String codeNameBase = ManifestManager.getInstance(jf.getManifest(), false).getCodeNameBase();
                Enumeration<JarEntry> entries = jf.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (!entry.getName().endsWith("Bundle.properties")) continue;
                    try {
                        URL url = new URL("jar:" + juri + "!/" + entry.getName());
                        FileObject fo = URLMapper.findFileObject((URL)url);
                        if (fo == null) {
                            LOG.log(Level.WARNING, "#207183: no bundle file found: {0}", url);
                            continue;
                        }
                        DataObject dobj = DataObject.find((FileObject)fo);
                        Node dobjnode = dobj.getNodeDelegate();
                        BundleNode filternode = new BundleNode(dobjnode, fo.getPath(), codeNameBase);
                        resourcebundlenodes.add(filternode);
                    }
                    catch (Exception e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                }
            }
            catch (ZipException ex) {
                LOG.log(Level.INFO, "Access failed for " + file.getPath());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.rootNode = new RootNode(resourcebundlenodes);
        this.rootNode.setName(InternationalizationResourceBundleBrandingPanel.getMessage("LBL_ResourceBundlesList"));
        this.rootNode.setDisplayName(InternationalizationResourceBundleBrandingPanel.getMessage("LBL_ResourceBundlesList"));
        this.rootNode.setShortDescription(InternationalizationResourceBundleBrandingPanel.getMessage("LBL_ResourceBundlesDesc"));
        this.manager.setRootContext((Node)this.rootNode);
    }

    private void searchStringUpdated() {
        if (null != this.rootNode) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        InternationalizationResourceBundleBrandingPanel.this.searchString = InternationalizationResourceBundleBrandingPanel.this.retrieveSearchField();
                        InternationalizationResourceBundleBrandingPanel.this.manager.setRootContext((Node)InternationalizationResourceBundleBrandingPanel.this.waitRoot);
                    }
                });
                this.rootNode.refreshChildren();
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (!InternationalizationResourceBundleBrandingPanel.this.searchFieldEquals(InternationalizationResourceBundleBrandingPanel.this.searchString)) {
                            return;
                        }
                        InternationalizationResourceBundleBrandingPanel.this.manager.setRootContext((Node)InternationalizationResourceBundleBrandingPanel.this.rootNode);
                        if (null == InternationalizationResourceBundleBrandingPanel.this.searchString) {
                            Node[] nodes;
                            for (Node node : nodes = InternationalizationResourceBundleBrandingPanel.this.rootNode.getChildren().getNodes()) {
                                InternationalizationResourceBundleBrandingPanel.this.view.collapseNode(node);
                            }
                        } else {
                            InternationalizationResourceBundleBrandingPanel.this.view.expandAll();
                        }
                    }
                });
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private String retrieveSearchField() {
        String value = this.searchField.getText().trim().toLowerCase();
        if (value.equalsIgnoreCase("")) {
            value = null;
        }
        return value;
    }

    private boolean searchFieldEquals(String value1) {
        String value2 = this.retrieveSearchField();
        if (null == value1 && null == value2) {
            return true;
        }
        return null != value1 && null != value2 && value1.equals(value2);
    }

    private boolean addKeyToBranding(String bundlepath, String codenamebase, String key) {
        String newValue;
        BrandingSupport.BundleKey bundleKey = this.getBranding().getGeneralLocalizedBundleKeyForModification(codenamebase, bundlepath, key);
        KeyInput inputLine = new KeyInput(key + ":", bundlepath);
        String oldValue = bundleKey.getValue();
        inputLine.setInputText(oldValue);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine) == NotifyDescriptor.OK_OPTION && (newValue = inputLine.getInputText()).compareTo(oldValue) != 0) {
            bundleKey.setValue(newValue);
            this.getBranding().addModifiedInternationalizedBundleKey(bundleKey);
            this.setModified();
            this.branding.updateProjectInternationalizationLocales();
            return true;
        }
        return false;
    }

    private String getKeyValue(String bundlepath, String codenamebase, String key) {
        return this.getBranding().getLocalizedKeyValue(bundlepath, codenamebase, key);
    }

    private boolean isKeyBranded(String bundlepath, String codenamebase, String key) {
        return this.getBranding().isKeyLocallyBranded(bundlepath, codenamebase, key);
    }

    private boolean isBundleBranded(String bundlepath, String codenamebase) {
        return this.getBranding().isBundleLocallyBranded(bundlepath, codenamebase);
    }

    @Override
    public void store() {
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(InternationalizationResourceBundleBrandingPanel.class, (String)key);
    }

    private AbstractNode getWaitRoot() {
        return new AbstractNode((Children)new Children.Array(){

            protected Collection<Node> initCollection() {
                return Collections.singleton(new WaitNode());
            }
        });
    }

    private void attachListeners() {
        this.localeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(final ItemEvent e) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        final Set jars = InternationalizationResourceBundleBrandingPanel.this.loadPlatformJars();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (e.getStateChange() == 1) {
                                    InternationalizationResourceBundleBrandingPanel.this.branding.refreshLocalizedBundles((Locale)e.getItem());
                                    InternationalizationResourceBundleBrandingPanel.this.prepareTree(jars);
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    static final class EditRBAction
    extends EditAction {
        EditRBAction() {
        }

        public String getName() {
            return InternationalizationResourceBundleBrandingPanel.getMessage("LBL_ResourceBundlesAddToBranding");
        }
    }

    static final class OpenRBAction
    extends OpenAction {
        OpenRBAction() {
        }

        public String getName() {
            return InternationalizationResourceBundleBrandingPanel.getMessage("LBL_ResourceBundlesViewOriginal");
        }
    }

    static final class ExpandAllAction
    extends OpenAction {
        ExpandAllAction() {
        }

        public String getName() {
            return InternationalizationResourceBundleBrandingPanel.getMessage("LBL_ResourceBundlesExpand");
        }
    }

    private class RootNode
    extends AbstractNode
    implements OpenCookie {
        private RootChildren rootChildren;

        public RootNode(List<BundleNode> resourceBundleNodes) {
            this(resourceBundleNodes, new InstanceContent());
        }

        private RootNode(List<BundleNode> resourceBundleNodes, InstanceContent content) {
            super((Children)new RootChildren(resourceBundleNodes), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
            content.add((Object)this);
            this.rootChildren = (RootChildren)this.getChildren();
        }

        public Action[] getActions(boolean context) {
            return new Action[]{InternationalizationResourceBundleBrandingPanel.this.expandAllAction.createContextAwareInstance(this.getLookup())};
        }

        public void open() {
            InternationalizationResourceBundleBrandingPanel.this.view.expandAll();
            InternationalizationResourceBundleBrandingPanel.this.view.requestFocusInWindow();
        }

        public void refreshChildren() {
            this.rootChildren.refreshChildren();
        }
    }

    private class SearchListener
    implements DocumentListener,
    FocusListener {
        private SearchListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (InternationalizationResourceBundleBrandingPanel.this.searchTask == null) {
                InternationalizationResourceBundleBrandingPanel.this.searchTask = InternationalizationResourceBundleBrandingPanel.this.RPforSearch.create(new Runnable(){

                    @Override
                    public void run() {
                        InternationalizationResourceBundleBrandingPanel.this.searchStringUpdated();
                    }
                });
            }
            InternationalizationResourceBundleBrandingPanel.this.searchTask.schedule(500);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.insertUpdate(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.insertUpdate(e);
        }

        @Override
        public void focusGained(FocusEvent e) {
            InternationalizationResourceBundleBrandingPanel.this.searchField.selectAll();
        }

        @Override
        public void focusLost(FocusEvent e) {
            InternationalizationResourceBundleBrandingPanel.this.searchField.select(0, 0);
        }
    }

    private class MyTree
    extends BeanTreeView {
        public MyTree() {
            this.setBorder(InternationalizationResourceBundleBrandingPanel.this.scrollPane.getBorder());
            this.setViewportBorder(InternationalizationResourceBundleBrandingPanel.this.scrollPane.getViewportBorder());
        }

        public void updateUI() {
            super.updateUI();
            this.setBorder(InternationalizationResourceBundleBrandingPanel.this.scrollPane.getBorder());
            this.setViewportBorder(InternationalizationResourceBundleBrandingPanel.this.scrollPane.getViewportBorder());
        }
    }

    private class BundleNode
    extends FilterNode
    implements OpenCookie,
    Comparable<BundleNode> {
        private String bundlepath;
        private String codenamebase;
        private BundleChildren bundleChildren;

        public BundleNode(Node orig, String bundlepath, String codenamebase) {
            this(orig, bundlepath, codenamebase, new InstanceContent());
        }

        public BundleNode(Node orig, String bundlepath, String codenamebase, InstanceContent content) {
            super(orig, (Children)new BundleChildren(orig, bundlepath, codenamebase), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
            content.add((Object)this);
            this.disableDelegation(188);
            this.setDisplayName(bundlepath);
            this.setShortDescription(codenamebase);
            this.bundlepath = bundlepath;
            this.codenamebase = codenamebase;
            this.bundleChildren = (BundleChildren)this.getChildren();
        }

        public String getHtmlDisplayName() {
            if (InternationalizationResourceBundleBrandingPanel.this.isBundleBranded(this.bundlepath, this.codenamebase)) {
                return "<b>" + this.bundlepath + "</b>";
            }
            return this.bundlepath;
        }

        public void refresh() {
            this.fireDisplayNameChange(null, null);
        }

        public Action[] getActions(boolean context) {
            return new Action[]{InternationalizationResourceBundleBrandingPanel.this.openRBAction.createContextAwareInstance(this.getLookup())};
        }

        public Action getPreferredAction() {
            return null;
        }

        public boolean canRename() {
            return false;
        }

        public void open() {
            EditCookie originalEC = (EditCookie)this.getOriginal().getCookie(EditCookie.class);
            if (null != originalEC) {
                originalEC.edit();
            }
        }

        @Override
        public int compareTo(BundleNode o) {
            return this.getDisplayName().compareTo(o.getDisplayName());
        }

        private void refreshChildren() {
            this.bundleChildren.refreshChildren();
        }
    }

    public static class KeyInput
    extends NotifyDescriptor {
        protected ResourceBundleKeyPanel keyPanel;

        public KeyInput(String text, String title) {
            this(text, title, 2, -1);
        }

        public KeyInput(String text, String title, int optionType, int messageType) {
            super(null, title, optionType, messageType, null, null);
            super.setMessage((Object)this.createDesign(text));
        }

        public String getInputText() {
            return this.keyPanel.getText();
        }

        public void setInputText(String text) {
            this.keyPanel.setText(text);
        }

        protected Component createDesign(String text) {
            this.keyPanel = new ResourceBundleKeyPanel(text);
            return this.keyPanel;
        }
    }

    private final class WaitNode
    extends AbstractNode {
        public WaitNode() {
            super(Children.LEAF);
            this.setDisplayName(UIUtil.WAIT_VALUE);
            this.setIconBaseWithExtension(InternationalizationResourceBundleBrandingPanel.WAIT_ICON_PATH);
        }
    }

    private class KeyNode
    extends FilterNode
    implements EditCookie,
    OpenCookie {
        private String key;
        private String bundlepath;
        private String codenamebase;
        private String cachedDisplayName;
        private String cachedHtmlDisplayName;

        public KeyNode(Node orig, String bundlepath, String codenamebase) {
            this(orig, bundlepath, codenamebase, new InstanceContent());
        }

        public KeyNode(Node orig, String bundlepath, String codenamebase, InstanceContent content) {
            super(orig, null, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
            content.add((Object)this);
            this.disableDelegation(188);
            this.key = orig.getDisplayName();
            this.bundlepath = bundlepath;
            this.codenamebase = codenamebase;
            this.cachedDisplayName = null;
            this.cachedHtmlDisplayName = null;
        }

        public String getDisplayName() {
            if (null == this.cachedDisplayName) {
                this.cachedDisplayName = this.key + " = " + InternationalizationResourceBundleBrandingPanel.this.getKeyValue(this.bundlepath, this.codenamebase, this.key);
            }
            return this.cachedDisplayName;
        }

        public String getHtmlDisplayName() {
            if (null == this.cachedHtmlDisplayName) {
                this.cachedHtmlDisplayName = InternationalizationResourceBundleBrandingPanel.this.isKeyBranded(this.bundlepath, this.codenamebase, this.key) ? "<b>" + this.key + "</b> = <font color=\"#ce7b00\">" + this.escapeTagDefinitions(InternationalizationResourceBundleBrandingPanel.this.getKeyValue(this.bundlepath, this.codenamebase, this.key)) + "</font>" : this.key + " = <font color=\"#ce7b00\">" + this.escapeTagDefinitions(InternationalizationResourceBundleBrandingPanel.this.getKeyValue(this.bundlepath, this.codenamebase, this.key)) + "</font>";
            }
            return this.cachedHtmlDisplayName;
        }

        private String escapeTagDefinitions(String text) {
            return text.replace("<", "&lt;").replace(">", "&gt;");
        }

        public void refresh() {
            this.cachedDisplayName = null;
            this.cachedHtmlDisplayName = null;
            this.fireDisplayNameChange(null, null);
        }

        public Action[] getActions(boolean context) {
            return new Action[]{InternationalizationResourceBundleBrandingPanel.this.editRBAction.createContextAwareInstance(this.getLookup()), InternationalizationResourceBundleBrandingPanel.this.openRBAction.createContextAwareInstance(this.getLookup())};
        }

        public Action getPreferredAction() {
            return InternationalizationResourceBundleBrandingPanel.this.editRBAction.createContextAwareInstance(this.getLookup());
        }

        public boolean canRename() {
            return false;
        }

        public void edit() {
            if (InternationalizationResourceBundleBrandingPanel.this.addKeyToBranding(this.bundlepath, this.codenamebase, this.getOriginal().getDisplayName())) {
                this.refresh();
                Node parent = this.getParentNode();
                if (parent instanceof BundleNode) {
                    ((BundleNode)parent).refresh();
                }
            }
        }

        public void open() {
            EditCookie originalEC = (EditCookie)this.getOriginal().getCookie(EditCookie.class);
            if (null != originalEC) {
                originalEC.edit();
            }
        }
    }

    private class BundleChildren
    extends Children.Keys<Node> {
        Node original;
        private String bundlepath;
        private String codenamebase;

        public BundleChildren(Node orig, String bundlepath, String codenamebase) {
            this.original = orig;
            this.bundlepath = bundlepath;
            this.codenamebase = codenamebase;
        }

        protected Node[] createNodes(Node key) {
            if (!key.getDisplayName().toUpperCase().startsWith("OPENIDE-MODULE")) {
                KeyNode keyNode = new KeyNode(key, this.bundlepath, this.codenamebase);
                if (null == InternationalizationResourceBundleBrandingPanel.this.searchString || keyNode.getDisplayName().toLowerCase().indexOf(InternationalizationResourceBundleBrandingPanel.this.searchString) != -1) {
                    return new Node[]{keyNode};
                }
            }
            return null;
        }

        protected void addNotify() {
            this.refreshList();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
        }

        private void refreshList() {
            Node[] origChildren;
            ArrayList<Node> keys = new ArrayList<Node>();
            for (Node node : origChildren = this.original.getChildren().getNodes()) {
                keys.add(node);
            }
            this.setKeys(keys);
        }

        private void refreshChildren() {
            Node[] origChildren;
            for (Node node : origChildren = this.original.getChildren().getNodes()) {
                this.refreshKey(node);
            }
        }
    }

    private class RootChildren
    extends Children.Keys<Node> {
        List<BundleNode> resourceBundleNodes;

        public RootChildren(List<BundleNode> resourceBundleNodes) {
            this.resourceBundleNodes = resourceBundleNodes;
        }

        protected Node[] createNodes(Node key) {
            if (key.getChildren().getNodesCount() > 0) {
                return new Node[]{key};
            }
            return null;
        }

        protected void addNotify() {
            this.refreshList();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
        }

        private void refreshList() {
            ArrayList<BundleNode> keys = new ArrayList<BundleNode>();
            for (BundleNode node : this.resourceBundleNodes) {
                keys.add(node);
            }
            Collections.sort(keys);
            this.setKeys(keys);
        }

        private void refreshChildren() {
            for (BundleNode node : this.resourceBundleNodes) {
                node.refreshChildren();
                this.refreshKey(node);
            }
        }
    }
}

